/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.atm;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.DslInfo;
import com.cisco.xdm.data.base.DevInfoBase;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AdslInfo
extends DslInfo {
    private String _dslOperatingMode = "auto";
    public static String[] OPERATING_MODE = null;

    public AdslInfo() {
        Log.getLog().debug("AdslInfo() " + this.getClass().getName());
    }

    public AdslInfo(XDMObject parent) {
        super(parent);
        Log.getLog().debug("AdslInfo() " + this.getClass().getName());
    }

    public AdslInfo(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        Log.getLog().debug("AdslInfo() " + this.getClass().getName());
    }

    private boolean compareStrings(String first, String second) {
        if (first == second && first == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            AdslInfo dsl = (AdslInfo)obj;
            return this.compareStrings(this._dslOperatingMode, dsl._dslOperatingMode) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(ConfigValues cv) throws XDMException {
        Log.getLog().info("generateAddCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        if (this._dslOperatingMode != null) {
            cmd = new CmdValues("dsl");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.addValue("ADSLMODE", this._dslOperatingMode);
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(cv.toString());
    }

    private void generateChangeCmd(AdslInfo old, ConfigValues cv) throws XDMException {
        Log.getLog().info("generateChangeCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        if (this._dslOperatingMode != null && !this._dslOperatingMode.equals(old._dslOperatingMode)) {
            cmd = new CmdValues("dsl");
            cmd.addOldValue("operating-mode", "operating-mode");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.addValue("ADSLMODE", this._dslOperatingMode);
            cmd.addOldValue("ADSLMODE", old._dslOperatingMode);
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        } else if (this._dslOperatingMode == null && this._dslOperatingMode != old._dslOperatingMode) {
            cmd = new CmdValues("dsl");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(cv.toString());
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        Log.getLog().info("generateDelta() " + this.getClass().getName());
        if (!this.isReadOnly() && this.isModified()) {
            AdslInfo backupAtm = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(values);
                } else {
                    backupAtm = (AdslInfo)backup;
                    this.generateChangeCmd(backupAtm, values);
                }
            }
        }
    }

    public String getDslOperatingMode() {
        return this._dslOperatingMode;
    }

    public boolean isResetRequired() {
        AdslInfo obj = (AdslInfo)this.getBackup();
        if (!obj._dslOperatingMode.equals(this._dslOperatingMode)) {
            return true;
        }
        Log.getLog().debug("isResetRequired(): Returning false");
        return false;
    }

    private void parseResponse(String dsllinerate) {
        Log.getLog().debug("DSL Operating Mode Is " + dsllinerate);
        StringTokenizer st = new StringTokenizer(dsllinerate, "\r\n");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            String nline = st.nextToken().trim();
            if (nline.indexOf("dsl operating-mode") > -1) break;
            int index = nline.indexOf(" ");
            if (index <= 0) continue;
            v.addElement(nline.substring(0, index));
        }
        if (v.size() == 0) {
            return;
        }
        OPERATING_MODE = new String[v.size()];
        v.copyInto(OPERATING_MODE);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getLog().info("populate() " + this.getClass().getName());
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(config.toString());
        this.populateOperatingMode(((Atm)this.getParent()).getIfID());
        ConfigValues cv = config.getCmds("dsl", "operating-mode", ".*", false);
        if (cv != null) {
            CmdValues cmd = cv.getCmdValues(0);
            this._dslOperatingMode = cmd.getValue("ADSLMODE");
        }
    }

    private void populateOperatingMode(IfID ifId) {
        if (OPERATING_MODE != null) {
            return;
        }
        String[] cliCommands = new String[]{"interface " + ifId, "dsl operating-mode ?"};
        IOSCmdResponse[] response = this.sendConfigCommands(cliCommands);
        if (response == null || response.length < 2) {
            Log.getLog().error("Failed during DSL Operating Mode Discovery");
            return;
        }
        String dsllinerate = response[1].getOutput();
        this.parseResponse(dsllinerate);
    }

    private IOSCmdResponse[] sendConfigCommands(String[] cliCommands) {
        IOSCmdResponse[] response;
        DevInfoBase deviceInfo = ((DeviceBase)this.getDevice()).getDevInfoBase();
        try {
            response = deviceInfo.getComm().config(cliCommands);
        }
        catch (IOSCmdServiceException ex) {
            Log.getLog().error("Failed during DSL Operating Mode Discovery");
            ex.printStackTrace();
            return null;
        }
        return response;
    }

    public void setDslOperatingMode(String dslOperatingMode) {
        this._dslOperatingMode = dslOperatingMode;
        this.setModified();
    }

    public String toString() {
        return "\t_dslOperatingMode: " + this._dslOperatingMode;
    }
}

