/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.atm;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.Pvc;
import com.cisco.xdm.data.atm.PvcCollection;
import com.cisco.xdm.data.atm.ShdslInfo;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.Dialer;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import java.util.Enumeration;
import java.util.Vector;

public class AtmHelper
extends XDMObject {
    private PvcCollection _pvcs;
    private CmdSet _cmdset;
    private XDMInterfaceBase _ifc;

    public AtmHelper() {
        Log.getLog().debug("AtmHelper() " + this.getClass().getName());
        this._pvcs = new PvcCollection(this, false);
    }

    public AtmHelper(XDMObject parent) {
        super(parent);
        if (this._ifc == null) {
            this._ifc = (XDMInterfaceBase)this.getParent();
        }
        Log.getLog().debug("AtmHelper() " + this._ifc.getIfID());
        this._pvcs = new PvcCollection(this, false);
    }

    public AtmHelper(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        this._ifc = (XDMInterfaceBase)this.getParent();
        Log.getLog().debug("AtmHelper() " + this._ifc.getIfID());
        Log.getLog().debug("AtmHelper() " + this._ifc.getIfID());
        this._pvcs = new PvcCollection(this, false);
    }

    private boolean checkConnectionOnPvcs(String connectionType) {
        Enumeration e = this.getPvcs().elements();
        while (e.hasMoreElements()) {
            Pvc pvc = (Pvc)e.nextElement();
            if (pvc.getConnectionType() == null || !pvc.getConnectionType().equals(connectionType)) continue;
            return true;
        }
        return false;
    }

    private boolean checkEncapsulationOnPvcs(String encap) {
        Enumeration e = this.getPvcs().elements();
        while (e.hasMoreElements()) {
            Pvc pvc = (Pvc)e.nextElement();
            if (pvc.getEncapsulation() == null || !pvc.getEncapsulation().equals(encap)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProtocolIp() {
        if (this._ifc.getIfID().isSubInterface()) {
            return true;
        }
        Enumeration e = this.getPvcs().elements();
        while (e.hasMoreElements()) {
            Pvc pvc = (Pvc)e.nextElement();
            if (pvc.getProtocolIPAddress() != null) continue;
            this.setReadOnly(true);
            Log.getLog().warn("checkProtocolIp(): Partial Configuration: No protocol IP address on associated PVC. ATM is non-configurable " + this._ifc.getIfID());
            this.setROReason(0x7000011);
            return false;
        }
        return true;
    }

    private boolean checkPvcs(boolean ipExists) {
        if (this.getPvcs().size() == 0) {
            if (ipExists) {
                this.setReadOnly(true);
                Log.getLog().warn("checkPvcs(): Partial Configuration: IPaddress but No associated PVC. ATM is non-configurable " + this._ifc.getIfID());
                this.setROReason(0x700000C);
                return false;
            }
        } else if (!ipExists) {
            this.setReadOnly(true);
            Log.getLog().warn("checkPvcs(): Partial Configuration: PVCs but No associated IPAddress. ATM is non-configurable " + this._ifc.getIfID());
            this.setROReason(0x700000C);
            return false;
        }
        return true;
    }

    public Object clone() {
        Log.getLog().debug("clone() " + this.getClass().getName());
        AtmHelper newa = (AtmHelper)super.clone();
        if (this._pvcs != null) {
            newa._pvcs = (PvcCollection)this._pvcs.clone();
            newa._pvcs.setParent(newa);
        }
        return newa;
    }

    public boolean containsPvc(int vpi, int vci) {
        return this._pvcs.containsPvc(vpi, vci);
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            AtmHelper atm = (AtmHelper)obj;
            return this._pvcs.equals(atm._pvcs) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(ConfigValues cv) throws XDMException {
        Log.getLog().info("generateAddCmd() " + this._ifc.getIfID() + " " + this.getClass().getName());
        Object cmd = null;
        this._pvcs.generateDelta(null, cv);
        Log.getLog().debug("Cmd Values " + cv);
    }

    private void generateChangeCmd(AtmHelper old, ConfigValues cv) throws XDMException {
        Log.getLog().info("generateChangeCmd() " + this._ifc.getIfID() + " " + this.getClass().getName());
        Object cmd = null;
        this._pvcs.generateDelta(old._pvcs, cv);
        Log.getLog().debug("Cmd Values " + cv);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        Log.getLog().info("generateDelta() " + this._ifc.getIfID() + " " + this.getClass().getName());
        if (!this.isReadOnly() && this.isModified()) {
            AtmHelper backupAtm = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(values);
                } else {
                    backupAtm = (AtmHelper)backup;
                    this.generateChangeCmd(backupAtm, values);
                }
            }
        }
    }

    public XDMInterfaceBase getLogicalIf() {
        Vector ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1001);
        Enumeration e1 = this.getPvcs().elements();
        while (e1.hasMoreElements()) {
            int dialpool = ((Pvc)e1.nextElement()).getDialPoolNumber();
            if (dialpool == -1) continue;
            Enumeration e2 = ifs.elements();
            while (e2.hasMoreElements()) {
                Dialer item = (Dialer)e2.nextElement();
                if (item.getDialPoolNumber() != dialpool) continue;
                return item;
            }
        }
        return null;
    }

    public PvcCollection getPvcs() {
        return this._pvcs;
    }

    public boolean isATMConfiguredForPPPoA() {
        if (this.isATMConfiguredForPPPoAandPPPoE()) {
            if (!this.checkEncapsulationOnPvcs("aal5snap") && !this.checkEncapsulationOnPvcs("aal5mux")) {
                this.setReadOnly(true);
                Log.getLog().debug("isATMConfiguredForPPPoA(): Returning false for " + this._ifc.getIfID());
                return false;
            }
            if (!this.checkConnectionOnPvcs("PPPoA")) {
                this.setReadOnly(true);
                Log.getLog().debug("isATMConfiguredForPPPoA(): Returning false for " + this._ifc.getIfID());
                return false;
            }
        } else {
            return false;
        }
        Log.getLog().debug("isATMConfiguredForPPPoA(): PPPoA connection. Checking Operating Mode for " + this._ifc.getIfID());
        this.isOperatingModeCO();
        Log.getLog().debug("isATMConfiguredForPPPoA(): Returning true " + this._ifc.getIfID());
        return true;
    }

    public boolean isATMConfiguredForPPPoAandPPPoE() {
        if (this._ifc == null) {
            this._ifc = (XDMInterfaceBase)this.getParent();
        }
        Log.getLog().info("isATMConfiguredForPPPoAandPPPoE() for " + this._ifc.getIfID());
        Dialer d = (Dialer)this.getLogicalIf();
        if (d == null) {
            Log.getLog().debug("isATMConfiguredForPPPoAandPPPoE(): Returning false. No dialer associated with " + this._ifc.getIfID());
            return false;
        }
        if (d.getEncapsulation() == null || !d.getEncapsulation().equals("ppp")) {
            this.setReadOnly(true);
            this.setROReason(0x700000E);
            Log.getLog().warn("isATMConfiguredForPPPoAandPPPoE(): Partial/Incorrect Configuration. Dialer encapsulation is not PPP. Setting read only flag on " + this._ifc.getIfID());
            return false;
        }
        if (!d.isConfigured()) {
            this.setReadOnly(true);
            this.setROReason(0x700000D);
            Log.getLog().warn("isATMConfiguredForPPPoAandPPPoE(): Partial/Incorrect Configuration. Dialer encapsulation is not configured with IP Address. Setting read only flag on " + this._ifc.getIfID());
            return false;
        }
        return true;
    }

    public boolean isATMConfiguredForPPPoE() {
        if (this.isATMConfiguredForPPPoAandPPPoE()) {
            if (((DeviceBase)this.getDevice()).getDevInfoBase().isPPPoENeedVpdn() && !((DeviceBase)this.getDevice()).getVPDN().getVPDNGroupCollection().isPPPOESet()) {
                this.setReadOnly(true);
                this.setROReason(0x700000F);
                Log.getLog().warn("isATMConfiguredForPPPoE(): Partial/Incorrect Configuration. No VPDN Configured on for PPPoE connection. Setting read only flag for " + this._ifc.getIfID());
                return false;
            }
            if (!this.checkConnectionOnPvcs("PPPoE")) {
                Log.getLog().debug("isATMConfiguredForPPPoE(): Returning false for " + this._ifc.getIfID());
                return false;
            }
        } else {
            return false;
        }
        Log.getLog().debug("isATMConfiguredForPPPoE(): PPPoE connection. Checking Operating Mode for " + this._ifc.getIfID());
        this.isOperatingModeCO();
        Log.getLog().debug("isATMConfiguredForPPPoE(): Returning true " + this._ifc.getIfID());
        return true;
    }

    public boolean isATMConfiguredForRFCMUX() {
        boolean ipExists = true;
        if (!this.isIpAddressConfigured()) {
            Log.getLog().debug("isATMConfiguredForRFCMUX(): No IP Address for " + this._ifc.getIfID());
            ipExists = false;
            if (this._ifc.getIfID().isSubInterface()) {
                Log.getLog().warn("isATMConfiguredForRFCMUX(): Setting RO flag. No IP Address for " + this._ifc.getIfID());
                this.setReadOnly(true);
                this.setROReason(117440530);
                return false;
            }
        }
        if (!this.checkPvcs(ipExists)) {
            Log.getLog().debug("isATMConfiguredForRFCMUX(): Returning false for " + this._ifc.getIfID());
            return false;
        }
        if (!this.checkEncapsulationOnPvcs("aal5mux")) {
            Log.getLog().debug("isATMConfiguredForRFCMUX(): Returning false for " + this._ifc.getIfID());
            return false;
        }
        if (!this.checkProtocolIp()) {
            Log.getLog().debug("isATMConfiguredForRFCMUX(): Returning false for " + this._ifc.getIfID());
            return true;
        }
        Log.getLog().debug("isATMConfiguredForRFCMUX(): Returning true for " + this._ifc.getIfID());
        return true;
    }

    public boolean isATMConfiguredForRFCSNAP() {
        boolean ipExists = true;
        if (!this.isIpAddressConfigured()) {
            Log.getLog().debug("isATMConfiguredForRFCSNAP(): No IP Address for " + this._ifc.getIfID());
            ipExists = false;
            if (this._ifc.getIfID().isSubInterface()) {
                Log.getLog().warn("isATMConfiguredForRFCSNAP(): Setting RO flag. No IP Address for " + this._ifc.getIfID());
                this.setReadOnly(true);
                this.setROReason(117440530);
                return false;
            }
        }
        if (!this.checkPvcs(ipExists)) {
            Log.getLog().debug("isATMConfiguredForRFCSNAP(): Returning false for " + this._ifc.getIfID());
            return false;
        }
        if (!this.checkEncapsulationOnPvcs("aal5snap")) {
            Log.getLog().debug("isATMConfiguredForRFCSNAP(): Returning false for " + this._ifc.getIfID());
            return false;
        }
        if (!this.checkProtocolIp()) {
            Log.getLog().debug("isATMConfiguredForRFCSNAP(): Returning false for " + this._ifc.getIfID());
            return true;
        }
        Log.getLog().debug("isATMConfiguredForRFCSNAP(): Returning true for " + this._ifc.getIfID());
        return true;
    }

    public boolean isATMConnected() {
        if (this.isATMConfiguredForPPPoE() || this.isATMConfiguredForPPPoA() || this.isATMConfiguredForRFCSNAP() || this.isATMConfiguredForRFCMUX()) {
            Log.getLog().debug("isATMConnected(): Returning true " + this._ifc.getIfID());
            return true;
        }
        Log.getLog().debug("isATMConnected(): Returning false " + this._ifc.getIfID());
        return false;
    }

    public boolean isDeepEqual() {
        return true;
    }

    private boolean isIpAddressConfigured() {
        if (this._ifc == null) {
            this._ifc = (XDMInterfaceBase)this.getParent();
        }
        if (this._ifc.getIpAddr() == null) {
            Log.getLog().debug("isATMConfiguredForRFCSNAP(): Returning false. No IP Address configured on " + this._ifc.getIfID());
            return false;
        }
        if (this._ifc.getIpAddr().getIPAddressType() == null) {
            Log.getLog().debug("isATMConfiguredForRFCSNAP(): Returning false. No IP Address configured on " + this._ifc.getIfID());
            return false;
        }
        return true;
    }

    private boolean isOperatingModeCO() {
        ShdslInfo info;
        if (this._ifc.getIfID().isSubInterface()) {
            return false;
        }
        Atm atm = (Atm)this._ifc;
        if (atm.getIfID().getType() == 504 && (info = (ShdslInfo)atm.getDslInfo()).getDslEquipmentType().equals("CO")) {
            this.setReadOnly(true);
            this.setROReason(0x700000B);
            Log.getLog().warn("isOperatingModeCO(): Operating mode is CO. ATM is non-configurable " + atm.getIfID());
            return true;
        }
        return false;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        ConfigValues cv;
        Log.getLog().info("populate() " + this.getClass().getName());
        Log.getLog().debug("Cmd Values " + cmdVal);
        this._cmdset = ((DeviceBase)this.getDevice()).getDevInfoBase().getCmdSet();
        ConfigValues subcmds = cmdVal.getModeCmdsValues();
        this.populatePvcInfo(subcmds);
        if (this._pvcs.isReadOnly()) {
            this.setReadOnly(true);
            this.setROReason(this._pvcs.getROReason());
            Log.getLog().warn("populate(): PVCS are RO. Setting read only flag " + this._ifc.getIfID());
        }
        if ((cv = subcmds.getCmds("bridge-group", ".*", ".*", false)) != null) {
            this.setReadOnly(true);
            this.setROReason(0x7000003);
            Log.getLog().warn("populate(): Found bridge-group command. Setting read only flag " + this._ifc.getIfID());
        }
    }

    private void populatePvcInfo(ConfigValues subcmds) throws XDMException, CliGPBException {
        Log.getLog().info("populatePvcInfo() " + this._ifc.getIfID());
        this._pvcs.populate(subcmds, null);
    }

    public void resetModifiedFlag() {
        Log.getLog().debug("resetModifiedFlag() " + this.getClass().getName());
        super.resetModifiedFlag();
        if (this._pvcs != null) {
            this._pvcs.resetModifiedFlag();
        }
    }

    public void setPvcs(PvcCollection pvcs) {
        this._pvcs = pvcs;
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tpvc: " + this._pvcs);
        return sb.toString();
    }
}

