/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.atm;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;

public class Pvc
extends XDMObject {
    private String _name;
    private int _vpi = -1;
    private int _vci = -1;
    private int _dialpoolnum = -1;
    private String _protocol;
    private IPAddress _ipaddr;
    private String _connectionType;
    private String _encapsulation;
    private String _type = "ip";

    public Pvc() {
        Log.getLog().debug("Pvc() " + this.getClass().getName());
    }

    public Pvc(XDMObject parent) {
        super(parent);
        Log.getLog().debug("Pvc() " + this.getClass().getName());
    }

    public Pvc(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        Log.getLog().debug("Pvc() " + this.getClass().getName());
    }

    private boolean compareStrings(String first, String second) {
        if (first == second && first == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Pvc pvc = (Pvc)obj;
            return this.compareStrings(this._name, pvc._name) && this._vpi == pvc._vpi && this._vci == pvc._vci && this._dialpoolnum == pvc._dialpoolnum && this.compareStrings(this._protocol, pvc._protocol) && this.compareStrings(this._encapsulation, pvc._encapsulation) && this.compareStrings(this._type, pvc._type) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(ConfigValues cv) {
        Log.getLog().info("generateAddCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        CmdValues subcmd = null;
        cmd = new CmdValues("pvc");
        cmd.setAction(1);
        cmd.addValue("VPIVCI", String.valueOf(this._vpi) + "/" + this._vci);
        if (this._name != null) {
            cmd.addValue("NAME", this._name);
        }
        cv.addCmdValues(cmd);
        ConfigValues ccv = new ConfigValues();
        if (this._dialpoolnum != -1 && this._encapsulation.equals("PPPoE")) {
            subcmd = new CmdValues("pppoe-client");
            subcmd.addValue("DIALPOOL", String.valueOf(this._dialpoolnum));
            subcmd.setAction(1);
            ccv.addCmdValues(subcmd);
        }
        if (this._ipaddr != null) {
            subcmd = new CmdValues("protocol");
            if (this._protocol == null) {
                this._protocol = "ip";
            }
            subcmd.addValue("PROTOCOL", this._protocol);
            subcmd.addValue("IPADDR", this._ipaddr.toString());
            if (this._protocol != null && this._protocol.equals("ip")) {
                subcmd.addValue("broadcast", "broadcast");
            }
            subcmd.setAction(1);
            ccv.addCmdValues(subcmd);
        }
        if (!this._encapsulation.equals("PPPoE")) {
            subcmd = new CmdValues("encapsulation");
            subcmd.addValue("ENCAP", this._encapsulation);
            if (this._encapsulation.equals("aal5mux")) {
                subcmd.addValue("TYPE", this._type);
                if (!this._protocol.equals("ip")) {
                    subcmd.addValue("dialer", "dialer");
                }
                subcmd.setAction(1);
                ccv.addCmdValues(subcmd);
                if (this._type.equals("ppp")) {
                    subcmd = new CmdValues("dialer");
                    subcmd.addValue("pool-member", "pool-member");
                    subcmd.addValue("DIALPOOL", String.valueOf(this._dialpoolnum));
                    subcmd.setAction(1);
                    ccv.addCmdValues(subcmd);
                }
            } else if (this._encapsulation.equals("aal5snap")) {
                subcmd.setAction(1);
                ccv.addCmdValues(subcmd);
                if (this._ipaddr == null && this._connectionType != null) {
                    subcmd = new CmdValues("protocol");
                    subcmd.addValue("ppp", "ppp");
                    subcmd.addValue("dialer", "dialer");
                    subcmd.setAction(1);
                    ccv.addCmdValues(subcmd);
                    subcmd = new CmdValues("dialer");
                    subcmd.addValue("pool-member", "pool-member");
                    subcmd.addValue("DIALPOOL", String.valueOf(this._dialpoolnum));
                    subcmd.setAction(1);
                    ccv.addCmdValues(subcmd);
                }
            } else {
                subcmd.setAction(1);
                ccv.addCmdValues(subcmd);
            }
        }
        if (!ccv.isEmpty()) {
            cmd.setModeCmdsValues(ccv);
            Log.getLog().debug("generateAddCmd(): cv is " + ccv);
        } else {
            Log.getLog().debug("generateAddCmd(): cv is empty " + this.getClass().getName());
        }
    }

    private void generateChangeCmd(Pvc old, ConfigValues parent) {
        Log.getLog().info("generateChangeCmd() " + this.getClass().getName());
        if (this.isReadOnly()) {
            Log.getLog().warn("generateChangeCmd(): PVC is RO " + this.getClass().getName());
        }
        CmdValues cmd = null;
        CmdValues subcmd = null;
        ConfigValues ccv = new ConfigValues();
        cmd = new CmdValues("pvc");
        cmd.setAction(1);
        cmd.addValue("VPIVCI", String.valueOf(this._vpi) + "/" + this._vci);
        if (this._name != null) {
            cmd.addValue("NAME", this._name);
        }
        if (this._dialpoolnum != -1 && old._dialpoolnum != this._dialpoolnum) {
            Log.getLog().debug("generateChangeCmd(): Setting dial pool info " + this.getClass().getName());
            subcmd = new CmdValues("pppoe-client");
            subcmd.addValue("DIALPOOL", String.valueOf(this._dialpoolnum));
            subcmd.addOldValue("DIALPOOL", String.valueOf(old._dialpoolnum));
            subcmd.setAction(3);
            ccv.addCmdValues(subcmd);
        } else if (this._dialpoolnum == -1 && old._dialpoolnum != this._dialpoolnum) {
            subcmd = new CmdValues("pppoe-client");
            subcmd.addValue("DIALPOOL", String.valueOf(old._dialpoolnum));
            subcmd.setAction(2);
            ccv.addCmdValues(subcmd);
        }
        if (this._protocol != null && !this._protocol.equals(old._protocol) || this._ipaddr != null && !this._ipaddr.equals(old._ipaddr)) {
            Log.getLog().debug("generateChangeCmd(): Setting ip address info " + this.getClass().getName());
            subcmd = new CmdValues("protocol");
            if (this._protocol == null) {
                this._protocol = "ip";
            }
            subcmd.addValue("PROTOCOL", this._protocol);
            if (old._protocol != null) {
                subcmd.addOldValue("PROTOCOL", old._protocol);
            }
            if (this._ipaddr != null) {
                subcmd.addValue("IPADDR", this._ipaddr.toString());
            }
            if (old._ipaddr != null) {
                subcmd.addOldValue("IPADDR", old._ipaddr.toString());
                subcmd.addOldValue("broadcast", "broadcast");
            }
            if (this._protocol.equals("ip")) {
                subcmd.addValue("broadcast", "broadcast");
            }
            if (old._ipaddr == null || old._protocol == null) {
                subcmd.setAction(1);
            } else {
                subcmd.setAction(3);
            }
            ccv.addCmdValues(subcmd);
        } else if (this._ipaddr == null && this._ipaddr != old._ipaddr || this._protocol == null && this._protocol != old._protocol) {
            Log.getLog().debug("generateChangeCmd(): Deleting ip addr info " + this.getClass().getName());
            subcmd = new CmdValues("protocol");
            subcmd.addValue("PROTOCOL", old._protocol);
            subcmd.addValue("IPADDR", old._ipaddr.toString());
            subcmd.addValue("broadcast", "broadcast");
            subcmd.setAction(2);
            ccv.addCmdValues(subcmd);
        }
        if (this._encapsulation != null && !this._encapsulation.equals(old._encapsulation) || old._type != null && !old._type.equals(this._type)) {
            Log.getLog().debug("generateChangeCmd(): Setting encap info " + this.getClass().getName());
            subcmd = new CmdValues("encapsulation");
            subcmd.addValue("ENCAP", this._encapsulation);
            subcmd.addOldValue("ENCAP", old._encapsulation);
            if (this._encapsulation.equals("aal5mux")) {
                subcmd.addValue("TYPE", this._type);
                subcmd.addOldValue("TYPE", old._type);
            }
            subcmd.setAction(3);
            ccv.addCmdValues(subcmd);
        } else if (this._encapsulation == null && this._encapsulation != old._encapsulation || this._type == null && this._type != old._type) {
            Log.getLog().debug("generateChangeCmd(): Deleting encap info " + this.getClass().getName());
            subcmd = new CmdValues("encapsulation");
            subcmd.setAction(2);
            ccv.addCmdValues(subcmd);
        }
        if (!ccv.isEmpty()) {
            cmd.setModeCmdsValues(ccv);
            Log.getLog().debug("generateChangeCmd(): cv is " + cmd);
            parent.addCmdValues(cmd);
        } else {
            Log.getLog().debug("generateChangeCmd(): cv is empty " + this.getClass().getName());
        }
    }

    private void generateDeleteCmd(ConfigValues cv) {
        Log.getLog().info("generateDeleteCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        cmd = new CmdValues("pvc");
        cmd.setAction(2);
        cmd.addValue("VPIVCI", String.valueOf(this._vpi) + "/" + this._vci);
        if (this._name != null) {
            cmd.addValue("NAME", this._name);
        }
        cv.addCmdValues(cmd);
        Log.getLog().debug("Cmd Values " + cmd);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        Log.getLog().info("generateDelta() " + this.getClass().getName());
        if (!this.isReadOnly() && this.isModified()) {
            Pvc backupPvc = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(values);
                } else {
                    backupPvc = (Pvc)backup;
                    this.generateChangeCmd(backupPvc, values);
                }
            } else {
                this.generateDeleteCmd(values);
            }
        }
    }

    public String getAal5muxProtocol() {
        return this._type;
    }

    public String getConnectionType() {
        return this._connectionType;
    }

    public int getDialPoolNumber() {
        return this._dialpoolnum;
    }

    public String getEncapsulation() {
        return this._encapsulation;
    }

    public String getName() {
        return this._name;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public IPAddress getProtocolIPAddress() {
        return this._ipaddr;
    }

    public int getVCI() {
        return this._vci;
    }

    public int getVPI() {
        return this._vpi;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getLog().info("populate() " + this.getClass().getName());
        Log.getLog().debug("Cmd Values " + cmdVal);
        ConfigValues subcmds = cmdVal.getModeCmdsValues();
        this.populatePvcInfo(cmdVal);
        this.populateDialPoolInfo(subcmds);
        this.populateProtocolInfo(subcmds);
        this.populateEncapInfo(subcmds);
        if (this.isReadOnly()) {
            Log.getLog().warn("populate(): PVC is RO " + this.getClass().getName());
        }
    }

    private void populateDialPoolInfo(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populateDialPoolInfo() " + this.getClass().getName());
        ConfigValues cv = subcmds.getCmds("pppoe-client", ".*", ".*", false);
        if (cv == null) {
            Log.getLog().warn("populateDialPoolInfo(): for MUX and SNAP encapsulation. Setting read only flag " + this.getClass().getName());
            ConfigValues cvDial = subcmds.getCmds("dialer", ".*", ".*", false);
            if (cvDial == null) {
                return;
            }
            CmdValues cmd = cvDial.getCmdValues(0);
            this._dialpoolnum = Integer.parseInt(cmd.getValue("DIALPOOL"));
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._dialpoolnum = Integer.parseInt(cmd.getValue("DIALPOOL"));
        if (cmd.getValue("dial-on-demand") != null) {
            this.setReadOnly(true);
            this.setROReason(117440531);
            Log.getLog().warn("populateDialPoolInfo(): dial-on-demand for PPPoE. Setting read only flag " + this.getClass().getName());
            return;
        }
    }

    private void populateEncapInfo(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populateEncapInfo() " + this.getClass().getName());
        int _dialpoolnum = -1;
        ConfigValues cv = subcmds.getCmds("encapsulation", ".*", ".*", false);
        if (cv == null) {
            cv = subcmds.getCmds("extraCmd", "extraCmdValue", "..encapsulation.*", false);
            if (cv != null) {
                this.setReadOnly(true);
                this.setROReason(0x7000004);
                Log.getLog().warn("populateEncapInfo(): Encap not aal5mux or aal5snp. Setting read only flag " + this.getClass().getName());
                this._encapsulation = "unknown";
                return;
            }
            ConfigValues cvDial = subcmds.getCmds("dialer", ".*", ".*", false);
            if (cvDial != null) {
                CmdValues cmdDial = cvDial.getCmdValues(0);
                _dialpoolnum = Integer.parseInt(cmdDial.getValue("DIALPOOL"));
            }
            this._connectionType = _dialpoolnum != -1 ? "PPPoA" : "PPPoE";
            this._encapsulation = "aal5snap";
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._encapsulation = cmd.getValue("ENCAP");
        if (this._encapsulation != null) {
            this._connectionType = "PPPoA";
        }
        if (this._encapsulation.equals("aal5mux")) {
            this._type = cmd.getValue("TYPE");
            if (!this._type.equals("ip") && !this._type.equals("ppp")) {
                this.setReadOnly(true);
                this.setROReason(0x7000006);
                Log.getLog().warn("populateEncapInfo(): Encap protocol is not IP. Setting read only flag " + this.getClass().getName());
            }
        }
        if (this._encapsulation != null && !this._encapsulation.equals("aal5mux") && !this._encapsulation.equals("aal5snap")) {
            this.setReadOnly(true);
            this.setROReason(0x7000004);
            Log.getLog().warn("populateEncapInfo(): Encap not aal5mux or aal5snp. Setting read only flag " + this.getClass().getName());
        }
    }

    public void populatePPPoAInfo(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv = subcmds.getCmds("dialer", ".*", ".*", false);
        if (cv == null) {
            return;
        }
        this.setReadOnly(true);
        this.setROReason(0x700000A);
        Log.getLog().warn("populateProtocolInfo(): Interface configured for PPPoA. Setting read only flag " + this.getClass().getName());
    }

    private void populateProtocolInfo(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populateProtocolInfo() " + this.getClass().getName());
        ConfigValues cv = subcmds.getCmds("extraCmd", "extraCmdValue", "..protocol.*", false);
        if (cv != null) {
            this.setReadOnly(true);
            this.setROReason(0x7000005);
            Log.getLog().warn("populateProtocolInfo(): Protocol is not IP. Setting read only flag " + this.getClass().getName());
        }
        if ((cv = subcmds.getCmds("protocol", ".*", ".*", false)) == null) {
            return;
        }
        if (cv.numCmds() > 1) {
            this.setReadOnly(true);
            this.setROReason(0x7000010);
            Log.getLog().warn("populateProtocolInfo(): Multiple protocol IP commands. Setting read only flag " + this.getClass().getName());
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._protocol = cmd.getValue("PROTOCOL");
        String tempip = cmd.getValue("IPADDR");
        if (tempip != null) {
            this._ipaddr = new IPAddress(tempip);
        }
    }

    private void populatePvcInfo(CmdValues cmd) throws CliGPBException {
        Log.getLog().info("populatePvcInfo() " + this.getClass().getName());
        String vpivci = cmd.getValue("VPIVCI");
        int index = vpivci.indexOf("/");
        this._vpi = Integer.parseInt(vpivci.substring(0, index));
        this._vci = Integer.parseInt(vpivci.substring(index + 1));
        this._name = cmd.getValue("NAME");
    }

    public void setAal5muxProtocol(String type) {
        this._type = type;
    }

    public void setConnectionType(String connectionType) {
        this._connectionType = connectionType;
    }

    public void setDialPoolNumber(int dialpoolnum) {
        this._dialpoolnum = dialpoolnum;
        this.setModified();
    }

    public void setEncapsulation(String encapsulation) {
        this._encapsulation = encapsulation;
        this.setModified();
    }

    public void setName(String name) {
        this._name = name;
        this.setModified();
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
        this.setModified();
    }

    public void setProtocolIPAddress(IPAddress ipaddr) {
        this._ipaddr = ipaddr;
        this.setModified();
    }

    public void setVCI(int vci) {
        this._vci = vci;
        this.setModified();
    }

    public void setVPI(int vpi) {
        this._vpi = vpi;
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tpvcname: " + this._name);
        sb.append("\tvpi/vci: " + this._vpi + "/" + this._vci);
        sb.append("\tencapsulation: " + this._encapsulation);
        sb.append("\tencaptype: " + this._type);
        sb.append("\tdialpoolnumber: " + this._dialpoolnum);
        sb.append("\tprotocol: " + this._protocol);
        sb.append("\tprotocolipaddress: " + this._ipaddr);
        return sb.toString();
    }
}

