/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.atm;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.Pvc;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import java.util.Enumeration;

public class PvcCollection
extends XDMHashCollection {
    public PvcCollection() {
        Log.getLog().debug("PvcCollection() " + this.getClass().getName());
    }

    public PvcCollection(XDMObject parent) {
        super(parent);
        Log.getLog().debug("PvcCollection() " + this.getClass().getName());
    }

    public PvcCollection(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        Log.getLog().debug("PvcCollection() " + this.getClass().getName());
    }

    public void addPvc(Pvc pvc) {
        pvc.setParent(this);
        this.put(String.valueOf(String.valueOf(pvc.getVPI())) + "_" + String.valueOf(pvc.getVCI()), pvc);
    }

    public boolean containsPvc(int vpi, int vci) {
        return this.containsKey(String.valueOf(String.valueOf(vpi)) + "_" + String.valueOf(vci));
    }

    public void deletePvc(int vpi, int vci) {
        this.remove(String.valueOf(String.valueOf(vpi)) + "_" + String.valueOf(vci));
    }

    public boolean doesPvcCollectionContainDialerPool(int dialpool) {
        Enumeration e2 = this.elements();
        while (e2.hasMoreElements()) {
            Pvc pvc = (Pvc)e2.nextElement();
            if (pvc.getDialPoolNumber() != dialpool) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            return super.equals(obj);
        }
        return false;
    }

    public Pvc getPvc(int vpi, int vci) {
        return (Pvc)this.get(String.valueOf(String.valueOf(vpi)) + "_" + String.valueOf(vci));
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getLog().info("populate() " + this.getClass().getName());
        ConfigValues pvcCmds = config.getCmds("pvc", ".*", ".*", false);
        if (pvcCmds == null) {
            return;
        }
        CmdValues pppoeCmd = null;
        ConfigValues pppoeCmds = config.getCmds("pppoe-client", ".*", ".*", false);
        pppoeCmd = pppoeCmds == null || pppoeCmds.numCmds() > 1 ? null : pppoeCmds.getCmdValues(0);
        int i = 0;
        while (i < pvcCmds.numCmds()) {
            Pvc pvc = new Pvc(this, false);
            pvc.setParent(this);
            CmdValues pvccmd = pvcCmds.getCmdValues(i);
            if (pppoeCmd != null) {
                ConfigValues pvcsubcmds = pvccmd.getModeCmdsValues();
                pvcsubcmds.insertCmdValues(pppoeCmd, pvcsubcmds.numCmds());
            }
            pvc.populate(config, pvccmd);
            this._hashTable.put(String.valueOf(String.valueOf(pvc.getVPI())) + "_" + String.valueOf(pvc.getVCI()), pvc);
            if (pvc.isReadOnly()) {
                this.setReadOnly(true);
                this.setROReason(pvc.getROReason());
                Log.getLog().warn("populate(): Pvc is RO. Setting PvcCollection to read only " + this.getClass().getName());
            }
            ++i;
        }
        if (this.size() > 1) {
            this.setReadOnly(true);
            this.setROReason(0x7000007);
            Log.getLog().warn("populate(): Too many Pvcs. Setting PvcCollection to read only " + this.getClass().getName());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            sb.append(String.valueOf(e.nextElement().toString()) + "\n");
        }
        return sb.toString();
    }
}

