/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.atm;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.DslInfo;
import com.cisco.xdm.data.base.DevInfoBase;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ShdslInfo
extends DslInfo {
    public static String[] LINERATE_VALUES = null;
    private String _dslEquipmentType = "CPE";
    private String _dslLinerate = "AUTO";
    private String _dslOperatingMode = "A";

    public ShdslInfo() {
        Log.getLog().debug("ShdslInfo() " + this.getClass().getName());
    }

    public ShdslInfo(XDMObject parent) {
        super(parent);
        Log.getLog().debug("ShdslInfo() " + this.getClass().getName());
    }

    public ShdslInfo(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        Log.getLog().debug("ShdslInfo() " + this.getClass().getName());
    }

    private boolean compareStrings(String first, String second) {
        if (first == second && first == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ShdslInfo dsl = (ShdslInfo)obj;
            return this.compareStrings(this._dslEquipmentType, dsl._dslEquipmentType) && this.compareStrings(this._dslLinerate, dsl._dslLinerate) && this.compareStrings(this._dslOperatingMode, dsl._dslOperatingMode) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(ConfigValues cv) throws XDMException {
        Log.getLog().debug("generateAddCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        if (this._dslEquipmentType != null) {
            cmd = new CmdValues("dsl");
            cmd.addValue("equipment-type", "equipment-type");
            cmd.addValue("ETYPE", this._dslEquipmentType);
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        if (this._dslOperatingMode != null) {
            cmd = new CmdValues("dsl");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.addValue("GSHDSL", "GSHDSL");
            cmd.addValue("symmetric", "symmetric");
            cmd.addValue("ANNEX", this._dslOperatingMode);
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        if (this._dslLinerate != null) {
            cmd = new CmdValues("dsl");
            cmd.addValue("LINERATE", this._dslLinerate);
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(cv.toString());
    }

    private void generateChangeCmd(ShdslInfo old, ConfigValues cv) throws XDMException {
        Log.getLog().info("generateChangeCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        if (this._dslEquipmentType != null && !this._dslEquipmentType.equals(old._dslEquipmentType)) {
            cmd = new CmdValues("dsl");
            cmd.addValue("equipment-type", "equipment-type");
            cmd.addValue("ETYPE", this._dslEquipmentType);
            cmd.addOldValue("ETYPE", old._dslEquipmentType);
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        } else if (this._dslEquipmentType == null && this._dslEquipmentType != old._dslEquipmentType) {
            cmd = new CmdValues("dsl");
            cmd.addValue("equipment-type", "equipment-type");
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        if (this._dslOperatingMode != null && !this._dslOperatingMode.equals(old._dslOperatingMode)) {
            cmd = new CmdValues("dsl");
            cmd.addOldValue("operating-mode", "operating-mode");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.addOldValue("GSHDSL", "GSHDSL");
            cmd.addValue("GSHDSL", "GSHDSL");
            cmd.addOldValue("symmetric", "symmetric");
            cmd.addValue("symmetric", "symmetric");
            cmd.addValue("ANNEX", this._dslOperatingMode);
            cmd.addOldValue("ANNEX", old._dslOperatingMode);
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        } else if (this._dslOperatingMode == null && this._dslOperatingMode != old._dslOperatingMode) {
            cmd = new CmdValues("dsl");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        if (this._dslLinerate != null && !this._dslLinerate.equals(old._dslLinerate)) {
            cmd = new CmdValues("dsl");
            cmd.addValue("LINERATE", this._dslLinerate);
            cmd.addOldValue("LINERATE", old._dslLinerate);
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        } else if (this._dslLinerate == null && this._dslLinerate != old._dslLinerate) {
            cmd = new CmdValues("dsl");
            cmd.addValue("LINERATE", old._dslLinerate);
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(cv.toString());
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        Log.getLog().info("generateDelta() " + this.getClass().getName());
        if (!this.isReadOnly() && this.isModified()) {
            ShdslInfo backupAtm = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(values);
                } else {
                    backupAtm = (ShdslInfo)backup;
                    this.generateChangeCmd(backupAtm, values);
                }
            }
        }
    }

    public String getDslEquipmentType() {
        return this._dslEquipmentType;
    }

    public String getDslLinerate() {
        return this._dslLinerate;
    }

    public String getDslOperatingMode() {
        return this._dslOperatingMode;
    }

    public boolean isResetRequired() {
        ShdslInfo obj = (ShdslInfo)this.getBackup();
        if (!obj._dslOperatingMode.toUpperCase().equals(this._dslOperatingMode.toUpperCase())) {
            return true;
        }
        if (obj._dslEquipmentType == null && this._dslEquipmentType == null) {
            return false;
        }
        if (obj._dslEquipmentType == null && this._dslEquipmentType != null) {
            return true;
        }
        if (!obj._dslEquipmentType.equals(this._dslEquipmentType.toUpperCase())) {
            return true;
        }
        if (!obj._dslLinerate.toUpperCase().equals(this._dslLinerate.toUpperCase())) {
            return true;
        }
        Log.getLog().debug("isResetRequired(): Returning false");
        return false;
    }

    private void parseResponse(String dsllinerate) {
        Log.getLog().debug("DSL Linerate Is " + dsllinerate);
        StringTokenizer st = new StringTokenizer(dsllinerate);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            String nt = st.nextToken();
            if (nt.startsWith("<")) {
                v.addElement("AUTO");
                break;
            }
            v.addElement(nt);
        }
        LINERATE_VALUES = new String[v.size()];
        v.copyInto(LINERATE_VALUES);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        CmdValues cmd;
        Log.getLog().info("populate() " + this.getClass().getName());
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(config.toString());
        ConfigValues cv = config.getCmds("dsl", "operating-mode", ".*", false);
        if (cv != null) {
            cmd = cv.getCmdValues(0);
            this._dslOperatingMode = cmd.getValue("ANNEX");
        }
        if ((cv = config.getCmds("dsl", "equipment-type", ".*", false)) != null) {
            cmd = cv.getCmdValues(0);
            this._dslEquipmentType = cmd.getValue("ETYPE");
        }
        this.populateLinerate(((Atm)this.getParent()).getIfID());
        cv = config.getCmds("dsl", "linerate", ".*", false);
        if (cv != null) {
            cmd = cv.getCmdValues(0);
            this._dslLinerate = cmd.getValue("LINERATE");
        }
    }

    public void populateLinerate(IfID ifId) {
        if (LINERATE_VALUES != null) {
            return;
        }
        String[] cliCommands = new String[]{"interface " + ifId, "dsl linerate ?"};
        IOSCmdResponse[] response = this.sendConfigCommands(cliCommands);
        if (response == null || response.length < 2) {
            Log.getLog().error("Failed during DSL Linerate Discovery");
            return;
        }
        String dsllinerate = response[1].getOutput();
        this.parseResponse(dsllinerate);
    }

    private IOSCmdResponse[] sendConfigCommands(String[] cliCommands) {
        IOSCmdResponse[] response;
        DevInfoBase deviceInfo = ((DeviceBase)this.getDevice()).getDevInfoBase();
        try {
            response = deviceInfo.getComm().config(cliCommands);
        }
        catch (IOSCmdServiceException ex) {
            Log.getLog().error("Failed during DSL linerate Discovery");
            ex.printStackTrace();
            return null;
        }
        return response;
    }

    public void setDslEquipmentType(String dslEquipmentType) {
        this._dslEquipmentType = dslEquipmentType;
        this.setModified();
    }

    public void setDslLinerate(String dslLinerate) {
        this._dslLinerate = dslLinerate;
        this.setModified();
    }

    public void setDslOperatingMode(String dslOperatingMode) {
        this._dslOperatingMode = dslOperatingMode;
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t_dslEquipmentType: " + this._dslEquipmentType);
        sb.append("\t_dslLinerate: " + this._dslLinerate);
        sb.append("\t_dslOperatingMode: " + this._dslOperatingMode);
        return sb.toString();
    }
}

