/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.base;

import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.nm.xms.cliparser.CliBuilder;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.ConfigParser;
import com.cisco.nm.xms.cliparser.GrammarLocator;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACEProtocols;
import com.cisco.xdm.data.base.HWConfig;
import com.cisco.xdm.data.base.ProcessListener;
import com.cisco.xdm.data.base.SubmitCmds;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.common.PortMap;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.data.systemproperties.SystemProp;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.FileIOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceFactory;
import com.cisco.xdm.parser.VersionInfo;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;

public class DevInfoBase {
    private boolean _discovered = false;
    private IOSCmdService _comm = null;
    private ConfigParser _parser = null;
    private CliBuilder _cliBuilder = null;
    private CmdSet _cmdSet = null;
    private static String _addr = null;
    private String _model = "";
    private String _IOSVersion = "";
    private String _processor = "";
    private String _imageName = "";
    private String _bootLocation = "";
    private String _totalMem = "";
    private String _flash = "";
    private String _host = "";
    private HWConfig _hwConfig = null;
    private String _userView = "";
    private String _configRegister = "";
    public static final String CRYPTO = "crypto";
    public static final String CBAC = "cbac";
    public static final String IP_CEF = "cef";
    public static final String VPDN = "vpdn";
    public static final String NAMED_ACL = "named_acl";
    public static final String OSPF = "ospf";
    public static final String EIGRP = "eigrp";
    public static final String RIP = "rip";
    public static final String MOP = "mop";
    public static final String PPPOE = "pppoe";
    public static final String PPPOE_NeedVPDN = "pppoe_needvpdn";
    public static final String EXTENDED_PING = "extended_ping";
    public static final String HTTPS = "https";
    public static final String MULTILINK = "multilink";
    public static final String CLIVIEW = "cliview";
    public static final String ISAKMP = "isakmp";
    public static final String RTR = "rtr";
    public static final String IP_SLA = "ip_sla";
    public static final String RTR_CMD = "rtr_cmd";
    public static final String IP_SLA_CMD = "ip_sla_cmd";
    public static final String IP_SLA_ONLY = "ip_sla_only";
    public static final String NAC = "nac";
    public static final String NAC_NRH = "nac_non_responsive_host";
    public static final String USB = "usb";
    public static final String TOKEN = "token";
    public static final String CERT_STORAGE = "cert_storage";
    public static final String RSA_STORAGE = "rsa_storage";
    public static final String URL_FILTER_SUPPORTS = "urlfilter";
    public static final String URL_FILTER_TRUNCATE = "urltruncate";
    public static final String URL_FILTER_SOURCE_INTER = "urlinterface";
    public static final String VIEW_SECRET = "viewsecret";
    public static final String GRANULAR_PAM = "granularpam";
    public static final String PAM = "pam";
    public static final String TOP_TALKERS = "toptalkers";
    public static final String NETFLOW_AGGR = "netflowaggr";
    public static final String APPFW_PHASE_II = "appfwphaseII";
    public static final String STATIC_NETWORK_NAT_WITH_RMAP = "static_nw_nat_with_rmap";
    public static final String EASY_SDD = "easy_sdd";
    public static final String ENV_SUPP = "env_supp";
    public static final String PROTOCOLS_SUPP = "pro_supp";
    public static final String PROTOCOL_EIGRP = "ip_eigrp";
    public static final String CBAC_AUDIT_TRAIL = "audit-trail";
    protected Hashtable _features = new Hashtable();
    private IOSCmdService _sharedSvc = null;
    private CredentialRepository _sharedCred = null;

    public DevInfoBase(String host) {
        this._host = host;
        this._discovered = false;
    }

    static /* synthetic */ CmdSet access$0(DevInfoBase $0) {
        return $0._cmdSet;
    }

    static /* synthetic */ ConfigParser access$4(DevInfoBase $0) {
        return $0._parser;
    }

    static /* synthetic */ CliBuilder access$6(DevInfoBase $0) {
        return $0._cliBuilder;
    }

    void buildParser() {
        BuildParser builder = new BuildParser(this);
        builder.start();
    }

    private boolean checkCommandStatus(IOSCmdResponse[] execReplies) {
        Log.getLog().debug("Inside checkCommandStatus Length: " + execReplies.length);
        int p = 0;
        while (p < execReplies.length) {
            Log.getLog().debug("Command" + execReplies[p].getCmd());
            Log.getLog().debug("Response:" + execReplies[p].getOutput());
            Log.getLog().debug("Status:" + execReplies[p].getStatus());
            if (!XDMDiscovery.isOKResponse(execReplies[p])) {
                return false;
            }
            ++p;
        }
        return true;
    }

    private boolean checkIOS122(String model, String version) {
        boolean sup = false;
        if (version.indexOf("12.2") != 0) {
            sup = true;
        } else if (model.indexOf("26") == 0 || model.indexOf("36") == 0 || model.indexOf("37") == 0) {
            int v1 = this.getV1(version);
            if (this.getV2(version).equals("T") && (v1 > 11 || v1 == 11 && this.getV3(version) >= 6)) {
                sup = true;
            } else if (v1 >= 15) {
                sup = true;
            }
        } else if (model.indexOf("17") == 0) {
            int v1 = this.getV1(version);
            String v2 = this.getV2(version);
            if (v2.equals("T") && (v1 > 13 || v1 == 13 && this.getV3(version) >= 3) || v1 == 13 && v2.compareTo("ZH") >= 0 || v1 >= 15) {
                sup = true;
            }
        } else if (model.toLowerCase().indexOf("c8") == 0) {
            int v1 = this.getV1(version);
            if (v1 > 13 || v1 == 13 && this.getV2(version).compareTo("ZH") >= 0) {
                sup = true;
            }
        } else {
            sup = true;
        }
        return sup;
    }

    private boolean checkMinCommandSupported(IOSCmdService comm) {
        String strshparserview = "show parser view ?";
        Vector<String> vecMinExecCommands = new Vector<String>();
        vecMinExecCommands.addElement("show running-config view full ?");
        vecMinExecCommands.addElement("show version ?");
        vecMinExecCommands.addElement("ping ?");
        vecMinExecCommands.addElement("show diag ?");
        String model = this.getModel();
        if (model != null && model.length() == 4 && model.charAt(1) == '8' || model != null && model.length() == 5 && model.toUpperCase().charAt(0) == 'S') {
            Log.getLog().debug("Inside checkMinCommandSupported Router model is 8xx");
            vecMinExecCommands.removeElement("show diag ?");
        }
        if (model != null && model.length() > 4 && model.charAt(1) == '7') {
            Log.getLog().debug("Inside checkMinCommandSupported Router model is 7xxx");
            vecMinExecCommands.addElement("dir all-filesystems ?");
        }
        String[] oneCmd = new String[1];
        try {
            IOSCmdResponse[] execReplies = new IOSCmdResponse[vecMinExecCommands.size()];
            int m = 0;
            while (m < vecMinExecCommands.size()) {
                oneCmd[0] = String.valueOf(String.valueOf(vecMinExecCommands.elementAt(m)));
                IOSCmdResponse[] execReply = this._comm.exec(oneCmd);
                execReplies[m] = new IOSCmdResponse(execReply[0].getCmd(), execReply[0].getOutput(), execReply[0].getStatus());
                ++m;
            }
            if (!this.checkCommandStatus(execReplies)) {
                return false;
            }
        }
        catch (Exception exec) {
            Log.getLog().debug("Exception thrown" + exec);
        }
        return true;
    }

    protected boolean discoverFeature(String tag) {
        boolean discovered = false;
        IOSCmdResponse[] replies = null;
        try {
            if (tag.equals(CRYPTO) || tag.equals(ISAKMP)) {
                String[] cli = new String[]{"show crypto ?"};
                replies = this._comm.exec(cli);
                this._features.put(CRYPTO, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                this._features.put(ISAKMP, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], ISAKMP)));
                discovered = true;
            } else if (tag.equals(EASY_SDD)) {
                String[] cli = new String[]{"crypto wui tti ?"};
                replies = this.getComm().config(cli);
                this._features.put(EASY_SDD, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(ENV_SUPP)) {
                String[] cli = new String[]{"show environment"};
                replies = this._comm.exec(cli);
                this._features.put(ENV_SUPP, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(PROTOCOLS_SUPP)) {
                String[] cli = new String[]{"show protocols"};
                replies = this._comm.exec(cli);
                this._features.put(PROTOCOLS_SUPP, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(CBAC)) {
                String[] cli = new String[]{"show ip inspect interfaces ?"};
                replies = this._comm.exec(cli);
                this._features.put(CBAC, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(IP_CEF)) {
                String[] cli = new String[]{"show ip cef ?"};
                replies = this._comm.exec(cli);
                this._features.put(IP_CEF, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(VPDN)) {
                String[] cli = new String[]{"show vpdn ?"};
                replies = this._comm.exec(cli);
                this._features.put(VPDN, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(PPPOE) || tag.equals(PPPOE_NeedVPDN)) {
                String[] key1 = new String[]{"pppoe_client", "Protocol"};
                String[] key2 = new String[]{"sss", "Protocol"};
                String[] key3 = new String[]{VPDN, "Protocol"};
                if (XDMDiscovery.findFromExecOutput(this.getComm(), "show subsys", key1)) {
                    this._features.put(PPPOE, new Boolean(true));
                    this._features.put(PPPOE_NeedVPDN, new Boolean(false));
                } else if (XDMDiscovery.findFromExecOutput(this.getComm(), "show subsys", key2)) {
                    this._features.put(PPPOE, new Boolean(false));
                    this._features.put(PPPOE_NeedVPDN, new Boolean(false));
                } else if (XDMDiscovery.findFromExecOutput(this.getComm(), "show subsys", key3)) {
                    this._features.put(PPPOE, new Boolean(true));
                    this._features.put(PPPOE_NeedVPDN, new Boolean(true));
                } else {
                    this._features.put(PPPOE, new Boolean(false));
                    this._features.put(PPPOE_NeedVPDN, new Boolean(false));
                }
                discovered = true;
            } else if (tag.equals(NAMED_ACL)) {
                String[] cli = new String[]{"ip access-list standard ?"};
                replies = this._comm.config(cli);
                this._features.put(NAMED_ACL, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(OSPF) || tag.equals(EIGRP) || tag.equals(RIP)) {
                String[] key1 = new String[]{OSPF, "Protocol"};
                String[] key2 = new String[]{EIGRP, "Protocol"};
                String[] key3 = new String[]{RIP, "Protocol"};
                this._features.put(OSPF, new Boolean(XDMDiscovery.findFromExecOutput(this.getComm(), "show subsys", key1)));
                this._features.put(EIGRP, new Boolean(XDMDiscovery.findFromExecOutput(this.getComm(), "show subsys", key2)));
                this._features.put(RIP, new Boolean(XDMDiscovery.findFromExecOutput(this.getComm(), "show subsys", key3)));
                discovered = true;
            } else if (tag.equals(MOP)) {
                String[] cli = new String[]{"mop ?"};
                replies = this._comm.config(cli);
                this._features.put(MOP, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(EXTENDED_PING)) {
                String[] cli = new String[]{"ping ip 0.0.0.1 source ?"};
                replies = this._comm.exec(cli);
                this._features.put(EXTENDED_PING, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(HTTPS)) {
                this._features.put(HTTPS, new Boolean(XDMDiscovery.getIsHttpsSupported(this._comm)));
                discovered = true;
            } else if (tag.equals(MULTILINK)) {
                String[] cli = new String[]{"show ppp ?"};
                replies = this._comm.exec(cli);
                this._features.put(MULTILINK, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], MULTILINK)));
                discovered = true;
            } else if (tag.equals(CLIVIEW)) {
                String[] cli = new String[]{"show running-config view ?"};
                replies = this._comm.exec(cli);
                this._features.put(CLIVIEW, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(VIEW_SECRET)) {
                this._features.put(VIEW_SECRET, new Boolean(XDMDiscovery.getIsViewSecretSupported(this.getComm())));
                discovered = true;
            } else if (tag.equals(RTR)) {
                this._features.put(RTR, new Boolean(XDMDiscovery.isRTRSupported(this._comm)));
                discovered = true;
            } else if (tag.equals(IP_SLA)) {
                this._features.put(IP_SLA, new Boolean(XDMDiscovery.isIPSLASupported(this._comm)));
                discovered = true;
            } else if (tag.equals(RTR_CMD)) {
                this._features.put(RTR_CMD, new Boolean(XDMDiscovery.isRTRCommandSupported(this._comm)));
                discovered = true;
            } else if (tag.equals(IP_SLA_CMD)) {
                this._features.put(IP_SLA_CMD, new Boolean(XDMDiscovery.isIPSLACommandSupported(this._comm)));
                discovered = true;
            } else if (tag.equals(IP_SLA_ONLY)) {
                this._features.put(IP_SLA_ONLY, new Boolean(XDMDiscovery.isIPSLAOnlySupported(this._comm)));
                discovered = true;
            } else if (tag.equals(GRANULAR_PAM)) {
                String[] cli = new String[]{"ip port-map test port tcp ?"};
                replies = this._comm.config(cli);
                this._features.put(GRANULAR_PAM, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(PAM)) {
                String[] cli = new String[]{"show ip port-map"};
                replies = this._comm.exec(cli);
                this._features.put(PAM, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(TOP_TALKERS)) {
                String[] cli = new String[]{"show ip flow top-talkers"};
                replies = this._comm.exec(cli);
                this._features.put(TOP_TALKERS, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(NETFLOW_AGGR)) {
                String[] cli = new String[]{"show ip flow top 10 aggregate source-address"};
                replies = this._comm.exec(cli);
                this._features.put(NETFLOW_AGGR, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(NAC)) {
                String[] cli = new String[]{"show ip a?"};
                replies = this._comm.exec(cli);
                this._features.put(NAC, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], "admission")));
                discovered = true;
            } else if (tag.equals(NAC_NRH)) {
                String[] cli = new String[]{"eou clientless ?"};
                replies = this.getComm().config(cli);
                this._features.put(NAC_NRH, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(USB)) {
                this._features.put(USB, new Boolean(XDMDiscovery.isUSBDeviceSupported(this._comm)));
                discovered = true;
            } else if (tag.equals(TOKEN)) {
                String[] cli = new String[]{"crypto pki token?"};
                replies = this._comm.config(cli);
                this._features.put(TOKEN, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], TOKEN)));
                discovered = true;
            } else if (tag.equals(CERT_STORAGE)) {
                String[] cli = new String[]{"crypto pki certificate ?"};
                replies = this._comm.config(cli);
                this._features.put(CERT_STORAGE, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], "storage")));
                discovered = true;
            } else if (tag.equals(RSA_STORAGE)) {
                String[] cli = new String[]{"crypto key generate rsa storage?"};
                replies = this._comm.config(cli);
                this._features.put(RSA_STORAGE, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], "storage")));
                discovered = true;
            } else if (tag.equals(URL_FILTER_SUPPORTS)) {
                String[] cli = new String[]{"show ip urlfilter?"};
                replies = this._comm.exec(cli);
                Log.getLog().debug("################The repli for the URL filtering is####" + replies[0]);
                this._features.put(URL_FILTER_SUPPORTS, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(URL_FILTER_TRUNCATE)) {
                String[] cli = new String[]{"ip urlfilter truncate?"};
                replies = this._comm.config(cli);
                this._features.put(URL_FILTER_TRUNCATE, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], "truncate")));
                discovered = true;
            } else if (tag.equals(URL_FILTER_SOURCE_INTER)) {
                String[] cli = new String[]{"ip urlfilter source-interface?"};
                replies = this._comm.config(cli);
                this._features.put(URL_FILTER_SOURCE_INTER, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], "source-interface")));
                discovered = true;
            } else if (tag.equals(PROTOCOL_EIGRP)) {
                String[] cli = new String[]{"show ip eigrp?"};
                replies = this._comm.exec(cli);
                this._features.put(PROTOCOL_EIGRP, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], EIGRP)));
                discovered = true;
            } else if (tag.equals(APPFW_PHASE_II)) {
                String[] cli = new String[]{"debug appfw application im aol ?"};
                replies = this._comm.exec(cli);
                this._features.put(APPFW_PHASE_II, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (tag.equals(STATIC_NETWORK_NAT_WITH_RMAP)) {
                String[] cli = new String[]{"ip nat inside source static network 10.10.10.0 20.20.20.0 255.255.255.0 route?"};
                replies = this._comm.config(cli);
                this._features.put(STATIC_NETWORK_NAT_WITH_RMAP, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], "route-map")));
                discovered = true;
            } else if (tag.equals(CBAC_AUDIT_TRAIL)) {
                String[] cli = new String[]{"ip inspect ?"};
                replies = this._comm.config(cli);
                this._features.put(CBAC_AUDIT_TRAIL, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], CBAC_AUDIT_TRAIL)));
                discovered = true;
            }
        }
        catch (Exception exception) {}
        return discovered;
    }

    public boolean discovery(String version, IOSCmdService comm, ProcessListener listener) throws Exception {
        Log log = Log.getLog();
        this._comm = comm;
        try {
            if (listener != null) {
                listener.notify(1, 0);
            } else {
                log.debug("Start Device HW discovery");
            }
            this._userView = XDMDiscovery.getCLIViewName(this._comm);
            log.debug("Inside deviceinfo - discovery - _userView" + this._userView);
            VersionInfo vi = XDMDiscovery.getDevInfo(this._comm);
            this._model = vi._hardware;
            this._IOSVersion = vi._iosVersion;
            this._processor = vi._cpu;
            this._imageName = vi._imageName;
            this._bootLocation = vi._bootLocation;
            this._totalMem = vi._totalMem;
            this._flash = vi._flash;
            this._configRegister = vi._configReg;
            log.debug("Inside deviceinfo - discovery - _userView" + this._userView);
            if (this._userView != null && this._userView.trim().length() != 0 && !this._userView.trim().equals("root") && !this.checkMinCommandSupported(this._comm)) {
                throw new XDMException(207);
            }
            this.retrieveFlags(version);
            if (this._model.indexOf("17") == 0 && this._IOSVersion.indexOf("12.2(13)T") == 0 && SubmitCmds.ReachFileMaximum(32, this._comm)) {
                throw new XDMException(21);
            }
            this.buildParser();
            this._hwConfig = XDMDiscovery.getHWConfig(this._comm, this._model);
            if (this._hwConfig == null) {
                throw new XDMException(6);
            }
            if (this._processor.equalsIgnoreCase("NPE-G1") || this._processor.equalsIgnoreCase("NPE-G2")) {
                int i = 0;
                while (i < 3) {
                    this._hwConfig._ifs.addElement(new Integer(4));
                    ++i;
                }
            }
            if (!this.checkIOS122(vi._hardware, vi._iosVersion)) {
                throw new XDMException(20);
            }
            if (listener != null) {
                listener.notify(2, 0);
            } else {
                log.debug("Start IOS features discovery");
            }
            this.discoveryFeatures();
        }
        catch (Exception e) {
            if (listener != null) {
                listener.abort(e);
            } else {
                e.printStackTrace();
            }
            return false;
        }
        this._discovered = true;
        return true;
    }

    private void discoveryFeatures() throws Exception {
        String[] configCLIs = new String[]{"access-list 100 permit ?", "access-list 100 permit udp any eq ?", "access-list 100 permit tcp any eq ?"};
        IOSCmdResponse[] configReplies = this._comm.config(configCLIs);
        ACEProtocols.discoverProtocolsSupported(configReplies[0]);
        IOSCmdResponse[] pmResps = new IOSCmdResponse[]{configReplies[1], configReplies[2]};
        PortMap.discoverUdpPortSupported(pmResps);
    }

    public String getBootLoc() {
        return this._bootLocation;
    }

    public CliBuilder getCliBuilder() {
        block4: {
            if (this._cliBuilder != null) break block4;
            try {
                int i = 0;
                while (i < 10) {
                    Thread.sleep(1000L);
                    if (this._cliBuilder == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._cliBuilder;
    }

    public CmdSet getCmdSet() {
        block4: {
            if (this._cmdSet != null) break block4;
            try {
                int i = 0;
                while (i < 10) {
                    Thread.sleep(1000L);
                    if (this._cmdSet == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._cmdSet;
    }

    public IOSCmdService getComm() {
        return this._comm;
    }

    public int getConfigRegisterValue() {
        return Integer.decode("0x2102");
    }

    public String getCurrentUserCLIView() {
        return this._userView;
    }

    public double getFeatureDouble(String tag) {
        if (!this._features.containsKey(tag) && !this.discoverFeature(tag)) {
            return -1.0;
        }
        Object obj = this._features.get(tag);
        if (!(obj instanceof Double)) {
            return -1.0;
        }
        return (Double)obj;
    }

    public int getFeatureInt(String tag) {
        if (!this._features.containsKey(tag) && !this.discoverFeature(tag)) {
            return -1;
        }
        Object obj = this._features.get(tag);
        if (!(obj instanceof Integer)) {
            return -1;
        }
        return (Integer)obj;
    }

    public Object getFeatureObj(String tag) {
        if (!this._features.containsKey(tag) && !this.discoverFeature(tag)) {
            return null;
        }
        return this._features.get(tag);
    }

    public String getFeatureSetForCLIViewConfig() {
        return "FullSet";
    }

    private String getFlagsFileName(String version) {
        StringBuffer sb = new StringBuffer(System.getProperty("user.home"));
        sb.append("\\SDM-");
        sb.append(version);
        sb.append("-");
        sb.append(this._model);
        sb.append("-");
        sb.append(this._imageName);
        return sb.toString();
    }

    public String getFlashSize() {
        try {
            VersionInfo vi = XDMDiscovery.getDevInfo(this.getComm());
            this._flash = vi._flash;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._flash;
    }

    public HWConfig getHWConfig() {
        return this._hwConfig;
    }

    public String getIOSVersion() {
        return this._IOSVersion;
    }

    public String getImageName() {
        return this._imageName;
    }

    public IOSCmdService getInteractiveComm(CredentialRepository cred) {
        if (cred == null) {
            return null;
        }
        if (this.getComm() instanceof FileIOSCmdService) {
            return this.getComm();
        }
        IOSCmdService newService = null;
        int maxRetries = 3;
        Log log = Log.getLog();
        int i = 0;
        while (i < maxRetries) {
            if (this.isCrypto()) {
                try {
                    newService = IOSCmdServiceFactory.create("ssh", this._host, -1, cred);
                    break;
                }
                catch (IOSCmdServiceException iOSCmdServiceException) {
                    log.debug("not able to connect through ssh");
                    newService = null;
                }
            }
            if (newService == null) {
                try {
                    newService = IOSCmdServiceFactory.create("telnet", this._host, -1, cred);
                    break;
                }
                catch (IOSCmdServiceException iOSCmdServiceException) {
                    log.debug("not able to connect through ssh");
                    newService = null;
                    cred.setCredential(1, null);
                    cred.setCredential(2, null);
                }
            }
            ++i;
        }
        return newService;
    }

    public String getIpAddr() {
        block2: {
            if (_addr != null) break block2;
            try {
                InetAddress inetAddr = InetAddress.getByName(this._host);
                _addr = inetAddr.getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return _addr;
    }

    public String getMemSize() {
        return this._totalMem;
    }

    public String getModel() {
        return this._model;
    }

    public ConfigParser getParser() {
        block4: {
            if (this._parser != null) break block4;
            try {
                int i = 0;
                while (i < 10) {
                    Thread.sleep(1000L);
                    if (this._parser == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._parser;
    }

    public String getProcessor() {
        return this._processor;
    }

    public IOSCmdService getSharedInteractiveComm(CredentialRepository cred) {
        if (this._sharedSvc == null || !this._sharedCred.equalTo(cred)) {
            this._sharedSvc = this.getInteractiveComm(cred);
            this._sharedCred = cred;
        }
        return this._sharedSvc;
    }

    protected int getV1(String version) {
        int ret = 0;
        int start = version.indexOf("(");
        if (start >= 0 && start + 1 < version.length()) {
            int i = start + 1;
            char ch = version.charAt(i);
            while (i < version.length() && Character.isDigit(ch)) {
                ret = ret * 10 + Character.digit(ch, 10);
                if (++i >= version.length()) continue;
                ch = version.charAt(i);
            }
        }
        return ret;
    }

    protected String getV2(String version) {
        StringBuffer ret = new StringBuffer();
        int start = version.indexOf(")");
        if (start >= 0 && start + 1 < version.length()) {
            int i = start + 1;
            char ch = version.charAt(i);
            while (i < version.length() && !Character.isDigit(ch)) {
                ret.append(ch);
                if (++i >= version.length()) continue;
                ch = version.charAt(i);
            }
        }
        return ret.toString();
    }

    protected int getV3(String version) {
        int ret = 0;
        int start = version.indexOf(")");
        if (start >= 0 && start + 1 < version.length()) {
            int i = start + 1;
            char ch = version.charAt(i);
            while (i < version.length() && !Character.isDigit(ch)) {
                if (++i >= version.length()) continue;
                ch = version.charAt(i);
            }
            while (i < version.length() && Character.isDigit(ch)) {
                ret = ret * 10 + Character.digit(ch, 10);
                if (++i >= version.length()) continue;
                ch = version.charAt(i);
            }
        }
        return ret;
    }

    public boolean isCBAC() {
        return this.isSupported(CBAC);
    }

    public boolean isCLIViewSupported() {
        if (this._IOSVersion != null && this._IOSVersion.indexOf("12.3(8)YA") != -1 && this._model != null && this._model.toLowerCase().indexOf("c8") == 0) {
            return false;
        }
        return this.isSupported(CLIVIEW);
    }

    public boolean isCrypto() {
        String strModel = this.getModel();
        if (strModel.equalsIgnoreCase("SB101") || strModel.equalsIgnoreCase("SB106") || strModel.equalsIgnoreCase("SB107")) {
            return false;
        }
        return this.isSupported(CRYPTO);
    }

    public boolean isDiscovered() {
        return this._discovered;
    }

    public boolean isEIGRP() {
        return this.isSupported(EIGRP);
    }

    public boolean isEIGRPSupported() {
        return this.isSupported(PROTOCOL_EIGRP);
    }

    public boolean isExtendedPing() {
        return this.isSupported(EXTENDED_PING);
    }

    public boolean isFlowAggrSupported() {
        return this.isSupported(NETFLOW_AGGR);
    }

    public boolean isGranularPAMSupported() {
        return this.isSupported(GRANULAR_PAM);
    }

    public boolean isHTTPs() {
        return this.isSupported(HTTPS);
    }

    public boolean isIPSLACommandSupported() {
        return this.isSupported(IP_SLA_CMD);
    }

    public boolean isIPSLAOnlySupported() {
        return this.isSupported(IP_SLA_ONLY);
    }

    public boolean isIPSLASupported() {
        return this.isSupported(IP_SLA);
    }

    public boolean isIpCEF() {
        return this.isSupported(IP_CEF);
    }

    public boolean isMOP() {
        return this.isSupported(MOP);
    }

    public boolean isMultilinkSupported() {
        return this.isSupported(MULTILINK);
    }

    public boolean isNamedACLSupported() {
        return this.isSupported(NAMED_ACL);
    }

    public boolean isOSPF() {
        return this.isSupported(OSPF);
    }

    public boolean isPAMSupported() {
        return this.isSupported(PAM);
    }

    public boolean isPPPoE() {
        return this.isSupported(PPPOE);
    }

    public boolean isPPPoENeedVpdn() {
        return this.isSupported(PPPOE_NeedVPDN);
    }

    public boolean isRIP() {
        return this.isSupported(RIP);
    }

    public boolean isRTRCommandSupported() {
        return this.isSupported(RTR_CMD);
    }

    public boolean isRTRSupported() {
        return this.isSupported(RTR);
    }

    public boolean isShowEnvironmentSupported() {
        return this.isSupported(ENV_SUPP);
    }

    public boolean isShowProtocolSupported() {
        return this.isSupported(PROTOCOLS_SUPP);
    }

    public boolean isSupported(String tag) {
        if (!this._features.containsKey(tag) && !this.discoverFeature(tag)) {
            return false;
        }
        return (Boolean)this._features.get(tag);
    }

    public boolean isSupported(String tag, String cli, String phrase) {
        Object obj;
        if (!this._features.containsKey(tag)) {
            String[] words = new String[]{phrase};
            this._features.put(tag, new Boolean(XDMDiscovery.findFromConfigOutput(this.getComm(), cli, words)));
        }
        if (!((obj = this._features.get(tag)) instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public boolean isTTISupported() {
        return this.isSupported(EASY_SDD);
    }

    public boolean isTopTalkersSupported() {
        return this.isSupported(TOP_TALKERS);
    }

    public boolean isUSBDeviceSupported() {
        return this.isSupported(USB);
    }

    public boolean isVPDN() {
        return this.isSupported(VPDN);
    }

    public boolean isViewSecretSupported() {
        return this.isSupported(VIEW_SECRET);
    }

    public void retrieveFlags(String version) {
        if (version == null) {
            return;
        }
        String fileName = this.getFlagsFileName(version);
        try {
            if (Class.forName("com.ms.security.PolicyEngine") != null) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            }
        }
        catch (Throwable throwable) {}
        try {
            FileInputStream fis = SgzApplet.createFileInputStream(new File(fileName));
            ObjectInputStream ois = new ObjectInputStream(fis);
            this._features = (Hashtable)ois.readObject();
            SystemProp.setFeatures((Hashtable)ois.readObject());
            ois.close();
        }
        catch (Exception exception) {}
    }

    public void saveFlags(String version) {
        if (version == null) {
            return;
        }
        String fileName = this.getFlagsFileName(version);
        try {
            FileOutputStream fos = SgzApplet.createFileOutputStream(new File(fileName));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this._features);
            oos.writeObject(SystemProp.getFeatures());
            oos.close();
        }
        catch (Exception exception) {}
    }

    public void setComm(IOSCmdService comm) {
        this._comm = comm;
    }

    void setHWConfig(HWConfig hw) {
        this._hwConfig = hw;
    }

    public void setViewTampered() {
        if (this._userView != null && this._userView.length() > 0) {
            this._userView = String.valueOf(this._userView) + "Tampered";
        }
    }

    class BuildParser
    extends Thread {
        DevInfoBase _info;

        public BuildParser(DevInfoBase info) {
            this._info = info;
        }

        public void run() {
            try {
                this._info._cmdSet = GrammarLocator.getCmdSet(this._info._IOSVersion, this._info._model, "/grammar/");
                this._info._parser = new ConfigParser(this._info._IOSVersion, this._info._model, "/grammar/");
                this._info._cliBuilder = new CliBuilder(this._info._IOSVersion, this._info._model, "/grammar/");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

