/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.base;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.SubmitListener;
import com.cisco.xdm.net.cmdsvc.FileIOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.PAIIOSCmdService;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import com.cisco.xdm.net.cmdsvc.RcpDelivery;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SubmitCmds
extends Thread {
    private SubmitListener _listener;
    private Vector _cmds;
    private IOSCmdService _comm;
    private boolean _configMode;
    public static final String INFO_SUBMIT_CMDS = "Submitting";
    private static String _localAddr = null;
    public static final int MAX_CLI = 130;
    public static final String BOOKMARK_FINAL = "IP address / user account command";
    public static final int NS_YES = 1;
    public static final int NS_NO = 0;
    public static final int NS_ERROR_NOFREESPACE = -1;
    public static final int NS_ERROR_MAXFILENUMBER = -2;
    public static final int NS_ERROR_WRONG_PARAMETER = -3;
    public static final int NS_ERROR_IO_RESPONSE = -4;

    public SubmitCmds(IOSCmdService comm, Vector cmds, SubmitListener listener) {
        this._listener = listener;
        this._cmds = cmds;
        this._comm = comm;
        this._configMode = true;
    }

    public SubmitCmds(IOSCmdService comm, Vector cmds, SubmitListener listener, boolean cfgMode) {
        this._listener = listener;
        this._cmds = cmds;
        this._comm = comm;
        this._configMode = cfgMode;
    }

    private boolean PAISubmit(Vector commands) {
        if (commands == null || commands.size() == 0) {
            return true;
        }
        String[] statusCodeStr = new String[]{"UNKNOWN", "OK", "ERROR"};
        try {
            if (this._listener.notify(false, INFO_SUBMIT_CMDS, String.valueOf(this._cmds.size()), 1)) {
                Vector splitVector = SubmitCmds.splitIfEasyVPNGroupPolicyExists(commands);
                int count = 0;
                while (count < splitVector.size()) {
                    Vector cmds = (Vector)splitVector.elementAt(count);
                    Object[] cmdArray = new String[cmds.size()];
                    cmds.copyInto(cmdArray);
                    IOSCmdResponse[] replies = this._configMode ? this._comm.config((String[])cmdArray) : this._comm.exec((String[])cmdArray);
                    int i = 0;
                    while (i < replies.length) {
                        String resp = replies[i].getOutput();
                        int status = replies[i].getStatus();
                        if (resp != null && resp.indexOf(94) >= 0) {
                            status = 2;
                        }
                        if (!this._listener.notify(true, replies[i].getCmd(), replies[i].getOutput(), status)) {
                            return false;
                        }
                        ++i;
                    }
                    ++count;
                }
            }
        }
        catch (Exception e) {
            this._listener.abort(e);
            return false;
        }
        return true;
    }

    public static boolean ReachFileMaximum(int max, IOSCmdService comm) throws Exception {
        IOSCmdResponse[] reply = comm.exec(new String[]{"show flash"});
        if (reply == null || reply.length == 0) {
            throw new Exception("Cannot detect device information");
        }
        BufferedReader bfr = new BufferedReader(new InputStreamReader(new StringBufferInputStream(reply[reply.length - 1].getOutput())));
        String line = null;
        int count = 0;
        int index = 1;
        while ((line = bfr.readLine()) != null) {
            if (line.length() <= 0) continue;
            StringTokenizer st = new StringTokenizer(line);
            String token = st.nextToken();
            try {
                int num = Integer.valueOf(token);
                if (index != num) continue;
                ++index;
                if (line.indexOf("[deleted]") >= 0) continue;
                ++count;
            }
            catch (Exception exception) {}
        }
        return count >= max;
    }

    private static boolean commNeedRCP(IOSCmdService comm) {
        return (comm instanceof PAIIOSCmdService || comm instanceof FileIOSCmdService) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public static String getClientAddrOnRouter(IOSCmdService comm) throws Exception {
        if (comm instanceof FileIOSCmdService) {
            return "127.0.0.1";
        }
        if (_localAddr == null) {
            Log log = Log.getLog();
            int curTimeout = comm.getTimeout();
            try {
                int end;
                String key;
                String line = SubmitCmds.getCurrentLine(comm);
                if (line == null) {
                    throw new Exception("cannot get line number from show whoami");
                }
                comm.setTimeout(60000);
                IOSCmdResponse[] shCallerReply = comm.exec(new String[]{"show caller line " + line + " full"});
                if (shCallerReply == null || shCallerReply.length == 0) {
                    throw new Exception("cannot get response from show caller");
                }
                String host = null;
                log.debug("show caller -- " + shCallerReply[shCallerReply.length - 1].getOutput());
                StringTokenizer st = new StringTokenizer(shCallerReply[shCallerReply.length - 1].getOutput());
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.equalsIgnoreCase("remote")) continue;
                    if (!st.hasMoreTokens()) break;
                    host = st.nextToken();
                    break;
                }
                if (host == null) {
                    throw new Exception("cannot get host from show caller");
                }
                IOSCmdResponse[] pingReply = comm.exec(new String[]{"ping " + host});
                if (pingReply == null || pingReply.length == 0) {
                    throw new Exception("cannot get response from ping");
                }
                String output = pingReply[pingReply.length - 1].getOutput();
                int start = output.indexOf(key = "ICMP Echos to ");
                if (start > 0 && (end = output.indexOf(",", start)) > start) {
                    _localAddr = output.substring(start + key.length(), end);
                }
            }
            catch (Exception e) {
                void line;
                comm.setTimeout(curTimeout);
                throw line;
            }
            comm.setTimeout(curTimeout);
        }
        return _localAddr;
    }

    private static String getCurrentLine(IOSCmdService comm) throws Exception {
        String line = null;
        Log log = Log.getLog();
        log.debug("Retrieve client ip address on the router");
        boolean reseted = false;
        while (true) {
            String whoami;
            IOSCmdResponse[] reply;
            if ((reply = comm.exec(new String[]{whoami = "show whoami\r\n"}, new PromptHandlerIf(){

                public String handle(String[] devOutput) {
                    if (devOutput[devOutput.length - 1].trim().toLowerCase().indexOf("more--") > -1) {
                        return "\r\n";
                    }
                    return null;
                }
            })) == null || reply.length == 0) {
                throw new Exception("cannot get response from show whoami");
            }
            log.debug("show whoami -- " + reply[reply.length - 1].getOutput());
            StringTokenizer st = new StringTokenizer(reply[reply.length - 1].getOutput());
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equalsIgnoreCase("Line")) continue;
                if (!st.hasMoreTokens()) break;
                line = st.nextToken();
                break;
            }
            if (line != null || reseted) break;
            reseted = true;
            comm.close();
        }
        return line;
    }

    public static int getNumCLIs(Vector cmds) {
        int count = 0;
        if (cmds != null) {
            Enumeration e = cmds.elements();
            while (e.hasMoreElements()) {
                String item = (String)e.nextElement();
                if (item.charAt(0) == '!') continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean needRCP(DeviceBase dev) {
        boolean ret = false;
        if (dev != null) {
            ret = SubmitCmds.commNeedRCP(dev.getDevInfoBase().getComm());
        }
        return ret;
    }

    public static int needSqueeze(DeviceBase dev, Vector cmds) {
        if (dev == null || cmds == null) {
            return -3;
        }
        if (!SubmitCmds.needRCP(dev)) {
            return 0;
        }
        int MAX_FILE = dev.getDevInfoBase().getModel().toLowerCase().indexOf("c8") == 0 || dev.getDevInfoBase().getModel().indexOf("17") == 0 && dev.getDevInfoBase().getIOSVersion().indexOf("12.2(13)T") == 0 ? 32 : (dev.getDevInfoBase().getIOSVersion().indexOf("12.2") == 0 ? 64 : 256);
        int extraSpace = 50000;
        int maxSize = -1;
        int numFiles = -1;
        Log log = Log.getLog();
        try {
            IOSCmdResponse[] reply = dev.getDevInfoBase().getComm().exec(new String[]{"show flash"});
            if (reply == null || reply.length == 0) {
                return -4;
            }
            log.debug("show flash -- " + reply[reply.length - 1].getOutput());
            BufferedReader bfr = new BufferedReader(new InputStreamReader(new StringBufferInputStream(reply[reply.length - 1].getOutput())));
            String line = null;
            String preLine = null;
            while ((line = bfr.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) == '[' && preLine != null && preLine.length() > 0) {
                    StringTokenizer st = new StringTokenizer(preLine);
                    String token = st.nextToken();
                    numFiles = Integer.valueOf(token);
                    int begin = line.indexOf(",");
                    int end = line.indexOf("available");
                    if (begin >= 0 && end > begin) {
                        String freeSpace = line.substring(begin + 1, end).trim();
                        maxSize = Integer.valueOf(freeSpace);
                    }
                    break;
                }
                int dosFSmarker = line.indexOf("bytes available");
                if (dosFSmarker >= 0) {
                    return 0;
                }
                preLine = line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -4;
        }
        if (maxSize < 0) {
            return -4;
        }
        if (numFiles < 0) {
            return -4;
        }
        StringBuffer sb = new StringBuffer();
        Enumeration e = cmds.elements();
        while (e.hasMoreElements()) {
            String item = (String)e.nextElement();
            sb.append(item);
            sb.append("\n");
        }
        byte[] bcmds = sb.toString().getBytes();
        return bcmds.length + extraSpace > maxSize || numFiles >= MAX_FILE ? 1 : 0;
    }

    public synchronized void run() {
        if (this._comm instanceof FileIOSCmdService) {
            this.runFileCmd();
            return;
        }
        if (this._comm != null) {
            if (SubmitCmds.commNeedRCP(this._comm)) {
                this.runRCP();
            } else {
                this.runPAI();
            }
        }
    }

    private void runFileCmd() {
        this._listener.finish();
    }

    private void runPAI() {
        Vector datas = new Vector();
        if (this._cmds != null && this._cmds.size() >= 0) {
            Vector<String> commands = new Vector<String>();
            int i = 0;
            int index = 0;
            while (index < this._cmds.size()) {
                String item = (String)this._cmds.elementAt(index);
                if (item.startsWith("! IP address / user account command")) {
                    if (this._cmds.size() - 1 - index + i > 130) {
                        datas.addElement(commands);
                        commands = new Vector();
                        i = 0;
                    }
                } else if (i < 130) {
                    commands.addElement(item);
                    ++i;
                } else {
                    datas.addElement(commands);
                    Vector<String> nCmds = new Vector<String>();
                    i = 0;
                    if (item.startsWith(" ")) {
                        while (commands.size() > 0) {
                            String old = (String)commands.elementAt(commands.size() - 1);
                            nCmds.insertElementAt(old, 0);
                            commands.removeElementAt(commands.size() - 1);
                            ++i;
                            if (old.charAt(0) != ' ') break;
                        }
                    }
                    commands = nCmds;
                    commands.addElement(item);
                    ++i;
                }
                ++index;
            }
            if (commands.size() > 0) {
                datas.addElement(commands);
            }
            boolean ok = true;
            i = 0;
            while (ok && i < datas.size()) {
                Vector cmds = (Vector)datas.elementAt(i);
                ok = this.PAISubmit(cmds);
                ++i;
            }
            if (ok) {
                this._listener.finish();
            }
        }
    }

    private void runRCP() {
        if (!this._listener.notify(false, INFO_SUBMIT_CMDS, String.valueOf(this._cmds.size()), 1)) {
            return;
        }
        try {
            int curTimeout = this._comm.getTimeout();
            String localAddr = SubmitCmds.getClientAddrOnRouter(this._comm);
            if (localAddr == null) {
                throw new Exception("cannot get local address from router");
            }
            RcpDelivery rd = new RcpDelivery(this._comm, localAddr);
            StringBuffer sb = new StringBuffer();
            Enumeration e = this._cmds.elements();
            while (e.hasMoreElements()) {
                String item = (String)e.nextElement();
                sb.append(item);
                sb.append("\n");
            }
            sb.append("end\n");
            byte[] cmds = sb.toString().getBytes();
            this._comm.setTimeout(60000);
            rd.send(cmds);
            this._comm.setTimeout(curTimeout);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._listener.abort(ex);
            return;
        }
        this._listener.finish();
    }

    private static Vector splitIfEasyVPNGroupPolicyExists(Vector cmds) {
        String CMD_START = "crypto isakmp client configuration group";
        String CMD_END = "exit";
        Vector splitVectors = new Vector();
        Vector<String> clis = new Vector<String>();
        boolean isGroupPolicyCmd = false;
        if (cmds != null) {
            Enumeration e = cmds.elements();
            while (e.hasMoreElements()) {
                String iosCmd = (String)e.nextElement();
                if (iosCmd.trim().regionMatches(true, 0, "crypto isakmp client configuration group", 0, "crypto isakmp client configuration group".length())) {
                    isGroupPolicyCmd = true;
                    clis.addElement(iosCmd);
                    continue;
                }
                if (iosCmd.trim().equals("exit") && isGroupPolicyCmd) {
                    clis.addElement(iosCmd);
                    splitVectors.addElement(clis);
                    clis = new Vector();
                    isGroupPolicyCmd = false;
                    continue;
                }
                clis.addElement(iosCmd);
            }
            if (!clis.isEmpty()) {
                splitVectors.addElement(clis);
            }
        }
        return splitVectors;
    }
}

