/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.base;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.MiscUtils;
import com.cisco.xdm.data.base.XDMException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class XDMObject
implements Cloneable {
    private boolean _isReadOnly = false;
    private int _reason4RO = 0;
    private boolean _isModified = false;
    private XDMObject _parent = null;
    private Hashtable _objects = null;
    private Hashtable _attrs = null;

    public XDMObject() {
    }

    public XDMObject(XDMObject parent) {
        this._parent = parent;
        this._isReadOnly = false;
        this._isModified = false;
    }

    public XDMObject(XDMObject parent, boolean readOnly) {
        this._parent = parent;
        this._isReadOnly = readOnly;
        this._isModified = false;
    }

    protected void addObject(String key, XDMObject child) {
        if (this._objects == null) {
            this._objects = new Hashtable();
        }
        this._objects.put(key, child);
        child.setParent(this);
    }

    public Object clone() {
        try {
            Object key;
            Enumeration e;
            Object newObj = super.clone();
            XDMObject dmObj = (XDMObject)newObj;
            if (this._objects != null) {
                dmObj._objects = new Hashtable();
                e = this._objects.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    XDMObject obj = (XDMObject)this._objects.get(key);
                    XDMObject clonedObj = (XDMObject)obj.clone();
                    clonedObj.setParent(dmObj);
                    dmObj._objects.put(key, clonedObj);
                }
            }
            if (this._attrs != null) {
                dmObj._attrs = new Hashtable();
                e = this._attrs.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    Object val = this._attrs.get(key);
                    dmObj._attrs.put(key, val);
                }
            }
            return newObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XDMObject)) {
            return false;
        }
        XDMObject o = (XDMObject)obj;
        if (this._objects != null) {
            return MiscUtils.hashtableEquals(this._objects, o._objects);
        }
        if (this.isDeepEqual()) {
            return true;
        }
        return super.equals(obj);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup != null && !(backup instanceof XDMObject)) {
            return;
        }
        if (this._objects == null) {
            return;
        }
        XDMObject bObj = backup;
        Enumeration e = this._objects.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            XDMObject cur = (XDMObject)this._objects.get(key);
            XDMObject old = null;
            if (bObj != null) {
                old = (XDMObject)bObj._objects.get(key);
            }
            if (cur.isReadOnly() || !cur.isModified() && old != null) continue;
            cur.generateDelta(old, values);
        }
    }

    public Object getAttr(String attr) {
        if (this._attrs == null) {
            return null;
        }
        return this._attrs.get(attr);
    }

    public boolean getBooleanAttr(String attr) {
        Object obj = this.getAttr(attr);
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public XDMObject getDevice() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getDevice();
    }

    public int getIntAttr(String attr) {
        Object obj = this.getAttr(attr);
        if (obj != null && obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public XDMObject getObject(String key) {
        if (this._objects == null) {
            return null;
        }
        return (XDMObject)this._objects.get(key);
    }

    public XDMObject getParent() {
        return this._parent;
    }

    public int getROReason() {
        return this._reason4RO;
    }

    public String getStrAttr(String attr) {
        Object obj = this.getAttr(attr);
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    public boolean isBackup() {
        XDMObject dev = this.getDevice();
        if (dev != null) {
            return dev.isBackup();
        }
        return false;
    }

    public boolean isDeepEqual() {
        return false;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (this._objects == null) {
            return;
        }
        Enumeration e = this._objects.elements();
        while (e.hasMoreElements()) {
            XDMObject element = (XDMObject)e.nextElement();
            element.populate(config, cmdVal);
        }
    }

    public void resetClonedObjects() {
        Object key;
        Enumeration e;
        if (this._objects != null) {
            e = this._objects.keys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                XDMObject obj = (XDMObject)this._objects.get(key);
                obj.resetClonedObjects();
                obj = null;
            }
        }
        if (this._attrs != null) {
            e = this._attrs.keys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                Object val = this._attrs.get(key);
                Object var3_3 = null;
            }
        }
        this._objects = null;
        this._attrs = null;
    }

    public void resetModifiedFlag() {
        this._isModified = false;
        if (this._objects != null) {
            Enumeration e = this._objects.elements();
            while (e.hasMoreElements()) {
                XDMObject obj = (XDMObject)e.nextElement();
                obj.resetModifiedFlag();
            }
        }
    }

    public void setAttr(String attr, int val) {
        this.setAttr(attr, new Integer(val));
    }

    public void setAttr(String attr, Object val) {
        if (this._attrs == null) {
            this._attrs = new Hashtable();
        }
        this._attrs.put(attr, val);
        this.setModified();
    }

    public void setAttr(String attr, boolean val) {
        this.setAttr(attr, new Boolean(val));
    }

    protected void setModified() {
        if (!this._isModified) {
            this._isModified = true;
        }
        if (this._parent != null && !this._parent.isModified()) {
            this._parent.setModified();
        }
    }

    public void setParent(XDMObject parent) {
        this._parent = parent;
    }

    protected void setROReason(int reason) {
        this._reason4RO = reason;
    }

    protected void setReadOnly(boolean flag) {
        this._isReadOnly = flag;
    }

    public String toString() {
        return this.getClass().toString();
    }
}

