/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.feed.FwFeed;
import com.cisco.xdm.data.cbac.feed.FwResource;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CBACDiscover
extends XDMObject {
    private FwFeed feed;
    private Hashtable _protocols = new Hashtable();

    public CBACDiscover(FwFeed feed) {
        this.feed = feed;
        this.init();
    }

    public boolean attach(DeviceBase dev) {
        Log.getInstance().debug("CBAC Disover: discovering inspection protocols.");
        if (dev == null) {
            Log.getInstance().debug("CBAC Disover: discover failed, use built in protocols.");
            return false;
        }
        IOSCmdService _comm = dev.getDevInfoBase().getComm();
        if (_comm == null) {
            Log.getInstance().debug("CBAC Disover: discover failed, use built in protocols.");
            return false;
        }
        String[] cmds = new String[]{"ip inspect name test ?"};
        IOSCmdResponse[] response = null;
        try {
            response = _comm.config(cmds);
        }
        catch (IOSCmdServiceException e) {
            e.printStackTrace();
            Log.getInstance().debug("CBAC Disover: discover failed, use built in protocols.");
            return false;
        }
        StringBuffer keyvalue = new StringBuffer();
        int i = 0;
        while (i < response.length) {
            keyvalue.append(response[i].getOutput()).append("\n");
            ++i;
        }
        this._protocols.clear();
        String line = "";
        int pos = 0;
        String key = "";
        String value = "";
        StringTokenizer lineToken = new StringTokenizer(keyvalue.toString(), "\n");
        boolean bUseRouterDesc = false;
        FwResource res = this.feed.getResource();
        if (res == null) {
            bUseRouterDesc = true;
        }
        while (lineToken.hasMoreTokens()) {
            line = lineToken.nextToken();
            if (!line.startsWith(" ") || (line = line.trim()).equals("") || (pos = line.indexOf(32)) == -1) continue;
            key = line.substring(0, pos).trim();
            value = line.substring(pos + 1).trim();
            if (key.equals("appfw") || key.equals("parameter")) continue;
            this._protocols.put(key, bUseRouterDesc ? value : res.getResHelp(key));
        }
        return this._protocols.isEmpty() ^ true;
    }

    public Object clone() {
        CBACDiscover cloneEntry = (CBACDiscover)super.clone();
        cloneEntry.feed = this.feed;
        cloneEntry._protocols = new Hashtable();
        Enumeration enps = this._protocols.keys();
        while (enps.hasMoreElements()) {
            String anewString = new String((String)enps.nextElement());
            cloneEntry._protocols.put(anewString, this._protocols.get(anewString));
        }
        return cloneEntry;
    }

    public Hashtable getProtocols() {
        return this._protocols;
    }

    private void init() {
        if (this.feed == null) {
            this._protocols.put("cuseeme", "CUSeeMe Protocol");
            this._protocols.put("fragment", "IP fragment inspection");
            this._protocols.put("ftp", "File Transfer Protocol");
            this._protocols.put("h323", "H.323 Protocol (e.g, MS NetMeeting, Intel Video Phone)");
            this._protocols.put("http", "HTTP Protocol");
            this._protocols.put("netshow", "Microsoft NetShow Protocol");
            this._protocols.put("rcmd", "R commands (r-exec, r-login, r-sh)");
            this._protocols.put("realaudio", "Real Audio Protocol");
            this._protocols.put("rpc", "Remote Prodedure Call Protocol");
            this._protocols.put("rtsp", "Real Time Streaming Protocol");
            this._protocols.put("smtp", "Simple Mail Transfer Protocol");
            this._protocols.put("sqlnet", "SQL Net Protocol");
            this._protocols.put("streamworks", "StreamWorks Protocol");
            this._protocols.put("tcp", "Transmission Control Protocol");
            this._protocols.put("tftp", "TFTP Protocol");
            this._protocols.put("udp", "User Datagram Protocol");
            this._protocols.put("vdolive", "VDOLive Protocol");
        } else {
            FwResource res = this.feed.getResource();
            if (res == null) {
                return;
            }
            this._protocols.put("cuseeme", res.getResHelp("cuseeme"));
            this._protocols.put("fragment", res.getResHelp("fragment"));
            this._protocols.put("ftp", res.getResHelp("ftp"));
            this._protocols.put("h323", res.getResHelp("h323"));
            this._protocols.put("http", res.getResHelp("http"));
            this._protocols.put("netshow", res.getResHelp("netshow"));
            this._protocols.put("rcmd", res.getResHelp("rcmd"));
            this._protocols.put("realaudio", res.getResHelp("realaudio"));
            this._protocols.put("rpc", res.getResHelp("rpc"));
            this._protocols.put("rtsp", res.getResHelp("rtsp"));
            this._protocols.put("smtp", res.getResHelp("smtp"));
            this._protocols.put("sqlnet", res.getResHelp("sqlnet"));
            this._protocols.put("streamworks", res.getResHelp("streamworks"));
            this._protocols.put("tcp", res.getResHelp("tcp"));
            this._protocols.put("tftp", res.getResHelp("tftp"));
            this._protocols.put("udp", res.getResHelp("udp"));
            this._protocols.put("vdolive", res.getResHelp("vdolive"));
        }
    }

    public boolean isProtocolOptionSupported(DeviceBase dev, String protocol, String option) {
        String cli = "ip inspect name test " + protocol + " ?";
        return dev.getDevInfoBase().isSupported("INSPECT_" + protocol + "_" + option, cli, option);
    }

    public boolean isProtocolSupported(String protocol) {
        return this._protocols.containsKey(protocol);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        Enumeration enps = this._protocols.keys();
        String key = "";
        while (enps.hasMoreElements()) {
            key = (String)enps.nextElement();
            str.append(String.valueOf(key) + ": " + (String)this._protocols.get(key) + System.getProperty("line.separator"));
        }
        str.append(System.getProperty("line.separator"));
        return str.toString();
    }
}

