/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.CBACRuleEntry;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import java.util.Enumeration;
import java.util.Vector;

public class CBACRule
extends XDMObject {
    protected String sName;
    protected long nMaxSessions = -1L;
    protected String appfwPolicyName = "";
    protected Vector RuleEntryHolder;

    public CBACRule(XDMObject parent, String name) {
        super(parent);
        this.sName = name;
        this.appfwPolicyName = "";
        this.RuleEntryHolder = new Vector();
    }

    public CBACRule(XDMObject parent, String name, boolean readonly) {
        super(parent, readonly);
        this.sName = name;
        this.RuleEntryHolder = new Vector();
    }

    public void addRuleEntry(CBACRuleEntry entry) {
        entry.setParent(this.getParent());
        try {
            int i = 0;
            while (i < this.RuleEntryHolder.size()) {
                CBACRuleEntry theEntry = (CBACRuleEntry)this.RuleEntryHolder.elementAt(i);
                if (theEntry.getProtocol().equals(entry.getProtocol())) {
                    if (theEntry.getProtocol().equals("rpc")) {
                        if (entry.getOption("program-number") != null && theEntry.getOption("program-number") != null && theEntry.getOption("program-number").equals(entry.getOption("program-number"))) {
                            this.RuleEntryHolder.setElementAt(entry, i);
                            this.setModified();
                            return;
                        }
                    } else {
                        this.RuleEntryHolder.setElementAt(entry, i);
                        this.setModified();
                        return;
                    }
                }
                ++i;
            }
            if (!entry.getProtocol().equalsIgnoreCase("rpc") || entry.getOption("program-number") != null) {
                this.RuleEntryHolder.addElement(entry);
                this.setModified();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public Object clone() {
        CBACRule cloneEntry = null;
        cloneEntry = (CBACRule)super.clone();
        cloneEntry.sName = this.sName;
        cloneEntry.nMaxSessions = this.nMaxSessions;
        cloneEntry.appfwPolicyName = this.appfwPolicyName;
        cloneEntry.RuleEntryHolder = new Vector();
        Enumeration en = this.RuleEntryHolder.elements();
        while (en.hasMoreElements()) {
            CBACRuleEntry newRuleEntry = (CBACRuleEntry)((CBACRuleEntry)en.nextElement()).clone();
            cloneEntry.addRuleEntry(newRuleEntry);
            newRuleEntry.setParent(cloneEntry);
        }
        return cloneEntry;
    }

    public void empty() {
        this.RuleEntryHolder.removeAllElements();
        this.setModified();
    }

    public boolean equals(CBACRule r) {
        if (!this.sName.equals(r.getName())) {
            return false;
        }
        return this.equalsIgnoreName(r);
    }

    public boolean equalsIgnoreName(CBACRule r) {
        if (this.ruleEntryCount() != r.ruleEntryCount()) {
            return false;
        }
        if (!this.appfwPolicyName.equals(r.appfwPolicyName)) {
            return false;
        }
        Enumeration en = this.RuleEntryHolder.elements();
        while (en.hasMoreElements()) {
            CBACRuleEntry ruleEntry1 = (CBACRuleEntry)en.nextElement();
            if (!ruleEntry1.getSelected()) continue;
            CBACRuleEntry ruleEntry2 = null;
            if (ruleEntry1.getProtocol().equalsIgnoreCase("rpc")) {
                long rpcNumber = Long.parseLong(ruleEntry1.getOption("program-number"));
                ruleEntry2 = r.getRPCRuleEntry(rpcNumber);
            } else {
                ruleEntry2 = r.getRuleEntry(ruleEntry1.getProtocol());
            }
            if (ruleEntry2 == null || !ruleEntry2.getSelected()) {
                return false;
            }
            if (ruleEntry1.equals(ruleEntry2)) continue;
            return false;
        }
        return true;
    }

    public int generateDelta(CBACRule old, ConfigValues values, int index) {
        if (old != null && this.nMaxSessions != old.nMaxSessions || old == null && this.nMaxSessions != -1L) {
            CmdValues cmdMaxSessions = new CmdValues("ip");
            cmdMaxSessions.addValue("inspect", "inspect");
            cmdMaxSessions.addValue("inspectname", this.sName);
            cmdMaxSessions.addValue("parameter", "parameter");
            cmdMaxSessions.addValue("maxsessions", Long.toString(this.nMaxSessions));
            if (index >= 0) {
                values.insertCmdValues(cmdMaxSessions, index++);
            } else {
                values.addCmdValues(cmdMaxSessions);
            }
        }
        if (old != null && !this.appfwPolicyName.equals(old.appfwPolicyName) || old == null && !this.appfwPolicyName.equals("")) {
            CmdValues cmdAppfwPolicy = new CmdValues("ip");
            cmdAppfwPolicy.addValue("inspect", "inspect");
            cmdAppfwPolicy.addValue("inspectname", this.sName);
            cmdAppfwPolicy.addValue("appfw", "appfw");
            cmdAppfwPolicy.addValue("policyname", this.appfwPolicyName);
            if (old != null && !old.appfwPolicyName.equals("") && this.appfwPolicyName.equals("")) {
                cmdAppfwPolicy.setAction(2);
            }
            if (index >= 0) {
                values.insertCmdValues(cmdAppfwPolicy, index++);
            } else {
                values.addCmdValues(cmdAppfwPolicy);
            }
        }
        if (old != null) {
            Enumeration e = old.RuleEntryHolder.elements();
            while (e.hasMoreElements()) {
                CBACRuleEntry entry1 = (CBACRuleEntry)e.nextElement();
                if (!entry1.getSelected()) continue;
                CBACRuleEntry entry2 = null;
                entry2 = entry1.getProtocol().equals("rpc") ? this.getRPCRuleEntry(entry1.getOptionAsLong("program-number")) : this.getRuleEntry(entry1.getProtocol());
                if (entry2 != null) continue;
                CmdValues entry1CmdValues = entry1.getCmdValues(old.getName());
                entry1CmdValues.setAction(2);
                if (index >= 0) {
                    values.insertCmdValues(entry1CmdValues, index++);
                    continue;
                }
                values.addCmdValues(entry1CmdValues);
            }
            Enumeration en = this.RuleEntryHolder.elements();
            while (en.hasMoreElements()) {
                CBACRuleEntry entry1 = (CBACRuleEntry)en.nextElement();
                CBACRuleEntry entry2 = null;
                entry2 = entry1.getProtocol().equals("rpc") ? old.getRPCRuleEntry(entry1.getOptionAsLong("program-number")) : old.getRuleEntry(entry1.getProtocol());
                if ((entry1.getSelected() || entry2 == null || !entry2.getSelected()) && (entry2 == null || entry1.equals(entry2) || !entry1.getSelected() || !entry2.getSelected())) continue;
                CmdValues entry1CmdValues = entry1.getCmdValues(old.getName());
                entry1CmdValues.setAction(2);
                if (index >= 0) {
                    values.insertCmdValues(entry1CmdValues, index++);
                    continue;
                }
                values.addCmdValues(entry1CmdValues);
            }
            Enumeration en2 = this.RuleEntryHolder.elements();
            while (en2.hasMoreElements()) {
                CBACRuleEntry entry1 = (CBACRuleEntry)en2.nextElement();
                CBACRuleEntry entry2 = null;
                entry2 = entry1.getProtocol().equals("rpc") ? old.getRPCRuleEntry(entry1.getOptionAsLong("program-number")) : old.getRuleEntry(entry1.getProtocol());
                if ((entry2 != null || !entry1.getSelected()) && (entry2 == null || entry1.equals(entry2) || !entry1.getSelected())) continue;
                CmdValues entry1CmdValues = entry1.getCmdValues(this.getName());
                entry1CmdValues.setAction(1);
                if (index >= 0) {
                    values.insertCmdValues(entry1CmdValues, index++);
                    continue;
                }
                values.addCmdValues(entry1CmdValues);
            }
        } else {
            Enumeration en = this.RuleEntryHolder.elements();
            while (en.hasMoreElements()) {
                CBACRuleEntry entry1 = (CBACRuleEntry)en.nextElement();
                if (!entry1.getSelected()) continue;
                CmdValues entry1CmdValues = entry1.getCmdValues(this.getName());
                entry1CmdValues.setAction(1);
                if (index >= 0) {
                    values.insertCmdValues(entry1CmdValues, index++);
                    continue;
                }
                values.addCmdValues(entry1CmdValues);
            }
        }
        return index;
    }

    public String getAppfwPolicyName() {
        return this.appfwPolicyName;
    }

    public Vector getCLIs() {
        String str;
        Vector<String> v = new Vector<String>();
        if (this.nMaxSessions != -1L) {
            str = "ip inspect name " + this.sName + " parameter max-sessions " + this.nMaxSessions + System.getProperty("line.separator");
            v.addElement(str);
        }
        if (this.appfwPolicyName != null && !this.appfwPolicyName.equals("")) {
            str = "ip inspect name " + this.sName + " appfw " + this.appfwPolicyName + System.getProperty("line.separator");
            v.addElement(str);
        }
        Enumeration en = this.RuleEntryHolder.elements();
        while (en.hasMoreElements()) {
            String str2 = "ip inspect name " + this.sName + " " + ((CBACRuleEntry)en.nextElement()).toString();
            v.addElement(str2);
        }
        v.trimToSize();
        return v;
    }

    public long getMaxSessions() {
        return this.nMaxSessions;
    }

    public String getName() {
        return this.sName;
    }

    public Vector getRPCRuleEntry() {
        Vector<CBACRuleEntry> v = new Vector<CBACRuleEntry>();
        Enumeration en = this.RuleEntryHolder.elements();
        while (en.hasMoreElements()) {
            CBACRuleEntry curEntry = (CBACRuleEntry)en.nextElement();
            if (!curEntry.getProtocol().equalsIgnoreCase("rpc")) continue;
            v.addElement(curEntry);
        }
        v.trimToSize();
        return v;
    }

    public CBACRuleEntry getRPCRuleEntry(long rpcProgramNumber) {
        Enumeration en = this.RuleEntryHolder.elements();
        while (en.hasMoreElements()) {
            long rpcNumber;
            CBACRuleEntry curEntry = (CBACRuleEntry)en.nextElement();
            if (!curEntry.getProtocol().equalsIgnoreCase("rpc") || (rpcNumber = Long.parseLong(curEntry.getOption("program-number"))) != rpcProgramNumber) continue;
            return curEntry;
        }
        return null;
    }

    public boolean getReadOnly() {
        return this.isReadOnly();
    }

    public CBACRuleEntry getRuleEntry(String protocol) {
        Enumeration en = this.RuleEntryHolder.elements();
        while (en.hasMoreElements()) {
            CBACRuleEntry curEntry = (CBACRuleEntry)en.nextElement();
            if (!curEntry.getProtocol().equalsIgnoreCase(protocol)) continue;
            return curEntry;
        }
        return null;
    }

    public Vector getRuleEntrys() {
        return this.RuleEntryHolder;
    }

    public Vector getUsedInterfaces() {
        Vector<String> intfNames = new Vector<String>();
        XDMInterfaces ifs = ((DeviceBase)this.getDevice()).getIfs();
        Enumeration en = ifs.elements();
        while (en.hasMoreElements()) {
            XDMInterfaceBase intf = (XDMInterfaceBase)en.nextElement();
            if (!intf.getInspectIn().equals(this.sName) && !intf.getInspectOut().equals(this.sName)) continue;
            intfNames.addElement(intf.getLabel());
        }
        return intfNames;
    }

    public static boolean isValidName(String name) {
        if (name.equals("")) {
            return false;
        }
        if (name.indexOf(32) != -1) {
            return false;
        }
        if (name.indexOf(33) != -1) {
            return false;
        }
        if (name.indexOf(63) != -1) {
            return false;
        }
        if (name.indexOf(92) != -1) {
            return false;
        }
        if (name.indexOf(59) != -1) {
            return false;
        }
        return name.length() <= 16;
    }

    public void removeRuleEntry(int idx) {
        if (idx < 0 || idx >= this.ruleEntryCount()) {
            return;
        }
        try {
            this.RuleEntryHolder.removeElementAt(idx);
            this.setModified();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void removeRuleEntry(CBACRuleEntry entry) {
        this.RuleEntryHolder.removeElement(entry);
        this.setModified();
    }

    public int ruleEntryCount() {
        int count = 0;
        Enumeration e = this.RuleEntryHolder.elements();
        while (e.hasMoreElements()) {
            CBACRuleEntry entry = (CBACRuleEntry)e.nextElement();
            if (!entry.getSelected()) continue;
            ++count;
        }
        return count;
    }

    public void setAppfwPolicyName(String appfwPName) {
        this.appfwPolicyName = appfwPName;
        this.setModified();
    }

    public void setMaxSessions(long maxsesions) {
        this.nMaxSessions = maxsesions;
    }

    public void setName(String name) {
        this.sName = name;
    }

    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("");
        if (this.nMaxSessions != -1L) {
            str.append("    ip inspect name " + this.sName + " parameter max-sessions " + this.nMaxSessions);
            str.append(System.getProperty("line.separator"));
        }
        if (this.appfwPolicyName != null && !this.appfwPolicyName.equals("")) {
            str.append("    ip inspect name " + this.sName + " appfw " + this.appfwPolicyName);
            str.append(System.getProperty("line.separator"));
        }
        Enumeration en = this.RuleEntryHolder.elements();
        while (en.hasMoreElements()) {
            str.append("    ip inspect name ");
            str.append(this.sName);
            str.append(" ");
            str.append(((CBACRuleEntry)en.nextElement()).toString());
            str.append(System.getProperty("line.separator"));
        }
        return str.toString();
    }

    public void updateRuleEntry(CBACRuleEntry oldEntry, CBACRuleEntry newEntry) {
        try {
            int i = 0;
            while (i < this.RuleEntryHolder.size()) {
                CBACRuleEntry theEntry = (CBACRuleEntry)this.RuleEntryHolder.elementAt(i);
                if (theEntry.getProtocol().equals(oldEntry.getProtocol()) && (!theEntry.getProtocol().equals("rpc") || theEntry.getOption("program-number") == null || theEntry.getOption("program-number").equals(oldEntry.getOption("program-number")))) {
                    Enumeration en = newEntry.getOptions().keys();
                    while (en.hasMoreElements()) {
                        String optionName = (String)en.nextElement();
                        String optionVal = newEntry.getOption(optionName);
                        theEntry.addOption(optionName, optionVal);
                    }
                    this.setModified();
                    return;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }
}

