/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class CBACRuleEntry
extends XDMObject {
    public static final int DEFAULT = 0;
    public static final int ON = 1;
    public static final int OFF = 2;
    public static final String PROTOCOL_SMTP = "smtp";
    public static final String PROTOCOL_ESMTP = "esmtp";
    public static final String PROTOCOL_H323 = "h323";
    public static final String PROTOCOL_ICMP = "icmp";
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_UDP = "udp";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_POP = "pop";
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final String PROTOCOL_FRAGMENT = "fragment";
    public static final String PROTOCOL_RPC = "rpc";
    public static final String PROTOCOL_PARAM = "parameter";
    protected String protocol;
    protected Hashtable options = new Hashtable();
    protected boolean bselected;

    public CBACRuleEntry(XDMObject parent, String pro) {
        super(parent);
        this.protocol = pro;
    }

    public CBACRuleEntry(String pro) {
        this.protocol = pro;
    }

    public void addOption(String optionName, String optionValue) {
        this.options.put(new String(optionName), optionValue);
    }

    public Object clone() {
        CBACRuleEntry cloneEntry = null;
        cloneEntry = (CBACRuleEntry)super.clone();
        cloneEntry.protocol = this.protocol;
        cloneEntry.options = (Hashtable)this.options.clone();
        return cloneEntry;
    }

    public boolean equals(CBACRuleEntry obj) {
        if (!this.protocol.equals(obj.protocol)) {
            return false;
        }
        if (this.bselected != obj.bselected) {
            return false;
        }
        return this.options.equals(obj.options);
    }

    public int getAlert() {
        String alert = this.getOption("alert");
        if (alert == null) {
            return 0;
        }
        if (alert.equals("on")) {
            return 1;
        }
        if (alert.equals("off")) {
            return 2;
        }
        return 0;
    }

    public int getAuditTrail() {
        String audit = this.getOption("audit-trail");
        if (audit == null) {
            return 0;
        }
        if (audit.equals("on")) {
            return 1;
        }
        if (audit.equals("off")) {
            return 2;
        }
        return 0;
    }

    public CmdValues getCmdValues(String name) {
        CmdValues cmd = new CmdValues("ip");
        cmd.addValue("inspect", "inspect");
        cmd.addValue("inspectname", name);
        if (this.protocol.equals(PROTOCOL_RPC) || this.protocol.equals(PROTOCOL_FRAGMENT) || this.protocol.equals(PROTOCOL_HTTP) || this.protocol.equals(PROTOCOL_SMTP) || this.protocol.equals(PROTOCOL_ESMTP) || this.protocol.equals(PROTOCOL_H323) || this.protocol.equals(PROTOCOL_ICMP) || this.protocol.equals(PROTOCOL_TCP) || this.protocol.equals(PROTOCOL_UDP) || this.protocol.equals(PROTOCOL_IMAP) || this.protocol.equals(PROTOCOL_POP) || this.protocol.equals(PROTOCOL_POP3)) {
            cmd.addValue(this.protocol, this.protocol);
        } else {
            cmd.addValue("inspectprotocol", this.protocol.toLowerCase());
        }
        Enumeration en = this.options.keys();
        while (en.hasMoreElements()) {
            String optionName = (String)en.nextElement();
            String optionVal = (String)this.options.get(optionName);
            if (optionName.equalsIgnoreCase("javalist")) {
                if (optionVal == "-1") continue;
                cmd.addValue("javalist", optionVal);
                continue;
            }
            if (optionName.equalsIgnoreCase("max-data")) {
                if (optionVal == null) continue;
                cmd.addValue("maxdata", optionVal);
                continue;
            }
            if (optionName.equalsIgnoreCase("maximum")) {
                if (optionVal == null) continue;
                cmd.addValue(PROTOCOL_FRAGMENT, PROTOCOL_FRAGMENT);
                cmd.addValue("maximum", "maximum");
                cmd.addValue("maximumfrag", optionVal);
                continue;
            }
            if (optionName.equalsIgnoreCase("program-number")) {
                if (optionVal == null) continue;
                cmd.addValue("program-number", "program-number");
                cmd.addValue("programnumber", optionVal);
                continue;
            }
            if (optionName.equalsIgnoreCase("reset")) {
                cmd.addValue("reset", "reset");
                continue;
            }
            if (optionName.equalsIgnoreCase("router-traffic")) {
                cmd.addValue("router-traffic", "router-traffic");
                continue;
            }
            if (optionName.equalsIgnoreCase("secure-login")) {
                cmd.addValue("secure-login", "secure-login");
                continue;
            }
            if (optionName.equalsIgnoreCase("urlfilter") && optionVal.equals("true")) {
                cmd.addValue("urlfilter", "urlfilter");
                continue;
            }
            if (optionName.equalsIgnoreCase("wait-time")) {
                if (optionVal == null) continue;
                cmd.addValue("waittime", optionVal);
                continue;
            }
            if (optionName.equalsIgnoreCase("alert")) {
                if (optionVal == null) continue;
                if (optionVal.equalsIgnoreCase("on")) {
                    cmd.addValue("alert", "on");
                    continue;
                }
                if (!optionVal.equalsIgnoreCase("off")) continue;
                cmd.addValue("alert", "off");
                continue;
            }
            if (optionName.equalsIgnoreCase("audit-trail")) {
                if (optionVal == null) continue;
                if (optionVal.equalsIgnoreCase("on")) {
                    cmd.addValue("audit", "on");
                    continue;
                }
                if (!optionVal.equalsIgnoreCase("off")) continue;
                cmd.addValue("audit", "off");
                continue;
            }
            if (!optionName.equalsIgnoreCase("timeout")) continue;
            if (this.protocol.equalsIgnoreCase(PROTOCOL_FRAGMENT)) {
                if (optionVal == null || optionVal.equalsIgnoreCase("-1")) continue;
                cmd.addValue("fragtimeout", optionVal);
                continue;
            }
            if (optionVal == null || optionVal.equalsIgnoreCase("-1")) continue;
            cmd.addValue("timeout", optionVal);
        }
        cmd.setAction(1);
        return cmd;
    }

    public String getNonCommonOptions() {
        StringBuffer str = new StringBuffer();
        Enumeration e = this.options.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equalsIgnoreCase("alert") || key.equalsIgnoreCase("audit-trail") || key.equalsIgnoreCase("timeout")) continue;
            str.append(key).append("(").append((String)this.options.get(key));
            str.append(")").append(" ");
        }
        return str.toString();
    }

    public String getOption(String optionName) {
        return (String)this.options.get(optionName);
    }

    public boolean getOptionAsBoolean(String optionName) {
        String val = this.getOption(optionName);
        if (val == null) {
            return false;
        }
        return val.equals("true");
    }

    public int getOptionAsInt(String optionName) {
        return (int)this.getOptionAsLong(optionName);
    }

    public long getOptionAsLong(String optionName) {
        String optionVal = this.getOption(optionName);
        long nOptionVal = -1L;
        if (optionVal == null) {
            return -1L;
        }
        try {
            nOptionVal = Long.parseLong(optionVal);
        }
        catch (NumberFormatException numberFormatException) {
            nOptionVal = -1L;
        }
        return nOptionVal;
    }

    public Hashtable getOptions() {
        return this.options;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean getSelected() {
        return this.bselected;
    }

    public int getTimeout() {
        String timeOut = (String)this.options.get("timeout");
        int nTimeout = -1;
        try {
            nTimeout = Integer.parseInt(timeOut);
        }
        catch (NumberFormatException numberFormatException) {}
        return nTimeout;
    }

    public void populate(ConfigValues configValues, CmdValues inspectCmds) {
        if (inspectCmds.containsKey("alert")) {
            if (inspectCmds.getValue("alert").equals("off")) {
                this.addOption("alert", "off");
            } else {
                this.addOption("alert", "on");
            }
        }
        if (inspectCmds.containsKey("audit")) {
            if (inspectCmds.getValue("audit").equals("off")) {
                this.addOption("audit-trail", "off");
            } else {
                this.addOption("audit-trail", "on");
            }
        }
        if (inspectCmds.containsKey("timeout")) {
            this.addOption("timeout", inspectCmds.getValue("timeout"));
        }
        if (inspectCmds.containsKey("reset")) {
            this.addOption("reset", "true");
        }
        if (inspectCmds.containsKey("secure-login")) {
            this.addOption("secure-login", "true");
        }
        if (inspectCmds.containsKey("javalist")) {
            this.addOption("javalist", inspectCmds.getValue("javalist"));
        }
        if (inspectCmds.containsKey("router-traffic")) {
            this.addOption("router-traffic", "true");
        }
        if (inspectCmds.containsKey("urlfilter")) {
            this.addOption("urlfilter", "true");
        }
        if (inspectCmds.containsKey("maximum")) {
            if (inspectCmds.containsKey("maximumfrag")) {
                this.addOption("maximum", inspectCmds.getValue("maximumfrag"));
            }
            if (inspectCmds.containsKey("fragtimeout")) {
                this.addOption("timeout", inspectCmds.getValue("fragtimeout"));
            }
        }
        if (inspectCmds.containsKey("program-number")) {
            if (inspectCmds.containsKey("programnumber")) {
                this.addOption("program-number", inspectCmds.getValue("programnumber"));
            }
            if (inspectCmds.containsKey("waittime")) {
                this.addOption("wait-time", inspectCmds.getValue("waittime"));
            }
        }
        if (inspectCmds.containsKey("maxdata")) {
            this.addOption("max-data", inspectCmds.getValue("maxdata"));
        }
    }

    public void setAlert(int alert) {
        if (alert == 2) {
            this.addOption("alert", "off");
        } else if (alert == 1) {
            this.addOption("alert", "on");
        } else {
            this.addOption("alert", "default");
        }
    }

    public void setAuditTrail(int audit) {
        if (audit == 2) {
            this.addOption("audit-trail", "off");
        } else if (audit == 1) {
            this.addOption("audit-trail", "on");
        } else {
            this.addOption("audit-trail", "default");
        }
    }

    public void setSelected(boolean select) {
        this.bselected = select;
        this.setModified();
    }

    public void setTimeout(int timeout) {
        this.addOption("timeout", String.valueOf(timeout));
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.protocol.toLowerCase());
        s.append(" ").append(" ");
        Enumeration en = this.options.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)this.options.get(key);
            s.append(String.valueOf(key) + " " + value).append(",");
        }
        return s.toString();
    }
}

