/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.appfw;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.CmdPositionHandler;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.appfw.AppFwPolicy;

public class AppFw
extends XDMHashCollection
implements CmdPositionHandler {
    public AppFw(XDMObject parent) {
        super(parent);
    }

    public int getFirstCmdPosition(String module, ConfigValues config, boolean noCmd) {
        int ret = -1;
        if (config == null) {
            return ret;
        }
        int size = config.numCmds();
        int i = 0;
        while (i < size) {
            CmdValues cmd = config.getCmdValues(i);
            String name = cmd.getCmdName();
            if (name.equalsIgnoreCase("appfw") && (cmd.getAction() == 2 && noCmd || cmd.getAction() != 2 && !noCmd)) {
                ret = i;
                break;
            }
            ++i;
        }
        return ret;
    }

    public AppFwPolicy getTemporaryPolicyObject(String name) {
        if (this.containsKey(name)) {
            return (AppFwPolicy)this.get(name).clone();
        }
        return new AppFwPolicy(name, null);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        ConfigValues ifCVs = config.getCmds("appfw", "policy-name", "policy-name", false);
        if (ifCVs != null) {
            int i = 0;
            while (i < ifCVs.numCmds()) {
                CmdValues cmd = ifCVs.getCmdValues(i);
                String name = cmd.getValue("fwpolicyname");
                AppFwPolicy p = new AppFwPolicy(name, this);
                this.put(p);
                p.populate(config, cmd);
                ++i;
            }
        }
    }

    public XDMObject put(AppFwPolicy val) {
        if (val == null) {
            return null;
        }
        return this.put(val.getName(), val);
    }

    public void setTemporaryPolicyObject(AppFwPolicy temp) {
        AppFwPolicy original = null;
        if (this.containsKey(temp.getName())) {
            original = (AppFwPolicy)this.get(temp.getName());
        }
        temp.trimNewEmptyApp(original);
        if (temp.anyAttrChanged()) {
            this.put(temp);
        } else if (original != null && original.anyAttrChanged()) {
            this.remove(temp.getName());
        }
    }
}

