/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.appfw;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.MergeCallback;
import com.cisco.xdm.data.base.MergeInterface;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.appfw.AppFwAction;
import com.cisco.xdm.data.cbac.appfw.AppFwPolicy;
import com.cisco.xdm.data.cbac.appfw.HTTPContentLength;
import com.cisco.xdm.data.cbac.appfw.HTTPContentType;
import com.cisco.xdm.data.cbac.appfw.HTTPMaxHeaderLength;
import com.cisco.xdm.data.cbac.appfw.HTTPMaxUriLength;
import com.cisco.xdm.data.cbac.appfw.HTTPPortMisuse;
import com.cisco.xdm.data.cbac.appfw.HTTPReqMethodExt;
import com.cisco.xdm.data.cbac.appfw.HTTPReqMethodRfc;
import com.cisco.xdm.data.cbac.appfw.HTTPTransEncoding;
import com.cisco.xdm.data.cbac.appfw.StrictHTTP;

public class AppFwHTTP
extends XDMObject
implements MergeInterface {
    public static final int AUDIT_NOT_SET = -1;
    public static final int AUDIT_OFF = 0;
    public static final int AUDIT_ON = 1;
    private int _audit_trail = -1;
    private int _timeout = -1;
    private static final String[] _portMisuses = new String[]{"im", "p2p", "tunneling"};
    private static final String[] _reqMethodExts = new String[]{"copy", "edit", "getattribute", "getattributenames", "getproperties", "index", "lock", "mkdir", "move", "revadd", "revlabel", "revlog", "revnum", "save", "setattribute", "startrev", "stoprev", "unedit", "unlock"};
    private static final String[] _reqMethodRfcs = new String[]{"connect", "delete", "get", "head", "options", "post", "put", "trace"};
    private static final String[] _transferEncodings = new String[]{"chunked", "compress", "deflate", "gzip", "identity"};
    private static final String OBJ_CONTENT_LENGTH = "content-length";
    private static final String OBJ_CONTENT_TYPE = "content-type";
    private static final String OBJ_MAX_HEADER_LENGTH = "max-header-length";
    private static final String OBJ_MAX_URI_LENGTH = "max-uri-length";
    private static final String OBJ_STRICT_HTTP = "strict-http";
    private static final String OBJ_PORT_MISUSE = "port-misuse";
    private static final String OBJ_REQUEST_METHOD_EXT = "request-method-ext";
    private static final String OBJ_REQUEST_METHOD_RFC = "request-method-rfc";
    private static final String OBJ_TRANSFER_ENCODING = "transfer-encoding";
    private static final String KEY_AUDIT = "audit-trail";
    private static final String KEY_AUDITTRAIL = "audittrail";
    private static final String KEY_ON = "on";
    private static final String KEY_OFF = "off";
    private static final String KEY_TIMEOUT = "timeout";
    private static final String KEY_TIMEOUTVAL = "timeoutval";

    public AppFwHTTP(XDMObject parent) {
        super(parent);
        this.addObject(OBJ_CONTENT_LENGTH, new HTTPContentLength(this));
        this.addObject(OBJ_CONTENT_TYPE, new HTTPContentType(this));
        this.addObject(OBJ_MAX_HEADER_LENGTH, new HTTPMaxHeaderLength(this));
        this.addObject(OBJ_MAX_URI_LENGTH, new HTTPMaxUriLength(this));
        this.addObject(OBJ_STRICT_HTTP, new StrictHTTP(this));
        this.addObject(OBJ_PORT_MISUSE, new XDMHashCollection(this));
        this.addObject(OBJ_REQUEST_METHOD_EXT, new XDMHashCollection(this));
        this.addObject(OBJ_REQUEST_METHOD_RFC, new XDMHashCollection(this));
        this.addObject(OBJ_TRANSFER_ENCODING, new XDMHashCollection(this));
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues subcmd;
        CmdValues cmd = new CmdValues("application");
        cmd.addValue("http", "http");
        if (this.isBackup()) {
            cmd.setAction(2);
            values.addCmdValues(cmd);
            return;
        }
        ConfigValues subconfig = new ConfigValues();
        AppFwHTTP bObj = null;
        if (backup != null) {
            bObj = (AppFwHTTP)backup;
        }
        super.generateDelta(backup, subconfig);
        if (bObj != null && bObj._audit_trail != this._audit_trail || bObj == null && this._audit_trail != -1) {
            subcmd = new CmdValues(KEY_AUDIT);
            if (this._audit_trail == 1) {
                subcmd.addValue(KEY_AUDITTRAIL, KEY_ON);
            } else if (this._audit_trail == 0) {
                subcmd.addValue(KEY_AUDITTRAIL, KEY_OFF);
            } else {
                subcmd.setAction(2);
            }
            subconfig.addCmdValues(subcmd);
        }
        if (bObj != null && bObj._timeout != this._timeout || bObj == null && this._timeout != -1) {
            subcmd = new CmdValues(KEY_TIMEOUT);
            if (this._timeout == -1) {
                subcmd.setAction(2);
            } else {
                subcmd.addValue(KEY_TIMEOUTVAL, String.valueOf(this._timeout));
            }
            subconfig.addCmdValues(subcmd);
        }
        if (subconfig.numCmds() == 0 && backup != null) {
            return;
        }
        if (subconfig.numCmds() > 0) {
            cmd.setModeCmdsValues(subconfig);
        }
        values.addCmdValues(cmd);
    }

    public int getAuditTrail() {
        return this._audit_trail;
    }

    public HTTPContentLength getHTTPContentLength() {
        return (HTTPContentLength)this.getObject(OBJ_CONTENT_LENGTH);
    }

    public HTTPContentType getHTTPContentType() {
        return (HTTPContentType)this.getObject(OBJ_CONTENT_TYPE);
    }

    public HTTPMaxHeaderLength getHTTPMaxHeaderLength() {
        return (HTTPMaxHeaderLength)this.getObject(OBJ_MAX_HEADER_LENGTH);
    }

    public HTTPMaxUriLength getHTTPMaxUriLength() {
        return (HTTPMaxUriLength)this.getObject(OBJ_MAX_URI_LENGTH);
    }

    public HTTPPortMisuse getPortMisuse(String key) {
        XDMHashCollection col = this.getPortMisuses();
        XDMObject val = col.get(key);
        if (val == null) {
            val = new HTTPPortMisuse(key);
            col.put(key, val);
        }
        return (HTTPPortMisuse)val;
    }

    private XDMHashCollection getPortMisuses() {
        return (XDMHashCollection)this.getObject(OBJ_PORT_MISUSE);
    }

    public HTTPReqMethodExt getRequestMethodExt(String key) {
        XDMHashCollection col = this.getRequestMethodExts();
        XDMObject val = col.get(key);
        if (val == null) {
            val = new HTTPReqMethodExt(key);
            col.put(key, val);
        }
        return (HTTPReqMethodExt)val;
    }

    private XDMHashCollection getRequestMethodExts() {
        return (XDMHashCollection)this.getObject(OBJ_REQUEST_METHOD_EXT);
    }

    public HTTPReqMethodRfc getRequestMethodRfc(String key) {
        XDMHashCollection col = this.getRequestMethodRfcs();
        XDMObject val = col.get(key);
        if (val == null) {
            val = new HTTPReqMethodRfc(key);
            col.put(key, val);
        }
        return (HTTPReqMethodRfc)val;
    }

    private XDMHashCollection getRequestMethodRfcs() {
        return (XDMHashCollection)this.getObject(OBJ_REQUEST_METHOD_RFC);
    }

    public StrictHTTP getStrictHttp() {
        return (StrictHTTP)this.getObject(OBJ_STRICT_HTTP);
    }

    public static String[] getSupportedPortMisuses() {
        return _portMisuses;
    }

    public static String[] getSupportedReqMethodExts() {
        return _reqMethodExts;
    }

    public static String[] getSupportedReqMethodRfcs() {
        return _reqMethodRfcs;
    }

    public static String[] getSupportedTransferEncodings() {
        return _transferEncodings;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public HTTPTransEncoding getTransferEncoding(String key) {
        XDMHashCollection col = this.getTransferEncodings();
        XDMObject val = col.get(key);
        if (val == null) {
            val = new HTTPTransEncoding(key);
            col.put(key, val);
        }
        return (HTTPTransEncoding)val;
    }

    private XDMHashCollection getTransferEncodings() {
        return (XDMHashCollection)this.getObject(OBJ_TRANSFER_ENCODING);
    }

    public boolean merge(XDMObject data, MergeCallback cb) {
        if (!(data != null && data instanceof AppFwHTTP || AppFwPolicy.notifyMergeCaller(1, cb, null))) {
            return false;
        }
        AppFwHTTP mData = (AppFwHTTP)data;
        if (mData._audit_trail != -1) {
            this.setAuditTrail(mData._audit_trail);
        }
        if (mData._timeout != -1) {
            this.setTimeout(mData._timeout);
        }
        if (!this.getHTTPContentLength().merge(mData.getHTTPContentLength(), cb)) {
            return false;
        }
        if (!this.getHTTPContentType().merge(mData.getHTTPContentType(), cb)) {
            return false;
        }
        if (!this.getHTTPMaxHeaderLength().merge(mData.getHTTPMaxHeaderLength(), cb)) {
            return false;
        }
        if (!this.getHTTPMaxUriLength().merge(mData.getHTTPMaxUriLength(), cb)) {
            return false;
        }
        if (!this.getStrictHttp().merge(mData.getStrictHttp(), cb)) {
            return false;
        }
        if (!AppFwPolicy.mergeHashtable(this.getPortMisuses(), mData.getPortMisuses(), cb)) {
            return false;
        }
        if (!AppFwPolicy.mergeHashtable(this.getRequestMethodExts(), mData.getRequestMethodExts(), cb)) {
            return false;
        }
        if (!AppFwPolicy.mergeHashtable(this.getRequestMethodRfcs(), mData.getRequestMethodRfcs(), cb)) {
            return false;
        }
        return AppFwPolicy.mergeHashtable(this.getTransferEncodings(), mData.getTransferEncodings(), cb);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (cmdVal == null) {
            return;
        }
        ConfigValues subConfig = cmdVal.getModeCmdsValues();
        if (subConfig == null) {
            return;
        }
        int i = 0;
        while (i < subConfig.numCmds()) {
            AppFwAction action;
            String key;
            CmdValues cmd = subConfig.getCmdValues(i);
            String cmdName = cmd.getCmdName();
            if (cmdName.equals(KEY_AUDIT)) {
                String val = cmd.getValue(KEY_AUDITTRAIL);
                this._audit_trail = val.equals(KEY_ON) ? 1 : 0;
            } else if (cmdName.equals(KEY_TIMEOUT)) {
                this._timeout = Integer.parseInt(cmd.getValue(KEY_TIMEOUTVAL));
            } else if (cmdName.equals(OBJ_CONTENT_LENGTH)) {
                this.getHTTPContentLength().populate(config, cmd);
            } else if (cmdName.equals("content-type-verification")) {
                this.getHTTPContentType().populate(config, cmd);
            } else if (cmdName.equals(OBJ_MAX_HEADER_LENGTH)) {
                this.getHTTPMaxHeaderLength().populate(config, cmd);
            } else if (cmdName.equals(OBJ_MAX_URI_LENGTH)) {
                this.getHTTPMaxUriLength().populate(config, cmd);
            } else if (cmdName.equals(OBJ_STRICT_HTTP)) {
                this.getStrictHttp().populate(config, cmd);
            } else if (cmdName.equals(OBJ_PORT_MISUSE)) {
                key = cmd.getValue("portmisuse");
                action = new HTTPPortMisuse(key);
                this.getPortMisuses().put(key, action);
                action.populate(config, cmd);
            } else if (cmdName.equals("request-method")) {
                XDMHashCollection methods = null;
                String key2 = null;
                AppFwAction action2 = null;
                if (cmd.containsKey("extension")) {
                    methods = this.getRequestMethodExts();
                    key2 = cmd.getValue("reqext");
                    action2 = new HTTPReqMethodExt(key2);
                } else if (cmd.containsKey("rfc")) {
                    methods = this.getRequestMethodRfcs();
                    key2 = cmd.getValue("reqrfc");
                    action2 = new HTTPReqMethodRfc(key2);
                }
                if (key2 != null && methods != null) {
                    methods.put(key2, action2);
                    action2.populate(config, cmd);
                }
            } else if (cmdName.equals(OBJ_TRANSFER_ENCODING)) {
                key = cmd.getValue("encodingtype");
                action = new HTTPTransEncoding(key);
                this.getTransferEncodings().put(key, action);
                action.populate(config, cmd);
            }
            ++i;
        }
    }

    public void setAuditTrail(int val) {
        if (val != this._audit_trail) {
            this._audit_trail = val;
            this.setModified();
        }
    }

    public void setTimeout(int val) {
        if (val != this._timeout) {
            this._timeout = val;
            this.setModified();
        }
    }
}

