/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.appfw;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.MergeCallback;
import com.cisco.xdm.data.base.MergeInterface;
import com.cisco.xdm.data.base.XDMEditableVector;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.appfw.AppFwAction;
import com.cisco.xdm.data.cbac.appfw.AppFwIMServer;
import com.cisco.xdm.data.cbac.appfw.AppFwPolicy;
import com.cisco.xdm.data.common.IPAddress;
import java.util.Enumeration;

public abstract class AppFwIM
extends XDMObject
implements MergeInterface {
    public static final int ALERT_NOT_SET = -1;
    public static final int ALERT_OFF = 0;
    public static final int ALERT_ON = 1;
    private int _alert = -1;
    public static final int AUDIT_NOT_SET = -1;
    public static final int AUDIT_OFF = 0;
    public static final int AUDIT_ON = 1;
    private int _audit_trail = -1;
    private int _timeout = -1;
    private static final String OBJ_SERVICE_DEFAULT = "service_default";
    private static final String OBJ_SERVICE_TEXT_CHAT = "service_text_chat";
    private static final String OBJ_SERVERS = "servers";
    private static final String KEY_ALERT = "alert";
    private static final String KEY_ALERT_VAL = "alert_val";
    private static final String KEY_AUDIT_TRAIL = "audit-trail";
    private static final String KEY_AUDITTRAIL = "audittrail";
    private static final String KEY_ON = "on";
    private static final String KEY_OFF = "off";
    private static final String KEY_SERVER = "server";
    private static final String KEY_SERVICE = "service";
    private static final String KEY_DEFAULT = "default";
    private static final String KEY_TEXT_CHAT = "text-chat";
    private static final String KEY_TIMEOUT = "timeout";
    private static final String KEY_TIMEOUT_VAL = "timeout_val";

    public AppFwIM(XDMObject parent) {
        super(parent);
        this.addObject(OBJ_SERVICE_DEFAULT, new AppFwAction(this));
        this.addObject(OBJ_SERVICE_TEXT_CHAT, new AppFwAction(this));
        this.addObject(OBJ_SERVERS, new XDMEditableVector(this));
    }

    protected CmdValues createIMCmdValue() {
        CmdValues cmd = new CmdValues("application");
        cmd.addValue("im", "im");
        return cmd;
    }

    private void createServerFromCmdValue(CmdValues cmd) {
        XDMEditableVector servers = this.getServers();
        AppFwIMServer server = null;
        boolean permit = cmd.getValue("access").equals("permit");
        if (cmd.containsKey("servername")) {
            server = new AppFwIMServer(cmd.getValue("servername"), permit);
        } else if (cmd.containsKey("serverip")) {
            server = new AppFwIMServer(new IPAddress(cmd.getValue("serverip")), permit);
        } else if (cmd.containsKey("startip") && cmd.containsKey("endip")) {
            server = new AppFwIMServer(new IPAddress(cmd.getValue("startip")), new IPAddress(cmd.getValue("endip")), permit);
        }
        if (server != null) {
            servers.addElement(server);
        }
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues subcmd;
        CmdValues cmd = this.createIMCmdValue();
        if (this.isBackup()) {
            cmd.setAction(2);
            values.addCmdValues(cmd);
            return;
        }
        ConfigValues subconfig = new ConfigValues();
        AppFwIM bObj = null;
        XDMEditableVector bServers = null;
        if (backup != null) {
            bObj = (AppFwIM)backup;
            bServers = bObj.getServers();
        }
        this.generateServiceDefault(subconfig, bObj);
        this.generateServiceTextChat(subconfig, bObj);
        this.getServers().generateDelta(bServers, subconfig);
        if (bObj != null && bObj._alert != this._alert || bObj == null && this._alert != -1) {
            subcmd = new CmdValues(KEY_ALERT);
            if (this._alert == 1) {
                subcmd.addValue(KEY_ALERT_VAL, KEY_ON);
            } else if (this._alert == 0) {
                subcmd.addValue(KEY_ALERT_VAL, KEY_OFF);
            } else {
                subcmd.setAction(2);
            }
            subconfig.addCmdValues(subcmd);
        }
        if (bObj != null && bObj._audit_trail != this._audit_trail || bObj == null && this._audit_trail != -1) {
            subcmd = new CmdValues(KEY_AUDIT_TRAIL);
            if (this._audit_trail == 1) {
                subcmd.addValue(KEY_AUDITTRAIL, KEY_ON);
            } else if (this._audit_trail == 0) {
                subcmd.addValue(KEY_AUDITTRAIL, KEY_OFF);
            } else {
                subcmd.setAction(2);
            }
            subconfig.addCmdValues(subcmd);
        }
        if (bObj != null && bObj._timeout != this._timeout || bObj == null && this._timeout != -1) {
            subcmd = new CmdValues(KEY_TIMEOUT);
            if (this._timeout == -1) {
                subcmd.setAction(2);
            } else {
                subcmd.addValue(KEY_TIMEOUT_VAL, String.valueOf(this._timeout));
            }
            subconfig.addCmdValues(subcmd);
        }
        if (subconfig.numCmds() == 0 && backup != null) {
            return;
        }
        if (subconfig.numCmds() > 0) {
            cmd.setModeCmdsValues(subconfig);
        }
        values.addCmdValues(cmd);
    }

    private void generateServiceDefault(ConfigValues config, AppFwIM backup) {
        AppFwAction sd = this.getServiceDefault();
        if (backup == null && sd.isNoAct() || backup != null && sd.equals(backup.getServiceDefault())) {
            return;
        }
        CmdValues cmd = new CmdValues(KEY_SERVICE);
        cmd.addValue(KEY_DEFAULT, KEY_DEFAULT);
        sd.generateCmdValue(cmd);
        config.addCmdValues(cmd);
    }

    private void generateServiceTextChat(ConfigValues config, AppFwIM backup) {
        AppFwAction sd = this.getServiceTextChat();
        if (backup == null && sd.isNoAct() || backup != null && sd.equals(backup.getServiceTextChat())) {
            return;
        }
        CmdValues cmd = new CmdValues(KEY_SERVICE);
        cmd.addValue(KEY_TEXT_CHAT, KEY_TEXT_CHAT);
        sd.generateCmdValue(cmd);
        config.addCmdValues(cmd);
    }

    public int getAlert() {
        return this._alert;
    }

    public int getAuditTrail() {
        return this._audit_trail;
    }

    public XDMEditableVector getServers() {
        return (XDMEditableVector)this.getObject(OBJ_SERVERS);
    }

    public AppFwAction getServiceDefault() {
        return (AppFwAction)this.getObject(OBJ_SERVICE_DEFAULT);
    }

    public AppFwAction getServiceTextChat() {
        return (AppFwAction)this.getObject(OBJ_SERVICE_TEXT_CHAT);
    }

    public int getTimeout() {
        return this._timeout;
    }

    public abstract String getType();

    public boolean merge(XDMObject data, MergeCallback cb) {
        if (!(data != null && data instanceof AppFwIM || AppFwPolicy.notifyMergeCaller(1, cb, null))) {
            return false;
        }
        AppFwIM mData = (AppFwIM)data;
        if (mData._alert != -1) {
            this.setAlert(mData._alert);
        }
        if (mData._audit_trail != -1) {
            this.setAuditTrail(mData._audit_trail);
        }
        if (mData._timeout != -1) {
            this.setTimeout(mData._timeout);
        }
        if (!this.getServiceDefault().merge(mData.getServiceDefault(), cb)) {
            return false;
        }
        if (!this.getServiceTextChat().merge(mData.getServiceTextChat(), cb)) {
            return false;
        }
        return this.mergeServers(this.getServers(), mData.getServers(), cb);
    }

    private boolean mergeServers(XDMEditableVector target, XDMEditableVector src, MergeCallback cb) {
        Enumeration es = src.elements();
        while (es.hasMoreElements()) {
            AppFwIMServer s = (AppFwIMServer)es.nextElement();
            if (s.getType() != 2) continue;
            int i = 0;
            while (i < target.size()) {
                AppFwIMServer t = (AppFwIMServer)target.elementAt(i);
                if (t.getName() != null && t.getName().length() > 0 && t.getName().equals(s.getName())) {
                    target.removeElementAt(i);
                    break;
                }
                ++i;
            }
            target.addElement((XDMObject)s.clone());
        }
        return true;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (cmdVal == null) {
            return;
        }
        ConfigValues subConfig = cmdVal.getModeCmdsValues();
        if (subConfig == null) {
            return;
        }
        int i = 0;
        while (i < subConfig.numCmds()) {
            String val;
            CmdValues cmd = subConfig.getCmdValues(i);
            String cmdName = cmd.getCmdName();
            if (cmdName.equals(KEY_ALERT)) {
                val = cmd.getValue(KEY_ALERT_VAL);
                this._alert = val.equals(KEY_ON) ? 1 : 0;
            } else if (cmdName.equals(KEY_AUDIT_TRAIL)) {
                val = cmd.getValue(KEY_AUDITTRAIL);
                this._audit_trail = val.equals(KEY_ON) ? 1 : 0;
            } else if (cmdName.equals(KEY_SERVER)) {
                this.createServerFromCmdValue(cmd);
            } else if (cmdName.equals(KEY_SERVICE)) {
                if (cmd.containsKey(KEY_DEFAULT)) {
                    this.getServiceDefault().populate(config, cmd);
                } else if (cmd.containsKey(KEY_TEXT_CHAT)) {
                    this.getServiceTextChat().populate(config, cmd);
                }
            } else if (cmdName.equals(KEY_TIMEOUT)) {
                this._timeout = Integer.parseInt(cmd.getValue(KEY_TIMEOUT_VAL));
            }
            ++i;
        }
    }

    public void setAlert(int val) {
        if (val != this._alert) {
            this._alert = val;
            this.setModified();
        }
    }

    public void setAuditTrail(int val) {
        if (val != this._audit_trail) {
            this._audit_trail = val;
            this.setModified();
        }
    }

    public void setTimeout(int val) {
        if (val != this._timeout) {
            this._timeout = val;
            this.setModified();
        }
    }
}

