/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.feed;

import com.cisco.xdm.data.cbac.feed.FwBase;
import com.cisco.xdm.data.cbac.feed.FwGroup;
import com.cisco.xdm.data.cbac.feed.FwProtocol;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

public class FwData
implements Cloneable {
    private Vector groups = new Vector();

    public Object clone() {
        FwData cloneEntry = null;
        try {
            cloneEntry = (FwData)super.clone();
            cloneEntry.groups = new Vector();
            Enumeration en = this.groups.elements();
            while (en.hasMoreElements()) {
                FwBase fwbase = (FwBase)((FwBase)en.nextElement()).clone();
                cloneEntry.groups.addElement(fwbase);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return cloneEntry;
    }

    public Vector getAllProtocolGroups() {
        Vector<FwBase> protocolCollection = new Vector<FwBase>();
        Vector groups = this.getGroups();
        int i = 0;
        while (i < groups.size()) {
            FwGroup grp = (FwGroup)groups.elementAt(i);
            protocolCollection.addElement(grp);
            Vector items = grp.getItems();
            int j = 0;
            while (j < items.size()) {
                FwBase item = (FwBase)items.elementAt(j);
                if (item instanceof FwGroup) {
                    protocolCollection.addElement(item);
                }
                ++j;
            }
            ++i;
        }
        return protocolCollection;
    }

    public FwGroup getGroup(String groupname) {
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            FwGroup grp = (FwGroup)e.nextElement();
            if (grp.getName() != null && grp.getName().equals(groupname)) {
                return grp;
            }
            Vector items = grp.getItems();
            int j = 0;
            while (j < items.size()) {
                FwBase item = (FwBase)items.elementAt(j);
                if (item instanceof FwGroup && item.getName().equals(groupname)) {
                    return (FwGroup)item;
                }
                ++j;
            }
        }
        return null;
    }

    public String getGroupName(String protocolName) {
        String groupName = null;
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            FwGroup grp = (FwGroup)e.nextElement();
            Vector items = grp.getItems();
            int j = 0;
            while (j < items.size()) {
                FwProtocol prot;
                FwBase item = (FwBase)items.elementAt(j);
                if (item instanceof FwGroup && (prot = ((FwGroup)item).getProtocol(protocolName)) != null) {
                    return item.getName();
                }
                ++j;
            }
            FwProtocol prot = grp.getProtocol(protocolName);
            if (prot == null) continue;
            return grp.getName();
        }
        return groupName;
    }

    public Vector getGroups() {
        return this.groups;
    }

    public FwProtocol getProtocol(String prot) {
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            FwGroup grp = (FwGroup)e.nextElement();
            FwProtocol fwprot = grp.getProtocol(prot);
            if (fwprot == null) continue;
            return fwprot;
        }
        return null;
    }

    public Vector getProtocols() {
        Vector v = new Vector();
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            FwGroup grp = (FwGroup)e.nextElement();
            grp.addProtocols(v);
        }
        return v;
    }

    public void parse(Element data) {
        List l = data.getChildren();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Element item = (Element)it.next();
            String name = item.getAttributeValue("name");
            FwGroup grp = new FwGroup();
            grp.parse(item);
            this.groups.add(grp);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("FwData:").append(System.getProperty("line.separator"));
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            str.append(((FwGroup)e.nextElement()).toString());
        }
        str.append(System.getProperty("line.separator"));
        return str.toString();
    }
}

