/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.feed;

import com.cisco.xdm.data.cbac.feed.FwBase;
import com.cisco.xdm.data.cbac.feed.FwOption;
import com.cisco.xdm.data.cbac.feed.type.Member;
import com.cisco.xdm.data.cbac.feed.type.tBase;
import com.cisco.xdm.data.cbac.feed.type.tStruct;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

public class FwProtocol
extends FwBase {
    private boolean bcheckopt = true;
    private Vector options = new Vector();
    private String altcmd = "";
    private String pam = "";
    private String type = "";

    public void addOption(FwOption option) {
        this.options.addElement(option);
    }

    public Object clone() {
        FwProtocol cloneEntry = (FwProtocol)super.clone();
        cloneEntry.altcmd = this.altcmd;
        cloneEntry.pam = this.pam;
        cloneEntry.type = this.type;
        cloneEntry.bcheckopt = this.bcheckopt;
        cloneEntry.options = new Vector();
        Enumeration en = this.options.elements();
        while (en.hasMoreElements()) {
            FwOption opt = (FwOption)((FwOption)en.nextElement()).clone();
            cloneEntry.options.addElement(opt);
        }
        return cloneEntry;
    }

    public String getAltCmd() {
        return this.altcmd;
    }

    public boolean getCheckOpt() {
        return this.bcheckopt;
    }

    public String getDefault(Hashtable types, String varname) {
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            FwOption opt = (FwOption)e.nextElement();
            tBase baseClass = (tBase)types.get(opt.getType());
            if (baseClass instanceof tStruct) {
                Enumeration m = ((tStruct)baseClass).getMembers().elements();
                while (m.hasMoreElements()) {
                    Member mem = (Member)m.nextElement();
                    if (!mem.getName().equals(varname)) continue;
                    String def = mem.getDefault();
                    if (def == null) {
                        def = "";
                    }
                    return def;
                }
                continue;
            }
            if (!opt.getName().equals(varname)) continue;
            String def = opt.getDefault();
            if (def == null) {
                def = "";
            }
            return def;
        }
        return "";
    }

    public String getName4Type(Hashtable types, String typeName) {
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            FwOption opt = (FwOption)e.nextElement();
            tBase baseClass = (tBase)types.get(opt.getType());
            if (baseClass instanceof tStruct) {
                Enumeration m = ((tStruct)baseClass).getMembers().elements();
                while (m.hasMoreElements()) {
                    Member mem = (Member)m.nextElement();
                    if (!mem.getType().equals(typeName)) continue;
                    return mem.getName();
                }
                continue;
            }
            if (!baseClass.getTypename().equals(typeName)) continue;
            return opt.getName();
        }
        return "";
    }

    public FwOption getOption(String typeName) {
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            FwOption opt = (FwOption)e.nextElement();
            if (!opt.getType().equals(typeName)) continue;
            return opt;
        }
        return null;
    }

    public FwOption getOptionFromName(String optionName) {
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            FwOption opt = (FwOption)e.nextElement();
            if (!opt.getName().equals(optionName)) continue;
            return opt;
        }
        return null;
    }

    public Vector getOptions() {
        return this.options;
    }

    public String getPam() {
        return this.pam;
    }

    public void parse(Element prot) {
        String oref;
        this.name = prot.getAttributeValue("name");
        this.resid = prot.getAttributeValue("resid");
        if (prot.getAttributeValue("alt") != null) {
            this.altcmd = prot.getAttributeValue("alt");
        }
        if (prot.getAttributeValue("pam") != null) {
            this.pam = prot.getAttributeValue("pam");
        }
        if (prot.getAttributeValue("type") != null) {
            this.type = prot.getAttributeValue("type");
        }
        if (prot.getAttributeValue("checkopt") != null && prot.getAttributeValue("checkopt").equals("false")) {
            this.bcheckopt = false;
        }
        if ((oref = prot.getAttributeValue("optionref")) != null && !oref.equals("")) {
            FwOption o = new FwOption(oref, oref);
            this.addOption(o);
        }
        List l = prot.getChildren();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Element option = (Element)it.next();
            String oname = option.getAttributeValue("name");
            String otype = option.getAttributeValue("type");
            String odefault = option.getAttributeValue("default");
            boolean breq = false;
            if (option.getAttributeValue("required") != null && option.getAttributeValue("required").equals("true")) {
                breq = true;
            }
            FwOption fwOption = new FwOption(oname, otype, odefault);
            fwOption.setRequired(breq);
            this.addOption(fwOption);
        }
    }

    public void setOptionType(String stType) {
        this.type = stType;
    }

    public void setPam(String stPam) {
        this.pam = stPam;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Protocol: " + this.name);
        if (!this.altcmd.equals("")) {
            str.append(" alt(" + this.altcmd + ")");
        }
        if (!this.pam.equals("")) {
            str.append(" pam(" + this.pam + ")");
        }
        if (!this.type.equals("")) {
            str.append(" type(" + this.type + ")");
        }
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            str.append("  " + ((FwOption)e.nextElement()).toString());
        }
        str.append(System.getProperty("line.separator"));
        return str.toString();
    }
}

