/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DevInfoBase;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.systemproperties.SystemProp;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceExpListener;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class HostIdentity
implements Cloneable {
    public static final int MAX_HOSTNAME_LENGTH = 63;
    public static final int MAX_TIMEOUT_FOR_PING = 120000;
    public static final int VALID_IP_ADDRESS = -2;
    public static final int VALID_HOST = -1;
    public static final int NULL_HOST = 0;
    public static final int HOSTNAME_LENGTH_EXCEED = 1;
    public static final int INVALID_HOST = 2;
    public static final int DNS_NOT_CONFIGURED = 3;
    public static final int HOSTNAME_UNRESOLVABLE = 4;
    private boolean _isHostNameFlag;
    private String _name;
    private IPAddress _ipaddr;

    public HostIdentity(IPAddress addr) {
        this._isHostNameFlag = false;
        this._ipaddr = addr;
    }

    public HostIdentity(String name) {
        if (IPAddress.isLegalIPAddress(name)) {
            this._ipaddr = new IPAddress(name);
            this._isHostNameFlag = false;
        } else {
            this._name = name;
            this._isHostNameFlag = true;
        }
    }

    public Object clone() {
        try {
            HostIdentity newObj = (HostIdentity)super.clone();
            if (!this._isHostNameFlag) {
                newObj._ipaddr = (IPAddress)this._ipaddr.clone();
            }
            return newObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HostIdentity)) {
            return false;
        }
        HostIdentity host = (HostIdentity)obj;
        if (this._isHostNameFlag && host._isHostNameFlag) {
            if (this._name != null && host._name != null) {
                return this._name.equals(host._name);
            }
            return this._name == null && host._name == null;
        }
        if (this._isHostNameFlag || host._isHostNameFlag) {
            return false;
        }
        if (this._ipaddr != null && host._ipaddr != null) {
            return this._ipaddr.equals(host._ipaddr);
        }
        return this._ipaddr == null && host._ipaddr == null;
    }

    private static IPAddress extractIP(String response) {
        StringTokenizer strTok = new StringTokenizer(response, " ");
        boolean foundTimeout = false;
        String previousTok = "";
        while (!foundTimeout) {
            try {
                String tok = strTok.nextToken();
                if (tok.indexOf("timeout") >= 0) {
                    foundTimeout = true;
                    Log.getLog().debug("validateHostname:Found IP address " + previousTok);
                    IPAddress ret = new IPAddress(previousTok.substring(0, previousTok.length() - 1));
                    Log.getLog().debug("validateHostname: extractIP: returning ip as" + ret);
                    return ret;
                }
                previousTok = tok;
            }
            catch (Exception exception) {
                Log.getLog().debug("validateHostname: Cannot find IP address from ping response");
                return null;
            }
        }
        return null;
    }

    public String getHostName() {
        if (this._isHostNameFlag) {
            return this._name;
        }
        if (this._ipaddr != null) {
            return this._ipaddr.toString();
        }
        return null;
    }

    public static IPAddress getIPFromHostname(String hostname, DeviceBase dev) {
        if (IPAddress.isLegalIPAddress(hostname)) {
            return new IPAddress(hostname);
        }
        if (HostIdentity.validateHostnameSyntax(hostname) == -1) {
            return HostIdentity.resolveIP(hostname, dev.getDevInfoBase());
        }
        return null;
    }

    public IPAddress getIpAddress() {
        if (!this._isHostNameFlag) {
            return this._ipaddr;
        }
        return null;
    }

    public String getIpAddressAsString() {
        return this._ipaddr.toString();
    }

    public boolean isHostName() {
        return this._isHostNameFlag;
    }

    public void print() {
        if (this._isHostNameFlag) {
            Log.getLog().debug("Host name is    " + this._name);
        } else if (this._ipaddr != null) {
            Log.getLog().debug("Host IP is   " + this._ipaddr.toString());
        } else {
            Log.getLog().debug("Host Identity is   emplty");
        }
    }

    private static IPAddress resolveIP(String host, DevInfoBase devInfo) {
        IPAddress retVal;
        block12: {
            String[] cmd = new String[]{"ping " + host};
            retVal = null;
            Log.getLog().debug("Hostname: validateHostname: sending '" + cmd[0] + "' Command to device");
            if (devInfo == null) break block12;
            IOSCmdService cmdSrvc = devInfo.getComm();
            IOSCmdServiceExpListener listener = cmdSrvc.getFirstExpListener();
            if (listener != null) {
                cmdSrvc.removeIOSCmdServiceExpListener(listener);
            }
            int origTimeout = 10000;
            try {
                String cmdSent;
                IOSCmdResponse[] result;
                origTimeout = cmdSrvc.getTimeout();
                if (origTimeout < 120000) {
                    cmdSrvc.setTimeout(120000);
                }
                if ((result = cmdSrvc.exec(cmd)) != null && result.length > 0 && (cmdSent = result[0].getCmd()).equals(cmd[0])) {
                    int status = result[0].getStatus();
                    Log.getLog().debug("HostIdentity: validateHostname: Status of " + cmd[0] + " is " + status);
                    String response = result[0].getOutput();
                    Log.getLog().debug("HostIdentity: validateHostname: Response of " + cmd[0] + " is: ");
                    if (response != null) {
                        Log.getLog().debug(response);
                        if (response.indexOf("%") >= 0) {
                            Log.getLog().debug("HostIdentity: validateHostname: Found '%'. Cannot resolve hostname into IP");
                        } else {
                            retVal = HostIdentity.extractIP(response);
                        }
                    }
                }
            }
            catch (IOSCmdServiceException iOSCmdServiceException) {
                Log.getLog().debug("HostIdentity: validateHostname: exception from Cmd svc for ping cmd");
            }
            if (listener != null) {
                cmdSrvc.addIOSCmdServiceExpListener(listener);
            }
            try {
                if (cmdSrvc.getTimeout() != origTimeout) {
                    cmdSrvc.setTimeout(origTimeout);
                }
            }
            catch (IOSCmdServiceException iOSCmdServiceException) {
                Log.getLog().debug("HostIdentity: validateHostname: Cannot set timeout of cmdsvc back to original timeout = " + origTimeout);
            }
        }
        return retVal;
    }

    public boolean setHostName(String hostname) {
        if (IPAddress.isLegalIPAddress(hostname)) {
            this._ipaddr = new IPAddress(hostname);
            this._isHostNameFlag = false;
        } else {
            this._isHostNameFlag = true;
            this._name = hostname;
        }
        return true;
    }

    public boolean setIpAddress(IPAddress ipaddress) {
        if (IPAddress.isLegalIPAddress(ipaddress.toString())) {
            this._isHostNameFlag = false;
            this._ipaddr = ipaddress;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this._isHostNameFlag) {
            return this._name;
        }
        if (this._ipaddr != null) {
            return this._ipaddr.toString();
        }
        return "";
    }

    public static int validateHostIdentity(String host, DeviceBase dev) {
        if (IPAddress.isLegalIPAddress(host)) {
            return -2;
        }
        return HostIdentity.validateHostname(host, dev);
    }

    public static int validateHostname(String hostname, DeviceBase dev) {
        int result = HostIdentity.validateHostnameSyntax(hostname);
        if (result == -1) {
            Enumeration dns;
            Log.getLog().debug("HostIdentity:validateHostname: hostname syntax is correct. Checking if device can resolve it to IP address.");
            IPAddress addr = HostIdentity.resolveIP(hostname, dev.getDevInfoBase());
            if (addr != null) {
                Log.getLog().debug("HostIdentity: validateHostname: Hostname " + hostname + " is resolved into " + addr);
                return -1;
            }
            Log.getLog().debug("HostIdentity: validateHostname: hostname not resolvabel by Dns ");
            SystemProp sysProp = dev.getSystemProp();
            if (sysProp != null && !(dns = sysProp.getNameServers()).hasMoreElements()) {
                Log.getLog().debug("HostIdentity: validateHostname: DNS is not configured..");
                return 3;
            }
            return 4;
        }
        Log.getLog().debug("HostIdentity: validateHostname: Invalid hostname syntax");
        return result;
    }

    public static int validateHostnameSyntax(String hostname) {
        if (hostname == null) {
            Log.getLog().debug("HostIdentity: validateHostnameSyntax: hostname is null");
            return 0;
        }
        int originalLen = hostname.length();
        if (originalLen == 0) {
            Log.getLog().debug("HostIdentity: validateHostnameSyntax: hostname is null");
            return 0;
        }
        int len = (hostname = hostname.trim()).length();
        if (len != originalLen) {
            Log.getLog().debug("HostIdentity: validateHostnameSyntax: hostname has spaces.");
            return 2;
        }
        StringTokenizer strTok1 = new StringTokenizer(hostname, " ", false);
        if (strTok1.countTokens() > 1) {
            Log.getLog().debug("HostIdentity: validateHostnameSyntax: Hostname has spaces.");
            return 2;
        }
        if (hostname.indexOf(63) >= 0) {
            Log.getLog().debug("HostIdentity: validateHostnameSyntax: hostname has a  '?' Character.");
            return 2;
        }
        if (len > 63) {
            Log.getLog().debug("HostIdentity: validateHostnameSyntax: hostname length exceeds 1");
            return 1;
        }
        Log.getLog().debug("HostIdentity: validateHostnameSyntax: Hostname syntax is valid");
        return -1;
    }
}

