/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.systemproperties.SystemProp;
import java.util.StringTokenizer;

public class IPAddress
implements Cloneable {
    public static final String WILD_ANY_STR = "0.0.0.0";
    public static final IPAddress WILD_ANY = new IPAddress("0.0.0.0");
    public static final String ALL_1S_STR = "255.255.255.255";
    public static final IPAddress ALL_1S = new IPAddress("255.255.255.255");
    public static final String LOOP_BACK_START_STR = "127.0.0.0";
    public static final IPAddress LOOP_BACK_START = new IPAddress("127.0.0.0");
    public static final String LOOP_BACK_END_STR = "127.255.255.255";
    public static final IPAddress LOOP_BACK_END = new IPAddress("127.255.255.255");
    public static final String CLASS_A_START_STR = "1.0.0.0";
    public static final IPAddress CLASS_A_START = new IPAddress("1.0.0.0");
    public static final String CLASS_B_START_STR = "128.0.0.0";
    public static final IPAddress CLASS_B_START = new IPAddress("128.0.0.0");
    public static final String CLASS_C_START_STR = "192.0.0.0";
    public static final IPAddress CLASS_C_START = new IPAddress("192.0.0.0");
    public static final String CLASS_C_END_STR = "223.255.255.255";
    public static final IPAddress CLASS_C_END = new IPAddress("223.255.255.255");
    private static final String _errorStr = "Cannot construct IP address from string ";
    private boolean _isNull;
    private int[] bytes;
    private int intValue;
    private long unsignedIntValue;

    public IPAddress() {
        this.bytes = new int[4];
        this._isNull = true;
    }

    public IPAddress(int iip) {
        this.bytes = new int[4];
        this.intValue = iip;
        this.bytes[3] = iip & 0xFF;
        this.bytes[2] = (iip >>>= 8) & 0xFF;
        this.bytes[1] = (iip >>>= 8) & 0xFF;
        this.bytes[0] = (iip >>>= 8) & 0xFF;
        this.unsignedIntValue = ((long)this.bytes[0] << 24) + ((long)this.bytes[1] << 16) + ((long)this.bytes[2] << 8) + (long)this.bytes[3];
        if (this.unsignedIntValue < 0L) {
            Log.getLog().debug("3:" + this.unsignedIntValue + " " + this.bytes[0] + " " + this.bytes[1] + " " + this.bytes[2] + " " + this.bytes[3]);
        }
    }

    public IPAddress(int b0, int b1, int b2, int b3) throws NumberFormatException {
        this.bytes = new int[4];
        this._isNull = false;
        if (b0 < 0 || b0 > 255 || b1 < 0 || b1 > 255 || b2 < 0 || b2 > 255 || b3 < 0 || b3 > 255) {
            throw new NumberFormatException(_errorStr + b0 + "." + b1 + "." + b2 + "." + b3);
        }
        this.bytes[0] = b0;
        this.bytes[1] = b1;
        this.bytes[2] = b2;
        this.bytes[3] = b3;
        this.intValue = (this.bytes[0] << 24) + (this.bytes[1] << 16) + (this.bytes[2] << 8) + this.bytes[3];
        this.unsignedIntValue = ((long)this.bytes[0] << 24) + ((long)this.bytes[1] << 16) + ((long)this.bytes[2] << 8) + (long)this.bytes[3];
        if (this.unsignedIntValue < 0L) {
            Log.getLog().debug("2:" + this.unsignedIntValue);
        }
    }

    public IPAddress(IPAddress addr, Netmask mask) throws NumberFormatException {
        this.bytes = new int[4];
        this._isNull = false;
        this.bytes[0] = addr.getByte(0) & mask.getByte(0);
        this.bytes[1] = addr.getByte(1) & mask.getByte(1);
        this.bytes[2] = addr.getByte(2) & mask.getByte(2);
        this.bytes[3] = addr.getByte(3) & mask.getByte(3);
        this.intValue = (this.bytes[0] << 24) + (this.bytes[1] << 16) + (this.bytes[2] << 8) + this.bytes[3];
        this.unsignedIntValue = ((long)this.bytes[0] << 24) + ((long)this.bytes[1] << 16) + ((long)this.bytes[2] << 8) + (long)this.bytes[3];
    }

    public IPAddress(String s) throws NumberFormatException {
        if (!IPAddress.isLegalIPAddress(s)) {
            throw new NumberFormatException(_errorStr + s);
        }
        this.bytes = new int[4];
        this._isNull = false;
        if ((s = s.trim()) == null || s.equals("")) {
            this._isNull = true;
            return;
        }
        if (s.equals(WILD_ANY_STR) || s.equals("0")) {
            this.intValue = 0;
            this.unsignedIntValue = 0L;
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ".");
        int i = 0;
        while (i < 4) {
            if (!st.hasMoreTokens()) {
                throw new NumberFormatException(_errorStr + s);
            }
            int value = Integer.parseInt(st.nextToken(), 10);
            if (value < 0 || value > 255) {
                throw new NumberFormatException(_errorStr + s);
            }
            this.bytes[i] = value;
            ++i;
        }
        this.intValue = (this.bytes[0] << 24) + (this.bytes[1] << 16) + (this.bytes[2] << 8) + this.bytes[3];
        this.unsignedIntValue = ((long)this.bytes[0] << 24) + ((long)this.bytes[1] << 16) + ((long)this.bytes[2] << 8) + (long)this.bytes[3];
        if (this.unsignedIntValue < 0L) {
            Log.getLog().debug("1:" + this.unsignedIntValue + " " + s + " " + this.bytes[0] + " " + this.bytes[1] + " " + this.bytes[2] + " " + this.bytes[3]);
        }
        if (st.hasMoreTokens()) {
            throw new NumberFormatException(_errorStr + s);
        }
    }

    public Object clone() {
        try {
            IPAddress newObj = (IPAddress)super.clone();
            newObj.bytes = new int[4];
            newObj.bytes[0] = this.bytes[0];
            newObj.bytes[1] = this.bytes[1];
            newObj.bytes[2] = this.bytes[2];
            newObj.bytes[3] = this.bytes[3];
            return newObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public boolean equals(IPAddress ip) {
        if (ip == null) {
            return false;
        }
        if (this._isNull && ip.isNull()) {
            return true;
        }
        return this.unsignedIntValue == ip.unsignedIntValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IPAddress)) {
            return false;
        }
        return this.equals((IPAddress)o);
    }

    public boolean equals(String val) {
        return this.toString().equals(val);
    }

    private static int findIPDots(String s) {
        int i = 0;
        int j = 0;
        int length = s.length();
        String dot = ".";
        do {
            j = s.indexOf(dot, j);
        } while (++j >= 1 && j <= length && ++i < 5);
        return --i;
    }

    public IPAddress getBeginningAddress(Netmask b) {
        int ip = this.intValue;
        int nm = b.getIntValue();
        int bip = ip & nm;
        if (bip == ip) {
            return this;
        }
        return new IPAddress(bip);
    }

    public IPAddress getBeginningHostAddress(Netmask b) {
        if (b.equals(Netmask.HOST_MASK)) {
            return this;
        }
        IPAddress ip = this.getBeginningAddress(b);
        return new IPAddress(ip.getIntValue() + 1);
    }

    public IPAddress getBroadcastAddr(Netmask mask) {
        Netmask reverseMask = mask.reverseMask();
        int reverseMaskInt = reverseMask.getIntValue();
        return new IPAddress(this.intValue | reverseMaskInt);
    }

    public int getByte(int pos) {
        return this.bytes[pos];
    }

    public IPAddress getFinalAddress(Netmask b) {
        int ip = this.intValue;
        int nm = b.getIntValue();
        IPAddress returnAddress = new IPAddress(ip | ~nm);
        return returnAddress;
    }

    public IPAddress getFinalHostAddress(Netmask b) {
        if (b.equals(Netmask.HOST_MASK)) {
            return this;
        }
        IPAddress ip = this.getFinalAddress(b);
        return new IPAddress(ip.getIntValue() - 1);
    }

    public int getIntValue() {
        return this.intValue;
    }

    public long getRangeCount(IPAddress endIp) {
        return endIp.unsignedIntValue - this.unsignedIntValue + 1L;
    }

    public IPAddress getSubnet(Netmask mask) {
        return new IPAddress(this, mask);
    }

    public long getUnsignedIntValue() {
        return this.unsignedIntValue;
    }

    public boolean greaterThan(IPAddress ip) {
        return this.unsignedIntValue > ip.unsignedIntValue;
    }

    public boolean greaterThanOrEqual(IPAddress ip) {
        return this.unsignedIntValue >= ip.unsignedIntValue;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isAddrStartWith255() {
        IPAddress addrStartWith255 = new IPAddress("255.0.0.0");
        return this.greaterThanOrEqual(addrStartWith255);
    }

    public boolean isClassA() {
        return this.greaterThanOrEqual(CLASS_A_START) && this.lessThan(CLASS_B_START);
    }

    public boolean isClassB() {
        return this.greaterThanOrEqual(CLASS_B_START) && this.lessThan(CLASS_C_START);
    }

    public boolean isClassC() {
        return this.greaterThanOrEqual(CLASS_C_START) && this.lessThanOrEqual(CLASS_C_END);
    }

    public static boolean isLegalIPAddress(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).equals("")) {
            return false;
        }
        if (s.equals(WILD_ANY_STR) || s.equals("0")) {
            return true;
        }
        if (IPAddress.findIPDots(s) != 3) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(s, ".");
        if (st.countTokens() != 4) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int value;
            try {
                value = Integer.parseInt(st.nextToken(), 10);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (value < 0 || value > 255) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isLoopbackAddr() {
        return this.greaterThanOrEqual(LOOP_BACK_START) && this.lessThanOrEqual(LOOP_BACK_END);
    }

    public boolean isNull() {
        return this._isNull;
    }

    public boolean isPrivateAddr() {
        IPAddress startClassAPri = new IPAddress("10.0.0.0");
        IPAddress endClassAPri = new IPAddress("10.255.255.255");
        IPAddress startClassBPri = new IPAddress("172.16.0.0");
        IPAddress endClassBPri = new IPAddress("172.31.255.255");
        IPAddress startClassCPri = new IPAddress("192.168.0.0");
        IPAddress endClassCPri = new IPAddress("192.168.255.255");
        return this.greaterThanOrEqual(startClassAPri) && this.lessThanOrEqual(endClassAPri) || this.greaterThanOrEqual(startClassBPri) && this.lessThanOrEqual(endClassBPri) || this.greaterThanOrEqual(startClassCPri) && this.lessThanOrEqual(endClassCPri);
    }

    public boolean isSubnetZeroAddress(Netmask mask) {
        if (mask == null) {
            return false;
        }
        Netmask classBasedMask = Netmask.getClassBasedMaskFromIP(this);
        if (mask.getMaskLength() <= classBasedMask.getMaskLength()) {
            return false;
        }
        IPAddress classBasedSubnet = this.getSubnet(classBasedMask);
        IPAddress givenSubnet = this.getSubnet(mask);
        return mask.getMaskLength() < 31 && classBasedSubnet.equals(givenSubnet);
    }

    public boolean isValidHost() {
        if (this.equals(WILD_ANY) || this.equals(ALL_1S)) {
            return false;
        }
        if (!(this.isClassA() || this.isClassB() || this.isClassC())) {
            return false;
        }
        if (this.isLoopbackAddr()) {
            return false;
        }
        return !this.isAddrStartWith255();
    }

    public boolean isValidHost(Netmask mask, DeviceBase dev) {
        if (mask == null) {
            return false;
        }
        if (this.equals(WILD_ANY) || this.equals(ALL_1S) || mask.equals(WILD_ANY) || mask.equals(ALL_1S)) {
            return false;
        }
        if (!Netmask.isLegalNetmask(mask)) {
            return false;
        }
        IPAddress ntwk = this.getSubnet(mask);
        IPAddress bcastAddr = this.getBroadcastAddr(mask);
        if (this.equals(ntwk) || this.equals(bcastAddr)) {
            return false;
        }
        if (!(this.isClassA() || this.isClassB() || this.isClassC())) {
            return false;
        }
        if (this.isLoopbackAddr()) {
            return false;
        }
        if (this.isAddrStartWith255()) {
            return false;
        }
        SystemProp sysProp = dev.getSystemProp();
        return sysProp.isIpSubnetZero() || !this.isSubnetZeroAddress(mask);
    }

    public boolean isValidHost(Netmask mask, boolean ignore31mask, DeviceBase dev) {
        if (mask == null) {
            return false;
        }
        if (this.equals(WILD_ANY) || this.equals(ALL_1S) || mask.equals(WILD_ANY) || mask.equals(ALL_1S)) {
            return false;
        }
        if (!Netmask.isLegalNetmask(mask)) {
            return false;
        }
        IPAddress ntwk = this.getSubnet(mask);
        IPAddress bcastAddr = this.getBroadcastAddr(mask);
        if (ignore31mask ? mask.getMaskLength() < 31 && (this.equals(ntwk) || this.equals(bcastAddr)) : this.equals(ntwk) || this.equals(bcastAddr)) {
            return false;
        }
        if (!(this.isClassA() || this.isClassB() || this.isClassC())) {
            return false;
        }
        if (this.isLoopbackAddr()) {
            return false;
        }
        if (this.isAddrStartWith255()) {
            return false;
        }
        SystemProp sysProp = dev.getSystemProp();
        return sysProp.isIpSubnetZero() || !this.isSubnetZeroAddress(mask);
    }

    public boolean isValidLoopbackIntfIP(Netmask mask, DeviceBase dev) {
        if (this.equals(WILD_ANY) || this.equals(ALL_1S)) {
            return false;
        }
        if (!(this.isClassA() || this.isClassB() || this.isClassC())) {
            return false;
        }
        if (this.isLoopbackAddr()) {
            return false;
        }
        SystemProp sysProp = dev.getSystemProp();
        return sysProp.isIpSubnetZero() || !this.isSubnetZeroAddress(mask);
    }

    public boolean lessThan(IPAddress ip) {
        return this.unsignedIntValue < ip.unsignedIntValue;
    }

    public boolean lessThanOrEqual(IPAddress ip) {
        return this.unsignedIntValue <= ip.unsignedIntValue;
    }

    public static IPAddress makeHiAddrInRange(IPAddress addr, Netmask mask) throws NumberFormatException {
        int[] b = new int[]{addr.getByte(0) | mask.getByte(0) ^ 0xFF, addr.getByte(1) | mask.getByte(1) ^ 0xFF, addr.getByte(2) | mask.getByte(2) ^ 0xFF, addr.getByte(3) | mask.getByte(3) ^ 0xFF};
        return new IPAddress(b[0], b[1], b[2], b[3]);
    }

    public static IPAddress makeLegalIPAddress(String s) {
        if (!IPAddress.isLegalIPAddress(s)) {
            return null;
        }
        if (s == null || s.equals("")) {
            return null;
        }
        if (s.equals(WILD_ANY_STR) || s.equals("0")) {
            return new IPAddress(WILD_ANY_STR);
        }
        StringTokenizer st = new StringTokenizer(s, ".");
        int i = 0;
        while (i < 4) {
            int value;
            if (!st.hasMoreTokens()) {
                return null;
            }
            try {
                value = Integer.parseInt(st.nextToken(), 10);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (value < 0 || value > 255) {
                return null;
            }
            ++i;
        }
        IPAddress ip = new IPAddress(s);
        return ip;
    }

    public void setByte(int pos, int value) throws NumberFormatException {
        if (value < 0 || value > 255) {
            throw new NumberFormatException("Cannot set ip address with " + value + " at position " + pos);
        }
        this.bytes[pos] = value;
        this.intValue = (this.bytes[0] << 24) + (this.bytes[1] << 16) + (this.bytes[2] << 8) + this.bytes[3];
        this.unsignedIntValue = ((long)this.bytes[0] << 24) + ((long)this.bytes[1] << 16) + ((long)this.bytes[2] << 8) + (long)this.bytes[3];
    }

    public void setNull() {
        this.bytes[0] = 0;
        this.bytes[1] = 0;
        this.bytes[2] = 0;
        this.bytes[3] = 0;
        this.intValue = 0;
        this.unsignedIntValue = 0L;
        this._isNull = true;
    }

    public String toString() {
        String s = String.valueOf(String.valueOf(this.bytes[0])) + "." + String.valueOf(this.bytes[1]) + "." + String.valueOf(this.bytes[2]) + "." + String.valueOf(this.bytes[3]);
        return s;
    }

    public static boolean verifyAddress(IPAddress ntwk, Netmask mask, IPAddress addr) {
        if (ntwk == null || mask == null || addr == null) {
            return false;
        }
        IPAddress networkBeginAddr = ntwk.getSubnet(mask);
        IPAddress networkEndAddr = ntwk.getBroadcastAddr(mask);
        return addr.greaterThanOrEqual(networkBeginAddr) && addr.lessThanOrEqual(networkEndAddr);
    }

    public static boolean verifyNetwork(IPAddress ntwk1, Netmask mask1, IPAddress ntwk2, Netmask mask2) {
        if (ntwk1 == null || mask1 == null || ntwk1 == null || mask1 == null) {
            return false;
        }
        IPAddress ntwk1BeginAddr = ntwk1.getSubnet(mask1);
        IPAddress ntwk1EndAddr = ntwk1.getBroadcastAddr(mask1);
        IPAddress ntwk2BeginAddr = ntwk2.getSubnet(mask2);
        IPAddress ntwk2EndAddr = ntwk2.getBroadcastAddr(mask2);
        return !ntwk1EndAddr.lessThan(ntwk2BeginAddr) && !ntwk2EndAddr.lessThan(ntwk1BeginAddr);
    }
}

