/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.HWConfig;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.interfaces.IfID;

public class IfIdentity
implements Cloneable {
    private boolean _isIfNameFlag;
    private IPAddress _ipaddr;
    private IfID _ifId;

    public IfIdentity(IPAddress addr) {
        this._isIfNameFlag = false;
        this._ipaddr = addr;
    }

    public IfIdentity(IfID ifId) {
        this._isIfNameFlag = true;
        this._ifId = ifId;
    }

    public Object clone() {
        try {
            IfIdentity newObj = (IfIdentity)super.clone();
            if (!this._isIfNameFlag) {
                newObj._ipaddr = (IPAddress)this._ipaddr.clone();
            }
            return newObj;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return this;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IfIdentity)) {
            return false;
        }
        IfIdentity intf = (IfIdentity)obj;
        if (this._isIfNameFlag && intf._isIfNameFlag) {
            if (this._ifId != null && intf._ifId != null) {
                return this._ifId.equals(intf._ifId);
            }
            return this._ifId == null && intf._ifId == null;
        }
        if (this._isIfNameFlag || intf._isIfNameFlag) {
            return false;
        }
        if (this._ipaddr != null && intf._ipaddr != null) {
            return this._ipaddr.equals(intf._ipaddr);
        }
        return this._ipaddr == null && intf._ipaddr == null;
    }

    public IfID getIf() {
        return this._ifId;
    }

    public String getIfName() {
        if (this._isIfNameFlag && this._ifId != null) {
            return this._ifId.toString();
        }
        return null;
    }

    public IPAddress getIpAddress() {
        if (this._isIfNameFlag) {
            return null;
        }
        return this._ipaddr;
    }

    public String getIpAddressAsString() {
        if (!this._isIfNameFlag && this._ipaddr != null) {
            return this._ipaddr.toString();
        }
        return null;
    }

    public boolean isIfName() {
        return this._isIfNameFlag;
    }

    public void print() {
        if (this._isIfNameFlag) {
            Log.getLog().debug("   " + this._ifId.toString());
        } else {
            Log.getLog().debug("   " + this._ipaddr);
        }
    }

    public boolean setIfName(String ifname, HWConfig hwConfig) {
        this._isIfNameFlag = true;
        this._ifId = IfID.fromString(ifname, hwConfig);
        return true;
    }

    public boolean setIpAddress(IPAddress ipaddress) {
        if (IPAddress.isLegalIPAddress(ipaddress.toString())) {
            this._isIfNameFlag = false;
            this._ipaddr = ipaddress;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this._isIfNameFlag) {
            return "Intf Name is " + this._ifId;
        }
        return "Intf IP is " + this._ipaddr.toString();
    }
}

