/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.controllers;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.controllers.ControllerID;
import com.cisco.xdm.data.controllers.Controllers;
import java.io.IOException;
import java.util.StringTokenizer;

public class Controller
extends XDMObject {
    private CmdValues _cmd = null;
    private int _cmdPos = -1;
    private ControllerID _id;
    private boolean _shutdown = false;
    private String _desc = new String();
    static final String KEY_DESCRIPTION = "description";
    static final String KEY_DESC = "desc";
    static final String KEY_SHUTDOWN = "shutdown";

    protected Controller(ControllerID id) {
        super(null);
        this._id = id;
    }

    public Object clone() {
        Controller newObj = (Controller)super.clone();
        this._cmd = null;
        this._cmdPos = -1;
        return newObj;
    }

    public CmdValues generateControllerCmd() {
        CmdValues cmd = new CmdValues("controller");
        StringTokenizer st = new StringTokenizer(this._id.toString());
        cmd.addValue("type", st.nextToken());
        cmd.addValue("location", st.nextToken());
        return cmd;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup != null && !(backup instanceof Controller)) {
            throw new XDMException(4);
        }
        Controller bController = null;
        if (backup != null) {
            bController = (Controller)backup;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        CmdValues cmd = this.generateControllerCmd();
        if (this.isBackup()) {
            cmd.setAction(2);
            values.addCmdValues(cmd);
            return;
        }
        ConfigValues subcfg = new ConfigValues();
        if (bController == null && this._desc.length() > 0 || bController != null && !this._desc.equals(bController._desc)) {
            CmdValues subcmd = new CmdValues(KEY_DESCRIPTION);
            if (this._desc.length() == 0) {
                subcmd.setAction(2);
            } else {
                subcmd.addValue(KEY_DESC, this._desc);
            }
            subcfg.addCmdValues(subcmd);
        }
        if (bController == null && !this._shutdown || bController != null && this._shutdown != bController._shutdown) {
            CmdValues subCmd = new CmdValues(KEY_SHUTDOWN);
            subCmd.setAction(2);
            subcfg.addCmdValues(subCmd);
        }
        if (subcfg.numCmds() > 0) {
            cmd.setModeCmdsValues(subcfg);
            values.addCmdValues(cmd);
            this._cmd = cmd;
            this._cmdPos = -1;
        } else {
            this._cmd = null;
            this._cmdPos = values.numCmds();
        }
    }

    public CmdValues getControllerCmdValues() {
        if (this._cmd == null) {
            this._cmd = this.generateControllerCmd();
        }
        return this._cmd;
    }

    public String getDesc() {
        return this._desc;
    }

    public ControllerID getID() {
        return this._id;
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        if (subCmds != null) {
            int i = 0;
            while (i < subCmds.numCmds()) {
                CmdValues cmd = subCmds.getCmdValues(i);
                String cmdName = cmd.getCmdName();
                if (cmdName.compareTo(KEY_DESCRIPTION) == 0) {
                    this._desc = cmd.getValue(KEY_DESC);
                } else if (cmdName.compareTo(KEY_SHUTDOWN) == 0) {
                    this._shutdown = cmd.isNoCmd() ^ true;
                }
                ++i;
            }
        }
    }

    public void sendShutdown2Dev(boolean flag) throws IOException {
        if (this.isBackup()) {
            return;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        Controllers ctrls = dev.getBackup().getControllers();
        if (!ctrls.containsKey(this._id)) {
            return;
        }
        Controller bObject = (Controller)ctrls.get(this._id);
        this.shutdown(flag);
        String[] commands = new String[]{"controller " + this._id.toString(), "no shutdown"};
        if (flag) {
            commands[1] = KEY_SHUTDOWN;
        }
        dev.getDevInfoBase().getComm().config(commands);
        bObject.shutdown(flag);
    }

    public void setControllerCmdValues(ConfigValues values) {
        ConfigValues subCmds;
        if (this._cmd == null || values == null) {
            return;
        }
        if (this._cmdPos >= 0 && (subCmds = this._cmd.getModeCmdsValues()) != null && subCmds.numCmds() > 0) {
            values.insertCmdValues(this._cmd, this._cmdPos);
            this._cmdPos = -1;
        }
    }

    public void setDesc(String desc) {
        if (!this._desc.equals(desc)) {
            this._desc = desc == null ? "" : desc;
            this.setModified();
        }
    }

    public void shutdown(boolean flag) {
        if (this._shutdown != flag) {
            this._shutdown = flag;
            this.setModified();
        }
    }
}

