/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.controllers;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.controllers.Controller;
import com.cisco.xdm.data.controllers.ControllerID;
import com.cisco.xdm.data.controllers.DSLController;
import java.util.Enumeration;
import java.util.Vector;

public class Controllers
extends XDMHashCollection {
    public Controllers(XDMObject parent) {
        super(parent);
    }

    private Controller createControllerFromCmd(CmdValues cmd) {
        if (cmd == null) {
            return null;
        }
        if (!cmd.containsKey("type") || !cmd.containsKey("location")) {
            return null;
        }
        String type = cmd.getValue("type");
        String loc = cmd.getValue("location");
        Controller newController = null;
        DeviceBase dev = (DeviceBase)this.getDevice();
        ControllerID cID = ControllerID.fromString(type, loc, dev.getDevInfoBase().getHWConfig());
        switch (cID.getType()) {
            case 2001: {
                newController = new DSLController(cID);
                break;
            }
            default: {
                newController = new Controller(cID);
            }
        }
        Log log = Log.getLog();
        log.debug("Created interface object: " + newController.getClass().toString());
        return newController;
    }

    public Controller getControllerFromString(String name) {
        DeviceBase dev;
        String location;
        Controller ret = null;
        if (name == null) {
            return null;
        }
        int space = name.indexOf(" ");
        if (space <= 0) {
            return null;
        }
        String type = name.substring(0, space);
        ControllerID cID = ControllerID.fromString(type, location = name.substring(space + 1), (dev = (DeviceBase)this.getDevice()).getDevInfoBase().getHWConfig());
        if (cID != null) {
            ret = (Controller)this.get(cID);
        }
        return ret;
    }

    public Vector getControllersBySlot(int slot) {
        Vector<Controller> newList = new Vector<Controller>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Controller item = (Controller)e.nextElement();
            if (item.getID().getSlot() != slot) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Vector getControllersByType(int type) {
        Vector<Controller> newList = new Vector<Controller>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Controller item = (Controller)e.nextElement();
            if (item.getID().getType() != type) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log log = Log.getLog();
        ConfigValues ifCVs = config.getCmds("controller", "type", ".*", false);
        if (ifCVs != null) {
            int i = 0;
            while (i < ifCVs.numCmds()) {
                CmdValues cmd = ifCVs.getCmdValues(i);
                Controller newC = this.createControllerFromCmd(cmd);
                if (newC != null) {
                    this.put(newC);
                    newC.populate(config, cmd);
                }
                ++i;
            }
        }
    }

    public synchronized XDMObject put(Controller newController) throws XDMException {
        if (newController == null) {
            throw new XDMException(4);
        }
        return super.put(newController.getID(), newController);
    }
}

