/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.controllers;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.controllers.ATMControllerData;
import com.cisco.xdm.data.controllers.Controller;
import com.cisco.xdm.data.controllers.ControllerID;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterfaces;

public class DSLController
extends Controller {
    public static final int MODE_NONE = 0;
    public static final int MODE_ATM = 1;
    public static final int MODE_T1 = 2;
    public static final int MODE_E1 = 3;
    private int _mode = 0;
    public static final int ANNEX_A = 0;
    public static final int ANNEX_B = 1;
    private int _shdsl_annex = 0;
    public static final int LINE_TERM_CPE = 0;
    public static final int LINE_TERM_CO = 1;
    private int _line_term = 0;
    private String _snr_current = "0";
    private String _snr_snext = "0";
    private XDMObject _modeData = null;
    private static final String KEY_MODE = "mode";
    private static final String KEY_CMODE = "cmode";
    private static final String KEY_ATM = "atm";
    private static final String KEY_T1 = "t1";
    private static final String KEY_E1 = "e1";
    private static final String KEY_DSL_MODE = "dsl-mode";
    private static final String KEY_ANNEX = "annex";
    private static final String KEY_LINE_TERM = "line-term";
    private static final String KEY_TERM = "term";
    private static final String KEY_CPE = "cpe";
    private static final String KEY_CO = "co";
    private static final String KEY_SNR = "snr";
    private static final String KEY_MARGIN = "margin";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VALUE = "value";
    private static final String KEY_CURRENT = "current";
    private static final String KEY_SNEXT = "snext";

    public DSLController(ControllerID id) {
        super(id);
    }

    public Object clone() {
        DSLController newObj = (DSLController)super.clone();
        if (this._modeData != null) {
            newObj._modeData = (XDMObject)this._modeData.clone();
            newObj._modeData.setParent(newObj);
        }
        return newObj;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues subCmd;
        if (backup == null || values == null || this.isReadOnly() || !this.isModified()) {
            return;
        }
        super.generateDelta(backup, values);
        CmdValues cmd = this.getControllerCmdValues();
        ConfigValues subcfg = cmd.getModeCmdsValues();
        if (subcfg == null) {
            subcfg = new ConfigValues();
            cmd.setModeCmdsValues(subcfg);
        }
        DSLController bc = (DSLController)backup;
        if (this._mode != bc._mode) {
            subCmd = new CmdValues(KEY_MODE);
            if (this._mode == 0) {
                subCmd.setAction(2);
            } else if (this._mode == 1) {
                subCmd.addValue(KEY_CMODE, KEY_ATM);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (bc == null || bc._shdsl_annex != this._shdsl_annex) {
            subCmd = new CmdValues(KEY_DSL_MODE);
            subCmd.addValue("shdsl", "shdsl");
            subCmd.addValue("symmetric", "symmetric");
            subCmd.addValue(KEY_ANNEX, KEY_ANNEX);
            if (this._shdsl_annex == 0) {
                subCmd.addValue(KEY_MODE, "A");
            } else {
                subCmd.addValue(KEY_MODE, "B");
            }
            subcfg.addCmdValues(subCmd);
        }
        if (bc == null || bc._line_term != this._line_term) {
            subCmd = new CmdValues(KEY_LINE_TERM);
            if (this._line_term == 1) {
                subCmd.addValue(KEY_TERM, KEY_CO);
            } else {
                subCmd.addValue(KEY_TERM, KEY_CPE);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (bc == null || this._snr_current.compareTo(bc._snr_current) != 0) {
            subCmd = new CmdValues(KEY_SNR);
            subCmd.addValue(KEY_MARGIN, KEY_MARGIN);
            subCmd.addValue(KEY_TYPE, KEY_CURRENT);
            subCmd.addValue(KEY_VALUE, this._snr_current);
            subcfg.addCmdValues(subCmd);
        }
        if (bc == null || this._snr_snext.compareTo(bc._snr_snext) != 0) {
            subCmd = new CmdValues(KEY_SNR);
            subCmd.addValue(KEY_MARGIN, KEY_MARGIN);
            subCmd.addValue(KEY_TYPE, KEY_SNEXT);
            subCmd.addValue(KEY_VALUE, this._snr_snext);
            subcfg.addCmdValues(subCmd);
        }
        if (this._modeData != null && this._modeData.isModified() && !this._modeData.isReadOnly()) {
            this._modeData.generateDelta(bc.getControllerData(), subcfg);
        }
        this.setControllerCmdValues(values);
    }

    public int getAnnex() {
        return this._shdsl_annex;
    }

    public XDMObject getControllerData() {
        return this._modeData;
    }

    public int getLineTerm() {
        return this._line_term;
    }

    public int getMode() {
        return this._mode;
    }

    public String getSNRCurrent() {
        return this._snr_current;
    }

    public String getSNRSnext() {
        return this._snr_snext;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        if (subCmds != null) {
            int i = 0;
            while (i < subCmds.numCmds()) {
                String val;
                CmdValues cmd = subCmds.getCmdValues(i);
                String cmdName = cmd.getCmdName();
                if (cmdName.compareTo(KEY_MODE) == 0) {
                    val = cmd.getValue(KEY_CMODE);
                    if (val.compareTo(KEY_ATM) == 0) {
                        this._mode = 1;
                        this._modeData = new ATMControllerData(this);
                        this._modeData.populate(config, cmdVal);
                    } else if (val.compareTo(KEY_T1) == 0) {
                        this._mode = 2;
                    } else if (val.compareTo(KEY_E1) == 0) {
                        this._mode = 3;
                    }
                    if (this._mode != 0 && this._mode != 1) {
                        this.setReadOnly(true);
                    }
                }
                if (cmdName.compareTo(KEY_DSL_MODE) == 0) {
                    if (cmd.containsKey(KEY_ANNEX)) {
                        val = cmd.getValue(KEY_MODE);
                        this._shdsl_annex = val.compareTo("A") == 0 ? 0 : 1;
                    }
                } else if (cmdName.compareTo(KEY_LINE_TERM) == 0) {
                    val = cmd.getValue(KEY_TERM);
                    this._line_term = val.compareTo(KEY_CO) == 0 ? 1 : 0;
                } else if (cmdName.compareTo(KEY_SNR) == 0) {
                    String type = cmd.getValue(KEY_TYPE);
                    if (type.compareTo(KEY_CURRENT) == 0) {
                        this._snr_current = cmd.getValue(KEY_VALUE);
                    } else if (type.compareTo(KEY_SNEXT) == 0) {
                        this._snr_snext = cmd.getValue(KEY_VALUE);
                    }
                }
                ++i;
            }
        }
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        if (this._modeData != null) {
            this._modeData.resetModifiedFlag();
        }
    }

    public boolean setAnnex(int val) {
        if (val != 0 && val != 1) {
            return false;
        }
        this._shdsl_annex = val;
        this.setModified();
        return true;
    }

    public boolean setLineTerm(int val) {
        if (val != 0 && val != 1) {
            return false;
        }
        this._line_term = val;
        this.setModified();
        return true;
    }

    public boolean setMode(int mode) {
        if (this._mode != 0 && this._mode != 1) {
            return false;
        }
        if (mode != 0 && mode != 1) {
            return false;
        }
        if (mode != this._mode) {
            switch (mode) {
                case 0: {
                    if (this._mode == 1) {
                        XDMInterfaces ifs = ((DeviceBase)this.getDevice()).getIfs();
                        IfID ifid = new IfID(1008, this.getID().getSlot(), this.getID().getModuleSlot(), this.getID().getPort(), -1, 0);
                        ifs.remove(ifid);
                    }
                    this._modeData = null;
                    break;
                }
                case 1: {
                    IfID ifid = new IfID(1008, this.getID().getSlot(), this.getID().getModuleSlot(), this.getID().getPort(), -1, 0);
                    Atm atm = new Atm(ifid);
                    XDMInterfaces ifs = ((DeviceBase)this.getDevice()).getIfs();
                    ifs.put(ifid, atm);
                    this._modeData = new ATMControllerData(this);
                    break;
                }
            }
            this._mode = mode;
            this.setModified();
        }
        return true;
    }

    public boolean setSNRCurrent(String value) {
        if (this._snr_current.compareTo(value) != 0 && this.validateSNR(value)) {
            this._snr_current = value;
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setSNRSnext(String value) {
        if (this._snr_snext.compareTo(value) != 0 && this.validateSNR(value)) {
            this._snr_snext = value;
            this.setModified();
            return true;
        }
        return false;
    }

    private boolean validateSNR(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        if (value.compareTo("disable") == 0) {
            return true;
        }
        try {
            if (value.indexOf(".") >= 0) {
                return false;
            }
            int iValue = Integer.valueOf(value);
            if (iValue >= -10 && iValue <= 10) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }
}

