/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.dhcp;

import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressRange;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.MACAddress;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.dhcp.DHCPPoolCollection;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.util.CommonUtil;
import java.util.Vector;

public class DHCPPool
extends XDMObject
implements Cloneable {
    private String _name;
    private IPAddress _network;
    private Netmask _mask;
    private IPAddress _start;
    private IPAddress _end;
    private String _domain;
    private IPAddress _defaultRouter;
    private IPAddress _dnsServer1;
    private IPAddress _dnsServer2;
    private IPAddress _netbiosNameServer1;
    private IPAddress _netbiosNameServer2;
    private boolean _importFlag;
    private int _leaseDays;
    private int _leaseHours;
    private int _leaseMins;
    private boolean _leaseInfiniteFlag;
    private boolean _poolReadOnly = false;
    private boolean m_bHostPool = false;
    private IPAddress _host;
    private Netmask _bindingIPMask;
    private MACAddress _clientIdentifier;
    private MACAddress _hardwareAddress;
    private String _hardwareType;
    private String _clientName;
    public static final String TYPE_ETHERNET = "ethernet";
    public static final String TYPE_IEEE = "ieee802";

    public DHCPPool() {
    }

    public DHCPPool(String poolname) {
        this._name = poolname;
    }

    public DHCPPool(String poolname, XDMObject parent) {
        super(parent);
        this._name = poolname;
    }

    public Object clone() {
        DHCPPool newObj = (DHCPPool)super.clone();
        if (!this.isHostPool()) {
            if (this._network != null) {
                newObj._network = (IPAddress)this._network.clone();
            }
            if (this._mask != null) {
                newObj._mask = (Netmask)this._mask.clone();
            }
            if (this._defaultRouter != null) {
                newObj._defaultRouter = (IPAddress)this._defaultRouter.clone();
            }
            if (this._dnsServer1 != null) {
                newObj._dnsServer1 = (IPAddress)this._dnsServer1.clone();
            }
            if (this._dnsServer2 != null) {
                newObj._dnsServer2 = (IPAddress)this._dnsServer2.clone();
            }
            if (this._netbiosNameServer1 != null) {
                newObj._netbiosNameServer1 = (IPAddress)this._netbiosNameServer1.clone();
            }
            if (this._netbiosNameServer2 != null) {
                newObj._netbiosNameServer2 = (IPAddress)this._netbiosNameServer2.clone();
            }
        } else {
            if (this._host != null) {
                newObj._host = (IPAddress)this._host.clone();
            }
            if (this._bindingIPMask != null) {
                newObj._bindingIPMask = (Netmask)this._bindingIPMask.clone();
            }
            if (this._hardwareAddress != null) {
                newObj._hardwareAddress = (MACAddress)this._hardwareAddress.clone();
            }
            if (this._clientIdentifier != null) {
                newObj._clientIdentifier = (MACAddress)this._clientIdentifier.clone();
            }
        }
        return newObj;
    }

    public boolean equals(Object obj) {
        if (obj == null && !(obj instanceof DHCPPool)) {
            return false;
        }
        DHCPPool pool = (DHCPPool)obj;
        if (this._name.equals(pool._name)) {
            if (this.isHostPool()) {
                if (this._host == null) {
                    if (pool._host != null) {
                        return false;
                    }
                } else {
                    if (pool._host == null) {
                        return false;
                    }
                    if (!this._host.equals(pool._host)) {
                        return false;
                    }
                }
                if (this._bindingIPMask == null) {
                    if (pool._bindingIPMask != null) {
                        return false;
                    }
                } else {
                    if (pool._bindingIPMask == null) {
                        return false;
                    }
                    if (!this._bindingIPMask.equals(pool._bindingIPMask)) {
                        return false;
                    }
                }
                if (this._hardwareAddress == null) {
                    if (pool._hardwareAddress != null) {
                        return false;
                    }
                } else {
                    if (pool._hardwareAddress == null) {
                        return false;
                    }
                    if (!this._hardwareAddress.equals(pool._hardwareAddress)) {
                        return false;
                    }
                }
                if (this._clientIdentifier == null) {
                    if (pool._clientIdentifier != null) {
                        return false;
                    }
                } else {
                    if (pool._clientIdentifier == null) {
                        return false;
                    }
                    if (!this._clientIdentifier.equals(pool._clientIdentifier)) {
                        return false;
                    }
                }
                if (this._hardwareType == null) {
                    if (pool._hardwareType != null) {
                        return false;
                    }
                } else {
                    if (pool._hardwareType == null) {
                        return false;
                    }
                    if (!this._hardwareType.equals(pool._hardwareType)) {
                        return false;
                    }
                }
                if (this._clientName == null) {
                    if (pool._clientName != null) {
                        return false;
                    }
                } else {
                    if (pool._clientName == null) {
                        return false;
                    }
                    if (!this._clientName.equals(pool._clientName)) {
                        return false;
                    }
                }
                Log.getLog().debug("returning true");
                return true;
            }
            if (this._network == null) {
                if (pool._network != null) {
                    return false;
                }
            } else {
                if (pool._network == null) {
                    return false;
                }
                if (!this._network.equals(pool._network)) {
                    return false;
                }
            }
            if (this._mask == null) {
                if (pool._mask != null) {
                    return false;
                }
            } else {
                if (pool._mask == null) {
                    return false;
                }
                if (!this._mask.equals(pool._mask)) {
                    return false;
                }
            }
            if (this._domain == null) {
                if (pool._domain != null) {
                    return false;
                }
            } else {
                if (pool._domain == null) {
                    return false;
                }
                if (!this._domain.equals(pool._domain)) {
                    return false;
                }
            }
            if (this._defaultRouter == null) {
                if (pool._defaultRouter != null) {
                    return false;
                }
            } else {
                if (pool._defaultRouter == null) {
                    return false;
                }
                if (!this._defaultRouter.equals(pool._defaultRouter)) {
                    return false;
                }
            }
            if (this._dnsServer1 == null) {
                if (pool._dnsServer1 != null) {
                    return false;
                }
            } else {
                if (pool._dnsServer1 == null) {
                    return false;
                }
                if (!this._dnsServer1.equals(pool._dnsServer1)) {
                    return false;
                }
            }
            if (this._dnsServer2 == null) {
                if (pool._dnsServer2 != null) {
                    return false;
                }
            } else {
                if (pool._dnsServer2 == null) {
                    return false;
                }
                if (!this._dnsServer2.equals(pool._dnsServer2)) {
                    return false;
                }
            }
            if (this._netbiosNameServer1 == null) {
                if (pool._netbiosNameServer1 != null) {
                    return false;
                }
            } else {
                if (pool._netbiosNameServer1 == null) {
                    return false;
                }
                if (!this._netbiosNameServer1.equals(pool._netbiosNameServer1)) {
                    return false;
                }
            }
            if (this._netbiosNameServer2 == null) {
                if (pool._netbiosNameServer2 != null) {
                    return false;
                }
            } else {
                if (pool._netbiosNameServer2 == null) {
                    return false;
                }
                if (!this._netbiosNameServer2.equals(pool._netbiosNameServer2)) {
                    return false;
                }
            }
            if (this._importFlag != pool._importFlag) {
                return false;
            }
            if (this._leaseInfiniteFlag != pool._leaseInfiniteFlag) {
                return false;
            }
            if (this._leaseDays != pool._leaseDays) {
                return false;
            }
            if (this._leaseMins != pool._leaseMins) {
                return false;
            }
            if (this._leaseHours != pool._leaseHours) {
                return false;
            }
            Log.getLog().debug("returning true");
            return true;
        }
        return false;
    }

    private String formatClientIdentifier(String cid, String type, boolean reverse) {
        if (reverse) {
            if (type == TYPE_ETHERNET) {
                type = "01";
            } else if (type == TYPE_IEEE) {
                type = "06";
            }
            cid = String.valueOf(type) + cid;
            cid = this.stripDots(cid);
            cid = this.placeDots(cid);
        } else {
            cid = this.stripDots(cid);
            if ((cid = this.placeDots(cid)).startsWith(".")) {
                cid = cid.substring(1);
            }
            if (cid.endsWith(".")) {
                cid = cid.substring(0, cid.length() - 1);
            }
        }
        return cid;
    }

    private void generateAddCommand(ConfigValues cfgval) {
        CmdValues cmdval = this.generateDHCPCmd(1);
        ConfigValues subcfgval = new ConfigValues();
        if (this.isHostPool()) {
            if (this._host != null) {
                CmdValues hostCmdValue = this.generateHostCmd(1, null);
                subcfgval.addCmdValues(hostCmdValue);
            }
            if (this._hardwareAddress != null) {
                CmdValues hwaddressCmdValue = this.generateHWAddressCmd(1, null);
                subcfgval.addCmdValues(hwaddressCmdValue);
            } else if (this._clientIdentifier != null) {
                CmdValues clientIdCmdValue = this.generateClientIdCmd(1, null);
                subcfgval.addCmdValues(clientIdCmdValue);
            }
            if (this._clientName != null && this._clientName.length() > 0) {
                CmdValues clientnmCmdValue = this.generateClientNmCmd(1, null);
                subcfgval.addCmdValues(clientnmCmdValue);
            }
        } else {
            CmdValues leaseCmdValue;
            CmdValues subcmdval;
            if (this._network != null) {
                CmdValues networkCmdValue = this.generateNetworkCmd(1, null);
                subcfgval.addCmdValues(networkCmdValue);
            }
            if (this._domain != null && this._domain.length() > 0) {
                subcmdval = this.generateDomainCmd(1, null);
                subcfgval.addCmdValues(subcmdval);
            }
            if (this._dnsServer1 != null) {
                subcmdval = this.generateDnsCmd(1, null, null);
                subcfgval.addCmdValues(subcmdval);
            }
            if (this._defaultRouter != null) {
                subcmdval = this.generateDefRtrCmd(1, null);
                subcfgval.addCmdValues(subcmdval);
            }
            if (this._netbiosNameServer1 != null) {
                subcmdval = this.generateNetBiosCmd(1, null, null);
                subcfgval.addCmdValues(subcmdval);
            }
            if (this._importFlag) {
                subcmdval = new CmdValues("import");
                subcmdval.addValue("all", "all");
                subcmdval.setAction(1);
                subcfgval.addCmdValues(subcmdval);
            }
            if ((leaseCmdValue = this.generateLeaseCmd(1, null)) != null) {
                subcfgval.addCmdValues(leaseCmdValue);
            }
        }
        if (subcfgval.numCmds() > 0) {
            cmdval.setModeCmdsValues(subcfgval);
        }
        cfgval.addCmdValues(cmdval);
    }

    private CmdValues generateClientIdCmd(int action, DHCPPool backupObj) {
        CmdValues subcmdval = new CmdValues("client-identifier");
        String cid = "";
        switch (action) {
            case 1: {
                cid = this.formatClientIdentifier(this._clientIdentifier.toString(), this._hardwareType, true);
                subcmdval.addValue("clientidname", cid);
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 3: {
                if (this._clientIdentifier.toString().equals(backupObj._clientIdentifier.toString()) && this._hardwareType.equals(backupObj._hardwareType)) break;
                cid = this.formatClientIdentifier(this._clientIdentifier.toString(), this._hardwareType, true);
                subcmdval.addValue("clientidname", cid);
                cid = this.formatClientIdentifier(backupObj._clientIdentifier.toString(), backupObj._hardwareType, true);
                subcmdval.addOldValue("clientidname", cid);
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 2: {
                cid = this.formatClientIdentifier(backupObj._clientIdentifier.toString(), backupObj._hardwareType, true);
                subcmdval.addValue("clientidname", backupObj._clientIdentifier.toString());
                subcmdval.setAction(action);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private CmdValues generateClientNmCmd(int action, DHCPPool backupObj) {
        CmdValues subcmdval = new CmdValues("client-name");
        switch (action) {
            case 1: {
                subcmdval.addValue("clientname", this._clientName);
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 3: {
                if (this._clientName.equals(backupObj._clientName)) break;
                subcmdval.addValue("clientname", this._clientName);
                subcmdval.addOldValue("clientname", backupObj._clientName);
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("clientname", backupObj._clientName);
                subcmdval.setAction(action);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private CmdValues generateDHCPCmd(int action) {
        CmdValues cmdval = new CmdValues("ip");
        cmdval.addValue("dhcp", "dhcp");
        cmdval.addValue("pool", "pool");
        cmdval.addValue("poolName", this._name);
        switch (action) {
            case 1: {
                cmdval.setAction(1);
                return cmdval;
            }
            case 2: {
                cmdval.setAction(2);
                return cmdval;
            }
        }
        return null;
    }

    private CmdValues generateDefRtrCmd(int action, IPAddress backupDefRtr) {
        CmdValues subcmdval = new CmdValues("default-router");
        switch (action) {
            case 1: {
                subcmdval.addValue("defaultRouter1", this._defaultRouter.toString());
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 3: {
                if (this._defaultRouter.equals(backupDefRtr)) break;
                subcmdval.addValue("defaultRouter1", this._defaultRouter.toString());
                subcmdval.addOldValue("defaultRouter1", backupDefRtr.toString());
                subcmdval.setAction(3);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("defaultRouter1", backupDefRtr.toString());
                subcmdval.setAction(2);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public void generateDelta(XDMObject backup, ConfigValues cfgval) {
        if (this.isBackup()) {
            CmdValues cmdval = this.generateDHCPCmd(2);
            cfgval.addCmdValues(cmdval);
        } else if (backup == null) {
            Log.getLog().debug("Generating NEW command");
            this.generateAddCommand(cfgval);
        } else {
            Log.getLog().debug("Generating MODIFY command");
            this.generateModifyCommands(backup, cfgval);
        }
    }

    private CmdValues generateDnsCmd(int action, IPAddress backupDns1, IPAddress backupDns2) {
        CmdValues subcmdval = new CmdValues("dns-server");
        switch (action) {
            case 1: {
                subcmdval.addValue("dnsServer1", this._dnsServer1.toString());
                if (this._dnsServer2 != null) {
                    subcmdval.addValue("dnsServer2", this._dnsServer2.toString());
                }
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 3: {
                if (this._dnsServer1.equals(backupDns1)) {
                    if (this._dnsServer2 != null) {
                        if (this._dnsServer2.equals(backupDns2)) break;
                        subcmdval.addValue("dnsServer1", this._dnsServer1.toString());
                        subcmdval.addValue("dnsServer2", this._dnsServer2.toString());
                        subcmdval.setAction(1);
                        return subcmdval;
                    }
                    if (backupDns2 == null) break;
                    subcmdval.addValue("dnsServer1", this._dnsServer1.toString());
                    subcmdval.setAction(1);
                    return subcmdval;
                }
                subcmdval.addValue("dnsServer1", this._dnsServer1.toString());
                if (this._dnsServer2 != null) {
                    subcmdval.addValue("dnsServer2", this._dnsServer2.toString());
                }
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("dnsServer1", backupDns1.toString());
                if (backupDns2 != null) {
                    subcmdval.addValue("dnsServer2", backupDns2.toString());
                }
                subcmdval.setAction(2);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private CmdValues generateDomainCmd(int action, String backup) {
        CmdValues subcmdval = new CmdValues("domain-name");
        switch (action) {
            case 1: {
                subcmdval.addValue("domainName", this._domain);
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 3: {
                if (this._domain.equals(backup)) break;
                subcmdval.addValue("domainName", this._domain);
                subcmdval.addOldValue("domainName", backup);
                subcmdval.setAction(3);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("domainName", backup);
                subcmdval.setAction(2);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Vector generateExcludedAddresses(DeviceBase dev, IfIPAddress intfIPAddr) {
        if (intfIPAddr == null) {
            return null;
        }
        Log.getLog().debug("In DHCPPool: generateExcludedAddresses: Received intf address is : " + intfIPAddr);
        Vector<IPAddressRange> retValue = new Vector<IPAddressRange>(3);
        IPAddress intfIp = intfIPAddr.getIPAddress();
        Netmask intfmask = intfIPAddr.getNetmask();
        DHCPPoolCollection coll = dev.getDhcp();
        Vector removeExcluded = coll.getMatchedVector(intfIp.getSubnet(intfmask), intfmask);
        boolean res = coll.removeExcludedAddress(removeExcluded);
        IPAddress startHostAddress = intfIp.getBeginningHostAddress(intfmask);
        IPAddress endHostAddress = intfIp.getFinalHostAddress(intfmask);
        if (this._start.greaterThan(startHostAddress)) {
            IPAddressRange range1 = new IPAddressRange(startHostAddress);
            IPAddress tmpEndAddr = new IPAddress(this._start.getIntValue() - 1);
            if (!startHostAddress.equals(tmpEndAddr)) {
                range1.setHighIPAddress(tmpEndAddr);
            }
            Log.getLog().debug("DHCPPool: generateExcludedAddresses(): 1. Adding range to the vector: " + range1.toString());
            retValue.addElement(range1);
        }
        if (this._end.lessThan(endHostAddress)) {
            IPAddressRange range2 = new IPAddressRange(new IPAddress(this._end.getIntValue() + 1));
            IPAddress tmpStartAddr = new IPAddress(this._end.getIntValue() + 1);
            if (!tmpStartAddr.equals(endHostAddress)) {
                range2.setHighIPAddress(endHostAddress);
            }
            Log.getLog().debug("DHCPPool: generateExcludedAddresses(): 2. Adding range to the vector: " + range2.toString());
            retValue.addElement(range2);
        }
        if (intfIp.greaterThanOrEqual(this._start) && intfIp.lessThanOrEqual(this._end)) {
            IPAddressRange range3 = new IPAddressRange(intfIp);
            Log.getLog().debug("DHCPPool: generateExcludedAddresses(): 3. Adding range to the vector: " + range3.toString());
            retValue.addElement(range3);
        }
        this._network = new IPAddress(intfIp, intfmask);
        this._mask = new Netmask(intfmask);
        return retValue;
    }

    private CmdValues generateHWAddressCmd(int action, DHCPPool backupObj) {
        CmdValues subcmdval = new CmdValues("hardware-address");
        switch (action) {
            case 1: {
                subcmdval.addValue("hwaddress", this._hardwareAddress.toString());
                if (this._hardwareType != null) {
                    subcmdval.addValue("hwtype", this._hardwareType);
                } else {
                    subcmdval.addValue("hwtype", TYPE_ETHERNET);
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 3: {
                if (this._hardwareAddress.toString().equals(backupObj._hardwareAddress.toString()) && this._hardwareType.equals(backupObj._hardwareType)) break;
                subcmdval.addValue("hwaddress", this._hardwareAddress.toString());
                subcmdval.addOldValue("hwaddress", backupObj._hardwareAddress.toString());
                if (this._hardwareType != null) {
                    subcmdval.addValue("hwtype", this._hardwareType);
                }
                if (backupObj._hardwareType != null) {
                    subcmdval.addOldValue("hwtype", backupObj._hardwareType);
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("hwaddress", backupObj._hardwareAddress.toString());
                if (backupObj._hardwareType != null) {
                    subcmdval.addValue("hwtype", backupObj._hardwareType);
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private CmdValues generateHostCmd(int action, DHCPPool backupObj) {
        CmdValues subcmdval = new CmdValues("host");
        switch (action) {
            case 1: {
                subcmdval.addValue("hostaddress", this._host.toString());
                if (this._bindingIPMask != null) {
                    subcmdval.addValue("subnetMask", this._bindingIPMask.toString());
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 3: {
                if (this._host.equals(backupObj._host) && this._bindingIPMask.equals(backupObj._bindingIPMask)) break;
                subcmdval.addValue("hostaddress", this._host.toString());
                subcmdval.addOldValue("hostaddress", backupObj._host.toString());
                if (this._bindingIPMask != null) {
                    subcmdval.addValue("subnetMask", this._bindingIPMask.toString());
                }
                if (backupObj._bindingIPMask != null) {
                    subcmdval.addOldValue("subnetMask", backupObj._bindingIPMask.toString());
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("hostaddress", backupObj._host.toString());
                if (backupObj._bindingIPMask != null) {
                    subcmdval.addValue("subnetMask", backupObj._bindingIPMask.toString());
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private CmdValues generateLeaseCmd(int action, DHCPPool backup) {
        switch (action) {
            case 1: {
                CmdValues subcmdval;
                if (this._leaseInfiniteFlag) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("infinite", "infinite");
                } else if (this._leaseMins != 0) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("days", String.valueOf(this._leaseDays));
                    subcmdval.addValue("hours", String.valueOf(this._leaseHours));
                    subcmdval.addValue("mins", String.valueOf(this._leaseMins));
                } else if (this._leaseHours != 0) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("days", String.valueOf(this._leaseDays));
                    subcmdval.addValue("hours", String.valueOf(this._leaseHours));
                } else if (this._leaseDays != 0) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("days", String.valueOf(this._leaseDays));
                } else {
                    return null;
                }
                if (subcmdval == null) break;
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 3: {
                CmdValues subcmdval;
                boolean bf = backup._leaseInfiniteFlag;
                int bd = backup._leaseDays;
                int bh = backup._leaseHours;
                int bm = backup._leaseMins;
                if (this._leaseInfiniteFlag == bf && this._leaseDays == bd && this._leaseHours == bh && this._leaseMins == bm) break;
                if (this._leaseInfiniteFlag) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("infinite", "infinite");
                } else if (this._leaseMins != 0) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("days", String.valueOf(this._leaseDays));
                    subcmdval.addValue("hours", String.valueOf(this._leaseHours));
                    subcmdval.addValue("mins", String.valueOf(this._leaseMins));
                } else if (this._leaseHours != 0) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("days", String.valueOf(this._leaseDays));
                    subcmdval.addValue("hours", String.valueOf(this._leaseHours));
                } else if (this._leaseDays != 0) {
                    subcmdval = new CmdValues("lease");
                    subcmdval.addValue("days", String.valueOf(this._leaseDays));
                } else {
                    return null;
                }
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 2: {
                CmdValues subcmdval = new CmdValues("lease");
                subcmdval.setAction(2);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private void generateModifyCommands(XDMObject backup, ConfigValues cfgval) {
        DHCPPool backupObj = (DHCPPool)backup;
        ConfigValues subcfgval = new ConfigValues();
        if (this.isHostPool()) {
            CmdValues hostCmdValue;
            if (this._host != null) {
                if (backupObj._host != null) {
                    hostCmdValue = this.generateHostCmd(3, backupObj);
                    if (hostCmdValue != null) {
                        subcfgval.addCmdValues(hostCmdValue);
                    }
                } else {
                    hostCmdValue = this.generateHostCmd(1, null);
                    subcfgval.addCmdValues(hostCmdValue);
                }
            } else if (backupObj._host != null) {
                hostCmdValue = this.generateHostCmd(2, backupObj);
                subcfgval.addCmdValues(hostCmdValue);
            }
            if (this._hardwareAddress != null) {
                CmdValues hwclientCmdValue;
                if (backupObj._clientIdentifier != null) {
                    hwclientCmdValue = this.generateClientIdCmd(2, backupObj);
                    subcfgval.addCmdValues(hwclientCmdValue);
                }
                if (backupObj._hardwareAddress != null) {
                    hwclientCmdValue = this.generateHWAddressCmd(3, backupObj);
                    if (hwclientCmdValue != null) {
                        subcfgval.addCmdValues(hwclientCmdValue);
                    }
                } else {
                    hwclientCmdValue = this.generateHWAddressCmd(1, null);
                    subcfgval.addCmdValues(hwclientCmdValue);
                }
            } else if (this._clientIdentifier != null) {
                CmdValues hwclientCmdValue;
                if (backupObj._hardwareAddress != null) {
                    hwclientCmdValue = this.generateHWAddressCmd(2, backupObj);
                    subcfgval.addCmdValues(hwclientCmdValue);
                }
                if (backupObj._clientIdentifier != null) {
                    hwclientCmdValue = this.generateClientIdCmd(3, backupObj);
                    if (hwclientCmdValue != null) {
                        subcfgval.addCmdValues(hwclientCmdValue);
                    }
                } else {
                    hwclientCmdValue = this.generateClientIdCmd(1, null);
                    subcfgval.addCmdValues(hwclientCmdValue);
                }
            }
            if (this._clientName != null && this._clientName.length() > 0) {
                if (backupObj._clientName != null && backupObj._clientName.length() > 0) {
                    CmdValues clientNmCmdValue = this.generateClientNmCmd(3, backupObj);
                    if (clientNmCmdValue != null) {
                        subcfgval.addCmdValues(clientNmCmdValue);
                    }
                } else {
                    CmdValues clientNmCmdValue = this.generateClientNmCmd(1, null);
                    subcfgval.addCmdValues(clientNmCmdValue);
                }
            } else if (backupObj._clientName != null && backupObj._clientName.length() > 0) {
                CmdValues clientNmCmdValue = this.generateClientNmCmd(2, backupObj);
                subcfgval.addCmdValues(clientNmCmdValue);
            }
        } else {
            CmdValues networkCmdValue;
            if (this._network != null) {
                if (backupObj._network != null) {
                    networkCmdValue = this.generateNetworkCmd(3, backupObj);
                    if (networkCmdValue != null) {
                        subcfgval.addCmdValues(networkCmdValue);
                    }
                } else {
                    networkCmdValue = this.generateNetworkCmd(1, null);
                    subcfgval.addCmdValues(networkCmdValue);
                }
            } else if (backupObj._network != null) {
                networkCmdValue = this.generateNetworkCmd(2, backupObj);
                subcfgval.addCmdValues(networkCmdValue);
            }
            if (this._domain != null && this._domain.length() > 0) {
                if (backupObj._domain != null && backupObj._domain.length() > 0) {
                    CmdValues domainCmdValue = this.generateDomainCmd(3, backupObj._domain);
                    if (domainCmdValue != null) {
                        subcfgval.addCmdValues(domainCmdValue);
                    }
                } else {
                    CmdValues domainCmdValue = this.generateDomainCmd(1, null);
                    subcfgval.addCmdValues(domainCmdValue);
                }
            } else if (backupObj._domain != null && backupObj._domain.length() > 0) {
                CmdValues domainCmdValue = this.generateDomainCmd(2, backupObj._domain);
                subcfgval.addCmdValues(domainCmdValue);
            }
            if (this._dnsServer1 != null) {
                if (backupObj._dnsServer1 != null) {
                    CmdValues dnsCmdValue = this.generateDnsCmd(3, backupObj._dnsServer1, backupObj._dnsServer2);
                    if (dnsCmdValue != null) {
                        subcfgval.addCmdValues(dnsCmdValue);
                    }
                } else {
                    CmdValues dnsCmdValue = this.generateDnsCmd(1, null, null);
                    subcfgval.addCmdValues(dnsCmdValue);
                }
            } else if (backupObj._dnsServer1 != null) {
                CmdValues dnsCmdValue = this.generateDnsCmd(2, backupObj._dnsServer1, backupObj._dnsServer2);
                subcfgval.addCmdValues(dnsCmdValue);
            }
            if (this._defaultRouter != null) {
                if (backupObj._defaultRouter != null) {
                    CmdValues defRtrCmdValue = this.generateDefRtrCmd(3, backupObj._defaultRouter);
                    if (defRtrCmdValue != null) {
                        subcfgval.addCmdValues(defRtrCmdValue);
                    }
                } else {
                    CmdValues defRtrCmdValue = this.generateDefRtrCmd(1, null);
                    subcfgval.addCmdValues(defRtrCmdValue);
                }
            } else if (backupObj._defaultRouter != null) {
                CmdValues defRtrCmdValue = this.generateDefRtrCmd(2, backupObj._defaultRouter);
                subcfgval.addCmdValues(defRtrCmdValue);
            }
            if (this._netbiosNameServer1 != null) {
                if (backupObj._netbiosNameServer1 != null) {
                    CmdValues netbiosCmdValue = this.generateNetBiosCmd(3, backupObj._netbiosNameServer1, backupObj._netbiosNameServer2);
                    if (netbiosCmdValue != null) {
                        subcfgval.addCmdValues(netbiosCmdValue);
                    }
                } else {
                    CmdValues netbiosCmdValue = this.generateNetBiosCmd(1, null, null);
                    subcfgval.addCmdValues(netbiosCmdValue);
                }
            } else if (backupObj._netbiosNameServer1 != null) {
                CmdValues netbiosCmdValue = this.generateNetBiosCmd(2, backupObj._netbiosNameServer1, backupObj._netbiosNameServer2);
                subcfgval.addCmdValues(netbiosCmdValue);
            }
            CmdValues importCmdValue = new CmdValues("import");
            importCmdValue.addValue("all", "all");
            if (this._importFlag) {
                if (!backupObj._importFlag) {
                    importCmdValue.setAction(1);
                    subcfgval.addCmdValues(importCmdValue);
                }
            } else if (backupObj._importFlag) {
                importCmdValue.setAction(2);
                subcfgval.addCmdValues(importCmdValue);
            }
            if (this._leaseInfiniteFlag || this._leaseDays != 0 || this._leaseHours != 0 || this._leaseMins != 0) {
                if (backupObj._leaseInfiniteFlag || backupObj._leaseDays != 0 || backupObj._leaseHours != 0 || backupObj._leaseMins != 0) {
                    CmdValues leaseCmdValue = this.generateLeaseCmd(3, backupObj);
                    if (leaseCmdValue != null) {
                        subcfgval.addCmdValues(leaseCmdValue);
                    }
                } else {
                    CmdValues leaseCmdValue = this.generateLeaseCmd(1, null);
                    subcfgval.addCmdValues(leaseCmdValue);
                }
            } else if (backupObj._leaseInfiniteFlag || backupObj._leaseDays != 0 || backupObj._leaseHours != 0 || backupObj._leaseMins != 0) {
                CmdValues leaseCmdValue = this.generateLeaseCmd(2, backupObj);
                subcfgval.addCmdValues(leaseCmdValue);
            }
        }
        if (subcfgval.numCmds() > 0) {
            CmdValues cmdval = this.generateDHCPCmd(1);
            cmdval.setModeCmdsValues(subcfgval);
            cfgval.addCmdValues(cmdval);
        }
    }

    private CmdValues generateNetBiosCmd(int action, IPAddress backupNetBios1, IPAddress backupNetBios2) {
        CmdValues subcmdval = new CmdValues("netbios-name-server");
        switch (action) {
            case 1: {
                subcmdval.addValue("netbiosServer1", this._netbiosNameServer1.toString());
                if (this._netbiosNameServer2 != null) {
                    subcmdval.addValue("netbiosServer2", this._netbiosNameServer2.toString());
                }
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 3: {
                if (this._netbiosNameServer1.equals(backupNetBios1)) {
                    if (this._netbiosNameServer2 != null) {
                        if (this._netbiosNameServer2.equals(backupNetBios2)) break;
                        subcmdval.addValue("netbiosServer1", this._netbiosNameServer1.toString());
                        subcmdval.addValue("netbiosServer2", this._netbiosNameServer2.toString());
                        subcmdval.setAction(1);
                        return subcmdval;
                    }
                    if (backupNetBios2 == null) break;
                    subcmdval.addValue("netbiosServer1", this._netbiosNameServer1.toString());
                    subcmdval.setAction(1);
                    return subcmdval;
                }
                subcmdval.addValue("netbiosServer1", this._netbiosNameServer1.toString());
                if (this._netbiosNameServer2 != null) {
                    subcmdval.addValue("netbiosServer2", this._netbiosNameServer2.toString());
                }
                subcmdval.setAction(1);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("netbiosServer1", backupNetBios1.toString());
                if (backupNetBios2 != null) {
                    subcmdval.addValue("netbiosServer2", backupNetBios2.toString());
                }
                subcmdval.setAction(2);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private CmdValues generateNetworkCmd(int action, DHCPPool backupObj) {
        CmdValues subcmdval = new CmdValues("network");
        switch (action) {
            case 1: {
                subcmdval.addValue("networkNo", this._network.toString());
                if (this._mask != null) {
                    subcmdval.addValue("subnetMask", this._mask.toString());
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 3: {
                if (this._network.equals(backupObj._network) && this._mask.equals(backupObj._mask)) break;
                subcmdval.addValue("networkNo", this._network.toString());
                subcmdval.addOldValue("networkNo", backupObj._network.toString());
                if (this._mask != null) {
                    subcmdval.addValue("subnetMask", this._mask.toString());
                }
                if (backupObj._mask != null) {
                    subcmdval.addOldValue("subnetMask", backupObj._mask.toString());
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("networkNo", backupObj._network.toString());
                if (backupObj._mask != null) {
                    subcmdval.addValue("subnetMask", backupObj._mask.toString());
                }
                subcmdval.setAction(action);
                return subcmdval;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Netmask getBindingMask() {
        return this._bindingIPMask;
    }

    public MACAddress getClientIdentifier() {
        return this._clientIdentifier;
    }

    public String getClientName() {
        return this._clientName;
    }

    public static int getDefaultLeaseDays(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "days", true);
        return Integer.parseInt(param.getDefaultValue());
    }

    public static int getDefaultLeaseHours(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "hours", true);
        return Integer.parseInt(param.getDefaultValue());
    }

    public static int getDefaultLeaseMinutes(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "mins", true);
        return Integer.parseInt(param.getDefaultValue());
    }

    public IPAddress getDefaultRouter() {
        return this._defaultRouter;
    }

    public IPAddress getDnsServer1() {
        return this._dnsServer1;
    }

    public IPAddress getDnsServer2() {
        return this._dnsServer2;
    }

    public String getDomain() {
        return this._domain;
    }

    public IPAddress getEndAddress() {
        return this._end;
    }

    public MACAddress getHardwareAddress() {
        return this._hardwareAddress;
    }

    public String getHardwareType() {
        return this._hardwareType;
    }

    public IPAddress getHostIP() {
        return this._host;
    }

    public boolean getImportFlag() {
        return this._importFlag;
    }

    public int getLeaseDays() {
        return this._leaseDays;
    }

    public int getLeaseHours() {
        return this._leaseHours;
    }

    public boolean getLeaseInfiniteFlag() {
        return this._leaseInfiniteFlag;
    }

    public int getLeaseMinutes() {
        return this._leaseMins;
    }

    public Netmask getMask() {
        return this._mask;
    }

    public static long getMaxLeaseDays(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "days", true);
        return param.getMaxRange();
    }

    public static long getMaxLeaseHours(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "hours", true);
        return param.getMaxRange();
    }

    public static long getMaxLeaseMinutes(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "mins", true);
        return param.getMaxRange();
    }

    public static long getMinLeaseDays(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "days", true);
        return param.getMinRange();
    }

    public static long getMinLeaseHours(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "hours", true);
        return param.getMinRange();
    }

    public static long getMinLeaseMinutes(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "mins", true);
        return param.getMinRange();
    }

    public String getName() {
        return this._name;
    }

    public IPAddress getNetbiosServer1() {
        return this._netbiosNameServer1;
    }

    public IPAddress getNetbiosServer2() {
        return this._netbiosNameServer2;
    }

    public IPAddress getNetwork() {
        return this._network;
    }

    public IPAddress getStartAddress() {
        return this._start;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isHostPool() {
        return this.m_bHostPool;
    }

    public boolean isPoolReadOnly() {
        return this._poolReadOnly;
    }

    public void makeReadOnly(boolean flag) {
        this._poolReadOnly = flag;
    }

    private String placeDots(String str) {
        if (CommonUtil.isEmpty((String)str)) {
            return str;
        }
        StringBuffer res = new StringBuffer(str);
        int idx = 4;
        int i = 1;
        while (i <= str.length() / 4) {
            res.insert(idx++, '.');
            idx += 4;
            ++i;
        }
        return res.toString();
    }

    public void populate(ConfigValues configValues, CmdValues cmdVals) {
        if (configValues != null) {
            int numberOfCmds = configValues.numCmds();
            this.setHostPool(false);
            int i = 0;
            while (i < numberOfCmds) {
                CmdValues eachCmdValue = configValues.getCmdValues(i);
                String cmdName = eachCmdValue.getCmdName();
                if (cmdName.equals("network") && eachCmdValue.containsKey("networkNo") && eachCmdValue.containsKey("subnetMask")) {
                    this.setHostPool(false);
                    String networkaddr = eachCmdValue.getValue("networkNo");
                    String subnetaddr = eachCmdValue.getValue("subnetMask");
                    this._network = new IPAddress(networkaddr);
                    this._mask = new Netmask(subnetaddr);
                }
                if (cmdName.equals("host") && eachCmdValue.containsKey("hostaddress") && eachCmdValue.containsKey("subnetMask")) {
                    this.setHostPool(true);
                    String host = eachCmdValue.getValue("hostaddress");
                    String mask = eachCmdValue.getValue("subnetMask");
                    this._host = new IPAddress(host);
                    this._bindingIPMask = new Netmask(mask);
                }
                if (cmdName.equals("hardware-address") && eachCmdValue.containsKey("hwaddress")) {
                    this.setHostPool(true);
                    String hwaddress = eachCmdValue.getValue("hwaddress");
                    this._hardwareAddress = new MACAddress(hwaddress);
                    String hwtype = TYPE_ETHERNET;
                    if (eachCmdValue.containsKey("hwtype")) {
                        String type = eachCmdValue.getValue("hwtype");
                        if (type.trim().equalsIgnoreCase(TYPE_ETHERNET) || type.trim().equalsIgnoreCase("1")) {
                            hwtype = TYPE_ETHERNET;
                        } else if (type.trim().equalsIgnoreCase(TYPE_IEEE) || type.trim().equalsIgnoreCase("6")) {
                            hwtype = TYPE_IEEE;
                        } else {
                            this.makeReadOnly(true);
                            hwtype = type;
                        }
                    }
                    this._hardwareType = hwtype;
                }
                if (cmdName.equals("client-identifier") && eachCmdValue.containsKey("clientidname")) {
                    this.setHostPool(true);
                    String clientnm = eachCmdValue.getValue("clientidname");
                    if (clientnm.length() != 17 || clientnm.indexOf("..") != -1) {
                        this.makeReadOnly(true);
                    } else if (clientnm.startsWith("01")) {
                        this._hardwareType = TYPE_ETHERNET;
                        clientnm = this.formatClientIdentifier(clientnm.substring(2), null, false);
                        this._clientIdentifier = new MACAddress(clientnm);
                    } else if (clientnm.startsWith("06")) {
                        this._hardwareType = TYPE_IEEE;
                        clientnm = this.formatClientIdentifier(clientnm.substring(2), null, false);
                        this._clientIdentifier = new MACAddress(clientnm);
                    } else {
                        this.makeReadOnly(true);
                    }
                }
                if (cmdName.equals("client-name") && eachCmdValue.containsKey("clientname")) {
                    this.setHostPool(true);
                    String cname = eachCmdValue.getValue("clientname");
                    if (cname != null && cname.length() > 0) {
                        this._clientName = cname;
                    }
                }
                if (cmdName.equals("domain-name") && eachCmdValue.containsKey("domainName")) {
                    this._domain = eachCmdValue.getValue("domainName");
                }
                if (cmdName.equals("dns-server") && eachCmdValue.containsKey("dnsServer1")) {
                    String dns1 = eachCmdValue.getValue("dnsServer1");
                    this._dnsServer1 = new IPAddress(dns1);
                    if (eachCmdValue.containsKey("dnsServer2")) {
                        String dns2 = eachCmdValue.getValue("dnsServer2");
                        this._dnsServer2 = new IPAddress(dns2);
                    }
                    if (eachCmdValue.containsKey("dnsServer")) {
                        this.makeReadOnly(true);
                    }
                }
                if (cmdName.equals("default-router") && eachCmdValue.containsKey("defaultRouter1")) {
                    String drouter = eachCmdValue.getValue("defaultRouter1");
                    this._defaultRouter = new IPAddress(drouter);
                }
                if (cmdName.equals("netbios-name-server") && eachCmdValue.containsKey("netbiosServer1")) {
                    String netbios1 = eachCmdValue.getValue("netbiosServer1");
                    this._netbiosNameServer1 = new IPAddress(netbios1);
                    if (eachCmdValue.containsKey("netbiosServer2")) {
                        String netbios2 = eachCmdValue.getValue("netbiosServer2");
                        this._netbiosNameServer2 = new IPAddress(netbios2);
                    }
                    if (eachCmdValue.containsKey("netbiosServer")) {
                        this.makeReadOnly(true);
                    }
                }
                if (cmdName.equals("import") && eachCmdValue.containsKey("all")) {
                    this._importFlag = true;
                }
                if (cmdName.equals("lease")) {
                    if (eachCmdValue.containsKey("infinite")) {
                        this._leaseInfiniteFlag = true;
                    } else {
                        if (eachCmdValue.containsKey("days")) {
                            String days = eachCmdValue.getValue("days");
                            this._leaseDays = Integer.parseInt(days);
                        }
                        if (eachCmdValue.containsKey("hours")) {
                            String hours = eachCmdValue.getValue("hours");
                            this._leaseHours = Integer.parseInt(hours);
                        }
                        if (eachCmdValue.containsKey("mins")) {
                            String mins = eachCmdValue.getValue("mins");
                            this._leaseMins = Integer.parseInt(mins);
                        }
                    }
                }
                if (cmdName.equals("accounting") || cmdName.equals("bootfile") || cmdName.equals("class") || cmdName.equals("next-server") || cmdName.equals("option") || cmdName.equals("origin") || cmdName.equals("update") || cmdName.equals("utilization") || cmdName.equals("vrf") || cmdName.equals("subnet") || cmdName.equals("netbios-node-type")) {
                    this.makeReadOnly(true);
                }
                ++i;
            }
            if (this._leaseDays == 0 && this._leaseHours == 0 && this._leaseMins == 0 && !this._leaseInfiniteFlag) {
                this._leaseDays = DHCPPool.getDefaultLeaseDays((DeviceBase)this.getDevice());
            }
        }
        if (this.isHostPool()) {
            if (this.getHostIP() == null) {
                this.makeReadOnly(true);
            }
            if (this.getHardwareAddress() == null && this.getClientIdentifier() == null) {
                this.makeReadOnly(true);
            }
        }
    }

    public void print() {
        Log.getLog().debug("DHCP Pool: Name = " + this._name);
        if (this._network != null) {
            Log.getLog().debug("DHCP Pool: Network = " + this._network);
        }
        if (this._mask != null) {
            Log.getLog().debug("DHCP Pool: Mask = " + this._mask);
        }
        if (this._domain != null) {
            Log.getLog().debug("DHCP Pool: Domain = " + this._domain);
        }
        if (this._defaultRouter != null) {
            Log.getLog().debug("DHCP Pool: Default Router = " + this._defaultRouter);
        }
        if (this._dnsServer1 != null) {
            Log.getLog().debug("DHCP Pool: DNS Server1 = " + this._dnsServer1);
        }
        if (this._dnsServer2 != null) {
            Log.getLog().debug("DHCP Pool: DNS Server2 = " + this._dnsServer2);
        }
        if (this._netbiosNameServer1 != null) {
            Log.getLog().debug("DHCP Pool: Netbios Name Server1 = " + this._netbiosNameServer1);
        }
        if (this._netbiosNameServer2 != null) {
            Log.getLog().debug("DHCP Pool: Netbios Name Server2 = " + this._netbiosNameServer2);
        }
        Log.getLog().debug("DHCP Pool: Import All Flag = " + this._importFlag);
        Log.getLog().debug("DHCP Pool: Lease = " + this._leaseDays + " Days " + this._leaseHours + " Hours " + this._leaseMins + "Mins");
    }

    public void setBindingMask(Netmask mask) {
        this._bindingIPMask = mask;
        this.setModified();
    }

    public void setClientIdentifier(MACAddress clientid) {
        this._clientIdentifier = clientid;
        this.setModified();
    }

    public void setClientName(String clientnm) {
        this._clientName = clientnm;
        this.setModified();
    }

    public void setDefaultRouter(IPAddress defaultRouter) {
        this._defaultRouter = defaultRouter;
        this.setModified();
    }

    public void setDnsServer1(IPAddress dnsserver) {
        this._dnsServer1 = dnsserver;
        this.setModified();
    }

    public void setDnsServer2(IPAddress dnsserver) {
        this._dnsServer2 = dnsserver;
        this.setModified();
    }

    public void setDomain(String domain) {
        this._domain = domain;
        this.setModified();
    }

    public void setEndAddress(IPAddress poolEndAddress) {
        this._end = poolEndAddress;
        this.setModified();
    }

    public void setHardwareAddress(MACAddress hardwareAdd) {
        this._hardwareAddress = hardwareAdd;
        this.setModified();
    }

    public void setHardwareType(String hwtype) {
        this._hardwareType = hwtype;
        this.setModified();
    }

    public void setHostIP(IPAddress ip) {
        this._host = ip;
        this.setModified();
    }

    public void setHostPool(boolean flag) {
        this.m_bHostPool = flag;
    }

    public void setImportFlag(boolean importAll) {
        this._importFlag = importAll;
        this.setModified();
    }

    public void setLease(int days, int hours, int min) {
        this._leaseDays = days;
        this._leaseHours = hours;
        this._leaseMins = min;
        this.setModified();
    }

    public void setLeaseDays(int days) {
        this._leaseDays = days;
        this.setModified();
    }

    public void setLeaseHours(int hours) {
        this._leaseHours = hours;
        this.setModified();
    }

    public void setLeaseInfiniteFlag(boolean leaseInfinite) {
        this._leaseInfiniteFlag = leaseInfinite;
        this.setModified();
    }

    public void setLeaseMinutes(int min) {
        this._leaseMins = min;
        this.setModified();
    }

    public void setMask(Netmask mask) {
        this._mask = mask;
        this.setModified();
    }

    public void setNetbiosServer1(IPAddress netbiosserver) {
        this._netbiosNameServer1 = netbiosserver;
        this.setModified();
    }

    public void setNetbiosServer2(IPAddress netbiosserver) {
        this._netbiosNameServer2 = netbiosserver;
        this.setModified();
    }

    public void setNetwork(IPAddress network) {
        this._network = network;
        this.setModified();
    }

    public void setStartAddress(IPAddress poolStartAddress) {
        this._start = poolStartAddress;
        this.setModified();
    }

    private String stripDots(String str) {
        if (CommonUtil.isEmpty((String)str)) {
            return str;
        }
        String res = "";
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != '.') {
                res = String.valueOf(res) + str.charAt(i);
            }
            ++i;
        }
        return res;
    }

    public boolean validateStartEndIP(IfIPAddress intfIPAddress) {
        return DHCPPool.validateStartEndIP(intfIPAddress, this._start, this._end);
    }

    public static boolean validateStartEndIP(IfIPAddress intfIPAddress, IPAddress poolStartAddr, IPAddress poolEndAddr) {
        if (intfIPAddress.getIPAddressType() != IPAddressType.STATIC) {
            return false;
        }
        IPAddress intfIp = intfIPAddress.getIPAddress();
        Netmask intfmask = intfIPAddress.getNetmask();
        IPAddress intfNetwork = new IPAddress(intfIp, intfmask);
        Log.getLog().debug("DHCPPool: validateStartEndIP(): Network number from intf IP addr is " + intfNetwork);
        IPAddress startIPNetwork = new IPAddress(poolStartAddr, intfmask);
        IPAddress endIPNetwork = new IPAddress(poolEndAddr, intfmask);
        if (intfNetwork.equals(startIPNetwork) && intfNetwork.equals(endIPNetwork)) {
            Log.getLog().debug("DHCPPool: validateStartEndIP(): Interface, Start and End addresses belong to same network");
            if (poolStartAddr.lessThanOrEqual(poolEndAddr)) {
                Log.getLog().debug("DHCPPool: validateStartEndIP(): Start Address is less than End Address");
                return true;
            }
        }
        return false;
    }
}

