/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.dialer;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.dialer.DialerList;
import java.util.Enumeration;

public class DialerListCollection
extends XDMHashCollection {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static int DEBUG_LEVEL = 3;

    public DialerListCollection() {
        if (DEBUG_LEVEL <= 1) {
            System.out.println("DialerListCollection() " + this.getClass().getName());
        }
    }

    public DialerListCollection(XDMObject parent) {
        super(parent);
        if (DEBUG_LEVEL <= 1) {
            System.out.println("DialerListCollection() " + this.getClass().getName());
        }
    }

    public DialerListCollection(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        if (DEBUG_LEVEL <= 1) {
            System.out.println("DialerListCollection() " + this.getClass().getName());
        }
    }

    public void addDialerList(DialerList dl) {
        dl.setParent(this);
        this.put(String.valueOf(dl.getGroup()) + dl.getProtocol(), dl);
    }

    public DialerList createDialerList() {
        int n = this.getNextNumber();
        if (DEBUG_LEVEL <= 2) {
            System.out.println("createDialerList() " + this.getClass().getName());
        }
        return new DialerList(n);
    }

    public boolean equals(Object obj) {
        if (DEBUG_LEVEL <= 1) {
            System.out.println("equals() " + this.getClass().getName());
        }
        if (obj != null && obj.getClass().equals(this.getClass())) {
            return super.equals(obj);
        }
        return false;
    }

    private int getNextNumber() {
        int[] nextDL = new int[128];
        int i = 0;
        while (i < 128) {
            nextDL[i] = 0;
            ++i;
        }
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            DialerList dl = (DialerList)e.nextElement();
            nextDL[dl.getGroup() - 1] = 1;
        }
        int i2 = 0;
        while (i2 < 128) {
            if (nextDL[i2] == 0) {
                return i2 + 1;
            }
            ++i2;
        }
        return 1;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        ConfigValues dialerCmds;
        if (DEBUG_LEVEL <= 2) {
            System.out.println("populate() " + this.getClass().getName());
        }
        if ((dialerCmds = config.getCmds("dialer-list", ".*", ".*", false)) == null) {
            return;
        }
        int i = 0;
        while (i < dialerCmds.numCmds()) {
            DialerList dl = new DialerList(this, false);
            dl.setParent(this);
            dl.populate(config, dialerCmds.getCmdValues(i));
            this._hashTable.put(String.valueOf(dl.getGroup()) + dl.getProtocol(), dl);
            ++i;
        }
    }

    public void removeDialerList(DialerList dl) {
        this.remove(String.valueOf(dl.getGroup()) + dl.getProtocol());
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            sb.append(String.valueOf(e.nextElement().toString()) + "\n");
        }
        return sb.toString();
    }
}

