/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.discovery;

import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.discovery.ControllerType;
import com.cisco.xdm.data.discovery.HWComponent;
import com.cisco.xdm.data.discovery.HWDevice;
import com.cisco.xdm.data.discovery.HWEntity;
import com.cisco.xdm.data.discovery.IfType;
import com.cisco.xdm.data.discovery.XDMHWDictionaryHandler;
import com.cisco.xdm.xmlparser.XmlApp;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public final class HWDictionary {
    private Hashtable _devices = new Hashtable();
    private Hashtable _NMs = new Hashtable();
    private Hashtable _WICs = new Hashtable();
    private Hashtable _interfaces;
    private Hashtable _controllers = new Hashtable();
    private XDMHWDictionaryHandler handler;
    private static final String HWDICTIONARY_FILE_NAME = "HWDictionary.xml";
    private static HWDictionary instance = null;

    private HWDictionary() {
        this._interfaces = new Hashtable();
    }

    public static HWDictionary GetInstance() {
        block2: {
            if (instance != null) break block2;
            instance = new HWDictionary();
            try {
                instance.populateHWDictionary();
            }
            catch (XDMException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public void addControllerType(int type, ControllerType ctype) {
        Integer key = new Integer(type);
        if (!this._controllers.containsKey(key) && !this._controllers.contains(ctype)) {
            this._controllers.put(key, ctype);
        }
    }

    public void addDevice(String key, HWEntity entity) {
        if (!this._devices.containsKey(key) && !this._devices.contains(entity)) {
            this._devices.put(key, entity);
        }
    }

    public void addInterfaceType(int type, IfType iftype) {
        Integer key = new Integer(type);
        if (!this._interfaces.containsKey(key) && !this._interfaces.contains(iftype)) {
            this._interfaces.put(key, iftype);
        }
    }

    public void addNM(String key, HWEntity entity) {
        if (!this._NMs.containsKey(key) && !this._NMs.contains(entity)) {
            this._NMs.put(key, entity);
        }
    }

    public void addWIC(String key, HWEntity entity) {
        if (!this._WICs.containsKey(key) && !this._WICs.contains(entity)) {
            this._WICs.put(key, entity);
        }
    }

    public ControllerType getController(int type) {
        Integer obj = new Integer(type);
        return (ControllerType)this._controllers.get(obj);
    }

    public Hashtable getControllers() {
        return this._controllers;
    }

    public HWEntity getDevice(String key) {
        return (HWEntity)this._devices.get(key);
    }

    public Hashtable getDevices() {
        return this._devices;
    }

    public String getHWDictionaryFilePath() {
        Properties prop = System.getProperties();
        String path = prop.getProperty("user.dir");
        return path.concat(HWDICTIONARY_FILE_NAME);
    }

    public HWEntity getNM(String key) {
        return (HWEntity)this._NMs.get(key);
    }

    public Hashtable getNMs() {
        return this._NMs;
    }

    public HWEntity getWIC(String key) {
        return (HWEntity)this._WICs.get(key);
    }

    public Hashtable getWICs() {
        return this._WICs;
    }

    public IfType getif(int type) {
        Integer obj = new Integer(type);
        return (IfType)this._interfaces.get(obj);
    }

    public Hashtable getifs() {
        return this._interfaces;
    }

    public void populateHWDictionary() throws XDMException {
        this.handler = new XDMHWDictionaryHandler(instance);
        XmlApp app = new XmlApp(this.handler);
        InputStream in = this.getClass().getResourceAsStream(HWDICTIONARY_FILE_NAME);
        try {
            app.doParse(in);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void print() {
        HWComponent comp;
        Enumeration en;
        HWEntity ent;
        Enumeration e = this._interfaces.elements();
        System.out.println("Interfaces :");
        while (e.hasMoreElements()) {
            IfType obj = (IfType)e.nextElement();
            System.out.println("Iftype type = " + obj.getType() + " name = " + obj.getName());
        }
        e = this._NMs.elements();
        System.out.println("\nNetwork Modules :");
        while (e.hasMoreElements()) {
            ent = (HWEntity)e.nextElement();
            System.out.println("NM name = " + ent.getName() + " label = " + ent.getLabel() + " PartNo = " + ent.getPartNo());
            en = ent.getHWComponents().elements();
            while (en.hasMoreElements()) {
                comp = (HWComponent)en.nextElement();
                System.out.println("    Component type = " + comp._type + " count = " + comp._count);
            }
        }
        e = this._WICs.elements();
        System.out.println("\nWICS :");
        while (e.hasMoreElements()) {
            ent = (HWEntity)e.nextElement();
            System.out.println("WIC name = " + ent.getName() + " label = " + ent.getLabel() + " PartNo = " + ent.getPartNo());
            en = ent.getHWComponents().elements();
            while (en.hasMoreElements()) {
                comp = (HWComponent)en.nextElement();
                System.out.println("   component type = " + comp._type + " count = " + comp._count);
            }
        }
        e = this._devices.elements();
        System.out.println("\nDevice :");
        while (e.hasMoreElements()) {
            HWDevice device = (HWDevice)e.nextElement();
            System.out.println("Device name = " + device.getName() + " MainBoard = " + device.getMainboard() + " MainBoardSlot = " + device.getMainboardSlot() + "label = " + device.getLabel());
            Enumeration en2 = device.getHWComponents().elements();
            while (en2.hasMoreElements()) {
                comp = (HWComponent)en2.nextElement();
                System.out.println("   component type = " + comp._type + " count = " + comp._count);
            }
        }
    }
}

