/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.discovery;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.StringUtils;
import com.cisco.xdm.data.base.HWCompConfig;
import com.cisco.xdm.data.base.HWConfig;
import com.cisco.xdm.data.common.CLIViewType;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.discovery.HWComponent;
import com.cisco.xdm.data.discovery.HWDevice;
import com.cisco.xdm.data.discovery.HWDictionary;
import com.cisco.xdm.data.discovery.HWEntity;
import com.cisco.xdm.net.HTTPService;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.parser.DiagInfo;
import com.cisco.xdm.parser.ShowCmdParser;
import com.cisco.xdm.parser.VersionInfo;
import com.cisco.xdm.parser.WicInfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XDMDiscovery {
    public static String SHOW_RUN = "show running-config";
    public static final String PARTIAL_CRYPTO_IPSEC_TRANSFORMSET = "crypto ipsec transform-set try-it ?";
    public static final String SHOW_VERSION = "show version";
    public static final String SHOW_DIAG = "show diag";
    public static final String CRYPTO_PKI_TRUSTPOINT_NAME = "test_trustpoint_config_created_for_sdm";
    public static final String CRYPTO_PKI_TRUSTPOINT = "crypto ca trustpoint test_trustpoint_config_created_for_sdm";
    public static final String CRYPTO_CLIENT_EZVPN = "crypto ipsec client ezvpn test_ezvpn_config_created_for_sdm";
    public static final String CRYPTO_CLIENT_EZVPN_GROUP = "group test_group_created_for_sdm key ?";
    public static final String CRYPTO_CLIENT_EZVPN_USERNAME = " username test_username_created_for_sdm ?";
    public static final String SHOW_SNMP_ENGINEID = "show snmp engineID";
    public static final String SHOW_IDB = "show idb";
    public static final String SHOW_IP_INT_BR = "show ip interface brief";
    public static final String SHOW_DEBUGGING = "show debugging";
    public static final String SHOW_CRYPTO_ENGINE_BRIEF = "show crypto engine brief";
    public static final String EASYVPN_SERVER_SESSION = "show crypto ?";
    public static final String EASYVPN_SERVER_GROUP = "crypto isakmp client configuration group test_group_created_for_sdm_discovery";
    public static final String[] EASYVPN_SERVER_KEYWORDS = new String[]{"configuration", "auto-update", "netmask", "backup-gateway", "include-local-lan", "save-password", "group-lock"};
    public static final double[] EASYVPN_SERVER_PHASES = new double[]{5.1, 5.0, 2.2, 2.1, 2.0, 1.2, 1.1};
    public static final String QOS_CLASS_MAP = "class-map match-any test_class_map_for_sdm";
    public static final String QOS_CLASS_MAP_MATCH_PROTOCOL = "match protocol http";
    public static final String QOS_POLICY_MAP = "policy-map test_policy_map_for_sdm";
    public static final String QOS_POLICY_MAP_C = "class test_class_map_for_sdm";
    public static final String QOS_POLICY_MAP_C_PRIO_PERCENT = "priority percent 5";
    public static final String QOS_POLICY_MAP_C_BW_PERCENT = "bandwidth percent 5";
    public static final String QOS_POLICY_MAP_C_SET_DSCP = "set dscp 5";
    public static final String QOS_POLICY_MAP_C_CRTP = "compression header ip tcp";
    public static final String QOS_POLICY_MAP_C_SERVICE_POLICY = "service-policy ?";
    public static final String QOS_INTF = "interface";
    public static final String SHOW_INTERFACES = "show interfaces";
    public static final String QOS_TUNNEL = "Tunnel";
    public static final String QOS_TUNNEL_NUMBER = "555555555";
    public static final String QOS_PRE_CLASSIFY = "qos pre-classify";
    public static final String SHOW_IP_NBAR_PROT_DISCOVERY = "show ip nbar protocol-discovery ?";
    private static boolean m_bIPHCSupported = true;
    public static final String DIALBACKUP_RTR = "rtr ?";
    public static final String DIALBACKUP_IP_SLA = "ip sla monitor ?";
    public static final String DIALBACKUP_RTR1 = "rtr 2147483647";
    public static final String IP_RTR_TYPE_SOURCE_INTER = "type echo protocol ipIcmpEcho 6.6.6.1 source-interface ?";
    public static final String DIALBACKUP_IP_SLA1 = "ip sla monitor 2147483647";
    public static final String IP_SLA_TYPE_SOURCE_INTER = " type echo protocol ipIcmpEcho 6.6.6.1 source-interface ?";
    public static final String DIALBACKUP_ONLY_IPSLA = "ip sla 2147483647";
    public static final String DIALBACKUP_ONLY_IPSLA_INTER = "icmp-echo 6.6.6.1 source-interface ?";
    public static final String USB_DEVICE_SUPPORTS = "show usb port ?";
    public static final String PARSER_VIEW = "parser view sdm_test";
    public static final String VIEW_SECRET = "secret 0 ?";
    public static final String DISCOVER_ATM_PVC = "discover atm pvc ?";
    public static final String SHOW_IP_INT_BRIEF = "show ip interface brief";
    public static final String DOT11RADIO = "Dot11Radio";
    public static final String IP_DDNS_CMD = "show ip ddns update ?";
    public static final String[] EASYVPN_REMOTE_KEYWORDS = new String[]{"xauth", "backup", "acl", "username"};
    public static final int[] EASYVPN_REMOTE_VALUES = new int[]{15, 7, 3, 1};
    public static final int EASY_REMOTE_SAVE_XAUTH = 1;
    public static final int EASY_REMOTE_MUL_SUBNET_ACL = 2;
    public static final int EASY_REMOTE_BACKUP = 4;
    public static final int EASY_REMOTE_WI = 8;
    private static Hashtable _commands = new Hashtable();
    private static final String UNSUPPORTED = "Unrecognized command";
    private static Hashtable ddnsHash = new Hashtable();
    private static String ipsMinorVersion = "";
    private static int schedulerInterrupt = -1;
    private static final String NTP = "ntp";
    private static final String SNTP = "sntp";

    private static void buildElements(Vector comps, HWCompConfig config) {
        if (comps == null) {
            return;
        }
        int i = 0;
        while (i < comps.size()) {
            int j;
            HWComponent c = (HWComponent)comps.elementAt(i);
            if (c.getType() >= 2000) {
                j = 0;
                while (j < c.getCount()) {
                    config._controllers.addElement(new Integer(c.getType()));
                    ++j;
                }
            } else if (c.getType() >= 0) {
                j = 0;
                while (j < c.getCount()) {
                    config._ifs.addElement(new Integer(c.getType()));
                    ++j;
                }
            }
            ++i;
        }
    }

    public static int discoverEasyVPNRemoteCommands(IOSCmdService comm) {
        int nRet = 0;
        try {
            String[] configCmds = new String[]{CRYPTO_CLIENT_EZVPN, " ?"};
            IOSCmdResponse[] reply = comm.config(configCmds);
            if (reply != null && reply.length > 1) {
                String output = reply[reply.length - 1].getOutput();
                nRet = XDMDiscovery.getEasyVPNRemoteVersion(output);
            }
            String[] negateCmds = new String[]{"no crypto ipsec client ezvpn test_ezvpn_config_created_for_sdm"};
            comm.config(negateCmds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nRet;
    }

    private static boolean discoverTrustpointSubCmd(IOSCmdService comm, String subCmd, String expectedResult) throws IOException {
        String[] cmd = new String[]{CRYPTO_PKI_TRUSTPOINT, subCmd};
        IOSCmdResponse[] reply = comm.config(cmd);
        if (reply != null && reply.length > 1) {
            StringReader strReader = new StringReader(reply[reply.length - 1].getOutput());
            LineNumberReader lineReader = new LineNumberReader(strReader);
            String line = lineReader.readLine();
            while (line != null) {
                if (line.toUpperCase().indexOf(expectedResult) >= 0) {
                    XDMDiscovery.removeDummyTrustpoint();
                    return true;
                }
                line = lineReader.readLine();
            }
        }
        XDMDiscovery.removeDummyTrustpoint();
        return false;
    }

    public static int discoverTrustpointSubCmds(IOSCmdService comm) throws IOException {
        int nRet = 0;
        boolean[] _attrs = new boolean[2];
        String[] cmd = new String[]{CRYPTO_PKI_TRUSTPOINT, " ?"};
        IOSCmdResponse[] reply = comm.config(cmd);
        if (reply != null && reply.length > 1) {
            StringReader strReader = new StringReader(reply[reply.length - 1].getOutput());
            LineNumberReader lineReader = new LineNumberReader(strReader);
            String line = lineReader.readLine();
            while (line != null) {
                if (line.toUpperCase().indexOf("FQDN") >= 0) {
                    nRet |= 1;
                } else if (line.toUpperCase().indexOf("SOURCE") >= 0) {
                    nRet |= 2;
                } else if (line.toUpperCase().indexOf("OCSP") >= 0) {
                    nRet |= 4;
                } else if (line.toUpperCase().indexOf("REVOCATION-CHECK") >= 0) {
                    nRet |= 8;
                } else if (line.toUpperCase().indexOf("FINGERPRINT") >= 0) {
                    nRet |= 0x40;
                }
                line = lineReader.readLine();
            }
        }
        XDMDiscovery.removeDummyTrustpoint();
        if (XDMDiscovery.discoverTrustpointSubCmd(comm, " enrollment ?", "TERMINAL")) {
            nRet |= 0x10;
        }
        if (XDMDiscovery.discoverTrustpointSubCmd(comm, " subject-name e=sdmtest@sdmtest.com", "THE SUBJECT NAME MUST BE IN X.500 (LDAP) FORMAT")) {
            nRet |= 0x20;
        }
        return nRet;
    }

    private static HWConfig discoveryHWConfig(IOSCmdService comm, DiagInfo[] shDiagData, String model) throws IOException {
        HWDictionary dict = HWDictionary.GetInstance();
        HWDevice dev = (HWDevice)dict.getDevice(model);
        if (dev == null) {
            return null;
        }
        HWConfig config = new HWConfig(model);
        Vector comps = dev.getHWComponents();
        boolean needShowDiag = false;
        String mainboardPN = null;
        int mainboardSlot = -1;
        int numNMs = 0;
        if (dev.getMainboard() != null) {
            mainboardPN = dev.getMainboard();
            mainboardSlot = Integer.valueOf(dev.getMainboardSlot());
            needShowDiag = true;
            ++numNMs;
        }
        config.setMainboardSlot(mainboardSlot);
        int i = 0;
        while (i < comps.size()) {
            HWComponent c = (HWComponent)comps.elementAt(i);
            if (c.getType() == -1) {
                numNMs += c.getCount();
                needShowDiag = true;
            }
            ++i;
        }
        XDMDiscovery.buildElements(comps, config);
        if (!needShowDiag) {
            return config;
        }
        DiagInfo[] shDiag = null;
        shDiag = comm != null ? XDMDiscovery.getShowDiag(comm) : shDiagData;
        if (shDiag != null) {
            int i2 = 0;
            while (i2 < shDiag.length) {
                StringTokenizer st = new StringTokenizer(shDiag[i2].slotNo);
                String token = st.nextToken();
                if (token.equalsIgnoreCase("AIM")) {
                    int aimSlot = XDMDiscovery.getAIMSlot(st);
                    if (aimSlot >= 0) {
                        config._AIMs.addElement(new HWCompConfig(1, XDMDiscovery.getMajorPartNum(shDiag[i2].partNumber), aimSlot));
                    }
                } else {
                    int slot = Integer.parseInt(token);
                    String pn = slot == mainboardSlot ? mainboardPN : XDMDiscovery.getMajorPartNum(shDiag[i2].partNumber);
                    if (slot >= numNMs) {
                        HWEntity vpn = dict.getNM(pn);
                        if (vpn != null) {
                            config._AIMs.addElement(new HWCompConfig(1, pn, slot));
                        }
                    } else {
                        WicInfo[] wics;
                        Vector subComps;
                        String newPn;
                        HWEntity nmEntity = dict.getNM(pn);
                        if (nmEntity != null && nmEntity.hasExtras() && (newPn = nmEntity.findPNFromExtra(shDiag[i2].slotText.toString())) != null) {
                            pn = newPn;
                            nmEntity = dict.getNM(pn);
                        }
                        HWCompConfig nm = new HWCompConfig(1, pn, slot);
                        if (nmEntity != null) {
                            XDMDiscovery.buildElements(nmEntity.getHWComponents(), nm);
                        }
                        config._components.addElement(nm);
                        boolean hasWIC = false;
                        if (nmEntity != null && (subComps = nmEntity.getHWComponents()) != null) {
                            int ii = 0;
                            while (ii < subComps.size()) {
                                HWComponent c = (HWComponent)subComps.elementAt(ii);
                                if (c.getType() == -2) {
                                    hasWIC = true;
                                    break;
                                }
                                ++ii;
                            }
                        }
                        if ((wics = shDiag[i2].wics) != null && hasWIC) {
                            int j = 0;
                            while (j < wics.length) {
                                String newPn2;
                                int wicSlot = Integer.parseInt(wics[j].slotNo);
                                String wicPN = XDMDiscovery.getMajorPartNum(wics[j].partNumber);
                                HWEntity wicEntity = dict.getWIC(wicPN);
                                if (wicEntity != null && wicEntity.hasExtras() && (newPn2 = wicEntity.findPNFromExtra(wics[j].slotText.toString())) != null) {
                                    wicPN = newPn2;
                                    wicEntity = dict.getWIC(wicPN);
                                }
                                HWCompConfig wic = new HWCompConfig(2, wicPN, wicSlot);
                                if (wicEntity != null) {
                                    XDMDiscovery.buildElements(wicEntity.getHWComponents(), wic);
                                }
                                nm._components.addElement(wic);
                                ++j;
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        return config;
    }

    public static boolean doesEncryptionEngineAllowSeal(IOSCmdService comm) {
        String[] cmd = new String[]{SHOW_CRYPTO_ENGINE_BRIEF};
        boolean ret = true;
        try {
            IOSCmdResponse[] responses = comm.exec(cmd);
            if (responses[0].getStatus() != 2 && responses[0].getOutput().indexOf("crypto engine type:  hardware") >= 0 && responses[0].getOutput().indexOf("State:  Disabled") == -1) {
                ret = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = false;
        }
        return ret;
    }

    public static void enableShowRunnViewFull() {
        SHOW_RUN = "show running-config view full";
    }

    public static boolean findFromConfigOutput(IOSCmdService comm, String command, String[] keys) {
        return XDMDiscovery.findFromOuput(comm, true, command, keys);
    }

    public static boolean findFromExecOutput(IOSCmdService comm, String command, String[] keys) {
        return XDMDiscovery.findFromOuput(comm, false, command, keys);
    }

    private static boolean findFromOuput(IOSCmdService comm, boolean config, String command, String[] keys) {
        if (command == null || command.length() == 0) {
            return false;
        }
        String key = config ? "config - " + command : "exec - " + command;
        if (!_commands.containsKey(key)) {
            try {
                String[] cmds = new String[]{command};
                IOSCmdResponse[] reply = config ? comm.config(cmds) : comm.exec(cmds);
                if (!XDMDiscovery.isOKResponse(reply[0])) {
                    _commands.put(key, UNSUPPORTED);
                    return false;
                }
                _commands.put(key, reply[0].getOutput());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        String output = (String)_commands.get(key);
        if (keys == null || keys.length == 0) {
            return output.indexOf(UNSUPPORTED) < 0;
        }
        if (keys.length == 1) {
            return XDMDiscovery.findFromTokens(output, keys);
        }
        boolean bFound = false;
        try {
            LineNumberReader reader = new LineNumberReader(new StringReader(output));
            String line = reader.readLine();
            while (line != null && !bFound) {
                bFound = XDMDiscovery.findFromTokens(line, keys);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bFound;
    }

    private static boolean findFromTokens(String src, String[] keys) {
        StringTokenizer st = new StringTokenizer(src);
        int index = 0;
        while (st.hasMoreElements() && index < keys.length) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase(keys[index])) continue;
            ++index;
        }
        return index == keys.length;
    }

    private static int getAIMSlot(StringTokenizer st) {
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            try {
                return Integer.parseInt(token);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private static String getByName(String in, String name) {
        String key = String.valueOf(name) + " ";
        try {
            LineNumberReader reader = new LineNumberReader(new StringReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(key)) {
                    return line;
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCLIViewName(IOSCmdService comm) throws IOException {
        String[] strShTestCmd = new String[]{"show parser view"};
        String strShParserViewResult = "";
        String strViewName = "";
        try {
            IOSCmdResponse[] execReply = comm.exec(strShTestCmd);
            strShParserViewResult = execReply[0].getOutput();
            if (execReply[0].getStatus() == 2 || strShParserViewResult == null) {
                return strViewName;
            }
            String strSearchString = "Current view is '";
            int firstIndex = strShParserViewResult.indexOf(strSearchString);
            if (firstIndex == -1) {
                return strViewName;
            }
            int secIndex = strShParserViewResult.indexOf("'", firstIndex + strSearchString.length());
            if (secIndex == -1) {
                return strViewName;
            }
            strViewName = strShParserViewResult.substring(firstIndex + strSearchString.length(), secIndex);
            return strViewName;
        }
        catch (Exception exception) {
            return strViewName;
        }
    }

    public static boolean[] getCmdsSupported(IOSCmdService comm, String[] commands) throws IOException {
        IOSCmdResponse[] responses = comm.config(commands);
        if (responses == null || responses.length < 1) {
            return null;
        }
        int last = responses.length;
        boolean[] ret = new boolean[responses.length];
        String buf = null;
        int i = 0;
        while (i < last) {
            buf = responses[i].getOutput();
            ret[i] = responses[i].getStatus() != 2 && buf != null && buf.indexOf("% Unrecognized command") < 0;
            ++i;
        }
        return ret;
    }

    public static boolean[] getCommandsSupported(IOSCmdService comm, String[] commands) throws IOException {
        IOSCmdResponse[] responses = comm.config(commands);
        if (responses == null || responses.length < 1) {
            return null;
        }
        int last = responses.length;
        boolean[] ret = new boolean[responses.length];
        String buf = null;
        int i = 0;
        while (i < last) {
            buf = responses[i].getOutput();
            ret[i] = responses[i].getStatus() != 2 && buf != null && buf.indexOf(UNSUPPORTED) < 0 && buf.indexOf("Invalid input") < 0;
            ++i;
        }
        return ret;
    }

    public static boolean getCryptpEngineSupport(IOSCmdService comm) {
        String[] cmd = new String[]{SHOW_CRYPTO_ENGINE_BRIEF};
        boolean bSupported = true;
        try {
            boolean bNoCompressionTag;
            IOSCmdResponse[] responses = comm.exec(cmd);
            boolean bcmdOK = responses[0].getStatus() != 2;
            boolean bHWEngineTag = responses[0].getOutput().indexOf("crypto engine type:  hardware") != -1;
            boolean bHWDisabledTag = responses[0].getOutput().indexOf("State:  Disabled") != -1;
            boolean bl = bNoCompressionTag = responses[0].getOutput().indexOf("Compression:  No") != -1;
            if (bcmdOK) {
                if (bHWEngineTag && !bHWDisabledTag) {
                    return !bNoCompressionTag;
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String getDefaultLAN(String model) {
        HWDictionary dictionary = HWDictionary.GetInstance();
        if (dictionary == null) {
            return null;
        }
        HWDevice dev = (HWDevice)dictionary.getDevice(model);
        if (dev == null) {
            return null;
        }
        String lan = dev.getAttr("LAN");
        return lan;
    }

    public static String getDefaultWAN(String model) {
        HWDictionary dictionary = HWDictionary.GetInstance();
        if (dictionary == null) {
            return null;
        }
        HWDevice dev = (HWDevice)dictionary.getDevice(model);
        if (dev == null) {
            return null;
        }
        String wan = dev.getAttr("WAN");
        return wan;
    }

    public static Hashtable getDeletedSubif(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{"show ip interface brief"};
        IOSCmdResponse[] reply = comm.exec(cmd);
        Hashtable<String, String> deleteds = new Hashtable<String, String>();
        BufferedReader bfr = new BufferedReader(new InputStreamReader(new StringBufferInputStream(reply[0].getOutput())));
        String line = null;
        while ((line = bfr.readLine()) != null) {
            StringTokenizer st;
            if (line.indexOf("deleted") <= 0 || !(st = new StringTokenizer(line, " ")).hasMoreTokens()) continue;
            String token = st.nextToken();
            deleteds.put(token, token);
        }
        return deleteds;
    }

    public static VersionInfo getDevInfo(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{SHOW_VERSION};
        IOSCmdResponse[] reply = comm.exec(cmd);
        return ShowCmdParser.parseShowVersion(new StringBufferInputStream(reply[0].getOutput()));
    }

    private static int getEasyVPNRemoteVersion(String output) throws Exception {
        int count = 0;
        while (count < EASYVPN_REMOTE_KEYWORDS.length) {
            StringReader strReader = new StringReader(output);
            LineNumberReader lineReader = new LineNumberReader(strReader);
            String line = lineReader.readLine();
            while (line != null) {
                if (line.toLowerCase().indexOf(EASYVPN_REMOTE_KEYWORDS[count]) >= 0) {
                    return EASYVPN_REMOTE_VALUES[count];
                }
                line = lineReader.readLine();
            }
            ++count;
        }
        return 0;
    }

    public static double getEasyVPNServerVersion(IOSCmdService comm) throws IOException {
        String[] configCmds = new String[]{EASYVPN_SERVER_GROUP, " ?"};
        IOSCmdResponse[] reply = comm.config(configCmds);
        double nRet = 1.0;
        if (reply != null && reply.length > 1) {
            String output = reply[reply.length - 1].getOutput();
            nRet = XDMDiscovery.getEasyVPNServerVersion(output);
        }
        String[] negateCmds = new String[]{"no crypto isakmp client configuration group test_group_created_for_sdm_discovery"};
        comm.config(negateCmds);
        return nRet;
    }

    private static double getEasyVPNServerVersion(String output) throws IOException {
        int count = 0;
        while (count < EASYVPN_SERVER_KEYWORDS.length) {
            StringReader strReader = new StringReader(output);
            LineNumberReader lineReader = new LineNumberReader(strReader);
            String line = lineReader.readLine();
            while (line != null) {
                if (line.trim().toLowerCase().indexOf(EASYVPN_SERVER_KEYWORDS[count]) == 0) {
                    return EASYVPN_SERVER_PHASES[count];
                }
                line = lineReader.readLine();
            }
            ++count;
        }
        return 1.0;
    }

    public static boolean getEzVPNKeyEncryptSupport(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{CRYPTO_CLIENT_EZVPN, CRYPTO_CLIENT_EZVPN_GROUP};
        IOSCmdResponse[] reply = comm.config(cmd);
        boolean keyEncryptSupport = false;
        if (reply != null && reply.length > 1) {
            StringTokenizer st = new StringTokenizer(reply[reply.length - 1].getOutput());
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equalsIgnoreCase("ENCRYPTED")) continue;
                keyEncryptSupport = true;
            }
        }
        String[] cmd1 = new String[]{"no crypto ipsec client ezvpn test_ezvpn_config_created_for_sdm"};
        IOSCmdResponse[] reply1 = comm.config(cmd1);
        return keyEncryptSupport;
    }

    public static int getEzVPNRemoteVersion(IOSCmdService comm) throws IOException {
        String output;
        int remoteVersion = 0;
        String[] cmd = new String[]{CRYPTO_CLIENT_EZVPN, CRYPTO_CLIENT_EZVPN_USERNAME};
        IOSCmdResponse[] reply = comm.config(cmd);
        if (reply != null && reply.length > 1 && (output = reply[reply.length - 1].getOutput()).toUpperCase().indexOf("PASSWORD") >= 0) {
            remoteVersion = 3;
        }
        String[] cmd1 = new String[]{"no crypto ipsec client ezvpn test_ezvpn_config_created_for_sdm"};
        IOSCmdResponse[] reply1 = comm.config(cmd1);
        return remoteVersion;
    }

    public static InputStream getFilteredRunningConfig(IOSCmdService comm, String filter) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(SHOW_RUN);
        if (filter != null && filter.length() > 0) {
            sb.append(" | include ");
            sb.append(filter);
        }
        String[] cmd = new String[]{sb.toString()};
        IOSCmdResponse[] reply = comm.exec(cmd);
        return new StringBufferInputStream(reply[0].getOutput());
    }

    public static HWConfig getHWConfig(IOSCmdService comm, String model) throws IOException {
        return XDMDiscovery.discoveryHWConfig(comm, null, model);
    }

    public static HWConfig getHWConfig(String shDiagOutput, String model) throws IOException {
        DiagInfo[] shDiag = null;
        if (shDiagOutput != null && shDiagOutput.length() > 0) {
            shDiag = XDMDiscovery.getShowDiag(shDiagOutput);
        }
        return XDMDiscovery.discoveryHWConfig(null, shDiag, model);
    }

    /*
     * Unable to fully structure code
     */
    public static Hashtable getIDB(IOSCmdService comm) throws IOException {
        block3: {
            cmd = new String[]{"show idb"};
            reply = comm.exec(cmd);
            idb = new Hashtable<String, String>();
            bfr = new BufferedReader(new InputStreamReader(new StringBufferInputStream(reply[0].getOutput())));
            line = null;
            if (reply[0].getOutput().indexOf("--------------------") >= 0) ** GOTO lbl33
            while ((line = bfr.readLine()) != null) {
                st = new StringTokenizer(line, " ");
                token = null;
                if (!st.hasMoreTokens() || (token = st.nextToken()).indexOf("SWIDB") < 0 && token.indexOf("HWIDB") < 0 || !st.hasMoreTokens()) continue;
                token = st.nextToken();
                if (Character.isLetter(token.charAt(0))) {
                    idb.put(token, token);
                    continue;
                }
                if (!st.hasMoreTokens()) continue;
                token = st.nextToken();
                idb.put(token, token);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                st = new StringTokenizer(line, " ");
                if (st.countTokens() < 5) continue;
                token = null;
                token = st.nextToken();
                if (!token.equals("H") && !token.equals("S")) continue;
                token = st.nextToken();
                token = st.nextToken();
                token = st.nextToken();
                token = st.nextToken();
                idb.put(token, token);
lbl33:
                // 4 sources

                ** while ((line = bfr.readLine()) != null)
            }
        }
        return idb;
    }

    public static IPAddress getIPAddrFromIPIntBrfOut(IOSCmdService comm, String strIntfName) throws IOException {
        IPAddress ipAddress = null;
        String strOutput = XDMDiscovery.getShIPIntBrfCmdOut(comm);
        StringBufferInputStream inpStream = new StringBufferInputStream(strOutput);
        if (inpStream == null) {
            return null;
        }
        BufferedReader bfr = new BufferedReader(new InputStreamReader(inpStream));
        String line = null;
        String strIPAddress = null;
        if (strIntfName == null || strIntfName.length() == 0) {
            return ipAddress;
        }
        strIntfName = strIntfName.trim();
        while ((line = bfr.readLine()) != null) {
            if (line.indexOf(strIntfName) == -1) continue;
            StringTokenizer st = new StringTokenizer(line, " ");
            int nTokenCnt = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (++nTokenCnt != 2) continue;
                strIPAddress = token;
            }
            break block0;
        }
        boolean bIPValid = IPAddress.isLegalIPAddress(strIPAddress);
        if (bIPValid) {
            ipAddress = new IPAddress(strIPAddress);
        }
        return ipAddress;
    }

    public static String getIPAddrFromIPIntBrfOut(StringBufferInputStream inpStream, String strIntfName) throws IOException {
        if (inpStream == null) {
            return null;
        }
        BufferedReader bfr = new BufferedReader(new InputStreamReader(inpStream));
        String line = null;
        String ipAddress = null;
        if (strIntfName == null || strIntfName.length() == 0) {
            return ipAddress;
        }
        strIntfName = strIntfName.trim();
        while ((line = bfr.readLine()) != null) {
            if (line.indexOf(strIntfName) == -1) continue;
            StringTokenizer st = new StringTokenizer(line, " ");
            int nTokenCnt = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (++nTokenCnt != 2) continue;
                ipAddress = token;
            }
            break block0;
        }
        return ipAddress;
    }

    public static Integer getIPSMajorVersion() {
        try {
            String[] versions = StringUtils.split(ipsMinorVersion, ".");
            return new Integer(versions[0]);
        }
        catch (Exception exception) {
            return new Integer(1);
        }
    }

    public static Integer getIPSMinorVersion() {
        try {
            String[] versions = StringUtils.split(ipsMinorVersion, ".");
            return new Integer(versions[1]);
        }
        catch (Exception exception) {
            return new Integer(1);
        }
    }

    public static boolean getIsAESSupported(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{PARTIAL_CRYPTO_IPSEC_TRANSFORMSET};
        IOSCmdResponse[] reply = comm.config(cmd);
        return reply != null && reply.length > 0 && reply[reply.length - 1].getOutput().toUpperCase().indexOf("ESP-AES") >= 0;
    }

    public static boolean getIsEncryptionEngineAllowAES(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{SHOW_CRYPTO_ENGINE_BRIEF};
        IOSCmdResponse[] responses = comm.exec(cmd);
        boolean ret = true;
        if (responses[0].getStatus() != 2 && responses[0].getOutput().indexOf("crypto engine type:  hardware") >= 0 && responses[0].getOutput().indexOf("State:  Disable") == -1 && responses[0].getOutput().indexOf("AES CBC:  No") >= 0) {
            ret = false;
        }
        return ret;
    }

    public static boolean getIsHttpsSupported(IOSCmdService comm) throws IOException {
        String[] cmds = new String[]{"show ip http server all | include secure server status", "show ip http server secure status | include secure server"};
        IOSCmdResponse[] replies = comm.exec(cmds);
        boolean ret = false;
        if (replies != null && replies.length > 1) {
            String r1 = replies[0].getOutput().toUpperCase();
            String r2 = replies[1].getOutput().toUpperCase();
            if (r1.indexOf("ENABLED") >= 0 || r1.indexOf("DISABLED") >= 0) {
                ret = true;
            } else if (r2.indexOf("ENABLED") >= 0 || r2.indexOf("DISABLED") >= 0) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean getIsKRBSupported(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{"aaa authentication login testing ?"};
        IOSCmdResponse[] reply = comm.config(cmd);
        return reply != null && reply.length > 0 && reply[reply.length - 1].getOutput().toUpperCase().indexOf("KRB5") >= 0;
    }

    public static boolean getIsSNMPEnabled(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{SHOW_SNMP_ENGINEID};
        IOSCmdResponse[] responses = comm.exec(cmd);
        return responses[0].getStatus() != 2 && responses[0].getOutput().indexOf("Local SNMP") >= 0;
    }

    public static boolean getIsViewSecretSupported(IOSCmdService comm) throws IOException {
        String[] viewCmds = new String[]{PARSER_VIEW, VIEW_SECRET};
        IOSCmdResponse[] responses = comm.config(viewCmds);
        boolean viewResponse = XDMDiscovery.isOKResponse(responses[1]);
        String[] removecmd = new String[]{"no parser view sdm_test"};
        IOSCmdResponse[] reply1 = comm.config(removecmd);
        return viewResponse;
    }

    public static long getLogDefaultValue(IOSCmdService comm) {
        long bufVal = 4096L;
        try {
            IOSCmdResponse[] resp = comm.exec(new String[]{"show logging | include size"});
            if (XDMDiscovery.isOKResponse(resp[0])) {
                String response = resp[0].getOutput();
                String[] values = StringUtils.split(resp[0].getOutput(), "(");
                if (values.length == 2) {
                    bufVal = new Long(values[1].substring(0, values[1].indexOf(" ")));
                }
            }
        }
        catch (Exception exp) {
            Log.getLog().debug("Exception at XDMDiscovery.getLogDefaultValue", exp);
        }
        return bufVal;
    }

    private static String getMajorPartNum(String partNum) {
        int i = partNum.indexOf("-");
        if ((i = partNum.indexOf("-", i + 1)) == -1) {
            return partNum;
        }
        return partNum.substring(0, i);
    }

    public static boolean getOptionSupported(IOSCmdService comm, String command, String option) throws IOException {
        String[] commands = new String[]{command};
        IOSCmdResponse[] responses = comm.config(commands);
        if (responses == null || responses.length < 1) {
            return false;
        }
        String buf = null;
        buf = responses[0].getOutput();
        return responses[0].getStatus() != 2 && buf != null && buf.indexOf("% Unrecognized command") < 0 && buf.indexOf(option) >= 0;
    }

    public static boolean getOptionSupportedOnCmd(IOSCmdResponse resp, String option) {
        if (!XDMDiscovery.isOKResponse(resp) || option == null || option.length() == 0) {
            return false;
        }
        String str = option.toUpperCase();
        return resp.getOutput().toUpperCase().indexOf(str) >= 0;
    }

    public static boolean[] getOptionsSupportedOnCmd(IOSCmdResponse resp, String[] options) {
        if (resp == null) {
            return null;
        }
        String buf = null;
        buf = resp.getOutput();
        boolean[] ret = new boolean[options.length];
        if (resp.getStatus() != 2 && buf != null && buf.indexOf("% Unrecognized command") < 0) {
            int i = 0;
            while (i < options.length) {
                ret[i] = buf.indexOf(options[i]) >= 0;
                ++i;
            }
        }
        return ret;
    }

    public static boolean[] getOptionsSupportedOnCmd(IOSCmdService comm, String command, String[] options) throws IOException {
        String[] commands = new String[]{command};
        IOSCmdResponse[] responses = comm.config(commands);
        if (responses == null || responses.length < 1) {
            return null;
        }
        return XDMDiscovery.getOptionsSupportedOnCmd(responses[0], options);
    }

    public static boolean[] getOptionsSupportedOnInterfaceCmd(IOSCmdService comm, String ifKey, String command, String[] options) throws IOException {
        String[] commands = new String[]{"interface " + ifKey, command};
        IOSCmdResponse[] responses = comm.config(commands);
        if (responses == null || responses.length < 1) {
            return null;
        }
        String buf = null;
        buf = responses[1].getOutput();
        boolean[] ret = new boolean[options.length];
        if (responses[1].getStatus() != 2 && buf != null && buf.indexOf("% Unrecognized command") < 0) {
            int i = 0;
            while (i < options.length) {
                ret[i] = buf.indexOf(options[i]) >= 0;
                ++i;
            }
        }
        return ret;
    }

    public static InputStream getRunningConfig(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{SHOW_RUN};
        IOSCmdResponse[] reply = comm.exec(cmd);
        if (reply[0].getOutput() == null || reply[0].getOutput().length() == 0 || reply[0].getOutput().indexOf(QOS_INTF) == -1) {
            reply = comm.exec(cmd);
        }
        return new StringBufferInputStream(reply[0].getOutput());
    }

    public static int getSchedulerInterruptTime(IOSCmdService comm) throws IOException {
        String[] cmds = new String[]{"scheduler allocate ?"};
        if (schedulerInterrupt != -1) {
            return schedulerInterrupt;
        }
        try {
            String result;
            String value;
            IOSCmdResponse[] resp_1 = comm.config(cmds);
            if (XDMDiscovery.isOKResponse(resp_1) && (value = (result = resp_1[0].getOutput().trim()).substring(1, result.indexOf(45))) != null && value.length() != 0) {
                schedulerInterrupt = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schedulerInterrupt;
    }

    public static String getShIPIntBrfCmdOut(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{"show ip interface brief"};
        IOSCmdResponse[] reply = comm.exec(cmd);
        return reply[0].getOutput();
    }

    private static DiagInfo[] getShowDiag(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{SHOW_DIAG};
        IOSCmdResponse[] reply = comm.exec(cmd);
        return ShowCmdParser.parseShowDiag(new StringBufferInputStream(reply[0].getOutput()));
    }

    private static DiagInfo[] getShowDiag(String shDiag) throws IOException {
        FileInputStream in = new FileInputStream(shDiag);
        return ShowCmdParser.parseShowDiag(in);
    }

    public static boolean isAnyDebugOn(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{SHOW_DEBUGGING};
        IOSCmdResponse[] reply = comm.exec(cmd);
        boolean ret = false;
        if (reply[0].getStatus() != 2) {
            String buf = reply[0].getOutput();
            ret = buf != null && buf.indexOf(" on") >= 0;
        }
        return ret;
    }

    public static boolean isDDNSDHCPCmdSupported(IOSCmdService comm, String subIntfName) {
        try {
            String[] cmd = new String[]{"interface " + subIntfName + " point-to-point", "ip dhcp client update ?"};
            boolean[] status = XDMDiscovery.getCommandsSupported(comm, cmd);
            if (status[1]) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean isDDNSSubCmdSupported(IOSCmdService comm, String subIntfName, boolean isWizardMode) {
        if (ddnsHash.size() > 0) {
            return (Boolean)ddnsHash.get("atm");
        }
        boolean status = XDMDiscovery.isDDNSDHCPCmdSupported(comm, subIntfName);
        ddnsHash.put("atm", new Boolean(status));
        try {
            if (isWizardMode) {
                comm.config(new String[]{"no " + subIntfName});
            }
        }
        catch (Exception exception) {}
        return status;
    }

    public static boolean isDiscoverATMPVCSupported(IOSCmdService comm) {
        try {
            IOSCmdResponse[] resp = comm.exec(new String[]{DISCOVER_ATM_PVC});
            if (!XDMDiscovery.isOKResponse(resp[0])) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isDynamicDNSSupported(IOSCmdService comm) {
        try {
            IOSCmdResponse[] resp = comm.exec(new String[]{IP_DDNS_CMD});
            if (!XDMDiscovery.isOKResponse(resp[0])) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isEVR401OptionSupported(IOSCmdService comm) {
        boolean support = false;
        try {
            String[] configCmds = new String[]{CRYPTO_CLIENT_EZVPN, "xauth userid mode http-intercept 4?"};
            IOSCmdResponse[] reply = comm.config(configCmds);
            support = XDMDiscovery.getOptionSupportedOnCmd(reply[reply.length - 1], "401");
            String[] negateCmds = new String[]{"no crypto ipsec client ezvpn test_ezvpn_config_created_for_sdm"};
            comm.config(negateCmds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return support;
    }

    public static boolean isIDSVersion(IOSCmdService comm) {
        String[] key = new String[]{"ips"};
        boolean ips = XDMDiscovery.findFromExecOutput(comm, "show subsys", key);
        String output = (String)_commands.get("exec - show subsys");
        String version = XDMDiscovery.getByName(output, "ips");
        if (version == null) {
            return false;
        }
        String[] versionVal = StringUtils.split(version);
        if (versionVal.length == 3 && Character.isDigit(versionVal[2].charAt(0))) {
            String cfr_ignored_0 = versionVal[2];
            int intVer = Integer.parseInt(String.valueOf(versionVal[2].charAt(0)));
            ipsMinorVersion = versionVal[2];
            if (intVer >= 2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isIPHCSupported() {
        return m_bIPHCSupported;
    }

    public static boolean isIPSLACommandSupported(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{DIALBACKUP_IP_SLA};
        boolean[] status = XDMDiscovery.getCommandsSupported(comm, cmd);
        return status != null && status[0];
    }

    public static boolean isIPSLAOnlySupported(IOSCmdService comm) throws IOException {
        String[] cmd1 = new String[]{DIALBACKUP_ONLY_IPSLA, DIALBACKUP_ONLY_IPSLA_INTER};
        boolean[] status1 = XDMDiscovery.getCommandsSupported(comm, cmd1);
        int i = 0;
        while (i < status1.length) {
            if (!status1[i]) {
                comm.config(new String[]{"no rtr ?"});
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIPSLASupported(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{DIALBACKUP_IP_SLA};
        boolean[] status = XDMDiscovery.getCommandsSupported(comm, cmd);
        if (status != null && status[0]) {
            String[] cmd1 = new String[]{DIALBACKUP_IP_SLA1, IP_SLA_TYPE_SOURCE_INTER};
            boolean[] status1 = XDMDiscovery.getCommandsSupported(comm, cmd1);
            Object resp = null;
            int i = 0;
            while (i < status1.length) {
                if (!status1[i]) {
                    comm.config(new String[]{"no rtr ?"});
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean[] isNTPandSNTPSupported(IOSCmdService comm) throws IOException {
        boolean[] retBool = new boolean[2];
        String[] key1 = new String[]{NTP};
        retBool[0] = XDMDiscovery.findFromExecOutput(comm, "show subsys", key1);
        String[] key2 = new String[]{SNTP};
        retBool[1] = XDMDiscovery.findFromExecOutput(comm, "show subsys", key2);
        return retBool;
    }

    public static boolean isNbarSupported(IOSCmdService comm) throws IOException {
        IOSCmdResponse[] resp = comm.exec(new String[]{SHOW_IP_NBAR_PROT_DISCOVERY});
        return XDMDiscovery.isOKResponse(resp[0]);
    }

    public static boolean isOKResponse(IOSCmdResponse resp) {
        if (resp == null) {
            return false;
        }
        int status = resp.getStatus();
        return status == 1 || status == 0 && resp.getOutput().indexOf("Invalid input") == -1 && resp.getOutput().indexOf(UNSUPPORTED) == -1;
    }

    private static boolean isOKResponse(IOSCmdResponse[] responses) {
        if (responses == null || responses.length < 1) {
            return false;
        }
        int last = responses.length - 1;
        int status = responses[last].getStatus();
        return status == 1 || status == 0 && responses[last].getOutput().indexOf("Invalid input") == -1 && responses[last].getOutput().indexOf(UNSUPPORTED) == -1;
    }

    public static boolean isQoSPreClassifySupported(IOSCmdService comm) throws IOException {
        String strCLIView = XDMDiscovery.getCLIViewName(comm);
        if (strCLIView != null && strCLIView.trim().length() > 0 && CLIViewType.getType(strCLIView) != 7) {
            return true;
        }
        String[] cmd = null;
        IOSCmdResponse[] resp = null;
        boolean[] status = null;
        int responseStatus = 0;
        boolean intfTunnel555555555Exists = false;
        cmd = new String[]{"show interfacesTunnel555555555"};
        resp = comm.exec(cmd);
        responseStatus = resp[0].getStatus();
        intfTunnel555555555Exists = responseStatus == 1 || responseStatus == 0 && resp[0].getOutput().indexOf("Invalid input") == -1 && resp[0].getOutput().indexOf(UNSUPPORTED) == -1;
        cmd = new String[]{"interface Tunnel 555555555", QOS_PRE_CLASSIFY};
        status = XDMDiscovery.getCommandsSupported(comm, cmd);
        if (intfTunnel555555555Exists) {
            if (!status[1]) {
                return false;
            }
            cmd = new String[]{"interface Tunnel 555555555", "no qos pre-classify"};
            comm.config(cmd);
        } else {
            if (!status[1]) {
                return false;
            }
            cmd = new String[]{"no interface Tunnel 555555555"};
            comm.config(cmd);
        }
        return true;
    }

    public static boolean isQoSSupported(IOSCmdService comm, String iosVersion) throws IOException {
        boolean nbarSupported = XDMDiscovery.isNbarSupported(comm);
        if (!nbarSupported) {
            return false;
        }
        String strCLIView = XDMDiscovery.getCLIViewName(comm);
        if (strCLIView != null && strCLIView.trim().length() > 0 && CLIViewType.getType(strCLIView) != 7 && nbarSupported) {
            return true;
        }
        if (iosVersion.indexOf("12.2") == -1) {
            return true;
        }
        String[] cmd = new String[]{QOS_CLASS_MAP, QOS_CLASS_MAP_MATCH_PROTOCOL};
        boolean[] status = XDMDiscovery.getCommandsSupported(comm, cmd);
        Object resp = null;
        int i = 0;
        while (i < status.length) {
            if (!status[i]) {
                comm.config(new String[]{"no class-map match-any test_class_map_for_sdm"});
                return false;
            }
            ++i;
        }
        cmd = new String[]{QOS_POLICY_MAP, QOS_POLICY_MAP_C};
        status = XDMDiscovery.getCommandsSupported(comm, cmd);
        int i2 = 0;
        while (i2 < status.length) {
            if (!status[i2]) {
                comm.config(new String[]{"no policy-map test_policy_map_for_sdm"});
                comm.config(new String[]{"no class-map match-any test_class_map_for_sdm"});
                return false;
            }
            ++i2;
        }
        cmd = new String[]{QOS_POLICY_MAP, QOS_POLICY_MAP_C, QOS_POLICY_MAP_C_PRIO_PERCENT};
        status = XDMDiscovery.getCommandsSupported(comm, cmd);
        if (!status[2]) {
            comm.config(new String[]{"no policy-map test_policy_map_for_sdm"});
            comm.config(new String[]{"no class-map match-any test_class_map_for_sdm"});
            return false;
        }
        cmd = new String[]{QOS_POLICY_MAP, QOS_POLICY_MAP_C, "no priority percent 5", QOS_POLICY_MAP_C_BW_PERCENT};
        status = XDMDiscovery.getCommandsSupported(comm, cmd);
        if (!status[3]) {
            comm.config(new String[]{"no policy-map test_policy_map_for_sdm"});
            comm.config(new String[]{"no class-map match-any test_class_map_for_sdm"});
            return false;
        }
        cmd = new String[]{QOS_POLICY_MAP, QOS_POLICY_MAP_C, QOS_POLICY_MAP_C_SET_DSCP, QOS_POLICY_MAP_C_CRTP, QOS_POLICY_MAP_C_SERVICE_POLICY};
        status = XDMDiscovery.getCommandsSupported(comm, cmd);
        int i3 = 0;
        while (i3 < status.length) {
            if (!status[i3]) {
                if (i3 == 3) {
                    m_bIPHCSupported = false;
                } else {
                    comm.config(new String[]{"no policy-map test_policy_map_for_sdm"});
                    comm.config(new String[]{"no class-map match-any test_class_map_for_sdm"});
                    return false;
                }
            }
            ++i3;
        }
        comm.config(new String[]{"no policy-map test_policy_map_for_sdm"});
        comm.config(new String[]{"no class-map match-any test_class_map_for_sdm"});
        return true;
    }

    public static boolean isRTRCommandSupported(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{DIALBACKUP_RTR};
        boolean[] status = XDMDiscovery.getCommandsSupported(comm, cmd);
        return status != null && status[0];
    }

    public static boolean isRTRSupported(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{DIALBACKUP_RTR};
        boolean[] status = XDMDiscovery.getCommandsSupported(comm, cmd);
        if (status != null && status[0]) {
            String[] cmd1 = new String[]{DIALBACKUP_RTR1, IP_RTR_TYPE_SOURCE_INTER};
            boolean[] status1 = XDMDiscovery.getCommandsSupported(comm, cmd1);
            Object resp = null;
            int i = 0;
            while (i < status1.length) {
                if (!status1[i]) {
                    comm.config(new String[]{"no rtr ?"});
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isUSBDeviceSupported(IOSCmdService comm) throws IOException {
        String[] cmd = new String[]{USB_DEVICE_SUPPORTS};
        try {
            IOSCmdResponse[] resp = comm.exec(cmd);
            if (!XDMDiscovery.isOKResponse(resp[0])) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isWirelessRouter(IOSCmdService comm) {
        try {
            IOSCmdResponse[] resp = comm.exec(new String[]{"show ip interface brief"});
            String response = resp[0].getOutput();
            if (response.indexOf(DOT11RADIO) == -1) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static Integer[] parseResponse(String buffRange) {
        Integer[] buffValues = new Integer[]{new Integer(-1), new Integer(-1)};
        int start1 = buffRange.indexOf(60);
        int end1 = buffRange.indexOf(62);
        String x1 = buffRange.substring(start1, end1 + 1);
        int index = x1.indexOf(45);
        buffValues[0] = Integer.valueOf(x1.substring(1, index));
        buffValues[1] = Integer.valueOf(x1.substring(index + 1, x1.length() - 1));
        return buffValues;
    }

    private static void removeDummyTrustpoint() {
        String url = new String("/level/15/configure/-/no/crypto/ca/trustpoint/test_trustpoint_config_created_for_sdm");
        try {
            String result = HTTPService.getInstance().getContentAsString(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

