/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.discovery;

import com.cisco.xdm.data.discovery.ControllerType;
import com.cisco.xdm.data.discovery.HWComponent;
import com.cisco.xdm.data.discovery.HWDevice;
import com.cisco.xdm.data.discovery.HWDictionary;
import com.cisco.xdm.data.discovery.HWEntity;
import com.cisco.xdm.data.discovery.IfType;
import com.cisco.xdm.xmlparser.Frame;
import com.cisco.xdm.xmlparser.XDMObjectHandler;
import java.util.Hashtable;
import java.util.Vector;

public class XDMHWDictionaryHandler
implements XDMObjectHandler {
    public static final String TAG_INTERFACES = "interfaces";
    public static final String TAG_INTERFACE = "interface";
    public static final String TAG_WICS = "wics";
    public static final String TAG_NETWORK_MODULES = "networkmodules";
    public static final String TAG_DEVICES = "devices";
    public static final String TAG_WIC = "wic";
    public static final String TAG_NM = "networkmodule";
    public static final String TAG_DEVICE = "device";
    public static final String TAG_OTHERMODULE = "othermodule";
    public static final String TAG_IFS = "ifs";
    public static final String TAG_ATTR = "attr";
    public static final String TAG_CONTROLLERS = "controllers";
    public static final String TAG_CONTROLLER = "controller";
    public static final String TAG_CNTL = "cntl";
    Vector currentObj = new Vector();
    Hashtable currentHt = null;
    Hashtable currentIfAttrs = null;
    HWDictionary _dictionary;
    boolean dbg;

    public XDMHWDictionaryHandler() {
        this._dictionary = HWDictionary.GetInstance();
        this.dbg = false;
    }

    public XDMHWDictionaryHandler(HWDictionary dictionary) {
        this.currentHt = new Hashtable();
        this._dictionary = dictionary;
        this.dbg = false;
    }

    public void printHWDictionary() {
        System.out.println("printing HWDictionary\n");
        this._dictionary.print();
        System.out.println("\nDone printing HWDictionary\n");
    }

    public void recieveXMLObject(Object obj, Object parent) {
        Integer wicCount;
        Integer ifType;
        String topOfStack = "";
        Frame f = (Frame)obj;
        if (parent != null) {
            topOfStack = ((Frame)parent).name;
        }
        if (this.dbg) {
            System.out.println("Inside reieveXMLObject");
            System.out.println("topofstack = " + topOfStack);
            System.out.println("Current obj = " + f.name);
            System.out.println();
        }
        if (topOfStack.equals(TAG_INTERFACES)) {
            String str;
            ifType = new Integer((String)f.attrs.get("type"));
            if (this.dbg) {
                System.out.println("iftype = " + ifType);
            }
            boolean support = false;
            if (f.attrs.containsKey("support") && (str = (String)f.attrs.get("support")).equalsIgnoreCase("yes")) {
                support = true;
            }
            IfType type = new IfType(ifType, (String)f.attrs.get("name"), (String)f.attrs.get("gif"), (String)f.attrs.get("phrase"), support, this.currentIfAttrs);
            this.currentIfAttrs = null;
            this._dictionary.addInterfaceType(ifType, type);
        }
        if (topOfStack.equals(TAG_CONTROLLERS)) {
            String str;
            Integer cType = new Integer((String)f.attrs.get("type"));
            if (this.dbg) {
                System.out.println("cType = " + cType);
            }
            boolean support = false;
            if (f.attrs.containsKey("support") && (str = (String)f.attrs.get("support")).equalsIgnoreCase("yes")) {
                support = true;
            }
            ControllerType type = new ControllerType(cType, (String)f.attrs.get("name"), (String)f.attrs.get("gif"), (String)f.attrs.get("phrase"), support, this.currentIfAttrs);
            this.currentIfAttrs = null;
            this._dictionary.addControllerType(cType, type);
        }
        if (topOfStack.equals(TAG_INTERFACE) && f.name.equals(TAG_ATTR) && f.attrs.containsKey("name") && f.attrs.containsKey("value")) {
            if (this.currentIfAttrs == null) {
                this.currentIfAttrs = new Hashtable();
            }
            this.currentIfAttrs.put(f.attrs.get("name"), f.attrs.get("value"));
        }
        if (topOfStack.equals(TAG_WIC) || topOfStack.equals(TAG_NM) || topOfStack.equals(TAG_DEVICE)) {
            if (f.name.equals(TAG_IFS) || f.name.equals(TAG_CNTL)) {
                ifType = new Integer((String)f.attrs.get("type"));
                Integer ifCount = new Integer((String)f.attrs.get("count"));
                HWComponent comp = new HWComponent(ifType, ifCount);
                this.currentObj.addElement(comp);
            } else if (f.name.equals(TAG_OTHERMODULE)) {
                this.currentHt.put(f.attrs.get("phrase"), f.attrs.get("partno"));
            }
        }
        if (topOfStack.equals(TAG_WICS)) {
            HWEntity ent = new HWEntity(2, (String)f.attrs.get("name"), (String)f.attrs.get("label"), (String)f.attrs.get("partno"), (String)f.attrs.get("family"));
            if (!this.currentObj.isEmpty()) {
                ent.setHWComponents(this.currentObj);
                this.currentObj.removeAllElements();
            }
            if (this.currentHt != null && this.currentHt.size() > 0) {
                ent.setExtras(this.currentHt);
                this.currentHt = new Hashtable();
            }
            this._dictionary.addWIC((String)f.attrs.get("partno"), ent);
        }
        if (topOfStack.equals(TAG_NETWORK_MODULES)) {
            HWEntity ent = new HWEntity(1, (String)f.attrs.get("name"), (String)f.attrs.get("label"), (String)f.attrs.get("partno"), (String)f.attrs.get("family"));
            if (f.attrs.get("wic-count") != null) {
                wicCount = new Integer((String)f.attrs.get("wic-count"));
                HWComponent wic = new HWComponent(-2, wicCount);
                ent.addHWComponent(wic);
            }
            if (!this.currentObj.isEmpty()) {
                ent.setHWComponents(this.currentObj);
                this.currentObj.removeAllElements();
            }
            if (this.currentHt != null && this.currentHt.size() > 0) {
                ent.setExtras(this.currentHt);
                this.currentHt = new Hashtable();
            }
            this._dictionary.addNM((String)f.attrs.get("partno"), ent);
        }
        if (topOfStack.equals(TAG_DEVICES)) {
            String auxBackup;
            String wan;
            String lan;
            Hashtable<String, String> ht = new Hashtable<String, String>();
            String ifNumbering3 = (String)f.attrs.get("ifNumbering3");
            if (ifNumbering3 != null) {
                ht.put("ifNumbering3", ifNumbering3);
            }
            if ((lan = (String)f.attrs.get("LAN")) != null) {
                ht.put("LAN", lan);
            }
            if ((wan = (String)f.attrs.get("WAN")) != null) {
                ht.put("WAN", wan);
            }
            if ((auxBackup = (String)f.attrs.get("AuxBackup")) != null) {
                ht.put("AuxBackup", auxBackup);
            }
            HWDevice ent = f.attrs.get("Mainboard") != null ? new HWDevice((String)f.attrs.get("Mainboard"), (String)f.attrs.get("MainboardSlot"), 0, (String)f.attrs.get("name"), (String)f.attrs.get("label"), (String)f.attrs.get("family"), ht) : new HWDevice(0, (String)f.attrs.get("name"), (String)f.attrs.get("label"), (String)f.attrs.get("family"), ht);
            if (f.attrs.get("wic-count") != null) {
                wicCount = new Integer((String)f.attrs.get("wic-count"));
                HWComponent wic = new HWComponent(-2, wicCount);
                ent.addHWComponent(wic);
            }
            if (f.attrs.get("nm-count") != null) {
                Integer nmCount = new Integer((String)f.attrs.get("nm-count"));
                HWComponent nm = new HWComponent(-1, nmCount);
                ent.addHWComponent(nm);
            }
            if (!this.currentObj.isEmpty()) {
                ent.setHWComponents(this.currentObj);
                this.currentObj.removeAllElements();
            }
            this._dictionary.addDevice((String)f.attrs.get("name"), ent);
        }
    }
}

