/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.Description;
import com.cisco.xdm.data.dialer.DialerList;
import com.cisco.xdm.data.dialer.DialerListCollection;
import com.cisco.xdm.data.interfaces.Dialer;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import java.util.Enumeration;
import java.util.Vector;

public class Async
extends XDMInterface {
    private String _asyncMode = "";
    private String _encapsulation = "";
    private String _dialerInband = "";
    private int _poolNumber = -1;
    private Dialer _logicalIf = null;
    private boolean _isMultilink;
    private boolean isUnSupportedConfig;
    private boolean isMultipleDialer;
    private boolean isAsyncModeOthers;
    private boolean isDialerGroup;
    public static final int ENCAPSET = 0;
    public static final int ENCAPNOTSET = 1;
    public static final int ENCAPOTHERS = 2;
    private int encap = 1;
    public static final String KEY_ENCAPSULATION = "encapsulation";
    public static final String KEY_ENCAP = "encapType";
    public static final String KEY_PPP = "ppp";
    public static final String KEY_DIALER = "dialer";
    public static final String KEY_DIALPOOLMEMBER = "pool-member";
    public static final String KEY_POOLMEMBER = "poolmemberkey";
    public static final String KEY_INBAND = "in-band";
    public static final String KEY_ASYNC = "async";
    public static final String KEY_MODE = "mode";
    public static final String KEY_DEDICATED = "dedicated";
    private static final String BACKUP_FLAG = "$BACKUP_INTF_";
    private Dialer _backUpLogicalIf = null;

    public Async(IfID id) {
        super(id);
        this.setSupport(0, 1);
        this.setSupport(1, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 0);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public boolean canSubIf() {
        return false;
    }

    public Object clone() {
        Async async = (Async)super.clone();
        async._asyncMode = this._asyncMode;
        async._dialerInband = this._dialerInband;
        async._encapsulation = this._encapsulation;
        async._logicalIf = this._logicalIf;
        async._poolNumber = this._poolNumber;
        return async;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Async) || !super.equals(obj)) {
            return false;
        }
        Async async = (Async)obj;
        return async.getPoolNumber() == this._poolNumber && async.getEncapsulation().equals(this._encapsulation) && async.getAsyncMode().equals(this._asyncMode);
    }

    public void generateAsyncDelta(XDMObject backup, CmdValues parent) throws XDMException {
        Async asyncBackup = null;
        if (backup instanceof Async) {
            asyncBackup = (Async)backup;
        }
        ConfigValues cv = parent.getModeCmdsValues();
        CmdValues cmd = null;
        if (cv == null) {
            cv = new ConfigValues();
        }
        if (this.isModified()) {
            if (asyncBackup != null && asyncBackup.getAsyncMode() != this.getAsyncMode()) {
                cmd = new CmdValues(KEY_ASYNC);
                cmd.addValue(KEY_MODE, KEY_MODE);
                cmd.addValue(KEY_DEDICATED, KEY_DEDICATED);
                if (this.getAsyncMode() == null || this.getAsyncMode().trim().length() == 0) {
                    cmd.setAction(2);
                }
                cv.addCmdValues(cmd);
            }
            if (asyncBackup != null && asyncBackup.getEncapsulation() != this.getEncapsulation()) {
                cmd = new CmdValues(KEY_ENCAPSULATION);
                cmd.addValue(KEY_ENCAP, KEY_PPP);
                if (this.getEncapsulation() == null || this.getEncapsulation().trim().length() == 0) {
                    cmd.setAction(2);
                }
                cv.addCmdValues(cmd);
            }
            if (asyncBackup != null && asyncBackup.getDialerInband() != this.getDialerInband()) {
                cmd = new CmdValues(KEY_DIALER);
                cmd.addValue(KEY_INBAND, KEY_INBAND);
                if (this.getDialerInband() == null || this.getDialerInband().trim().length() == 0) {
                    cmd.setAction(2);
                }
                cv.addCmdValues(cmd);
            }
            if (asyncBackup != null && asyncBackup.getPoolNumber() != this.getPoolNumber()) {
                cmd = new CmdValues(KEY_DIALER);
                cmd.addValue(KEY_DIALPOOLMEMBER, KEY_DIALPOOLMEMBER);
                if (this.getPoolNumber() == -1) {
                    cmd.addValue(KEY_POOLMEMBER, String.valueOf(asyncBackup._poolNumber));
                    cmd.setAction(2);
                } else {
                    cmd.addValue(KEY_POOLMEMBER, String.valueOf(this._poolNumber));
                }
                cv.addCmdValues(cmd);
            }
            if (asyncBackup != null && asyncBackup._isMultilink != this._isMultilink) {
                cmd = new CmdValues(KEY_PPP);
                cmd.addValue("multilink", "multilink");
                if (this._isMultilink) {
                    cmd.setAction(1);
                } else {
                    cmd.setAction(2);
                }
                cv.addCmdValues(cmd);
            }
        }
        if (!cv.isEmpty()) {
            parent.setModeCmdsValues(cv);
        }
    }

    private void generateAuxDelta(XDMObject backup, CmdValues parent) throws XDMException {
        Async asyncBackup = null;
        if (backup instanceof Async) {
            asyncBackup = (Async)backup;
        }
        boolean blnExist = false;
        XDMInterfaces ifs = ((DeviceBase)this.getDevice()).getIfs();
        Enumeration enumeration = ifs.elements();
        while (enumeration.hasMoreElements()) {
            XDMInterface If = (XDMInterface)enumeration.nextElement();
            if (If.getIfID().getType() != 1009) continue;
            blnExist = true;
        }
        if (blnExist) {
            ConfigValues cv = parent.getModeCmdsValues();
            CmdValues cmd = null;
            if (cv == null) {
                cv = new ConfigValues();
            }
            if (this.isModified()) {
                if (asyncBackup != null && asyncBackup.getAsyncMode() != this.getAsyncMode()) {
                    cmd = new CmdValues(KEY_ASYNC);
                    cmd.addValue(KEY_MODE, KEY_MODE);
                    cmd.addValue(KEY_DEDICATED, KEY_DEDICATED);
                    if (this.getAsyncMode() == null || this.getAsyncMode().trim().length() == 0) {
                        cmd.setAction(2);
                    }
                    cv.addCmdValues(cmd);
                } else if (this.getPoolNumber() != -1) {
                    cmd = new CmdValues(KEY_ASYNC);
                    cmd.addValue(KEY_MODE, KEY_MODE);
                    cmd.addValue(KEY_DEDICATED, KEY_DEDICATED);
                    cv.addCmdValues(cmd);
                }
                if (asyncBackup != null && asyncBackup.getEncapsulation() != this.getEncapsulation()) {
                    cmd = new CmdValues(KEY_ENCAPSULATION);
                    cmd.addValue(KEY_ENCAP, KEY_PPP);
                    if (this.getEncapsulation() == null || this.getEncapsulation().trim().length() == 0) {
                        cmd.setAction(2);
                    }
                    cv.addCmdValues(cmd);
                } else if (this.getPoolNumber() != -1) {
                    cmd = new CmdValues(KEY_ENCAPSULATION);
                    cmd.addValue(KEY_ENCAP, KEY_PPP);
                    cv.addCmdValues(cmd);
                }
                if (asyncBackup != null && asyncBackup.getDialerInband() != this.getDialerInband()) {
                    cmd = new CmdValues(KEY_DIALER);
                    cmd.addValue(KEY_INBAND, KEY_INBAND);
                    if (this.getDialerInband() == null || this.getDialerInband().trim().length() == 0) {
                        cmd.setAction(2);
                    }
                    cv.addCmdValues(cmd);
                } else if (this.getPoolNumber() != -1) {
                    cmd = new CmdValues(KEY_DIALER);
                    cmd.addValue(KEY_INBAND, KEY_INBAND);
                    cv.addCmdValues(cmd);
                }
                if (asyncBackup != null && asyncBackup.getPoolNumber() != this.getPoolNumber()) {
                    cmd = new CmdValues(KEY_DIALER);
                    cmd.addValue(KEY_DIALPOOLMEMBER, KEY_DIALPOOLMEMBER);
                    if (this.getPoolNumber() == -1) {
                        cmd.addValue(KEY_POOLMEMBER, String.valueOf(asyncBackup._poolNumber));
                        cmd.setAction(2);
                    } else {
                        cmd.addValue(KEY_POOLMEMBER, String.valueOf(this._poolNumber));
                    }
                    cv.addCmdValues(cmd);
                } else if (this.getPoolNumber() != -1) {
                    cmd = new CmdValues(KEY_DIALER);
                    cmd.addValue(KEY_DIALPOOLMEMBER, KEY_DIALPOOLMEMBER);
                    cmd.addValue(KEY_POOLMEMBER, String.valueOf(this._poolNumber));
                    cv.addCmdValues(cmd);
                }
                if (asyncBackup != null && asyncBackup._isMultilink != this._isMultilink) {
                    cmd = new CmdValues(KEY_PPP);
                    cmd.addValue("multilink", "multilink");
                    if (this._isMultilink) {
                        cmd.setAction(1);
                    } else {
                        cmd.setAction(2);
                    }
                    cv.addCmdValues(cmd);
                }
                if (!cv.isEmpty()) {
                    parent.setModeCmdsValues(cv);
                }
            }
        }
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        if (backup == null) {
            this.generateAuxDelta(backup, cmdVal);
        } else {
            this.generateAsyncDelta(backup, cmdVal);
        }
    }

    public String getAsyncDesc() {
        return Description.getFlagContent(this.getDesc(), BACKUP_FLAG);
    }

    public String getAsyncMode() {
        return this._asyncMode;
    }

    public Dialer getBackupLogicalIf() {
        Dialer dialerIntf = this._backUpLogicalIf != null ? this._backUpLogicalIf : (Dialer)this.getLogicalIf();
        return dialerIntf;
    }

    public String getDialerInband() {
        return this._dialerInband;
    }

    public String getEncapsulation() {
        return this._encapsulation;
    }

    protected Vector getFlags() {
        Vector flags = super.getFlags();
        flags.addElement(BACKUP_FLAG);
        return flags;
    }

    public XDMInterfaceBase getLogicalIf() {
        Vector ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1001);
        Enumeration enumeration = ifs.elements();
        while (enumeration.hasMoreElements()) {
            Dialer item = (Dialer)enumeration.nextElement();
            if (item.getDialPoolNumber() != this._poolNumber) continue;
            this._logicalIf = item;
            break;
        }
        Log.getLog().debug(" ########### The Logical Interface is : ##### " + this._logicalIf);
        return this._logicalIf;
    }

    public int getPoolNumber() {
        return this._poolNumber;
    }

    public boolean isConfigurable() {
        boolean result = super.isConfigurable();
        if (this.isReadOnly()) {
            return false;
        }
        if (this.getIpAddr() != null) {
            this.setConfigurable(false);
            Log.getLog().debug("################IP Address Under Async -- Async made readonly ");
            return false;
        }
        if (this.encap == 2) {
            this.setConfigurable(false);
            Log.getLog().debug("######################Encapsulation is other than ppp -- Async made read only ");
            return false;
        }
        if (this.isAsyncModeOthers) {
            this.setConfigurable(false);
            Log.getLog().debug("######################Asyc Mode is not dedicated -- Async made read only ");
            return false;
        }
        if (this.isDialerGroup && this._poolNumber == -1) {
            this.setConfigurable(false);
            Log.getLog().debug("##################SDM detects unsupported configuration under Async -- Async made read only");
            Log.getLog().debug("##################Reason : Dialer group present and dialer pool not present ");
            return false;
        }
        if (this.isUnSupportedConfig) {
            this.setConfigurable(false);
            Log.getLog().debug("##################SDM detects unsupported configuration under Async -- Async made read only");
            return false;
        }
        if (this._poolNumber > 0) {
            Dialer dialerIf;
            XDMInterfaceBase baseIf = this.getLogicalIf();
            if (baseIf == null) {
                this.setConfigurable(false);
                Log.getLog().debug("####################### Async with out a associated Dialer -- Async made read only");
                return false;
            }
            if (this.encap == 1) {
                this.setConfigurable(false);
                Log.getLog().debug("################### Async has a Dialer with some other encapsulation -- Async made read only");
                return false;
            }
            if (!(baseIf == null || (dialerIf = (Dialer)baseIf).getEncapsulation() != null && dialerIf.getEncapsulation().equals(KEY_PPP))) {
                this.setConfigurable(false);
                Log.getLog().debug("################## Associated Dialer has encapsulation other than ppp -- Async made read only");
            }
            if (baseIf != null) {
                DialerList dialerList;
                Dialer dialer = (Dialer)baseIf;
                int group = dialer.getDialerGroup();
                DialerListCollection dlc = ((DeviceBase)this.getDevice()).getDialerListCollection();
                if (dlc != null && (dialerList = (DialerList)dlc.get(String.valueOf(group) + "ip")) == null) {
                    this.setConfigurable(false);
                    Log.getLog().debug("##################SDM detects Dialer group command under Dialer but the dialer list is not present -- Async made read only");
                    return false;
                }
            }
        }
        if (this.isMultipleDialer) {
            this.setConfigurable(false);
            Log.getLog().debug("##################SDM detects Multiple Dialer for this Async -- Async made read only");
            return false;
        }
        return result;
    }

    public boolean isConfigured() {
        if (this.getLogicalIf() == null) {
            return false;
        }
        return this.getLogicalIf().getIpAddr() != null;
    }

    public boolean isMultilink() {
        return this._isMultilink;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        ConfigValues cmds = cmdVal.getModeCmdsValues();
        Log.getLog().debug(" **** Async Interface Populate ");
        int numberOfCmds = cmds.numCmds();
        this.isMultipleDialer = false;
        this.isUnSupportedConfig = false;
        this.isAsyncModeOthers = false;
        this.isDialerGroup = false;
        ConfigValues cv = cmds.getCmds(KEY_DIALER, KEY_DIALPOOLMEMBER, ".*", false);
        if (cv != null && cv.numCmds() > 1) {
            this.isMultipleDialer = true;
        }
        int i = 0;
        while (i < numberOfCmds) {
            String pn;
            CmdValues eachCmdValue = cmds.getCmdValues(i);
            String cmdName = eachCmdValue.getCmdName();
            if (cmdName.equals(KEY_ASYNC) && eachCmdValue.containsKey(KEY_MODE)) {
                if (eachCmdValue.containsKey(KEY_DEDICATED)) {
                    this._asyncMode = KEY_DEDICATED;
                } else {
                    this.isAsyncModeOthers = true;
                }
            }
            if (cmdName.equals(KEY_DIALER) && eachCmdValue.containsKey(KEY_INBAND)) {
                this._dialerInband = KEY_INBAND;
            }
            if (cmdName.equals(KEY_ENCAPSULATION)) {
                this._encapsulation = eachCmdValue.getValue(KEY_ENCAP);
                if (this._encapsulation != null) {
                    this.encap = this._encapsulation.equals(KEY_PPP) ? 0 : 2;
                } else {
                    this._encapsulation = "";
                }
            }
            if (cmdName.equals(KEY_DIALER) && eachCmdValue.containsKey(KEY_DIALPOOLMEMBER) && (pn = eachCmdValue.getValue(KEY_POOLMEMBER)) != null && pn.trim().length() != 0) {
                this._poolNumber = Integer.parseInt(pn);
            }
            ++i;
        }
        cv = cmds.getCmds(KEY_DIALER, "rotary-group", ".*", false);
        if (cv != null) {
            this.isUnSupportedConfig = true;
        }
        if ((cv = cmds.getCmds(KEY_DIALER, "map", ".*", false)) != null) {
            this.isUnSupportedConfig = true;
        }
        if ((cv = cmds.getCmds(KEY_DIALER, "mult-map-same-name", ".*", false)) != null) {
            this.isUnSupportedConfig = true;
        }
        if ((cv = cmds.getCmds("dialer-group", ".*", ".*", false)) != null) {
            this.isDialerGroup = true;
        }
        if ((cv = cmds.getCmds(KEY_PPP, "multilink", "multilink", false)) != null) {
            int num = cv.numCmds();
            int count = 0;
            while (count < num) {
                CmdValues cmd = cv.getCmdValues(count);
                String extra = cmd.getValue("restOfCmd");
                if (extra != null && extra.length() != 0 && !extra.equals("null")) {
                    this.setReadOnly(true);
                } else {
                    this._isMultilink = true;
                }
                ++count;
            }
        }
        Log.getLog().debug(">>>>**** Async Populate End Valuses Async mode: " + this._asyncMode + " Key Inband : " + this._dialerInband + " Encapsultion : " + this._encapsulation + " Dial Pool member : " + this._poolNumber + " Unsupported config : " + this.isUnSupportedConfig);
    }

    public void resetLogicalIf() {
        if (this._poolNumber == -1) {
            this._logicalIf = null;
        }
    }

    public void setAsyncDesc(String desc) {
        String str = Description.removeFlag(this.getDesc(), BACKUP_FLAG);
        this.setDesc(Description.addFlag(str, desc));
    }

    public void setAsyncMode(String asyncMode) {
        this._asyncMode = asyncMode;
        this.setModified();
    }

    public void setBackupLogicalIf(Dialer backUpLogicalIf) {
        this._backUpLogicalIf = backUpLogicalIf;
    }

    public void setDialerInband(String dialerInband) {
        this._dialerInband = dialerInband;
        this.setModified();
    }

    public void setEncapsulation(String encapsulation) {
        this.encap = 0;
        this._encapsulation = encapsulation;
        this.setModified();
    }

    public void setMultlink(boolean isMultilink) {
        this._isMultilink = isMultilink;
        this.setModified();
    }

    public void setPoolNumber(int poolNumber) {
        this._poolNumber = poolNumber;
        this.setModified();
    }
}

