/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.AdslInfo;
import com.cisco.xdm.data.atm.AdslOverIsdnInfo;
import com.cisco.xdm.data.atm.AtmHelper;
import com.cisco.xdm.data.atm.DslInfo;
import com.cisco.xdm.data.atm.PvcCollection;
import com.cisco.xdm.data.atm.ShdslInfo;
import com.cisco.xdm.data.base.DevInfoBase;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.AtmSubInterface;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.util.Enumeration;

public class Atm
extends XDMInterface {
    private AtmHelper _atm = new AtmHelper(this, false);
    private DslInfo _dsl;
    private long _vpimin = 0L;
    private long _vpimax = 255L;
    private long _vcimin = 1L;
    private long _vcimax = 255L;
    private boolean _pvcDefaults = false;

    public Atm(IfID ifID) {
        super(ifID);
        Log.getLog().debug("Atm() " + this.getIfID());
        this.setSupport(0, 1);
        this.setSupport(1, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 0);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
        if (this.getIfID().getType() == 504) {
            this._dsl = new ShdslInfo(this, false);
        }
        if (this.getIfID().getType() == 503) {
            this._dsl = new AdslInfo(this, false);
        }
        if (this.getIfID().getType() == 532) {
            this._dsl = new AdslOverIsdnInfo(this, false);
        }
    }

    public boolean canSubIf() {
        return true;
    }

    public Object clone() {
        Log.getLog().debug("clone() " + this.getIfID());
        Atm newIf = (Atm)super.clone();
        if (this._atm != null) {
            newIf._atm = (AtmHelper)this._atm.clone();
            newIf._atm.setParent(newIf);
        }
        if (this._dsl != null) {
            newIf._dsl = (DslInfo)this._dsl.clone();
            newIf._dsl.setParent(newIf);
        }
        return newIf;
    }

    public boolean containsPvc(int vpi, int vci) {
        Log.getLog().info("containsPvc() " + this.getIfID());
        if (this._atm.containsPvc(vpi, vci)) {
            Log.getLog().warn("containsPvc(): Main interface already contains this PVC " + vpi + "/" + vci + " " + this.getIfID());
            return true;
        }
        XDMSubInterfaces subifs = this.getSubInterfaces();
        Enumeration e = subifs.elements();
        while (e.hasMoreElements()) {
            AtmSubInterface asub = (AtmSubInterface)e.nextElement();
            if (!asub.containsPvc(vpi, vci)) continue;
            Log.getLog().warn("containsPvc(): SubInterface already contains this PVC " + vpi + "/" + vci + " " + this.getIfID());
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getIfID());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Atm ifObj = (Atm)obj;
            return this._atm.equals(ifObj._atm) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(CmdValues parent) throws XDMException {
        Log.getLog().info("generateAddCmd() " + this.getIfID());
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        this._atm.generateDelta(null, cv);
        if (this._dsl != null) {
            this._dsl.generateDelta(null, cv);
        }
        if (!cv.isEmpty()) {
            Log.getLog().debug("generateAddCmd(): cv is " + cv);
            parent.setModeCmdsValues(cv);
        } else {
            Log.getLog().debug("generateAddCmd(): cv is empty " + this.getIfID());
        }
    }

    private void generateChangeCmd(Atm old, CmdValues parent) throws XDMException {
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        this._atm.generateDelta(old._atm, cv);
        if (this._dsl != null) {
            this._dsl.generateDelta(old._dsl, cv);
        }
        if (!cv.isEmpty()) {
            parent.setModeCmdsValues(cv);
            Log.getLog().debug("generateChangeCmd(): cv is " + cv);
        } else {
            Log.getLog().debug("generateChangeCmd(): cv is empty " + this.getIfID());
        }
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        if (!this.isReadOnly() && this.isModified()) {
            Atm backupAtm = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(cmdVal);
                } else {
                    backupAtm = (Atm)backup;
                    this.generateChangeCmd(backupAtm, cmdVal);
                }
            }
        }
    }

    public AtmHelper getAtmHelper() {
        return this._atm;
    }

    public DslInfo getDslInfo() {
        return this._dsl;
    }

    public XDMInterfaceBase getLogicalIf() {
        return this._atm.getLogicalIf();
    }

    public PvcCollection getPvcs() {
        return this._atm.getPvcs();
    }

    public long getVciMax() {
        return this._vcimax;
    }

    public long getVciMin() {
        return this._vcimin;
    }

    public long getVpiMax() {
        return this._vpimax;
    }

    public long getVpiMin() {
        return this._vpimin;
    }

    public boolean isATMConfiguredForPPPoE() {
        return this._atm.isATMConfiguredForPPPoE();
    }

    public boolean isATMConfiguredForRFCMUX() {
        return this._atm.isATMConfiguredForRFCMUX();
    }

    public boolean isATMConfiguredForRFCSNAP() {
        return this._atm.isATMConfiguredForRFCSNAP();
    }

    public boolean isConfigurable() {
        Log.getLog().info("isConfigurable() " + this.getIfID() + " " + this.getClass().getName());
        if (this._atm.getPvcs().size() >= 1 && this.getSubInterfaces().size() >= 1) {
            this.setConfigurable(false);
            this.setROReason(0x7000002);
            Log.getLog().warn("isConfigurable(): 1 PVC on interface and subinterface on Main interface. ATM is non-configurable " + this.getIfID());
            return false;
        }
        this._atm.isATMConnected();
        if (this._atm.isReadOnly()) {
            this.setROReason(this._atm.getROReason());
            this.setConfigurable(false);
        }
        boolean result = super.isConfigurable();
        Log.getLog().info("isConfigurable(): Returning " + result + " for " + this.getIfID());
        if (!result) {
            Log.getLog().info("isConfigurable(): Not-configurable Reason " + Integer.toHexString(this.getROReason()));
        }
        return result;
    }

    public boolean isConfigured() {
        boolean result = this._atm.isATMConnected();
        Log.getLog().info("isConfigured(): Returning " + result + "for ATM interface " + this.getIfID());
        return result;
    }

    public boolean isReset() {
        Log.getLog().info("isReset() " + this.getIfID());
        if (this._dsl.isResetRequired()) {
            Log.getLog().debug("_dsl.isResetRequired():Returning true");
            return true;
        }
        boolean result = super.isReset();
        Log.getLog().debug("isReset():Returning " + result);
        return result;
    }

    private void parseResponse(String pvcrange) {
        Log.getLog().debug("parseResponse(): Pvc Range String is " + pvcrange);
        int start1 = pvcrange.indexOf(60);
        int end1 = pvcrange.indexOf(62);
        String x1 = pvcrange.substring(start1, end1 + 1);
        int index = x1.indexOf(45);
        this._vpimin = Long.parseLong(x1.substring(1, index));
        this._vpimax = Long.parseLong(x1.substring(index + 1, x1.length() - 1));
        int start2 = pvcrange.indexOf(60, end1 + 1);
        int end2 = pvcrange.indexOf(62, end1 + 1);
        String x2 = pvcrange.substring(start2, end2 + 1);
        index = x2.indexOf(45);
        this._vcimin = Long.parseLong(x2.substring(1, index));
        this._vcimax = Long.parseLong(x2.substring(index + 1, x2.length() - 1));
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getLog().info("populate() " + this.getIfID());
        super.populate(config, cmdVal);
        ConfigValues subcmds = cmdVal.getModeCmdsValues();
        this.populatePvcRange();
        Log.getLog().debug("VPI min " + this._vpimin);
        Log.getLog().debug("VPI max " + this._vpimax);
        Log.getLog().debug("VCI min " + this._vcimin);
        Log.getLog().debug("VCI max " + this._vcimax);
        if (this.getIfID().getType() != 1008) {
            this.populatedslInfo(subcmds);
        }
        this._atm = new AtmHelper(this, false);
        this._atm.populate(subcmds, cmdVal);
        if (this._atm.isReadOnly()) {
            this.setConfigurable(false);
            this.setROReason(this._atm.getROReason());
            Log.getLog().warn("populate(): Setting ATM to non-configurable " + this.getIfID());
        }
    }

    private void populatePvcRange() {
        Log.getLog().info("populate() " + this.getIfID());
        if (this._pvcDefaults) {
            Log.getLog().info("populate(): PVC Range already discovered for " + this.getIfID());
            return;
        }
        String[] cliCommands = new String[]{"interface " + this.getIfID(), "pvc ?"};
        IOSCmdResponse[] response = this.sendConfigCommands(cliCommands);
        if (response == null || response.length < 2) {
            Log.getLog().error("Failed during PVC Range Discovery");
            return;
        }
        String pvcrange = response[1].getOutput();
        if (response[1].getStatus() == 2 || pvcrange == null || pvcrange.indexOf("% Unrecognized command") != -1 || pvcrange.indexOf("% Invalid input detected at '^' marker") != -1) {
            return;
        }
        this.parseResponse(pvcrange);
        this._pvcDefaults = true;
    }

    private void populatedslInfo(ConfigValues subcmds) throws CliGPBException, XDMException {
        Log.getLog().info("populatedslInfo() " + this.getIfID());
        this._dsl.populate(subcmds, null);
    }

    public void resetModifiedFlag() {
        Log.getLog().debug("resetModifiedFlag() " + this.getIfID());
        super.resetModifiedFlag();
        if (this._atm != null) {
            this._atm.resetModifiedFlag();
        }
        if (this._dsl != null) {
            this._dsl.resetModifiedFlag();
        }
    }

    private IOSCmdResponse[] sendConfigCommands(String[] cliCommands) {
        IOSCmdResponse[] response;
        DevInfoBase deviceInfo = ((DeviceBase)this.getDevice()).getDevInfoBase();
        try {
            response = deviceInfo.getComm().config(cliCommands);
        }
        catch (IOSCmdServiceException ex) {
            Log.getLog().error("Failed during PVC Range Discovery");
            ex.printStackTrace();
            return null;
        }
        return response;
    }

    public void setDslInfo(DslInfo dsl) {
        this._dsl = dsl;
        this.setModified();
    }

    public void setPvcs(PvcCollection pvcs) {
        this._atm.setPvcs(pvcs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(this._atm.toString());
        if (this._dsl != null) {
            sb.append(this._dsl.toString());
        }
        return sb.toString();
    }
}

