/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.Description;
import com.cisco.xdm.data.dialer.DialerList;
import com.cisco.xdm.data.dialer.DialerListCollection;
import com.cisco.xdm.data.interfaces.Dialer;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.systemproperties.SystemProp;
import java.util.Enumeration;
import java.util.Vector;

public class BRI
extends XDMInterface {
    private String switchType = "";
    private String spid1 = "";
    private String spid2 = "";
    private String ldn1 = "";
    private String ldn2 = "";
    private int poolNumber;
    private int encap = 0;
    private int multilink = 0;
    private Dialer logicalIf = null;
    private boolean isLDN = false;
    private boolean isUnSupportedConfig = false;
    private boolean isMultipleDialer = false;
    private Dialer _backUpLogicalIf = null;
    public static final String ISDN = "isdn";
    public static final String SWITCHTYPE = "switch-type";
    public static final String DIALER = "dialer";
    public static final String POOLMEMBER = "pool-member";
    public static final String SPID1 = "spid1";
    public static final String SPID2 = "spid2";
    public static final String ENCAPSULATION = "encapsulation";
    public static final String ENCAPTYPE = "ppp";
    public static final String MULTILINK = "multilink";
    public static final int ENCAPSET = 1;
    public static final int ENCAPNOTSET = 0;
    public static final int ENCAPOTHERS = 2;
    public static final String BACKUP_FLAG = "$BACKUP_INTF_";
    public static final String ENCAP_HDLC = "hdlc";

    public BRI(IfID id) {
        super(id);
        this.setSupport(0, 1);
        this.setSupport(1, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public boolean canSubIf() {
        return false;
    }

    public Object clone() {
        BRI bri = (BRI)super.clone();
        bri.switchType = this.switchType;
        bri.spid1 = this.spid1;
        bri.spid2 = this.spid2;
        bri.poolNumber = this.poolNumber;
        return bri;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BRI) || !super.equals(obj)) {
            return false;
        }
        BRI bri = (BRI)obj;
        return bri.switchType.equals(this.switchType) && bri.spid1.equals(this.spid1) && bri.spid2.equals(this.spid2) && bri.poolNumber == this.poolNumber;
    }

    private void generateChangeCmd(BRI old, ConfigValues cv) throws XDMException {
        CmdValues cmd = null;
        if (old.getPoolNumber() != this.getPoolNumber()) {
            cmd = new CmdValues(DIALER);
            cmd.addValue(POOLMEMBER, POOLMEMBER);
            if (this.getPoolNumber() >= 1) {
                cmd.addValue("groupNum", String.valueOf(this.poolNumber));
                cv.addCmdValues(cmd);
            } else if (this.getPoolNumber() == -1 && old.getPoolNumber() >= 1) {
                cmd.addValue("groupNum", String.valueOf(old.getPoolNumber()));
                cmd.setAction(2);
                cv.addCmdValues(cmd);
            }
        }
        if (!old.getSwitchType().equals(this.getSwitchType())) {
            cmd = new CmdValues(ISDN);
            cmd.addValue(SWITCHTYPE, SWITCHTYPE);
            if (this.getSwitchType().equals("-1") && !old.getSwitchType().equals("-1")) {
                if (old.getSwitchType().length() > 0) {
                    cmd.addValue("switchName", old.getSwitchType());
                    cmd.setAction(2);
                    cv.addCmdValues(cmd);
                }
            } else if (this.getSwitchType().length() > 0 && !this.getSwitchType().equals("-1")) {
                cmd.addValue("switchName", this.getSwitchType());
                cv.addCmdValues(cmd);
                this.shutdown(false);
                old.shutdown(false);
                CmdValues cmdShut = new CmdValues("shutdown");
                cmdShut.setAction(2);
                cv.addCmdValues(cmdShut);
                SystemProp sysProp = ((DeviceBase)this.getDevice()).getSystemProp();
                sysProp.setSwitchType(this.getSwitchType());
            }
        }
        if (old.getSpid1().length() > 0 && this.getSpid1().length() == 0) {
            cmd = new CmdValues(ISDN);
            cmd.addValue(SPID1, SPID1);
            cmd.addValue("spidVal", old.getSpid1());
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        if (this.getSpid1().length() > 0 && !old.getSpid1().equals(this.getSpid1())) {
            cmd = new CmdValues(ISDN);
            cmd.addValue(SPID1, SPID1);
            cmd.addValue("spidVal", this.getSpid1());
            cv.addCmdValues(cmd);
        }
        if (old.getSpid2().length() > 0 && this.getSpid2().length() == 0) {
            cmd = new CmdValues(ISDN);
            cmd.addValue(SPID2, SPID2);
            cmd.addValue("spidVal", old.getSpid2());
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        if (this.getSpid2().length() > 0 && !old.getSpid2().equals(this.getSpid2())) {
            cmd = new CmdValues(ISDN);
            cmd.addValue(SPID2, SPID2);
            cmd.addValue("spidVal", this.getSpid2());
            cv.addCmdValues(cmd);
        }
        if (old.getMultilink() != this.getMultilink()) {
            cmd = new CmdValues(ENCAPTYPE);
            cmd.addValue(MULTILINK, MULTILINK);
            if (this.getMultilink() == -1 && old.getMultilink() == 1) {
                cmd.setAction(2);
                cv.addCmdValues(cmd);
            }
        }
        if (old.getEncap() != this.encap) {
            cmd = new CmdValues(ENCAPSULATION);
            cmd.addValue("ENCAP", ENCAPTYPE);
            if (old.getEncap() <= 0 && this.encap == 1) {
                cv.addCmdValues(cmd);
            } else if (old.getEncap() == 1 && this.encap == -1) {
                cmd.setAction(2);
                cv.addCmdValues(cmd);
            }
        }
        if (old.getMultilink() != this.getMultilink()) {
            cmd = new CmdValues(ENCAPTYPE);
            cmd.addValue(MULTILINK, MULTILINK);
            if (this.getMultilink() == 1 && old.getMultilink() <= 0) {
                cv.addCmdValues(cmd);
            }
        }
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        BRI briBackup = null;
        if (backup instanceof BRI) {
            briBackup = (BRI)backup;
        }
        ConfigValues cv = cmdVal.getModeCmdsValues();
        Object cmd = null;
        if (cv == null) {
            cv = new ConfigValues();
        }
        if (!this.isReadOnly() && this.isModified() && !this.isBackup()) {
            this.generateChangeCmd(briBackup, cv);
        }
        if (!cv.isEmpty()) {
            cmdVal.setModeCmdsValues(cv);
        }
    }

    public String getBRIDesc() {
        return Description.getFlagContent(this.getDesc(), BACKUP_FLAG);
    }

    public Dialer getBackupLogicalIf() {
        Dialer dialerIntf = this._backUpLogicalIf != null ? this._backUpLogicalIf : (Dialer)this.getLogicalIf();
        return dialerIntf;
    }

    public int getEncap() {
        return this.encap;
    }

    public String getEncapsulation() {
        if (this.encap == 1) {
            return ENCAPTYPE;
        }
        return null;
    }

    protected Vector getFlags() {
        Vector flags = super.getFlags();
        flags.addElement(BACKUP_FLAG);
        return flags;
    }

    public String getLdn1() {
        return this.ldn1;
    }

    public String getLdn2() {
        return this.ldn2;
    }

    public XDMInterfaceBase getLogicalIf() {
        Vector ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1001);
        Enumeration enumeration = ifs.elements();
        while (enumeration.hasMoreElements()) {
            Dialer item = (Dialer)enumeration.nextElement();
            if (item.getDialPoolNumber() != this.poolNumber) continue;
            this.logicalIf = item;
            break;
        }
        return this.logicalIf;
    }

    public int getMultilink() {
        return this.multilink;
    }

    public int getPoolNumber() {
        return this.poolNumber;
    }

    public String getSpid1() {
        return this.spid1;
    }

    public String getSpid2() {
        return this.spid2;
    }

    public String getSwitchType() {
        return this.switchType;
    }

    public boolean isConfigurable() {
        boolean result = super.isConfigurable();
        if (this.getIpAddr() != null) {
            this.setConfigurable(false);
            Log.getLog().debug("################IP Address Under BRI -- ISDN made readonly ");
            return false;
        }
        if (this.isLDN) {
            this.setConfigurable(false);
            Log.getLog().debug("####################Ldn is configured -- ISDN made read only ");
            return false;
        }
        if (this.encap == 2) {
            this.setConfigurable(false);
            Log.getLog().debug("######################3encapsulation is other than ppp -- ISDN made read only ");
            return false;
        }
        if (this.isUnSupportedConfig) {
            this.setConfigurable(false);
            Log.getLog().debug("##################SDM detects unsupported configuration under BRI -- ISDN made read only");
            return false;
        }
        if (this.poolNumber > 0) {
            XDMInterfaceBase baseIf = this.getLogicalIf();
            if (baseIf == null) {
                this.setConfigurable(false);
                Log.getLog().debug("#######################BRI with out a associated Dialer -- ISDN made read only");
                return false;
            }
            if (this.encap == 0) {
                this.setConfigurable(false);
                Log.getLog().debug("###################BRI has a Dialer with some other encapsulation -- ISDN made read only");
                return false;
            }
            if (baseIf != null) {
                Dialer dialerIf = (Dialer)baseIf;
                if (dialerIf.getEncapsulation() == null || !dialerIf.getEncapsulation().equals(ENCAPTYPE)) {
                    this.setConfigurable(false);
                    Log.getLog().debug("################## Associated Dialer has encapsulation other than ppp -- ISDN made read only");
                }
                if (dialerIf.isDialerStringOther()) {
                    this.setConfigurable(false);
                    Log.getLog().debug("####################Dialer string with map class is configured -- ISDN made read only ");
                }
                if (dialerIf.getIpAddr() == null) {
                    this.setConfigurable(false);
                    Log.getLog().debug("################## Associated Dialer has No IP address -- ISDN made read only");
                }
            }
            if (baseIf != null) {
                DialerList dialerList;
                Dialer dialer = (Dialer)baseIf;
                int group = dialer.getDialerGroup();
                DialerListCollection dlc = ((DeviceBase)this.getDevice()).getDialerListCollection();
                if (dlc != null && (dialerList = (DialerList)dlc.get(String.valueOf(group) + "ip")) == null) {
                    this.setConfigurable(false);
                    Log.getLog().debug("##################SDM detects Dialer group command under Dialer but the dialer list is not present -- BRI made read only");
                    return false;
                }
            }
        }
        if (this.isMultipleDialer) {
            this.setConfigurable(false);
            Log.getLog().debug("##################SDM detects Multiple Dialer for this BRI -- ISDN made read only");
            return false;
        }
        return result;
    }

    public boolean isConfigured() {
        if (this.getLogicalIf() == null) {
            return false;
        }
        return this.getLogicalIf().getIpAddr() != null;
    }

    public boolean isNew() {
        return this.getLogicalIf() == null;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        ConfigValues cmds = cmdVal.getModeCmdsValues();
        this.isLDN = false;
        this.encap = 0;
        int numberOfCmds = cmds.numCmds();
        this.isMultipleDialer = false;
        ConfigValues cv = cmds.getCmds(DIALER, POOLMEMBER, ".*", false);
        if (cv != null && cv.numCmds() > 1) {
            this.isMultipleDialer = true;
        }
        int i = 0;
        while (i < numberOfCmds) {
            CmdValues eachCmdValue = cmds.getCmdValues(i);
            String cmdName = eachCmdValue.getCmdName();
            if (cmdName.equals(ISDN)) {
                if (eachCmdValue.containsKey(SWITCHTYPE)) {
                    this.switchType = eachCmdValue.getValue("switchName");
                    if (this.switchType == null) {
                        this.switchType = "";
                    }
                }
                if (eachCmdValue.containsKey(SPID1)) {
                    this.spid1 = eachCmdValue.getValue("spidVal");
                    this.ldn1 = eachCmdValue.getValue("localDir");
                    if (this.spid1 == null) {
                        this.spid1 = "";
                    }
                    if (this.ldn1 != null) {
                        this.isLDN = true;
                    }
                }
                if (eachCmdValue.containsKey(SPID2)) {
                    this.spid2 = eachCmdValue.getValue("spidVal");
                    this.ldn2 = eachCmdValue.getValue("localDir");
                    if (this.spid2 == null) {
                        this.spid2 = "";
                    }
                    if (this.ldn2 != null) {
                        this.isLDN = true;
                    }
                }
            }
            if (cmdName.equals(DIALER) && eachCmdValue.containsKey(POOLMEMBER)) {
                this.poolNumber = Integer.valueOf(eachCmdValue.getValue("groupNum"));
                if (this.poolNumber == 0) {
                    this.logicalIf = null;
                }
            }
            if (cmdName.equals(ENCAPSULATION)) {
                String strEncap = eachCmdValue.getValue("ENCAP");
                this.encap = strEncap.equals(ENCAPTYPE) ? 1 : (strEncap.equals(ENCAP_HDLC) ? 0 : 2);
            }
            cv = cmds.getCmds(ENCAPTYPE, MULTILINK, ".*", false);
            this.multilink = 0;
            if (cv != null) {
                this.multilink = 1;
            }
            ++i;
        }
        this.isUnSupportedConfig = false;
        cv = cmds.getCmds(DIALER, "rotary-group", ".*", false);
        if (cv != null) {
            this.isUnSupportedConfig = true;
        }
        if ((cv = cmds.getCmds(DIALER, "map", ".*", false)) != null) {
            this.isUnSupportedConfig = true;
        }
        if ((cv = cmds.getCmds(DIALER, "mult-map-same-name", ".*", false)) != null) {
            this.isUnSupportedConfig = true;
        }
        if ((cv = cmds.getCmds("dialer-group", ".*", ".*", false)) != null) {
            this.isUnSupportedConfig = true;
        }
    }

    public void resetLogicalIf() {
        if (this.poolNumber == -1) {
            this.logicalIf = null;
        }
    }

    public void setBRIDesc(String desc) {
        String str = Description.removeFlag(this.getDesc(), BACKUP_FLAG);
        this.setDesc(Description.addFlag(str, desc));
    }

    public void setBackupLogicalIf(Dialer backUpLogicalIf) {
        this._backUpLogicalIf = backUpLogicalIf;
    }

    public void setEncap() {
        this.encap = 1;
        this.setModified();
    }

    public void setEncap(int encapVal) {
        this.encap = encapVal;
        this.setModified();
    }

    public void setLdn1(String ldn) {
        this.ldn1 = ldn;
        this.setModified();
    }

    public void setLdn2(String ldn) {
        this.ldn2 = ldn;
        this.setModified();
    }

    public void setMultilink(int link) {
        this.multilink = link;
        this.setModified();
    }

    public void setPoolNumber(int poolNum) {
        this.poolNumber = poolNum;
        this.setModified();
    }

    public void setSpid1(String spid) {
        this.spid1 = spid;
        this.setModified();
    }

    public void setSpid2(String spid) {
        this.spid2 = spid;
        this.setModified();
    }

    public void setSwitchType(String swType) {
        this.switchType = swType.trim();
        this.setModified();
    }
}

