/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.PvcCollection;
import com.cisco.xdm.data.authentication.PPPAuthentication;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.Async;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.AtmSubInterface;
import com.cisco.xdm.data.interfaces.BRI;
import com.cisco.xdm.data.interfaces.Ethernet;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import java.util.Enumeration;
import java.util.Vector;

public class Dialer
extends XDMInterface {
    private int _pool = -1;
    private int _group = -1;
    private String _encapsulation = null;
    private PPPAuthentication _auth = null;
    private String _dialerString = "";
    private boolean _isMultilink = false;
    private boolean isDialerStringOther = false;
    private int _loadVal = 0;
    private int _idleTimeout = 120;
    private int _fastTimeout = 20;
    private String _direction = "";
    private XDMInterfaceBase _backupPhysicalIf = null;

    public Dialer(IfID ifID) {
        super(ifID);
        Log.getLog().debug("Dialer() " + this.getClass().getName());
        this.setSupport(0, 1);
        this.setSupport(1, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
        this._auth = new PPPAuthentication(this);
    }

    public boolean canSubIf() {
        return true;
    }

    public Object clone() {
        Log.getLog().debug("clone() " + this.getClass().getName());
        Dialer newIf = (Dialer)super.clone();
        newIf._auth = (PPPAuthentication)this._auth.clone();
        newIf._dialerString = this._dialerString;
        newIf._isMultilink = this._isMultilink;
        newIf._loadVal = this._loadVal;
        newIf._fastTimeout = this._fastTimeout;
        newIf._idleTimeout = this._idleTimeout;
        newIf._auth.setParent(newIf);
        return newIf;
    }

    private boolean compareStrings(String first, String second) {
        if (first == second && first == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        return first.equals(second);
    }

    public void deleteMultiLinkOption() {
        this._isMultilink = false;
        this.setModified();
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Dialer ifObj = (Dialer)obj;
            return this._pool == ifObj._pool && this._group == ifObj._group && this.compareStrings(this._encapsulation, ifObj._encapsulation) && this.compareStrings(this._dialerString, ifObj._dialerString) && (this._isMultilink = ifObj._isMultilink) && this._auth.equals(ifObj._auth) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(CmdValues parent) throws XDMException {
        Log.getLog().info("generateAddCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        if (this._pool != -1) {
            cmd = new CmdValues("dialer");
            cmd.setAction(1);
            cmd.addValue("POOL", String.valueOf(this._pool));
            cv.addCmdValues(cmd);
        }
        if (this._group != -1) {
            cmd = new CmdValues("dialer-group");
            cmd.addValue("GROUPNUMBER", String.valueOf(this._group));
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        if (this._encapsulation != null) {
            cmd = new CmdValues("encapsulation");
            cmd.addValue("ENCAP", this._encapsulation);
            if (this._encapsulation.equals("frame-relay")) {
                cmd.addValue("ietf", "ietf");
            }
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        if (this._dialerString.length() > 0) {
            cmd = new CmdValues("dialer");
            cmd.addValue("string", "string");
            cmd.addValue("dialStr", this._dialerString);
            cv.addCmdValues(cmd);
        }
        if (this._isMultilink) {
            cmd = new CmdValues("ppp");
            cmd.addValue("string", "string");
            cmd.addValue("multilink", "multilink");
            cv.addCmdValues(cmd);
        }
        if (this._loadVal >= 1 && this._direction.length() > 0) {
            cmd = new CmdValues("dialer");
            cmd.addValue("load-threshold", "load-threshold");
            cmd.addValue("loadVal", String.valueOf(this._loadVal));
            cmd.addValue("direction", this._direction);
            cv.addCmdValues(cmd);
        }
        if (this._idleTimeout >= 0) {
            cmd = new CmdValues("dialer");
            cmd.addValue("idle-timeout", "idle-timeout");
            cmd.addValue("ldleVal", String.valueOf(this._idleTimeout));
            cv.addCmdValues(cmd);
        }
        if (this._fastTimeout >= 1) {
            cmd = new CmdValues("dialer");
            cmd.addValue("fast-idle", "fast-idle");
            cmd.addValue("fastVal", String.valueOf(this._fastTimeout));
            cv.addCmdValues(cmd);
        }
        if (this._auth.isModified()) {
            this._auth.generateDelta(null, cv);
        }
        if (!cv.isEmpty()) {
            parent.setModeCmdsValues(cv);
            Log.getLog().debug("generateAddCmd(): cv is " + cv);
        } else {
            Log.getLog().debug("generateAddCmd(): cv is empty " + this.getClass().getName());
        }
    }

    private void generateChangeCmd(Dialer old, CmdValues parent) throws XDMException {
        Log.getLog().info("generateChangeCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        if (old._pool != this._pool) {
            cmd = new CmdValues("dialer");
            cmd.setAction(3);
            cmd.addValue("POOL", String.valueOf(this._pool));
            cmd.addOldValue("POOL", String.valueOf(old._pool));
            cv.addCmdValues(cmd);
        }
        if (old._group != this._group) {
            cmd = new CmdValues("dialer-group");
            cmd.addValue("GROUPNUMBER", String.valueOf(this._group));
            cmd.addOldValue("GROUPNUMBER", String.valueOf(old._group));
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        }
        if (old._encapsulation != null && !old._encapsulation.equals(this._encapsulation)) {
            cmd = new CmdValues("encapsulation");
            cmd.addValue("ENCAP", this._encapsulation);
            cmd.addOldValue("ENCAP", old._encapsulation);
            if (this._encapsulation.equals("frame-relay")) {
                cmd.addValue("ietf", "ietf");
            }
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        }
        if (old._dialerString.length() == 0 && this._dialerString.length() > 0) {
            cmd = new CmdValues("dialer");
            cmd.addValue("string", "string");
            cmd.addValue("dialStr", this._dialerString);
            cv.addCmdValues(cmd);
        }
        if (old._dialerString.length() > 0 && !old._dialerString.equals(this._dialerString)) {
            cmd = new CmdValues("dialer");
            cmd.addValue("string", "string");
            cmd.addOldValue("string", "string");
            cmd.addValue("dialStr", this._dialerString);
            cmd.addOldValue("dialStr", old._dialerString);
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        }
        if (this._isMultilink != old._isMultilink) {
            cmd = new CmdValues("ppp");
            cmd.addValue("string", "string");
            cmd.addValue("multilink", "multilink");
            if (old._isMultilink && !this._isMultilink) {
                cmd.setAction(2);
            }
            cv.addCmdValues(cmd);
        }
        if (old._loadVal != this._loadVal) {
            cmd = new CmdValues("dialer");
            cmd.addValue("load-threshold", "load-threshold");
            if (this._loadVal >= 1) {
                cmd.addValue("loadVal", String.valueOf(this._loadVal));
                cmd.addValue("direction", this._direction);
                cv.addCmdValues(cmd);
            } else if (this._loadVal == -1 && old._loadVal >= 1) {
                cmd.addValue("loadVal", String.valueOf(old._loadVal));
                cmd.addValue("direction", this._direction);
                cmd.setAction(2);
                cv.addCmdValues(cmd);
            }
        }
        if (old._idleTimeout != this._idleTimeout) {
            cmd = new CmdValues("dialer");
            cmd.addValue("idle-timeout", "idle-timeout");
            cmd.addValue("ldleVal", String.valueOf(this._idleTimeout));
            cv.addCmdValues(cmd);
        }
        if (old._fastTimeout != this._fastTimeout) {
            cmd = new CmdValues("dialer");
            cmd.addValue("fast-idle", "fast-idle");
            cmd.addValue("fastVal", String.valueOf(this._fastTimeout));
            cv.addCmdValues(cmd);
        }
        if (this._auth.isModified()) {
            this._auth.generateDelta(old.getPPPAuthentication(), cv);
        }
        if (!cv.isEmpty()) {
            parent.setModeCmdsValues(cv);
            Log.getLog().debug("generateChangeCmd(): cv is" + cv);
        } else {
            Log.getLog().debug("generateChangeCmd(): cv is empty " + this.getClass().getName());
        }
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        Log.getLog().info("generateDelta() " + this.getClass().getName());
        if (!this.isReadOnly() && this.isModified()) {
            Dialer backupDialer = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(cmdVal);
                } else {
                    backupDialer = (Dialer)backup;
                    this.generateChangeCmd(backupDialer, cmdVal);
                }
            }
        }
    }

    public XDMInterfaceBase getATMSubPhysicalIf() {
        if (this._pool == -1) {
            return null;
        }
        Vector ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(503);
        Vector ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(504);
        int i = 0;
        while (i < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i));
            ++i;
        }
        ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(532);
        int i2 = 0;
        while (i2 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i2));
            ++i2;
        }
        ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1008);
        int i3 = 0;
        while (i3 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i3));
            ++i3;
        }
        Enumeration e = ifs.elements();
        while (e.hasMoreElements()) {
            Atm item = (Atm)e.nextElement();
            PvcCollection pvcs = item.getPvcs();
            if (pvcs.doesPvcCollectionContainDialerPool(this._pool)) {
                return item;
            }
            XDMSubInterfaces si = item.getSubInterfaces();
            Enumeration e2 = si.elements();
            while (e2.hasMoreElements()) {
                AtmSubInterface asub = (AtmSubInterface)e2.nextElement();
                if (!asub.getPvcs().doesPvcCollectionContainDialerPool(this._pool)) continue;
                return asub;
            }
        }
        return null;
    }

    public XDMInterfaceBase getBackupPhysicalIf() {
        XDMInterfaceBase xdmIf = this._backupPhysicalIf != null ? this._backupPhysicalIf : this.getPhysicalIf();
        return xdmIf;
    }

    public int getDialPoolNumber() {
        return this._pool;
    }

    public int getDialerGroup() {
        return this._group;
    }

    public String getDialerString() {
        return this._dialerString;
    }

    public String getDirection() {
        return this._direction;
    }

    public String getEncapsulation() {
        return this._encapsulation;
    }

    public int getFastTimeout() {
        return this._fastTimeout;
    }

    public int getIdleTime() {
        return this._idleTimeout;
    }

    public int getLoadVal() {
        return this._loadVal;
    }

    public boolean getMultilink() {
        return this._isMultilink;
    }

    public PPPAuthentication getPPPAuthentication() {
        return this._auth;
    }

    public XDMInterfaceBase getPhysicalIf() {
        if (this._pool == -1) {
            return null;
        }
        Vector ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(503);
        Vector ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(504);
        int i = 0;
        while (i < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i));
            ++i;
        }
        ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(532);
        int i2 = 0;
        while (i2 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i2));
            ++i2;
        }
        ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1008);
        int i3 = 0;
        while (i3 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i3));
            ++i3;
        }
        Enumeration e = ifs.elements();
        while (e.hasMoreElements()) {
            Atm item = (Atm)e.nextElement();
            PvcCollection pvcs = item.getPvcs();
            if (pvcs.doesPvcCollectionContainDialerPool(this._pool)) {
                return item;
            }
            XDMSubInterfaces si = item.getSubInterfaces();
            Enumeration e2 = si.elements();
            while (e2.hasMoreElements()) {
                AtmSubInterface asub = (AtmSubInterface)e2.nextElement();
                if (!asub.getPvcs().doesPvcCollectionContainDialerPool(this._pool)) continue;
                return item;
            }
        }
        ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1);
        ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(2);
        int i4 = 0;
        while (i4 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i4));
            ++i4;
        }
        ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(3);
        int i5 = 0;
        while (i5 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i5));
            ++i5;
        }
        ifs2 = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(4);
        int i6 = 0;
        while (i6 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i6));
            ++i6;
        }
        Enumeration e2 = ifs.elements();
        while (e2.hasMoreElements()) {
            Ethernet item = (Ethernet)e2.nextElement();
            if (item.getDialPoolNumber() != this._pool) continue;
            return item;
        }
        ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(505);
        Enumeration e3 = ifs.elements();
        while (e3.hasMoreElements()) {
            BRI item = (BRI)e3.nextElement();
            if (item.getPoolNumber() != this._pool) continue;
            return item;
        }
        ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1009);
        Enumeration e4 = ifs.elements();
        while (e4.hasMoreElements()) {
            Async item = (Async)e4.nextElement();
            if (item.getPoolNumber() != this._pool) continue;
            return item;
        }
        return null;
    }

    public boolean isConfigured() {
        Log.getLog().info("isConfigured() " + this.getClass().getName());
        if (this.getIpAddr() != null && this.getIpAddr().getIPAddressType() != null) {
            Log.getLog().debug("isConfigured(): Returning true for " + this.getIfID() + "  " + this.getClass().getName());
            return true;
        }
        Log.getLog().warn("isConfigured(): Returning false. No IP Address configured on Dialer interface " + this.getIfID() + "  " + this.getClass().getName());
        return false;
    }

    public boolean isDialerStringOther() {
        return this.isDialerStringOther;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getLog().info("populate() " + this.getClass().getName());
        super.populate(config, cmdVal);
        ConfigValues subcmds = cmdVal.getModeCmdsValues();
        this.populatePoolInfo(subcmds);
        this.populateGroupInfo(subcmds);
        this.populateEncapInfo(subcmds);
        if (this._encapsulation != null && this._encapsulation.equals("ppp")) {
            if (this._auth == null) {
                this._auth = new PPPAuthentication(this);
            }
            this._auth.populate(subcmds, cmdVal);
        }
        this.populateDialerString(subcmds);
        this.populateMultiLink(subcmds);
        this.populateDialerLoadOption(subcmds);
        this.populateDialerTimeout(subcmds);
        this.populateDialerFastidle(subcmds);
    }

    private void populateDialerFastidle(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv = subcmds.getCmds("dialer", "fast-idle", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._fastTimeout = new Integer(cmd.getValue("fastVal"));
    }

    private void populateDialerLoadOption(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv = subcmds.getCmds("dialer", "load-threshold", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._loadVal = new Integer(cmd.getValue("loadVal"));
        this._direction = cmd.getValue("direction");
        if (this._direction == null) {
            this._direction = "";
        }
    }

    private void populateDialerString(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populatePoolInfo() " + this.getClass().getName());
        ConfigValues cv = subcmds.getCmds("dialer", "string", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this.isDialerStringOther = false;
        if (cmd != null && cmd.getValue("others") != null && !cmd.getValue("others").equals("null")) {
            this.isDialerStringOther = true;
        }
        this._dialerString = cmd.getValue("dialStr");
    }

    private void populateDialerTimeout(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv = subcmds.getCmds("dialer", "idle-timeout", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._idleTimeout = new Integer(cmd.getValue("ldleVal"));
    }

    private void populateEncapInfo(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populateEncapInfo() " + this.getClass().getName());
        ConfigValues cv = subcmds.getCmds("encapsulation", ".*", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._encapsulation = cmd.getValue("ENCAP");
    }

    private void populateGroupInfo(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populateGroupInfo() " + this.getClass().getName());
        ConfigValues cv = subcmds.getCmds("dialer-group", "GROUPNUMBER", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._group = Integer.parseInt(cmd.getValue("GROUPNUMBER"));
    }

    private void populateMultiLink(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populatePoolInfo() " + this.getClass().getName());
        ConfigValues cv = subcmds.getCmds("ppp", "multilink", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._isMultilink = true;
    }

    private void populatePoolInfo(ConfigValues subcmds) throws CliGPBException {
        Log.getLog().info("populatePoolInfo() " + this.getClass().getName());
        ConfigValues cv = subcmds.getCmds("dialer", "POOL", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._pool = Integer.parseInt(cmd.getValue("POOL"));
    }

    public void resetModifiedFlag() {
        Log.getLog().debug("resetModifiedFlag() " + this.getClass().getName());
        super.resetModifiedFlag();
        if (this._auth != null) {
            this._auth.resetModifiedFlag();
        }
    }

    public void setBackupPhysicalIf(XDMInterfaceBase backIf) {
        this._backupPhysicalIf = backIf;
    }

    public void setDialPoolNumber(int pool) {
        this._pool = pool;
        this.setModified();
    }

    public void setDialerGroup(int group) {
        this._group = group;
        this.setModified();
    }

    public void setDialerString(String dialerString) {
        this._dialerString = dialerString;
        this.setModified();
    }

    public void setDirection(String direc) {
        this._direction = direc;
        this.setModified();
    }

    public void setEncapsulation(String encapsulation) {
        this._encapsulation = encapsulation;
        this.setModified();
    }

    public void setFastTimeout(int fastTimeout) {
        this._fastTimeout = fastTimeout;
        this.setModified();
    }

    public void setIdleTime(int idleTime) {
        this._idleTimeout = idleTime;
        this.setModified();
    }

    public void setLoadVal(int load) {
        this._loadVal = load;
        this.setModified();
    }

    public void setMultilink() {
        this._isMultilink = true;
        this.setModified();
    }

    public void setPPPAuthentication(PPPAuthentication auth) {
        this._auth = auth;
        this._auth.setParent(this);
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\t_pool: " + this._pool);
        sb.append("\t_group: " + this._group);
        sb.append("\t_encapsulation: " + this._encapsulation);
        sb.append("\t_auth: " + this._auth);
        sb.append("\t_dialerString:" + this._dialerString);
        return sb.toString();
    }
}

