/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.Description;
import com.cisco.xdm.data.dhcp.DHCPPool;
import com.cisco.xdm.data.dhcp.DHCPPoolCollection;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMSubInterface;
import java.util.Vector;

public class EthernetSubInterface
extends XDMSubInterface {
    static final String KEY_ENCAP = "encapsulation";
    public static final String KEY_DOT1Q = "dot1Q";
    public static final String KEY_NATIVE = "native";
    private String _encap;
    private int _vlanNum = -1;
    private String _native;
    public static final int DHCP_NONE = 0;
    public static final int DHCP_SERVER = 1;
    public static final int DHCP_RELAY = 2;
    public static final int DHCP_SERVER_RELAY = 3;
    public static final int TYPE_LAN = 0;
    public static final int TYPE_WAN = 1;
    public static final int TYPE_UNKNOWN = 2;
    public static final int ETH_NONE = 0;
    public static final int ETH_WAN = 1;
    public static final int ETH_LAN = 2;
    public static final int ETH_LAUNCHSW = 1;
    public static final String SDM_ETH_LAN = "$ETH-LAN$";
    public static final String SDM_ETH_WAN = "$ETH-WAN$";
    public static final String SDM_ETH_LAUNCHSW = "$ETH-SW-LAUNCH$";
    public static final String SDM_INTF_INFO = "$INTF-INFO-";
    int _connectionType = 2;
    int _dhcpMode = 0;
    DHCPPool _dhcpPool = null;

    public EthernetSubInterface(IfID ifID, XDMInterface mainIf) {
        super(ifID, mainIf);
        this.setConfigurable(true);
        this.setFeatures();
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        if (!this.isReadOnly() && this.isModified()) {
            Object backupEthernet = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    ConfigValues modecv;
                    if (this._encap.equals(KEY_DOT1Q) && (modecv = cmdVal.getModeCmdsValues()) != null) {
                        CmdValues cmd = new CmdValues(KEY_ENCAP);
                        cmd.addValue(KEY_DOT1Q, KEY_DOT1Q);
                        cmd.addValue("NUMBER", Integer.toString(this._vlanNum));
                        if (this._native != null && this._native.equals(KEY_NATIVE)) {
                            cmd.addValue(KEY_NATIVE, KEY_NATIVE);
                        }
                        modecv.insertCmdValues(cmd, 0);
                    }
                } else {
                    EthernetSubInterface ethernetSubInterface = (EthernetSubInterface)backup;
                }
            }
        }
    }

    public int getConnectionType() {
        return this._connectionType;
    }

    public int getDhcpMode() {
        return this._dhcpMode;
    }

    public String getEncapMethod() {
        return this._encap;
    }

    public int getEncapVLANNum() {
        return this._vlanNum;
    }

    protected Vector getFlags() {
        Vector flags = super.getFlags();
        flags.addElement(SDM_ETH_LAN);
        flags.addElement(SDM_ETH_WAN);
        flags.addElement(SDM_ETH_LAUNCHSW);
        flags.addElement(SDM_INTF_INFO);
        return flags;
    }

    public String getNative() {
        return this._native;
    }

    public boolean isConfigured() {
        IfIPAddress ipAddr = this.getIpAddr();
        return ipAddr != null || this.getBridgeGroup() > 0;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        this.populateType();
        this.populateDHCP(subCmds);
        int i = 0;
        while (i < subCmds.numCmds()) {
            CmdValues cmd = subCmds.getCmdValues(i);
            String cmdName = cmd.getCmdName();
            if (cmdName.compareTo(KEY_ENCAP) == 0 && cmd.containsKey(KEY_DOT1Q)) {
                this._encap = cmd.getValue(KEY_DOT1Q);
                this._vlanNum = Integer.parseInt(cmd.getValue("NUMBER"));
                this._native = cmd.getValue(KEY_NATIVE);
                return;
            }
            ++i;
        }
        this._encap = "";
        this._native = "";
    }

    private void populateDHCP(ConfigValues subcmds) throws CliGPBException {
        IfIPAddress ipAddr;
        this._dhcpMode = 0;
        if (this.getDhcpRelayAddr() != null) {
            this._dhcpMode = 2;
        }
        if ((ipAddr = this.getIpAddr()) == null || ipAddr.getIPAddress() == null) {
            return;
        }
        DHCPPoolCollection dhcpPools = ((DeviceBase)this.getDevice()).getDhcp();
        String poolName = dhcpPools.getPoolName(ipAddr.getIPAddress(), ipAddr.getNetmask());
        if (poolName != null) {
            this._dhcpPool = dhcpPools.getPool(poolName);
        }
        if (this._dhcpPool != null) {
            this._dhcpMode = this._dhcpMode == 2 ? 3 : 1;
        }
    }

    private void populateType() {
        this._connectionType = 0;
    }

    public void setConnectionType(int type) {
        this._connectionType = type < 2 ? type : 2;
    }

    public void setDhcpMode(int mode) {
        this._dhcpMode = mode;
        this.setModified();
    }

    public void setDhcpPool(DHCPPool pool) {
        this._dhcpPool = pool;
        this.setModified();
    }

    public void setDir(int dir) {
        if (dir != 0 && dir != 1 && dir != 2) {
            return;
        }
        this.setDesc(Description.removeFlag(this.getDesc(), SDM_ETH_WAN));
        this.setDesc(Description.removeFlag(this.getDesc(), SDM_ETH_LAN));
        if (dir == 1) {
            this.setDesc(Description.addFlag(this.getDesc(), SDM_ETH_WAN));
        } else if (dir == 2) {
            this.setDesc(Description.addFlag(this.getDesc(), SDM_ETH_LAN));
        }
    }

    public void setEncapMethod(String enCapString) {
        this._encap = enCapString == null ? "" : enCapString;
        this.setModified();
    }

    public void setEncapVLANNum(int vlanNo) {
        this._vlanNum = vlanNo;
        this.setModified();
    }

    private void setFeatures() {
        this.setSupport(4, 1);
        this.setSupport(1, 1);
        this.setSupport(0, 1);
        this.setSupport(3, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public void setNative() {
        this._native = KEY_NATIVE;
        this.setModified();
    }

    public void unSetNative() {
        this._native = "";
    }
}

