/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.ParserUtils;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.Ethernet;
import com.cisco.xdm.data.interfaces.GigEthernetSwitchPort;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.L2DuplexMode;
import com.cisco.xdm.data.interfaces.L2Speed;
import com.cisco.xdm.data.interfaces.VLANIf;
import java.util.Vector;

public class EthernetSwitchPort
extends Ethernet {
    public static final int ACCESS_MODE = 1;
    public static final int TRUNK_MODE = 2;
    private static final int DEFAULT_MODE = 1;
    public static final int NO_VLAN = -1;
    private int _mode = 1;
    private int _vlanid = 1;
    private int _nativeVlanid = 1;
    private String _vlanList = null;
    private String _stackLink = null;
    private L2Speed _speed = L2Speed.SPEED_AUTO;
    private L2DuplexMode _duplex = L2DuplexMode.AUTO;
    private boolean _isAutoPower = true;

    public EthernetSwitchPort(IfID ifID) {
        super(ifID);
        this.setSupport(0, 0);
        this.setSupport(2, 0);
        this.setSupport(3, 0);
        this.setSupport(1, 0);
        this.setSupport(4, 0);
        this.setSupport(5, 1);
        this.setSupport(6, 0);
        this.setSupport(19, 0);
        this.setSupport(8, 0);
        this.setSupport(14, 0);
        this.setSupport(7, 0);
        this.setSupport(11, 0);
        this.setSupport(10, 0);
        this.setSupport(9, 0);
        this.setSupport(18, 0);
    }

    public boolean canSubIf() {
        return false;
    }

    public Object clone() {
        EthernetSwitchPort swp = (EthernetSwitchPort)super.clone();
        swp._mode = this._mode;
        swp._nativeVlanid = this._nativeVlanid;
        swp._vlanid = this._vlanid;
        swp._stackLink = this._stackLink;
        return swp;
    }

    private CmdValues createStackLinkCmd(String ifname, boolean bNegate) {
        CmdValues cmd = new CmdValues("switchport");
        cmd.addValue("stacking-partner", "stacking-partner");
        cmd.addValue("interface", "interface");
        cmd.addValue("ifName", ifname);
        if (bNegate) {
            cmd.setAction(2);
        }
        return cmd;
    }

    public VLANIf defineVlan() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        VLANIf vlif = null;
        try {
            switch (this._mode) {
                case 1: {
                    vlif = new VLANIf(this._vlanid);
                    dev.getIfs().put(vlif);
                    break;
                }
                case 2: {
                    vlif = new VLANIf(this._nativeVlanid);
                    dev.getIfs().put(vlif);
                    break;
                }
                default: {
                    return vlif;
                }
            }
        }
        catch (XDMException xe) {
            xe.printStackTrace();
        }
        return vlif;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EthernetSwitchPort) || !super.equals(o)) {
            return false;
        }
        EthernetSwitchPort swp = (EthernetSwitchPort)o;
        return swp._mode == this._mode && swp._nativeVlanid == this._nativeVlanid && swp._vlanid == this._vlanid && (swp._vlanList == this._vlanList || this._vlanList != null && this._vlanList.equals(swp._vlanList)) && (swp._stackLink == this._stackLink || this._stackLink != null && this._stackLink.equals(swp._stackLink)) && this._speed == swp._speed && this._duplex == swp._duplex && this._isAutoPower == swp._isAutoPower;
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        CmdValues cmd;
        if (this.equals(backup)) {
            return;
        }
        EthernetSwitchPort swpBackup = (EthernetSwitchPort)backup;
        if (cmdVal.getModeCmdsValues() == null) {
            cmdVal.setModeCmdsValues(new ConfigValues());
        }
        ConfigValues subvals = cmdVal.getModeCmdsValues();
        if (swpBackup._mode != this._mode) {
            cmd = new CmdValues("switchport");
            cmd.addValue("mode", "mode");
            switch (this._mode) {
                case 2: {
                    cmd.addValue("portMode", "trunk");
                    break;
                }
                case 1: {
                    cmd.addValue("portMode", "access");
                    break;
                }
            }
            subvals.addCmdValues(cmd);
        }
        if (swpBackup._nativeVlanid != this._nativeVlanid) {
            cmd = new CmdValues("switchport");
            cmd.addValue("trunk", "trunk");
            cmd.addValue("native", "native");
            cmd.addValue("vlan", "vlan");
            if (this._nativeVlanid != -1) {
                cmd.addValue("nativeVlanID", Integer.toString(this._nativeVlanid));
            } else {
                cmd.setAction(2);
            }
            subvals.addCmdValues(cmd);
        }
        if (swpBackup._vlanid != this._vlanid) {
            cmd = new CmdValues("switchport");
            cmd.addValue("access", "access");
            cmd.addValue("vlan", "vlan");
            cmd.addValue("vlanID", Integer.toString(this._vlanid));
            subvals.addCmdValues(cmd);
        }
        if (swpBackup._stackLink == null) {
            if (this._stackLink != null) {
                cmd = this.createStackLinkCmd(this._stackLink, false);
                subvals.addCmdValues(cmd);
            }
        } else if (this._stackLink == null) {
            cmd = this.createStackLinkCmd(swpBackup._stackLink, true);
            subvals.addCmdValues(cmd);
        } else if (!this._stackLink.equals(swpBackup._stackLink)) {
            cmd = this.createStackLinkCmd(this._stackLink, false);
            subvals.addCmdValues(cmd);
        }
        if (this._duplex != swpBackup._duplex) {
            cmd = new CmdValues("duplex");
            cmd.addValue("DUPLEXMODE", this._duplex.getCLI());
            subvals.addCmdValues(cmd);
        }
        if (this._speed != swpBackup._speed) {
            cmd = new CmdValues("speed");
            cmd.addValue("SPEEDVALUE", this._speed.getCLI());
            subvals.addCmdValues(cmd);
        }
        if (this._isAutoPower != swpBackup._isAutoPower) {
            cmd = new CmdValues("power");
            cmd.addValue("inline", "inline");
            if (this._isAutoPower) {
                cmd.addValue("POWERSUPPLY", "auto");
            } else {
                cmd.addValue("POWERSUPPLY", "never");
            }
            subvals.addCmdValues(cmd);
        }
    }

    public boolean getAutoPower() {
        return this._isAutoPower;
    }

    public L2DuplexMode getDuplexMode() {
        return this._duplex;
    }

    public int getMode() {
        return this._mode;
    }

    public int getNativeVlanID() {
        return this._nativeVlanid;
    }

    public L2Speed getSpeed() {
        return this._speed;
    }

    public String[] getStackCandidates() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        int[] swmods = dev.getSwitchModules();
        Vector<EthernetSwitchPort> ifs = new Vector<EthernetSwitchPort>();
        int i = 0;
        while (i < swmods.length) {
            int slot = EthernetSwitchPort.unpackSlot(swmods[i]);
            int module = EthernetSwitchPort.unpackModule(swmods[i]);
            IfID ifid = this.getIfID();
            if (ifid.getSlot() != slot || ifid.getModuleSlot() != module) {
                Vector ports = dev.getIfs().getIfsByModule(slot, module);
                int j = ports.size() - 1;
                while (j >= 0) {
                    EthernetSwitchPort esp = (EthernetSwitchPort)ports.elementAt(j);
                    if (esp.isStackable()) {
                        ifs.addElement(esp);
                    }
                    --j;
                }
            }
            ++i;
        }
        String[] ids = new String[ifs.size()];
        int k = 0;
        while (k < ifs.size()) {
            ids[k] = ((EthernetSwitchPort)ifs.elementAt(k)).getIfID().toString();
            ++k;
        }
        return ids;
    }

    public String getStackLink() {
        return this._stackLink;
    }

    public int getVlanID() {
        return this._vlanid;
    }

    public String getVlanList() {
        return this._vlanList;
    }

    public boolean isConfigured() {
        return true;
    }

    private boolean isExclusiveStackingPort() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        IfID ifid = this.getIfID();
        Vector ports = dev.getIfs().getIfsByModule(ifid.getSlot(), ifid.getModuleSlot());
        switch (ports.size()) {
            case 9: {
                return ifid.getPort() == 9;
            }
            case 17: 
            case 38: {
                return this instanceof GigEthernetSwitchPort;
            }
        }
        return false;
    }

    public boolean isStackable() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        IfID ifid = this.getIfID();
        Vector ports = dev.getIfs().getIfsByModule(ifid.getSlot(), ifid.getModuleSlot());
        switch (ports.size()) {
            case 4: 
            case 9: {
                return true;
            }
            case 16: 
            case 36: {
                return false;
            }
            case 17: 
            case 38: {
                return this instanceof GigEthernetSwitchPort;
            }
        }
        return false;
    }

    public static boolean isStackingNeeded(DeviceBase dev) {
        int[] swmods = dev.getSwitchModules();
        if (swmods.length < 2) {
            return false;
        }
        int i = 0;
        while (i < swmods.length) {
            Vector ifs = dev.getIfs().getIfsByModule(EthernetSwitchPort.unpackSlot(swmods[i]), EthernetSwitchPort.unpackModule(swmods[i]));
            boolean bStacked = false;
            int j = 0;
            while (j < ifs.size()) {
                EthernetSwitchPort swpif = (EthernetSwitchPort)ifs.elementAt(j);
                if (swpif.getStackLink() != null) {
                    bStacked = true;
                    break;
                }
                ++j;
            }
            if (!bStacked) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSupported(int attr) {
        if (attr == 23 && this.isExclusiveStackingPort()) {
            this.setSupport(attr, 0);
        }
        return super.isSupported(attr);
    }

    public static int pack(int slot, int module) {
        return (slot & 0xFFFF) << 16 & 0xFFFF0000 | module & 0xFFFF;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        CmdValues cmdval;
        String power;
        ConfigValues cfgval;
        String speed;
        super.populate(config, cmdVal);
        ConfigValues subcmds = cmdVal.getModeCmdsValues();
        ConfigValues switchportCmds = null;
        ConfigValues accessCmds = null;
        ConfigValues trunkCmds = null;
        ConfigValues stackCmds = null;
        try {
            int vlan;
            String vlanStr;
            CmdValues cv;
            switchportCmds = subcmds.getCmds("switchport", ".*", ".*", false);
            if (switchportCmds != null) {
                ConfigValues modeCmd = switchportCmds.getCmds("switchport", "mode", "mode", false);
                if (modeCmd != null) {
                    if (modeCmd.numCmds() == 1) {
                        CmdValues cv2 = modeCmd.getCmdValues(0);
                        String modeStr = cv2.getValue("portMode");
                        if (modeStr != null) {
                            if (modeStr.equals("access")) {
                                this._mode = 1;
                            } else if (modeStr.equals("trunk")) {
                                this._mode = 2;
                            }
                        } else {
                            this.setConfigurable(false);
                        }
                    } else {
                        this.setConfigurable(false);
                    }
                }
                trunkCmds = switchportCmds.getCmds("switchport", "trunk", "trunk", false);
                accessCmds = switchportCmds.getCmds("switchport", "access", "access", false);
                stackCmds = switchportCmds.getCmds("switchport", "stacking-partner", "stacking-partner", false);
            }
            int numTrunkCmds = trunkCmds == null ? 0 : trunkCmds.numCmds();
            int numAccessCmds = accessCmds == null ? 0 : accessCmds.numCmds();
            String stackingPartner = stackCmds == null ? null : stackCmds.getCmdValues(0).getValue("ifName");
            this.setStackLink(stackingPartner);
            int i = 0;
            while (i < numAccessCmds) {
                cv = accessCmds.getCmdValues(i);
                vlanStr = cv.getValue("vlanID");
                if (vlanStr != null) {
                    try {
                        this._vlanid = vlan = Integer.parseInt(vlanStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.getLog().error("Internal error: bad vlan");
                    }
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < numTrunkCmds) {
                String rangeStr;
                String encapStr;
                cv = trunkCmds.getCmdValues(i);
                if (cv.getValue("encapsulation") != null && !(encapStr = cv.getValue("encapType")).equals("dot1q")) {
                    this.setConfigurable(false);
                }
                if (cv.getValue("native") != null && (vlanStr = cv.getValue("nativeVlanID")) != null) {
                    try {
                        this._nativeVlanid = vlan = Integer.parseInt(vlanStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.getLog().error("Internal error: bad native vlan");
                    }
                }
                if (cv.getValue("allowed") != null && (rangeStr = cv.getValue("all")) == null) {
                    this._vlanList = cv.getValue("vlanList");
                    this.setConfigurable(false);
                }
                ++i;
            }
        }
        catch (CliGPBException e) {
            Log.getLog().error("EthernetSwitchPort populate exception: " + e);
        }
        String mode = ParserUtils.getCommandValue(subcmds, "duplex", "DUPLEXMODE");
        if (mode != null && mode.trim().length() != 0) {
            this._duplex = L2DuplexMode.lookupByString(mode.trim());
        }
        if ((speed = ParserUtils.getCommandValue(subcmds, "speed", "SPEEDVALUE")) != null && speed.trim().length() != 0) {
            this._speed = L2Speed.lookupByString(speed.trim());
        }
        if ((cfgval = subcmds.getCmds("power", "inline", "inline", false)) != null && (power = (cmdval = cfgval.getCmdValues(0)).getValue("POWERSUPPLY")) != null && power.equals("never")) {
            this._isAutoPower = false;
        }
    }

    public void setAutoPower(boolean isAutoPower) {
        this._isAutoPower = isAutoPower;
        this.setModified();
    }

    public void setDuplexMode(L2DuplexMode duplex) {
        this._duplex = duplex;
        this.setModified();
    }

    public void setMode(int mode) {
        if (mode == 1 || mode == 2) {
            this._mode = mode;
        }
        this.shutdown(false);
        this.setModified();
    }

    public void setNativeVlanID(int vlanid) {
        this._nativeVlanid = vlanid;
        this.shutdown(false);
        this.setModified();
    }

    public void setSpeed(L2Speed speed) {
        this._speed = speed;
        this.setModified();
    }

    public void setStackLink(String stackIf) {
        Log.getLog().debug("setStackLink: " + stackIf);
        this._stackLink = stackIf;
        this.setModified();
    }

    public void setVlanID(int vlanid) {
        this._vlanid = vlanid;
        this.shutdown(false);
        this.setModified();
    }

    public static int unpackModule(int packedValue) {
        int upperMask = (packedValue & 0x8000) != 0 ? -65536 : 0;
        return packedValue & 0xFFFF | upperMask;
    }

    public static int unpackSlot(int packedValue) {
        return (packedValue & 0xFFFF0000) >> 16;
    }
}

