/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.AddressMask;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import java.util.Vector;

public class IfIPAddress
extends XDMObject
implements Cloneable {
    private IPAddress _ipAddr;
    private Netmask _mask;
    private Vector _secondaryIpAddr;
    private IfID _ipUnnumberedIntf;
    private String _clientId;
    private String _hostname;
    private String _poolname;
    private IPAddressType _type;

    public IfIPAddress() {
    }

    public IfIPAddress(IPAddress ipAddress, Netmask netMask) {
        this._ipAddr = ipAddress;
        this._mask = netMask;
        this._type = IPAddressType.STATIC;
    }

    public IfIPAddress(IPAddressType type) {
        this._type = type;
    }

    public IfIPAddress(IfID interf) {
        this._ipUnnumberedIntf = interf;
        this._type = IPAddressType.UNNUMBERED;
    }

    public void clearIPAddress() {
        this._type = null;
        this.setModified();
    }

    public Object clone() {
        IfIPAddress newObj = (IfIPAddress)super.clone();
        if (this._ipAddr != null) {
            newObj._ipAddr = (IPAddress)this._ipAddr.clone();
        }
        if (this._mask != null) {
            newObj._mask = (Netmask)this._mask.clone();
        }
        if (this._secondaryIpAddr != null) {
            newObj._secondaryIpAddr = (Vector)this._secondaryIpAddr.clone();
        }
        newObj._type = this._type;
        return newObj;
    }

    public boolean equals(Object tmpAddr) {
        if (tmpAddr == null || !(tmpAddr instanceof IfIPAddress)) {
            return false;
        }
        IfIPAddress addr = (IfIPAddress)tmpAddr;
        if (this._type != addr.getIPAddressType()) {
            return false;
        }
        switch (addr.getIPAddressType().getValue()) {
            case 1: {
                return this.isStaticIpEqual(addr);
            }
            case 2: {
                if (addr.getClientId() == null && this._clientId == null) {
                    if (addr.getHostname() == null && this._hostname == null) {
                        return true;
                    }
                    if (addr.getHostname() != null && this._hostname != null) {
                        return addr.getHostname().equals(this._hostname);
                    }
                    return false;
                }
                if (addr.getClientId() != null && this._clientId != null) {
                    if (addr.getClientId().equals(this._clientId)) {
                        if (addr.getHostname() == null && this._hostname == null) {
                            return true;
                        }
                        if (addr.getHostname() != null && this._hostname != null) {
                            return addr.getHostname().equals(this._hostname);
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            case 3: {
                if (addr.getIPUnnumberedIntf() == null && this._ipUnnumberedIntf == null) {
                    return true;
                }
                if (addr.getIPUnnumberedIntf() != null && this._ipUnnumberedIntf != null) {
                    return addr.getIPUnnumberedIntf().equals(this._ipUnnumberedIntf);
                }
                return false;
            }
            case 5: {
                if (addr.getPoolname() == null && this._poolname == null) {
                    return true;
                }
                if (addr.getPoolname() != null && this._poolname != null) {
                    return addr.getPoolname().equals(this._poolname);
                }
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private Vector generateCommand(int action) {
        return this.generateCommand(this, action);
    }

    private Vector generateCommand(IfIPAddress address, int action) {
        if (address.getIPAddressType() == null) {
            return null;
        }
        Vector<CmdValues> retVal = new Vector<CmdValues>();
        CmdValues cmdvalret = new CmdValues("ip");
        switch (address.getIPAddressType().getValue()) {
            case 1: {
                cmdvalret.addValue("address", "address");
                if (address._ipAddr != null && address._mask != null) {
                    cmdvalret.addValue("ipAddress", address._ipAddr.toString());
                    cmdvalret.addValue("subnetMask", address._mask.toString());
                    cmdvalret.setAction(action);
                    retVal.addElement(cmdvalret);
                }
                if (address._secondaryIpAddr == null || address._secondaryIpAddr.size() <= 0) break;
                int j = 0;
                while (j < address._secondaryIpAddr.size()) {
                    CmdValues tmpCmd = new CmdValues("ip");
                    IPAddress tmpAddr = ((AddressMask)address._secondaryIpAddr.elementAt(j)).getAddress();
                    Netmask tmpMask = ((AddressMask)address._secondaryIpAddr.elementAt(j)).getMask();
                    if (tmpAddr != null && tmpMask != null) {
                        tmpCmd.addValue("address", "address");
                        tmpCmd.addValue("ipAddress", tmpAddr.toString());
                        tmpCmd.addValue("subnetMask", tmpMask.toString());
                        tmpCmd.addValue("secondary", "secondary");
                        tmpCmd.setAction(action);
                        if (action == 2) {
                            retVal.insertElementAt(tmpCmd, 0);
                        } else {
                            retVal.addElement(tmpCmd);
                        }
                    }
                    ++j;
                }
                break;
            }
            case 2: {
                cmdvalret.addValue("address", "address");
                cmdvalret.addValue("dhcp", "dhcp");
                if (address._clientId != null) {
                    cmdvalret.addValue("client-id", "client-id");
                    cmdvalret.addValue("clientId", address._clientId);
                }
                if (address._hostname != null) {
                    cmdvalret.addValue("hostname", "hostname");
                    cmdvalret.addValue("hostName", address._hostname);
                }
                cmdvalret.setAction(action);
                retVal.addElement(cmdvalret);
                break;
            }
            case 5: {
                cmdvalret.addValue("address", "address");
                cmdvalret.addValue("pool", "pool");
                if (address._poolname != null) {
                    cmdvalret.addValue("poolName", address._poolname);
                }
                cmdvalret.setAction(action);
                retVal.addElement(cmdvalret);
                break;
            }
            case 4: {
                cmdvalret.addValue("address", "address");
                cmdvalret.addValue("negotiated", "negotiated");
                cmdvalret.setAction(action);
                retVal.addElement(cmdvalret);
                break;
            }
            case 3: {
                cmdvalret.addValue("unnumbered", "unnumbered");
                if (address._ipUnnumberedIntf != null) {
                    cmdvalret.addValue("ipUnnumberedIntf", address._ipUnnumberedIntf.toString());
                }
                cmdvalret.setAction(action);
                retVal.addElement(cmdvalret);
                break;
            }
            default: {
                return null;
            }
        }
        return retVal;
    }

    public void generateDelta(XDMObject backup, ConfigValues cfgval) throws XDMException {
        Log.getLog().debug("IfIPAddress: generateDelta: You shouldn't come here..");
    }

    public Vector generateIPAddessCommand(XDMObject backup, XDMInterfaceBase intf) throws XDMException {
        if (this.isBackup()) {
            Vector cmdvalgen = this.generateCommand(2);
            return cmdvalgen;
        }
        Vector cmdvalgen = backup == null ? this.generateCommand(1) : this.generateModifyCommand(backup);
        return cmdvalgen;
    }

    private Vector generateModifyCommand(XDMObject backupobj) {
        if (!(backupobj instanceof IfIPAddress)) {
            return null;
        }
        IfIPAddress backup = (IfIPAddress)backupobj;
        String backuptype = backup._type.toString();
        if (backuptype == null) {
            Vector cmdvalgen = this.generateCommand(1);
            return cmdvalgen;
        }
        if (this._type == null) {
            Vector cmdvalgen = this.generateCommand(backup, 2);
            return cmdvalgen;
        }
        if (this._type.getValue() != backup.getIPAddressType().getValue()) {
            int j;
            Vector cmdvalgen = this.generateCommand(1);
            if (backup.isSecondaryIpExists()) {
                Vector cmdvalgenSec = this.generateSecCommands(backup, 2);
                j = 0;
                while (j < cmdvalgenSec.size()) {
                    cmdvalgen.insertElementAt((CmdValues)cmdvalgenSec.elementAt(j), 0);
                    ++j;
                }
            }
            if (this._type.getValue() == 3 || backup.getIPAddressType().getValue() == 3) {
                Vector cmdvalgenBackup = this.generateCommand(backup, 2);
                j = 0;
                while (j < cmdvalgenBackup.size()) {
                    cmdvalgen.insertElementAt((CmdValues)cmdvalgenBackup.elementAt(j), 0);
                    ++j;
                }
            }
            return cmdvalgen;
        }
        switch (this._type.getValue()) {
            case 1: {
                if (!this.isStaticIpPrimEqual(backup)) {
                    CmdValues cmdvalret = new CmdValues("ip");
                    cmdvalret.addValue("address", "address");
                    cmdvalret.addValue("ipAddress", this._ipAddr.toString());
                    cmdvalret.addValue("subnetMask", this._mask.toString());
                    cmdvalret.setAction(1);
                    Vector<CmdValues> cmdvalgen = new Vector<CmdValues>();
                    cmdvalgen.addElement(cmdvalret);
                    return cmdvalgen;
                }
                return null;
            }
            case 2: {
                if (!this.equals(backup)) break;
                return null;
            }
            case 5: {
                if (!this._poolname.equals(backup.getPoolname())) break;
                return null;
            }
            case 4: {
                return null;
            }
            case 3: {
                if (!this._ipUnnumberedIntf.equals(backup.getIPUnnumberedIntf())) break;
                return null;
            }
            default: {
                return null;
            }
        }
        Vector cmdvalgen = this.generateCommand(this, 1);
        return cmdvalgen;
    }

    private Vector generateSecCommands(IfIPAddress backup, int action) {
        Vector<CmdValues> retVal = new Vector<CmdValues>();
        int i = 0;
        while (i < backup._secondaryIpAddr.size()) {
            AddressMask secIp = (AddressMask)backup._secondaryIpAddr.elementAt(i);
            CmdValues cmdval = new CmdValues("ip");
            cmdval.addValue("address", "address");
            cmdval.addValue("ipAddress", secIp.getAddress().toString());
            cmdval.addValue("subnetMask", secIp.getMask().toString());
            cmdval.addValue("secondary", "secondary");
            cmdval.setAction(action);
            retVal.addElement(cmdval);
            ++i;
        }
        return retVal;
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getHostname() {
        return this._hostname;
    }

    public IPAddress getIPAddress() {
        if (this._type != IPAddressType.STATIC) {
            return null;
        }
        return this._ipAddr;
    }

    public String getIPAddressAsString() {
        if (this._type == null) {
            return "";
        }
        switch (this._type.getValue()) {
            case 1: {
                if (this._ipAddr == null) break;
                return this._ipAddr.toString();
            }
            case 2: {
                return "Dynamic IP";
            }
            case 3: {
                IfIPAddress unnumberedipaddr;
                if (this._ipUnnumberedIntf == null) break;
                DeviceBase device = (DeviceBase)this.getDevice();
                XDMInterfaceBase unnumberedintf = (XDMInterfaceBase)device.getIfs().get(this._ipUnnumberedIntf);
                if (unnumberedintf != null && (unnumberedipaddr = unnumberedintf.getIpAddr()) != null && unnumberedipaddr.getIPAddressType() == IPAddressType.STATIC) {
                    return String.valueOf(unnumberedipaddr.getIPAddress().toString()) + "(unnumbered " + this._ipUnnumberedIntf.toString() + ")";
                }
                return this._ipUnnumberedIntf.toString();
            }
            case 5: {
                if (this._poolname == null) break;
                return "Local DHCP Pool - " + this._poolname;
            }
            case 4: {
                return "Easy IP";
            }
            default: {
                return "";
            }
        }
        return "";
    }

    public IPAddressType getIPAddressType() {
        return this._type;
    }

    public IPAddress getIPSubnet() {
        if (this._type != null) {
            IfIPAddress unnumberedipaddr;
            DeviceBase device;
            XDMInterfaceBase unnumberedintf;
            if (this._type == IPAddressType.STATIC && this._ipAddr != null && this._mask != null) {
                try {
                    IPAddress subnet = new IPAddress(this._ipAddr, this._mask);
                    return subnet;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (this._type == IPAddressType.UNNUMBERED && this._ipUnnumberedIntf != null && (unnumberedintf = (XDMInterfaceBase)(device = (DeviceBase)this.getDevice()).getIfs().get(this._ipUnnumberedIntf)) != null && (unnumberedipaddr = unnumberedintf.getIpAddr()) != null && unnumberedipaddr.getIPAddressType() == IPAddressType.STATIC) {
                IPAddress addr = unnumberedipaddr.getIPAddress();
                Netmask mask = unnumberedipaddr.getNetmask();
                if (addr != null && mask != null) {
                    try {
                        IPAddress subnet = new IPAddress(addr, mask);
                        return subnet;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public String getIPUnnumIntfIPAddr() {
        if (this._type == IPAddressType.UNNUMBERED && this._ipUnnumberedIntf != null) {
            IfIPAddress unnumberedipaddr;
            DeviceBase device = (DeviceBase)this.getDevice();
            XDMInterfaceBase unnumberedintf = (XDMInterfaceBase)device.getIfs().get(this._ipUnnumberedIntf);
            if (unnumberedintf != null && (unnumberedipaddr = unnumberedintf.getIpAddr()) != null && unnumberedipaddr.getIPAddressType() == IPAddressType.STATIC) {
                return String.valueOf(unnumberedipaddr.getIPAddress().toString()) + "(unnumbered " + this._ipUnnumberedIntf.toString() + ")";
            }
            return this._ipUnnumberedIntf.toString();
        }
        return null;
    }

    public IPAddress getIPUnnumIntfIPAddress() {
        IfIPAddress unnumberedipaddr;
        DeviceBase device;
        XDMInterfaceBase unnumberedintf;
        if (this._type == IPAddressType.UNNUMBERED && this._ipUnnumberedIntf != null && (unnumberedintf = (XDMInterfaceBase)(device = (DeviceBase)this.getDevice()).getIfs().get(this._ipUnnumberedIntf)) != null && (unnumberedipaddr = unnumberedintf.getIpAddr()) != null && unnumberedipaddr.getIPAddressType() == IPAddressType.STATIC) {
            return unnumberedipaddr.getIPAddress();
        }
        return null;
    }

    public Netmask getIPUnnumIntfNetmask() {
        IfIPAddress unnumberedipaddr;
        DeviceBase device;
        XDMInterfaceBase unnumberedintf;
        if (this._type == IPAddressType.UNNUMBERED && this._ipUnnumberedIntf != null && (unnumberedintf = (XDMInterfaceBase)(device = (DeviceBase)this.getDevice()).getIfs().get(this._ipUnnumberedIntf)) != null && (unnumberedipaddr = unnumberedintf.getIpAddr()) != null && unnumberedipaddr.getIPAddressType() == IPAddressType.STATIC) {
            return unnumberedipaddr.getNetmask();
        }
        return null;
    }

    public IfID getIPUnnumberedIntf() {
        if (this._type != IPAddressType.UNNUMBERED) {
            return null;
        }
        return this._ipUnnumberedIntf;
    }

    public Netmask getNetmask() {
        if (this._type != IPAddressType.STATIC) {
            return null;
        }
        return this._mask;
    }

    public String getPoolname() {
        return this._poolname;
    }

    public Vector getSecondaryIPs() {
        return this._secondaryIpAddr;
    }

    private String getSecondaryIPsAsString() {
        String retVal = "";
        if (this.isSecondaryIpExists()) {
            int i = 0;
            while (i < this._secondaryIpAddr.size()) {
                AddressMask addrMask = (AddressMask)this._secondaryIpAddr.elementAt(i);
                retVal = retVal.concat("Address = " + addrMask.getAddress() + " MASK is " + addrMask.getMask() + "\n");
                ++i;
            }
        }
        return retVal;
    }

    public String getWildcardMask() {
        if (this._type == IPAddressType.STATIC && this._ipAddr != null && this._mask != null) {
            Netmask wildcardmask = new Netmask(~this._mask.getIntValue());
            return wildcardmask.toString();
        }
        return null;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isIPUnnumbered() {
        return this.getIPUnnumIntfIPAddress() != null;
    }

    public boolean isSecondaryIpExists() {
        if (this._type != IPAddressType.STATIC) {
            return false;
        }
        return this._type == IPAddressType.STATIC && this._secondaryIpAddr != null && this._secondaryIpAddr.size() > 0;
    }

    public boolean isStatic() {
        return this._type == IPAddressType.STATIC && this._ipAddr != null && this._mask != null;
    }

    private boolean isStaticIpEqual(IfIPAddress tmp) {
        return this.isStaticIpPrimEqual(tmp) && this.isStaticIpSecEqual(tmp);
    }

    public boolean isStaticIpMatch(IPAddress tmpAddr) {
        if (tmpAddr == null || this._type != IPAddressType.STATIC) {
            return false;
        }
        return this.isStaticIpPrimMatch(tmpAddr) || this.isStaticIpSecMatch(tmpAddr);
    }

    private boolean isStaticIpPrimEqual(IfIPAddress tmp) {
        if (this._ipAddr == null) {
            if (tmp._ipAddr != null) {
                return false;
            }
        } else {
            if (tmp._ipAddr == null) {
                return false;
            }
            if (!this._ipAddr.equals(tmp._ipAddr)) {
                return false;
            }
        }
        if (this._mask == null) {
            if (tmp._mask != null) {
                return false;
            }
        } else {
            if (tmp._mask == null) {
                return false;
            }
            if (!this._mask.equals(tmp._mask)) {
                return false;
            }
        }
        return true;
    }

    private boolean isStaticIpPrimMatch(IPAddress addr) {
        return addr.equals(this._ipAddr);
    }

    private boolean isStaticIpPrimSubnetMatch(IPAddress address, Netmask mask) {
        if (this._ipAddr == null || this._mask == null) {
            return false;
        }
        return IPAddress.verifyNetwork(address, mask, this._ipAddr, this._mask);
    }

    private boolean isStaticIpSecEqual(IfIPAddress tmp) {
        if (this._secondaryIpAddr == null) {
            if (tmp._secondaryIpAddr != null) {
                return false;
            }
        } else {
            if (tmp._secondaryIpAddr == null) {
                return false;
            }
            if (tmp._secondaryIpAddr != null) {
                int size2;
                int size1 = this._secondaryIpAddr.size();
                if (size1 != (size2 = tmp._secondaryIpAddr.size())) {
                    return false;
                }
                int i = 0;
                while (i < size2) {
                    if (!this._secondaryIpAddr.contains(tmp._secondaryIpAddr.elementAt(i))) {
                        return false;
                    }
                    ++i;
                }
                int j = 0;
                while (j < size1) {
                    if (!tmp._secondaryIpAddr.contains(this._secondaryIpAddr.elementAt(j))) {
                        return false;
                    }
                    ++j;
                }
            }
        }
        return true;
    }

    private boolean isStaticIpSecMatch(IPAddress addr) {
        if (this._secondaryIpAddr == null) {
            return false;
        }
        int size1 = this._secondaryIpAddr.size();
        int i = 0;
        while (i < size1) {
            AddressMask secIp = (AddressMask)this._secondaryIpAddr.elementAt(i);
            if (secIp != null && addr.equals(secIp.getAddress())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isStaticIpSecSubnetMatch(IPAddress address, Netmask mask) {
        if (this._secondaryIpAddr == null) {
            return false;
        }
        int size1 = this._secondaryIpAddr.size();
        int i = 0;
        while (i < size1) {
            AddressMask secIp = (AddressMask)this._secondaryIpAddr.elementAt(i);
            if (secIp != null) {
                IPAddress address1 = secIp.getAddress();
                Netmask mask1 = secIp.getMask();
                if (address1 != null && mask1 != null && IPAddress.verifyNetwork(address, mask, address1, mask1)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isStaticIpSubnetMatch(IPAddress address, Netmask mask) {
        if (address == null || mask == null || this._type != IPAddressType.STATIC) {
            return false;
        }
        return this.isStaticIpPrimSubnetMatch(address, mask) || this.isStaticIpSecSubnetMatch(address, mask);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populate(ConfigValues configValues, CmdValues cmdVal) throws CliGPBException, XDMException {
        if (cmdVal == null) {
            throw new XDMException(7, this);
        }
        String cmdName = cmdVal.getCmdName();
        if (!cmdName.equals("ip")) {
            throw new XDMException(8, this);
        }
        if (cmdVal.containsKey("unnumbered")) {
            this._type = IPAddressType.UNNUMBERED;
            if (!cmdVal.containsKey("ipUnnumberedIntf")) throw new XDMException(9, this);
            String tmp = cmdVal.getValue("ipUnnumberedIntf");
            DeviceBase dev = (DeviceBase)this.getDevice();
            this._ipUnnumberedIntf = IfID.fromString(tmp, dev.getDevInfoBase().getHWConfig());
        } else {
            if (!cmdVal.containsKey("address")) throw new XDMException(12, this);
            if (cmdVal.containsKey("negotiated")) {
                this._type = IPAddressType.NEGOTIATED;
            } else if (cmdVal.containsKey("pool")) {
                this._type = IPAddressType.POOL;
                if (!cmdVal.containsKey("poolName")) throw new XDMException(10, this);
                this._poolname = cmdVal.getValue("poolName");
            } else if (cmdVal.containsKey("dhcp")) {
                this._type = IPAddressType.DYNAMIC;
                if (cmdVal.containsKey("clientId")) {
                    this._clientId = cmdVal.getValue("clientId");
                }
                if (cmdVal.containsKey("hostName")) {
                    this._hostname = cmdVal.getValue("hostName");
                }
            } else if (cmdVal.containsKey("ipAddress")) {
                Log.getLog().debug("IfIPAddress: ip address is static");
                this._type = IPAddressType.STATIC;
                String tmp = cmdVal.getValue("ipAddress");
                String tmpMask = cmdVal.getValue("subnetMask");
                if (cmdVal.containsKey("secondary")) {
                    if (this._secondaryIpAddr == null) {
                        this._secondaryIpAddr = new Vector();
                    }
                    this._secondaryIpAddr.addElement(new AddressMask(new IPAddress(tmp), new Netmask(tmpMask)));
                } else {
                    this._ipAddr = new IPAddress(tmp);
                    Log.getLog().debug("IfIPAddress: _ipAddr is " + this._ipAddr);
                    this._mask = new Netmask(tmpMask);
                    Log.getLog().debug("IfIPAddress: _mask is " + this._mask);
                }
            }
        }
        Log.getLog().debug("IfIPAddress: end populate");
    }

    public boolean setClientId(String clientid) {
        if (this._type != IPAddressType.DYNAMIC) {
            return false;
        }
        this._clientId = clientid;
        this.setModified();
        return true;
    }

    public boolean setHostname(String hostname) {
        if (this._type != IPAddressType.DYNAMIC) {
            return false;
        }
        this._hostname = hostname;
        this.setModified();
        return true;
    }

    public boolean setIPAddress(IPAddress address) {
        if (this._type != IPAddressType.STATIC) {
            return false;
        }
        this._ipAddr = address;
        this.setModified();
        return true;
    }

    public boolean setIPAddressType(IPAddressType type) {
        this._type = type;
        this.setModified();
        return true;
    }

    public boolean setIPUnnumberedIntf(IfID interf) {
        if (this._type != IPAddressType.UNNUMBERED) {
            return false;
        }
        this._ipUnnumberedIntf = interf;
        this.setModified();
        return true;
    }

    public boolean setNetmask(Netmask mask) {
        if (this._type != IPAddressType.STATIC) {
            return false;
        }
        this._mask = mask;
        this.setModified();
        return true;
    }

    public boolean setPoolName(String pool) {
        if (this._type != IPAddressType.POOL) {
            return false;
        }
        this._poolname = pool;
        this.setModified();
        return true;
    }

    public String toString() {
        String retVal = new String("");
        if (this._type != null) {
            switch (this._type.getValue()) {
                case 1: {
                    retVal = retVal.concat(" Address Type is STATIC. \n");
                    if (this._ipAddr != null) {
                        retVal = retVal.concat(" Primary IP = " + this._ipAddr + "\n");
                    }
                    if (this._mask != null) {
                        retVal = retVal.concat(" Mask = " + this._mask + "\n");
                    }
                    if (!this.isSecondaryIpExists()) break;
                    retVal = retVal.concat("Found Secondary IPs: \n " + this.getSecondaryIPsAsString());
                    break;
                }
                case 3: {
                    retVal = retVal.concat(" Address Type is UNNUMBERED. \n");
                    if (this._ipUnnumberedIntf == null) break;
                    retVal = retVal.concat("Unnumbered Intf is " + this._ipUnnumberedIntf);
                    break;
                }
                case 2: {
                    retVal = retVal.concat(" Address Type is DYNAMIC \n");
                    if (this._clientId != null) {
                        retVal = retVal.concat("Client Id is " + this._clientId + "\n");
                    }
                    if (this._hostname == null) break;
                    retVal = retVal.concat("Hostname  is " + this._hostname + "\n");
                    break;
                }
                case 5: {
                    retVal = retVal.concat(" Address Type is POOL \n");
                    if (this._poolname == null) break;
                    retVal = retVal.concat("Pool name is " + this._poolname);
                    break;
                }
                case 4: {
                    retVal = retVal.concat(" Address Type is NEGOTIATED \n");
                    break;
                }
                default: {
                    retVal = retVal.concat("UNKNOWN IP");
                }
            }
        }
        return retVal;
    }
}

