/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.NHRPMap;

public class NHRPMapCollection
extends XDMHashCollection {
    public NHRPMapCollection(XDMObject parent) {
        super(parent);
    }

    public boolean addMap(NHRPMap map) {
        if (map == null) {
            throw new NullPointerException("Null NHRP map parameter for addMap method");
        }
        map.setParent(this);
        this.setModified();
        this.put(map.toString(), map);
        return true;
    }

    public boolean contains(NHRPMap map) {
        if (map == null) {
            throw new NullPointerException("Null map parameter for \"contains\" method");
        }
        return super.containsKey(map.toString());
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException {
        if (configValues == null) {
            return;
        }
        int i = 0;
        while (i < configValues.numCmds()) {
            CmdValues cmd = configValues.getCmdValues(i);
            String cmdName = cmd.getCmdName();
            if (cmdName.equals("ip") && cmd.containsKey("nhrp") && cmd.containsKey("map")) {
                NHRPMap map = new NHRPMap();
                map.setParent(this);
                map.populate(configValues, cmd);
                this.put(map.toString(), map);
            }
            ++i;
        }
    }

    public boolean removeMap(NHRPMap map) {
        this.setModified();
        Object retVal = this.remove(map.toString());
        return retVal != null;
    }
}

