/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;

public class SSID
extends XDMObject {
    private String _ssid;
    private boolean _authen_open = false;
    private static final String KEY_OPEN = "open";
    private static final String KEY_AUTHENTICATION = "authentication";
    private static final String KEY_DONTCARE = "DONTCARE";
    private static final String KEY_SSID = "ssid";
    private static final String KEY_ID = "ID";

    public SSID(String id) {
        this._ssid = id;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues cmd = new CmdValues(KEY_SSID);
        cmd.addValue(KEY_ID, this._ssid);
        if (this.isBackup()) {
            cmd.setAction(2);
        } else {
            ConfigValues subcvs = new ConfigValues();
            CmdValues subcmd = new CmdValues(KEY_AUTHENTICATION);
            subcmd.addValue(KEY_OPEN, KEY_OPEN);
            if (!this._authen_open) {
                subcmd.setAction(2);
            }
            subcvs.addCmdValues(subcmd);
            cmd.setModeCmdsValues(subcvs);
        }
        values.addCmdValues(cmd);
    }

    public String getID() {
        return this._ssid;
    }

    public boolean isAuthenOpen() {
        return this._authen_open;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (cmdVal == null) {
            return;
        }
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        if (subCmds == null) {
            return;
        }
        int i = 0;
        while (i < subCmds.numCmds()) {
            CmdValues cmd = subCmds.getCmdValues(i);
            String cmdName = cmd.getCmdName();
            if (cmdName.equals(KEY_AUTHENTICATION) && cmd.containsKey(KEY_OPEN)) {
                String dontCare;
                this._authen_open = true;
                if (cmd.containsKey(KEY_DONTCARE) && (dontCare = cmd.getValue(KEY_DONTCARE)) != null && dontCare.length() > 0 && !dontCare.equalsIgnoreCase("null")) {
                    this.setReadOnly(true);
                }
            }
            ++i;
        }
    }

    public void setAuthenOpen(boolean enable) {
        this._authen_open = enable;
    }
}

