/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.xdm.data.interfaces.Ethernet;
import com.cisco.xdm.data.interfaces.IfID;
import java.util.Vector;

public class SwitchDMInterface
extends Ethernet {
    private static final String HEADER_SWDMADDR = "$SWDMADDR:";
    private static final String END_SWDMADDR = "$";

    public SwitchDMInterface(IfID ifID) {
        super(ifID);
        this.setSupport(0, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(1, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public boolean canSubIf() {
        return true;
    }

    protected Vector getFlags() {
        Vector flags = super.getFlags();
        flags.addElement(HEADER_SWDMADDR);
        return flags;
    }

    public String getSWDMAddr() {
        String desc = this.getDesc();
        int start = desc.indexOf(HEADER_SWDMADDR);
        if (start == -1) {
            return "";
        }
        int end = desc.indexOf(END_SWDMADDR, start + HEADER_SWDMADDR.length());
        if (end == -1) {
            return "";
        }
        return desc.substring(start + HEADER_SWDMADDR.length(), end);
    }

    private String getStringWithoutSWDMAddr(String buf) {
        int start = buf.indexOf(HEADER_SWDMADDR);
        if (start == -1) {
            return buf;
        }
        int end = buf.indexOf(END_SWDMADDR, start + HEADER_SWDMADDR.length());
        if (end == -1) {
            return buf;
        }
        StringBuffer sb = new StringBuffer(buf.substring(0, start));
        if (end < buf.length() - 1) {
            sb.append(buf.substring(end + 1));
        }
        return sb.toString();
    }

    public void setSWDMAddr(String addr) {
        StringBuffer sb = new StringBuffer(this.getStringWithoutSWDMAddr(this.getDesc()));
        if (addr != null && addr.length() > 0) {
            sb.append(HEADER_SWDMADDR);
            sb.append(addr);
            sb.append(END_SWDMADDR);
        }
        this.setDesc(sb.toString());
    }
}

