/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMSubInterface;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import java.util.Enumeration;

public abstract class XDMInterface
extends XDMInterfaceBase {
    private XDMSubInterfaces _subIfs = null;

    public XDMInterface(IfID ifID) {
        super(ifID);
    }

    public abstract boolean canSubIf();

    public Object clone() {
        XDMInterface newIf = (XDMInterface)super.clone();
        if (this._subIfs != null) {
            newIf._subIfs = (XDMSubInterfaces)this._subIfs.clone();
            newIf._subIfs.setParent(newIf);
            Enumeration e = newIf._subIfs.elements();
            while (e.hasMoreElements()) {
                XDMSubInterface subIf = (XDMSubInterface)e.nextElement();
                subIf.setMainInterface(newIf);
            }
        }
        return newIf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XDMInterface)) {
            return false;
        }
        XDMInterface ifObj = (XDMInterface)obj;
        return super.equals(obj) && (this._subIfs == null && ifObj._subIfs == null || this._subIfs == null && ifObj._subIfs != null && ifObj._subIfs.size() == 0 || ifObj._subIfs == null && this._subIfs != null && this._subIfs.size() == 0 || this._subIfs != null && ifObj._subIfs != null && this._subIfs.equals(ifObj._subIfs));
    }

    public final void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup != null && !(backup instanceof XDMInterface)) {
            throw new XDMException(3, this);
        }
        if (this.isBackup()) {
            if (this._subIfs != null) {
                this._subIfs.generateDelta(backup, values);
            }
            super.generateDelta(backup, values);
        } else {
            XDMInterface backupIf;
            XDMSubInterfaces backupIfs;
            if (backup == null) {
                CmdValues cmd = this.generateInterfaceCmd();
                cmd.setModeCmdsValues(new ConfigValues());
                values.addCmdValues(cmd);
                CmdValues defCli = new CmdValues("default");
                defCli.addValue("interface", "interface");
                defCli.addValue("NAME", this.getIfID().toString());
                values.addCmdValues(defCli);
            }
            if (this._subIfs != null && this._subIfs.isModified()) {
                backupIfs = null;
                if (backup != null) {
                    backupIf = (XDMInterface)backup;
                    backupIfs = backupIf.getSubInterfaces();
                }
                this._subIfs.generateDeleteDelta(backupIfs, values);
            }
            if (this.isModified()) {
                super.generateDelta(backup, values);
            }
            if (this._subIfs != null && this._subIfs.isModified()) {
                backupIfs = null;
                if (backup != null) {
                    backupIf = (XDMInterface)backup;
                    backupIfs = backupIf.getSubInterfaces();
                }
                this._subIfs.generateAddModifyDelta(backupIfs, values);
            }
        }
    }

    private void generateDelta4SubIfs(XDMObject backup, ConfigValues values) throws XDMException {
        if (this._subIfs != null && this._subIfs.isModified()) {
            XDMSubInterfaces backupSubIfs = null;
            if (backup != null) {
                XDMInterface backupIf = (XDMInterface)backup;
                backupSubIfs = backupIf.getSubInterfaces();
            }
            this._subIfs.generateDelta(backupSubIfs, values);
        }
    }

    public XDMInterfaceBase getPhysicalIf() {
        return null;
    }

    public XDMSubInterfaces getSubInterfaces() {
        if (this._subIfs == null && this.canSubIf()) {
            this._subIfs = new XDMSubInterfaces(this);
        }
        return this._subIfs;
    }

    public boolean isSubInterfaceExist() {
        return this._subIfs != null && this._subIfs.size() > 0;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        if (this._subIfs != null) {
            this._subIfs.resetModifiedFlag();
        }
    }

    public String toString() {
        String str = super.toString();
        if (this.isSubInterfaceExist()) {
            str = String.valueOf(str) + this._subIfs.toString();
        }
        return str;
    }
}

