/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.MiscUtils;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.bridging.Bridging;
import com.cisco.xdm.data.common.Description;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.discovery.HWDictionary;
import com.cisco.xdm.data.discovery.IfType;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import com.cisco.xdm.data.serial.SerialInterface;
import com.cisco.xdm.data.serial.SerialSubInterface;
import com.cisco.xdm.data.systemproperties.SDM_NTPClient;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class XDMInterfaceBase
extends XDMObject {
    private static final String SDM_FW_OUTSIDE = "$FW_OUTSIDE$";
    private static final String SDM_FW_INSIDE = "$FW_INSIDE$";
    private static final String SDM_FW_DMZ = "$FW_DMZ$";
    public static final int FW_NONE = 0;
    public static final int FW_OUTSIDE = 1;
    public static final int FW_INSIDE = 2;
    public static final int FW_DMZ = 3;
    public static final String ES_LAN = "$ES_LAN$";
    public static final String ES_WAN = "$ES_WAN$";
    public static final int IF_FEATURE_DETECT = -1;
    public static final int IF_FEATURE_UNSUPPORT = 0;
    public static final int IF_FEATURE_SUPPORT = 1;
    private static final int MIN_IF_ATTR = 0;
    public static final int IF_ATTR_ACL = 0;
    public static final int IF_ATTR_NAT = 1;
    public static final int IF_ATTR_CRYPTO = 2;
    public static final int IF_ATTR_EZVPN = 3;
    public static final int IF_ATTR_CBAC = 4;
    public static final int IF_ATTR_CDP = 5;
    public static final int IF_ATTR_MOP = 6;
    public static final int IF_ATTR_REDIRECTS = 7;
    public static final int IF_ATTR_PROXY_ARP = 8;
    public static final int IF_ATTR_DIRECTED_BROADCAST = 9;
    public static final int IF_ATTR_UNREACHABLES = 10;
    public static final int IF_ATTR_MASK_REPLY = 11;
    public static final int IF_ATTR_IPROUTE_CACHE = 12;
    public static final int IF_ATTR_IPROUTE_CACHE_CEF = 13;
    public static final int IF_ATTR_IPROUTE_CACHE_FLOW = 14;
    public static final int IF_IP_NXT_HP_SELF = 15;
    public static final int IF_IP_NHRP = 16;
    public static final int IF_IP_NHRP_REGISTRATION = 17;
    public static final int IF_ATTR_DIDS = 18;
    public static final int IF_ATTR_SERVICE_POLICY = 19;
    public static final int IF_IP_NBAR = 20;
    public static final int IF_ATTR_ADMISSION = 21;
    public static final int IF_IP_FLOW = 22;
    public static final int IF_ATTR_POE = 23;
    public static final int IF_ATTR_FLOWIN = 24;
    public static final int IF_ATTR_FLOWOUT = 25;
    private static final int MAX_IF_ATTR = 25;
    private int[] _isSupported = new int[26];
    private static final String[] _clis = new String[]{" ip ?", " crypto ?", " crypto ipsec client ezvpn ?", " cdp ?", " mop ?", " ip route-cache ?", " ip next-hop-self eigrp ?", " ip nhrp ?", " service-policy ?", " ip nbar ?", " power ?", " ip flow ?"};
    private static final int CLI_IP = 0;
    private static final int CLI_CRYPTO = 1;
    private static final int CLI_EZVPN = 2;
    private static final int CLI_CDP = 3;
    private static final int CLI_MOP = 4;
    private static final int CLI_IP_RC = 5;
    private static final int CLI_IP_NXT_HOP_SLF = 6;
    private static final int CLI_IP_NHRP = 7;
    private static final int CLI_SERVICE_POLICY = 8;
    private static final int CLI_IP_NBAR = 9;
    private static final int CLI_POE = 10;
    private static final int CLI_FLOWDIR = 11;
    private FeatureCLIMap[] _fcm = new FeatureCLIMap[]{new FeatureCLIMap(0, "access-group "), new FeatureCLIMap(0, "nat "), new FeatureCLIMap(1, "map "), new FeatureCLIMap(2, ""), new FeatureCLIMap(0, "inspect "), new FeatureCLIMap(3, ""), new FeatureCLIMap(4, ""), new FeatureCLIMap(0, "redirects "), new FeatureCLIMap(0, "proxy-arp "), new FeatureCLIMap(0, "directed-broadcast "), new FeatureCLIMap(0, "unreachables "), new FeatureCLIMap(0, "mask-reply "), new FeatureCLIMap(5, ""), new FeatureCLIMap(5, "cef "), new FeatureCLIMap(5, "flow "), new FeatureCLIMap(6, "Autonomous"), new FeatureCLIMap(7, "authentication"), new FeatureCLIMap(7, "registration"), new FeatureCLIMap(0, "ips "), new FeatureCLIMap(8, "output"), new FeatureCLIMap(9, "protocol-discovery"), new FeatureCLIMap(0, "admission"), new FeatureCLIMap(0, "flow"), new FeatureCLIMap(10, "inline"), new FeatureCLIMap(11, "ingress"), new FeatureCLIMap(11, "egress")};
    private boolean _isConfigurable = true;
    private boolean _reset = false;
    private boolean _guiReset = false;
    private IfID _ifID;
    private boolean _shutdown = false;
    private String _desc = new String();
    private String _zoneName = new String();
    private IfIPAddress _ipAddr = null;
    private boolean _ipProxyArp = true;
    private boolean _ipDirectedBCast = false;
    private String _ipDirectedBCastAcl = new String();
    private boolean _cdp = true;
    private String _ipAccessGroupIn = new String();
    private String _ipAccessGroupOut = new String();
    private String _ddnsMethod = new String();
    private String _ddnsHostName = new String();
    private boolean _ddnsReadOnly = false;
    private boolean _ddnsDHCPCmdPresent = false;
    private boolean _ddnsDHCPCmdReqd = false;
    public static final int NAT_NONE = 0;
    public static final int NAT_INSIDE = 1;
    public static final int NAT_OUTSIDE = 2;
    private int _nat = 0;
    private String _crypto = new String();
    public static final int EZVPN_NONE = 0;
    public static final int EZVPN_INSIDE = 1;
    public static final int EZVPN_OUTSIDE = 2;
    private String _ezVPNName = new String();
    private int _ezVPNDir = 0;
    private String _ipEzVPNOut = new String();
    private Vector _ipEzVPNIn = new Vector();
    private String _ipInspectIn = new String();
    private String _ipInspectOut = new String();
    private boolean _ipInspectInModified = false;
    private boolean _ipInspectOutModified = false;
    private String _ipIpsIn = new String();
    private String _ipIpsOut = new String();
    private boolean _virtualReassembly = false;
    private boolean _dropFragments = false;
    private Vector _helperAddress = null;
    private boolean _ipUnicastRPF = false;
    private String _ipUnicastRPFAcl = "";
    private int _ipDHCPTrackObjNo = -1;
    private int _bandwidth = -1;
    private String _nhrpAuth = new String();
    private boolean _nhrpSvrOnly = false;
    private boolean _nhrpRegNoQ = false;
    private int _ripRcvVersion = -1;
    private long _nhrpID = -1L;
    private int _nhrpHoldTime = -1;
    private Vector _nhrpNHS = null;
    private boolean _ripSplitHorizon = true;
    private Vector _eigrpSplitHorizon = null;
    private Vector _eigrpNHSelf = null;
    private String _ospfNetworkType = new String();
    private int _ospfPriority = -1;
    private int _delay = -1;
    private int _ospfHelloInt = -1;
    private int _ospfDeadInt = -1;
    private int _ospfDeadMux = -1;
    private boolean _isBackupNeedToDelete = false;
    private int _mtu = -1;
    public static final boolean DEF_IPREDIRECTS = true;
    public static final boolean DEF_IPUNREACHABLES = true;
    public static final boolean DEF_IPMASKREPLY = false;
    public boolean DEF_IPROUTECACHEFLOW = false;
    public boolean DEF_IPROUTECACHECEF = true;
    public boolean DEF_IPROUTECACHE = true;
    public boolean DEF_MOP = false;
    private boolean _ipRedirects = true;
    private boolean _ipUnreachables = true;
    private boolean _ipMaskReply = false;
    private boolean _ipRouteCacheFlow = this.DEF_IPROUTECACHEFLOW;
    private boolean _ipRouteCacheCef = this.DEF_IPROUTECACHECEF;
    private boolean _ipRouteCache = this.DEF_IPROUTECACHE;
    private boolean _mop = this.DEF_MOP;
    static final String KEY_NTP = "ntp";
    static final String KEY_BROADCAST = "broadcast";
    static final String KEY_BROADCAST_KEY = "peerBroadCastnumber";
    static final String KEY_BROADCAST_DESTINATION = "ipBroadCastdestination";
    static final String KEY_MULTICAST = "multicast";
    static final String KEY_MULTICAST_KEY = "peerMultiCastnumber";
    static final String KEY_MULTICAST_DESTINATION = "ipMultiCastdestination";
    private boolean _IDSMonitoring = false;
    private String _servicePolicyIN = new String();
    private String _servicePolicyOUT = new String();
    private boolean _nbarEnabled = false;
    private boolean _fairQueue = false;
    private boolean _flowOut = false;
    private boolean _flowIn = false;
    private int _bridgeGroup = 0;
    private int _tcpsize = -1;
    private String _admission = new String();
    private int m_nHoldPeriod = 180;
    private int m_nRetransmit = 3;
    private int m_nRevalidate = 36000;
    private int m_nStatusQuery = 300;
    static final String KEY_DESCRIPTION = "description";
    static final String KEY_DESC = "desc";
    static final String KEY_ZONE_MEMBER = "zone-member";
    static final String KEY_ZONE = "zonename";
    static final String KEY_SHUTDOWN = "shutdown";
    static final String KEY_CDP = "cdp";
    static final String KEY_ENABLE = "enable";
    static final String KEY_IP = "ip";
    static final String KEY_PROXY_ARP = "proxy-arp";
    static final String KEY_DIRECTEDBCAST = "directed-broadcast";
    static final String KEY_ACL = "acl";
    static final String KEY_CRYPTO = "crypto";
    static final String KEY_NAME = "name";
    static final String KEY_MAP = "map";
    static final String KEY_REDUNDANCY = "redundancy";
    static final String KEY_IPSEC = "ipsec";
    static final String KEY_CLIENT = "client";
    static final String KEY_EZVPN = "ezvpn";
    static final String KEY_DIR = "dir";
    static final String KEY_AG = "access-group";
    static final String KEY_NAT = "nat";
    static final String KEY_INSPECT = "inspect";
    static final String KEY_IPS = "ips";
    static final String KEY_VFR = "virtual-reassembly";
    static final String KEY_DROP_FRAG = "drop-fragments";
    static final String KEY_IN = "in";
    static final String KEY_OUT = "out";
    static final String KEY_INSIDE = "inside";
    static final String KEY_OUTSIDE = "outside";
    static final String KEY_ADDRESS = "address";
    static final String KEY_UNNUMBERED = "unnumbered";
    static final String KEY_HELPER_ADDR = "helper-address";
    static final String KEY_HELPERADDR = "helperAddress";
    static final String KEY_VERIFY = "verify";
    static final String KEY_UNICAST = "unicast";
    static final String KEY_REVERSE_PATH = "reverse-path";
    static final String KEY_DHCP = "dhcp";
    static final String KEY_ROUTE = "route";
    static final String KEY_TRACK = "track";
    static final String KEY_DHCP_TRACKOBJ_NO = "dhcpTrackObjectNo";
    static final String KEY_IDS_MODULE = "ids-service-module";
    static final String KEY_MONITORING = "monitoring";
    static final String KEY_MTU = "mtu";
    static final String KEY_REDIRECTS = "redirects";
    static final String KEY_UNREACHABLES = "unreachables";
    static final String KEY_MASK_REPLY = "mask-reply";
    static final String KEY_ROUTE_CACHE = "route-cache";
    static final String KEY_FLOW = "flow";
    static final String KEY_CEF = "cef";
    static final String KEY_MOP = "mop";
    static final String KEY_ENABLED = "enabled";
    static final String KEY_SERVICE_POLICY = "service-policy";
    static final String KEY_OUTPUT = "output";
    static final String KEY_INPUT = "input";
    static final String KEY_FAIR_QUEUE = "fair-queue";
    static final String KEY_BRIDGE_GROUP = "bridge-group";
    static final String KEY_NUMBER = "NUMBER";
    static final String KEY_ADJ_MSS = "adjust-mss";
    static final String KEY_TCPSIZE = "TCPSIZE";
    static final String KEY_TCP = "tcp";
    static final String KEY_ADMISSION = "admission";
    static final String KEY_EOU = "eou";
    static final String KEY_TIMEOUT = "timeout";
    static final String KEY_HOLD_PERIOD = "hold-period";
    static final String VAL_HOLD_PERIOD = "HoldPeriod";
    static final String KEY_RETRANSMIT = "retransmit";
    static final String VAL_RETRANSMIT = "Retransmit";
    static final String KEY_REVALIDATION = "revalidation";
    static final String VAL_REVALIDATION = "Revalidation";
    static final String KEY_STATUS_QUERY = "status-query";
    static final String VAL_STATUS_QUERY = "StatusQuery";

    protected XDMInterfaceBase(IfID ifID) {
        super(null);
        this._ifID = ifID;
        int i = 0;
        while (i <= 25) {
            this._isSupported[i] = -1;
            ++i;
        }
    }

    public void addEIGRPNHSelf(int asNo) {
        if (this._eigrpNHSelf == null) {
            this._eigrpNHSelf = new Vector();
        }
        if (!this._eigrpNHSelf.contains(new Integer(asNo))) {
            this._eigrpNHSelf.addElement(new Integer(asNo));
        }
        this.setModified();
    }

    public void addEIGRPSplitHorizon(int asNo) {
        if (this._eigrpSplitHorizon == null) {
            this._eigrpSplitHorizon = new Vector();
        }
        if (!this._eigrpSplitHorizon.contains(new Integer(asNo))) {
            this._eigrpSplitHorizon.addElement(new Integer(asNo));
        }
        this.setModified();
    }

    public void addInsideEzVPNRemote(String ezvpnIn) {
        if (ezvpnIn == null) {
            return;
        }
        this._ipEzVPNIn.addElement(ezvpnIn);
        this.setModified();
    }

    public void addnhrpNHS(IPAddress ip) {
        if (this._nhrpNHS == null) {
            this._nhrpNHS = new Vector();
        }
        if (!this._nhrpNHS.contains(ip)) {
            this._nhrpNHS.addElement(ip);
        }
        this.setModified();
    }

    private boolean checkHelperAddresses(Vector vec) {
        if (this._helperAddress == null && vec == null) {
            return true;
        }
        if (this._helperAddress != null && vec != null) {
            int size2;
            int size1 = this._helperAddress.size();
            if (size1 != (size2 = vec.size())) {
                return false;
            }
            int i = 0;
            while (i < size1) {
                if (!this._helperAddress.contains((IPAddress)vec.elementAt(i))) {
                    return false;
                }
                ++i;
            }
            int j = 0;
            while (j < size1) {
                if (!vec.contains((IPAddress)this._helperAddress.elementAt(j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    boolean checkIsSupportedWithoutDetectAll(int attr) {
        return this.getBridgeGroup() == 0 && this.isSupported(attr, false);
    }

    private boolean checkeigrpNHSelf(Vector vec) {
        if (this._eigrpNHSelf == null && vec == null) {
            return true;
        }
        if (this._eigrpNHSelf != null && vec != null) {
            int size2;
            int size1 = this._eigrpNHSelf.size();
            if (size1 != (size2 = vec.size())) {
                return false;
            }
            int i = 0;
            while (i < size1) {
                if (!this._eigrpNHSelf.contains((Integer)vec.elementAt(i))) {
                    return false;
                }
                ++i;
            }
            int j = 0;
            while (j < size1) {
                if (!vec.contains((Integer)this._eigrpNHSelf.elementAt(j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    private boolean checkeigrpSplitHorizon(Vector vec) {
        if (this._eigrpSplitHorizon == null && vec == null) {
            return true;
        }
        if (this._eigrpSplitHorizon != null && vec != null) {
            int size2;
            int size1 = this._eigrpSplitHorizon.size();
            if (size1 != (size2 = vec.size())) {
                return false;
            }
            int i = 0;
            while (i < size1) {
                if (!this._eigrpSplitHorizon.contains((Integer)vec.elementAt(i))) {
                    return false;
                }
                ++i;
            }
            int j = 0;
            while (j < size1) {
                if (!vec.contains((Integer)this._eigrpSplitHorizon.elementAt(j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    private boolean checknhrpNHS(Vector vec) {
        if (this._nhrpNHS == null && vec == null) {
            return true;
        }
        if (this._nhrpNHS != null && vec != null) {
            int size2;
            int size1 = this._nhrpNHS.size();
            if (size1 != (size2 = vec.size())) {
                return false;
            }
            int i = 0;
            while (i < size1) {
                if (!this._nhrpNHS.contains((IPAddress)vec.elementAt(i))) {
                    return false;
                }
                ++i;
            }
            int j = 0;
            while (j < size1) {
                if (!vec.contains((IPAddress)this._nhrpNHS.elementAt(j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        XDMInterfaceBase newObj = (XDMInterfaceBase)super.clone();
        if (this._ipAddr != null) {
            newObj._ipAddr = (IfIPAddress)this._ipAddr.clone();
            newObj._ipAddr.setParent(newObj);
        }
        if (this._helperAddress != null) {
            newObj._helperAddress = (Vector)this._helperAddress.clone();
        }
        if (this._nhrpNHS != null) {
            newObj._nhrpNHS = (Vector)this._nhrpNHS.clone();
        }
        if (this._eigrpSplitHorizon != null) {
            newObj._eigrpSplitHorizon = (Vector)this._eigrpSplitHorizon.clone();
        }
        if (this._eigrpNHSelf != null) {
            newObj._eigrpNHSelf = (Vector)this._eigrpNHSelf.clone();
        }
        newObj._ipEzVPNIn = (Vector)this._ipEzVPNIn.clone();
        return newObj;
    }

    private void createInsideEzVPNRemoteCmd(Vector list, int action, ConfigValues cfg) {
        int count = 0;
        while (count < list.size()) {
            CmdValues subcmd = new CmdValues(KEY_CRYPTO);
            subcmd.addValue(KEY_IPSEC, KEY_IPSEC);
            subcmd.addValue(KEY_CLIENT, KEY_CLIENT);
            subcmd.addValue(KEY_EZVPN, KEY_EZVPN);
            subcmd.addValue(KEY_NAME, (String)list.elementAt(count));
            subcmd.addValue(KEY_DIR, KEY_INSIDE);
            subcmd.setAction(action);
            cfg.addCmdValues(subcmd);
            ++count;
        }
    }

    private void createOutsideEzVPNRemoteCmd(String oldEzVPNName, ConfigValues cfg) {
        CmdValues subcmd = new CmdValues(KEY_CRYPTO);
        subcmd.addValue(KEY_IPSEC, KEY_IPSEC);
        subcmd.addValue(KEY_CLIENT, KEY_CLIENT);
        subcmd.addValue(KEY_EZVPN, KEY_EZVPN);
        subcmd.addValue(KEY_DIR, KEY_OUTSIDE);
        if (oldEzVPNName == null) {
            subcmd.addValue(KEY_NAME, this._ipEzVPNOut);
            subcmd.setAction(1);
        } else {
            subcmd.addValue(KEY_NAME, oldEzVPNName);
            subcmd.setAction(2);
        }
        cfg.addCmdValues(subcmd);
    }

    private void detect(int attr) {
        if (attr < 0 || attr > 25) {
            return;
        }
        FeatureCLIMap cliMap = this._fcm[attr];
        String[] clis = new String[]{"interface " + this._ifID.toString(), _clis[cliMap._cli]};
        DeviceBase dev = (DeviceBase)this.getDevice();
        try {
            IOSCmdResponse[] Replies = dev.getDevInfoBase().getComm().config(clis);
            this._isSupported[attr] = cliMap._phrase.length() == 0 ? (XDMDiscovery.isOKResponse(Replies[1]) ? 1 : 0) : (XDMDiscovery.getOptionSupportedOnCmd(Replies[1], cliMap._phrase) ? 1 : 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void detectAll() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        try {
            Vector<Integer> items = new Vector<Integer>();
            Vector<Integer> CLIIndexes = new Vector<Integer>();
            Vector<String> vCLIs = new Vector<String>();
            int i = 0;
            while (i <= 25) {
                if (this._isSupported[i] == -1) {
                    items.addElement(new Integer(i));
                    int ind = vCLIs.indexOf(_clis[this._fcm[i]._cli]);
                    if (ind >= 0) {
                        CLIIndexes.addElement(new Integer(ind));
                    } else {
                        vCLIs.addElement(_clis[this._fcm[i]._cli]);
                        CLIIndexes.addElement(new Integer(vCLIs.size() - 1));
                    }
                }
                ++i;
            }
            if (items.size() == 0) {
                return;
            }
            String[] clis = new String[vCLIs.size() + 1];
            clis[0] = "interface " + this._ifID.toString();
            int i2 = 0;
            while (i2 < vCLIs.size()) {
                clis[i2 + 1] = (String)vCLIs.elementAt(i2);
                ++i2;
            }
            IOSCmdResponse[] Replies = dev.getDevInfoBase().getComm().config(clis);
            int i3 = 0;
            while (i3 < items.size()) {
                int cliIndex = (Integer)CLIIndexes.elementAt(i3);
                int itemIndex = (Integer)items.elementAt(i3);
                this._isSupported[itemIndex] = this._fcm[itemIndex]._phrase.length() == 0 ? (XDMDiscovery.isOKResponse(Replies[cliIndex + 1]) ? 1 : 0) : (XDMDiscovery.getOptionSupportedOnCmd(Replies[cliIndex + 1], this._fcm[itemIndex]._phrase) ? 1 : 0);
                ++i3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void enableFairQueue(boolean state) {
        this._fairQueue = state;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XDMInterfaceBase)) {
            return false;
        }
        XDMInterfaceBase cObj = (XDMInterfaceBase)obj;
        boolean isSameIpAddr = this._ipAddr == null && cObj._ipAddr == null || this._ipAddr != null && this._ipAddr.equals(cObj._ipAddr);
        return super.equals(obj) && this._ifID.toString().compareTo(cObj._ifID.toString()) == 0 && !this._ipInspectInModified && !this._ipInspectOutModified && this._ipUnicastRPF == cObj._ipUnicastRPF && this._ipUnicastRPFAcl.equals(cObj._ipUnicastRPFAcl) && this._shutdown == cObj._shutdown && this._desc.equals(cObj._desc) && this._zoneName.equals(cObj._zoneName) && isSameIpAddr && this._cdp == cObj._cdp && this._ipProxyArp == cObj._ipProxyArp && this._ipDirectedBCast == cObj._ipDirectedBCast && this._ipDirectedBCastAcl.equals(cObj._ipDirectedBCastAcl) && this._ipAccessGroupIn.equals(cObj._ipAccessGroupIn) && this._ipAccessGroupOut.equals(cObj._ipAccessGroupOut) && this._crypto.equals(cObj._crypto) && this._ipEzVPNOut.equals(cObj._ipEzVPNOut) && MiscUtils.vectorEquals(this._ipEzVPNIn, cObj._ipEzVPNIn) && this._ipInspectIn.equals(cObj._ipInspectIn) && this._ipInspectOut.equals(cObj._ipInspectOut) && this._ipIpsIn.equals(cObj._ipIpsIn) && this._ipIpsOut.equals(cObj._ipIpsOut) && this._nat == cObj._nat && this._ipRedirects == cObj._ipRedirects && this._ipUnreachables == cObj._ipUnreachables && this._ipMaskReply == cObj._ipMaskReply && this._ipRouteCacheFlow == cObj._ipRouteCacheFlow && this._ipRouteCacheCef == cObj._ipRouteCacheCef && this._ipRouteCache == cObj._ipRouteCache && this._mop == cObj._mop && this._bandwidth == cObj._bandwidth && this._delay == cObj._delay && this._nhrpAuth.equals(cObj._nhrpAuth) && this._nhrpSvrOnly == cObj._nhrpSvrOnly && this._nhrpRegNoQ == cObj._nhrpRegNoQ && this._nhrpID == cObj._nhrpID && this._nhrpHoldTime == cObj._nhrpHoldTime && this._ripRcvVersion == cObj._ripRcvVersion && this._ripSplitHorizon == cObj._ripSplitHorizon && this._mtu == cObj._mtu && this._ospfNetworkType.equals(cObj._ospfNetworkType) && this._ospfPriority == cObj._ospfPriority && this._delay == cObj._delay && this._ospfHelloInt == cObj._ospfHelloInt && this._ospfDeadInt == cObj._ospfDeadInt && this._ospfDeadMux == cObj._ospfDeadMux && this.checknhrpNHS(cObj._nhrpNHS) && this.checkHelperAddresses(cObj._helperAddress) && this.checkeigrpSplitHorizon(cObj._eigrpSplitHorizon) && this._servicePolicyIN.equals(cObj._servicePolicyIN) && this._servicePolicyOUT.equals(cObj._servicePolicyOUT) && this._admission.equals(cObj._admission);
    }

    private void extrapolatePoEDiscovery() {
        Vector ifs = ((XDMInterfaces)this.getParent()).getIfsByModule(this.getIfID().getSlot(), this.getIfID().getModuleSlot());
        if (ifs == null || ifs.size() == 0) {
            return;
        }
        int count = 0;
        while (count < ifs.size()) {
            XDMInterfaceBase xib = (XDMInterfaceBase)ifs.elementAt(count);
            if (xib.getClass().equals(this.getClass())) {
                if (xib._isSupported[23] == -1) {
                    xib._isSupported[23] = this._isSupported[23];
                }
                Log.getLog().debug("Extrapolating discovery to Switch port " + xib.getIfID().toString());
            }
            ++count;
        }
    }

    private int findFlagFromSameMainIf(int attr) {
        int ret = -1;
        if (this._ifID.isSubInterface()) {
            XDMSubInterfaces subIfs;
            DeviceBase dev = (DeviceBase)this.getDevice();
            IfID mainID = new IfID(this._ifID.getType(), this._ifID.getSlot(), this._ifID.getModuleSlot(), this._ifID.getPort(), this._ifID.getChannel(), 0);
            XDMInterface mainIf = (XDMInterface)dev.getIfs().get(mainID);
            if (mainIf != null && (subIfs = mainIf.getSubInterfaces()) != null) {
                Enumeration e = subIfs.elements();
                while (e.hasMoreElements()) {
                    XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
                    if (item._isSupported[attr] == -1) continue;
                    ret = item._isSupported[attr];
                    break;
                }
            }
        }
        return ret;
    }

    public CmdValues generateDDNSDHCPCommand(int action) {
        CmdValues subcmd = new CmdValues(KEY_IP);
        subcmd.addValue(KEY_DHCP, KEY_DHCP);
        subcmd.addValue(KEY_CLIENT, KEY_CLIENT);
        subcmd.addValue("update", "update");
        subcmd.addValue("dns", "dns");
        subcmd.addValue("server", "server");
        subcmd.addValue("mode", "none");
        subcmd.setAction(action);
        return subcmd;
    }

    public CmdValues generateDDNSHostnameCommand(String value, int action) {
        this._ddnsDHCPCmdReqd = true;
        CmdValues subcmd = new CmdValues(KEY_IP);
        subcmd.addValue("ddns", "ddns");
        subcmd.addValue("update", "update");
        subcmd.addValue("hostname", "hostname");
        subcmd.addValue("hostnm", value);
        subcmd.setAction(action);
        return subcmd;
    }

    public CmdValues generateDDNSMethodCommand(String value, int action) {
        this._ddnsDHCPCmdReqd = true;
        CmdValues subcmd = new CmdValues(KEY_IP);
        subcmd.addValue("ddns", "ddns");
        subcmd.addValue("update", "update");
        subcmd.addValue("methodName", value);
        subcmd.setAction(action);
        return subcmd;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues subcmd;
        CmdValues subcmd2;
        if (backup != null && !(backup instanceof XDMInterfaceBase)) {
            throw new XDMException(4);
        }
        XDMInterfaceBase bBase = null;
        if (backup != null) {
            bBase = (XDMInterfaceBase)backup;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        CmdValues cmd = this.generateInterfaceCmd();
        int hpcmdPos = -1;
        if (this.isBackup()) {
            CmdValues subcmd3;
            CmdValues firstCmd = this.generateInterfaceCmd();
            ConfigValues firstCfg = new ConfigValues();
            if (!this._shutdown) {
                subcmd3 = new CmdValues(KEY_SHUTDOWN);
                firstCfg.addCmdValues(subcmd3);
            }
            if (!this._ipIpsIn.equals("")) {
                subcmd3 = new CmdValues(KEY_IP);
                subcmd3.addValue(KEY_IPS, KEY_IPS);
                subcmd3.addValue(KEY_DIR, KEY_IN);
                subcmd3.addValue(KEY_NAME, this._ipIpsIn);
                subcmd3.setAction(2);
                firstCfg.addCmdValues(subcmd3);
            }
            if (!this._ipIpsOut.equals("")) {
                subcmd3 = new CmdValues(KEY_IP);
                subcmd3.addValue(KEY_IPS, KEY_IPS);
                subcmd3.addValue(KEY_DIR, KEY_OUT);
                subcmd3.addValue(KEY_NAME, this._ipIpsOut);
                subcmd3.setAction(2);
                firstCfg.addCmdValues(subcmd3);
            }
            if (this._ipEzVPNOut.length() > 0) {
                this.createOutsideEzVPNRemoteCmd(this._ipEzVPNOut, firstCfg);
            }
            if (!firstCfg.isEmpty()) {
                firstCmd.setModeCmdsValues(firstCfg);
                values.addCmdValues(firstCmd);
            }
            cmd.setAction(2);
            values.addCmdValues(cmd);
            return;
        }
        ConfigValues hpsubcfg = new ConfigValues();
        ConfigValues subcfg = new ConfigValues();
        ConfigValues zeroIndexSubcfg = new ConfigValues();
        if (bBase == null && this._desc.length() > 0 || bBase != null && !this._desc.equals(bBase._desc)) {
            subcmd2 = new CmdValues(KEY_DESCRIPTION);
            if (this._desc.length() == 0) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue(KEY_DESC, this._desc);
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._bandwidth != -1 || bBase != null && this._bandwidth != bBase._bandwidth) {
            subcmd2 = new CmdValues("bandwidth");
            if (this._bandwidth == -1) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("bandwidth", Integer.toString(this._bandwidth));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._nhrpSvrOnly || bBase != null && this._nhrpSvrOnly != bBase._nhrpSvrOnly) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("nhrp", "nhrp");
            subcmd2.addValue("server-only", "server-only");
            if (!this._nhrpSvrOnly) {
                subcmd2.setAction(2);
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._nhrpRegNoQ || bBase != null && this._nhrpRegNoQ != bBase._nhrpRegNoQ) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("nhrp", "nhrp");
            subcmd2.addValue("registration", "registration");
            subcmd2.addValue("no-unique", "no-unique");
            if (!this._nhrpRegNoQ) {
                subcmd2.setAction(2);
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._delay != -1 || bBase != null && this._delay != bBase._delay) {
            subcmd2 = new CmdValues("delay");
            if (this._delay == -1) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("iDelay", Integer.toString(this._delay));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._nhrpHoldTime != -1 || bBase != null && this._nhrpHoldTime != bBase._nhrpHoldTime) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("nhrp", "nhrp");
            subcmd2.addValue("holdtime", "holdtime");
            if (this._nhrpHoldTime == -1) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("holdTime", Integer.toString(this._nhrpHoldTime));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._nhrpID != -1L || bBase != null && this._nhrpID != bBase._nhrpID) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("nhrp", "nhrp");
            subcmd2.addValue("network-id", "network-id");
            if (this._nhrpID == -1L) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("networkID", Long.toString(this._nhrpID));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._nhrpAuth.trim().length() != 0 || bBase != null && !this._nhrpAuth.equals(bBase._nhrpAuth)) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("nhrp", "nhrp");
            subcmd2.addValue("authentication", "authentication");
            if (this._nhrpAuth.trim().length() == 0) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("NHRPAuth", this._nhrpAuth);
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._ospfNetworkType.trim().length() != 0 || bBase != null && !this._ospfNetworkType.equals(bBase._ospfNetworkType)) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("ospf", "ospf");
            subcmd2.addValue("network", "network");
            if (this._ospfNetworkType.trim().length() == 0) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("networkType", this._ospfNetworkType);
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._ospfPriority != -1 || bBase != null && this._ospfPriority != bBase._ospfPriority) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("ospf", "ospf");
            subcmd2.addValue("priority", "priority");
            if (this._ospfPriority == -1) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("TunnelKey", Integer.toString(this._ospfPriority));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._ospfDeadInt != -1 || bBase != null && this._ospfDeadInt != bBase._ospfDeadInt) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("ospf", "ospf");
            subcmd2.addValue("dead-interval", "dead-interval");
            if (this._ospfDeadInt == -1) {
                subcmd2.setAction(2);
            } else if (this._ospfDeadMux != -1) {
                subcfg.addCmdValues(this.generateNoOSPFFastHello());
            } else {
                subcmd2.addValue("deadInt", Integer.toString(this._ospfDeadInt));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._ospfHelloInt != -1 || bBase != null && this._ospfHelloInt != bBase._ospfHelloInt) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("ospf", "ospf");
            subcmd2.addValue("hello-interval", "hello-interval");
            if (this._ospfHelloInt == -1) {
                subcmd2.setAction(2);
            } else {
                if (this._ospfDeadMux != -1) {
                    subcfg.addCmdValues(this.generateNoOSPFFastHello());
                }
                subcmd2.addValue("helloInt", Integer.toString(this._ospfHelloInt));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._mtu != -1 || bBase != null && this._mtu != bBase._mtu) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue(KEY_MTU, KEY_MTU);
            if (this._mtu == -1) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("SIZE", String.valueOf(this._mtu));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (bBase == null && this._ripRcvVersion != -1 || bBase != null && this._ripRcvVersion != bBase._ripRcvVersion) {
            subcmd2 = new CmdValues(KEY_IP);
            subcmd2.addValue("rip", "rip");
            subcmd2.addValue("receive", "receive");
            subcmd2.addValue("version", "version");
            if (this._ripRcvVersion != 1 && this._ripRcvVersion != 2) {
                subcmd2.setAction(2);
            } else {
                subcmd2.addValue("ripVer", Integer.toString(this._ripRcvVersion));
            }
            subcfg.addCmdValues(subcmd2);
        }
        if (!(this.getIfID().toString().equalsIgnoreCase("null0") || bBase != null && this._shutdown == bBase._shutdown)) {
            subcmd2 = new CmdValues(KEY_SHUTDOWN);
            if (!this._shutdown) {
                subcmd2.setAction(2);
            }
            subcfg.addCmdValues(subcmd2);
        }
        Vector addrCmds = null;
        IfIPAddress backupIp = null;
        if (bBase != null) {
            backupIp = bBase._ipAddr;
        }
        if (this._ipAddr != null) {
            addrCmds = this._ipAddr.generateIPAddessCommand(backupIp, this);
        } else if (backupIp != null) {
            addrCmds = backupIp.generateIPAddessCommand(null, this);
        }
        if (addrCmds != null && addrCmds.size() > 0) {
            if (this.isPointedIf() || bBase != null && bBase.isPointedIf() || this._ipAddr != null && IPAddressType.STATIC == this._ipAddr.getIPAddressType() && dev.getBackup().getIfs().getIfByIP(this._ipAddr.getIPAddress()) != null) {
                CmdValues lastCmd = this.generateInterfaceCmd();
                ConfigValues lastSubcfg = new ConfigValues();
                if (bBase != null && bBase._ipAddr != null && this._ipAddr != null) {
                    CmdValues ipcmd = new CmdValues(KEY_IP);
                    ipcmd.addValue(KEY_ADDRESS, KEY_ADDRESS);
                    ipcmd.setAction(2);
                    lastSubcfg.addCmdValues(ipcmd);
                    lastCmd.setModeCmdsValues(lastSubcfg);
                    dev.setLastCmd(1, lastCmd);
                }
                lastCmd = this.generateInterfaceCmd();
                lastSubcfg = new ConfigValues();
                int i = 0;
                while (i < addrCmds.size()) {
                    lastSubcfg.addCmdValues((CmdValues)addrCmds.elementAt(i));
                    ++i;
                }
                lastCmd.setModeCmdsValues(lastSubcfg);
                if (this._ipAddr == null) {
                    dev.setLastCmd(1, lastCmd);
                } else {
                    dev.setLastCmd(2, lastCmd);
                }
            } else {
                int i = 0;
                while (i < addrCmds.size()) {
                    subcfg.addCmdValues((CmdValues)addrCmds.elementAt(i));
                    ++i;
                }
            }
        }
        if (bBase == null && !this._cdp || bBase != null && this._cdp != bBase._cdp) {
            CmdValues subCmd = new CmdValues(KEY_CDP);
            subCmd.addValue(KEY_ENABLE, KEY_ENABLE);
            subCmd.setAction(2);
            subcfg.addCmdValues(subCmd);
        }
        if (this._isSupported[8] == 1 && (bBase == null && !this._ipProxyArp || bBase != null && this._ipProxyArp != bBase._ipProxyArp)) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_PROXY_ARP, KEY_PROXY_ARP);
            if (!this._ipProxyArp) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (this._isSupported[9] == 1 && (bBase == null && this._ipDirectedBCast || bBase != null && (this._ipDirectedBCast != bBase._ipDirectedBCast || !this._ipDirectedBCastAcl.equals(bBase._ipDirectedBCastAcl)))) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_DIRECTEDBCAST, KEY_DIRECTEDBCAST);
            if (!this._ipDirectedBCast) {
                subCmd.setAction(2);
            } else if (this._ipDirectedBCastAcl.length() > 0) {
                subCmd.addValue(KEY_ACL, this._ipDirectedBCastAcl);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (this._isSupported[7] == 1 && (bBase == null && !this._ipRedirects || bBase != null && this._ipRedirects != bBase._ipRedirects)) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_REDIRECTS, KEY_REDIRECTS);
            if (!this._ipRedirects) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (this._isSupported[10] == 1 && (bBase == null && !this._ipUnreachables || bBase != null && this._ipUnreachables != bBase._ipUnreachables)) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_UNREACHABLES, KEY_UNREACHABLES);
            if (!this._ipUnreachables) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (this._isSupported[11] == 1 && (bBase == null && this._ipMaskReply || bBase != null && this._ipMaskReply != bBase._ipMaskReply)) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_MASK_REPLY, KEY_MASK_REPLY);
            if (!this._ipMaskReply) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (this._isSupported[12] == 1 && (bBase == null && this._ipRouteCacheFlow != this.DEF_IPROUTECACHEFLOW || bBase != null && this._ipRouteCacheFlow != bBase._ipRouteCacheFlow)) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_ROUTE_CACHE, KEY_ROUTE_CACHE);
            subCmd.addValue(KEY_FLOW, KEY_FLOW);
            if (!this._ipRouteCacheFlow) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (bBase == null && this._ipRouteCache != this.DEF_IPROUTECACHE || bBase != null && this._ipRouteCache != bBase._ipRouteCache) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_ROUTE_CACHE, KEY_ROUTE_CACHE);
            if (!this._ipRouteCache) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (dev.getSystemProp().isIpCEF() && this._isSupported[12] == 1 && (bBase == null && this._ipRouteCacheCef != this.DEF_IPROUTECACHECEF || bBase != null && this._ipRouteCacheCef != bBase._ipRouteCacheCef)) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_ROUTE_CACHE, KEY_ROUTE_CACHE);
            subCmd.addValue(KEY_CEF, KEY_CEF);
            if (!this._ipRouteCacheCef) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (this._isSupported[6] == 1 && (bBase == null && this._mop != this.DEF_MOP || bBase != null && this._mop != bBase._mop)) {
            CmdValues subCmd = new CmdValues(KEY_MOP);
            subCmd.addValue(KEY_ENABLED, KEY_ENABLED);
            if (!this._mop) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (bBase == null && this._tcpsize != -1 || bBase != null && this._tcpsize != bBase._tcpsize) {
            CmdValues subCmd = new CmdValues(KEY_IP);
            subCmd.addValue(KEY_TCP, KEY_TCP);
            subCmd.addValue(KEY_ADJ_MSS, KEY_ADJ_MSS);
            if (this._tcpsize == -1) {
                subCmd.setAction(2);
            } else {
                subCmd.addValue(KEY_TCPSIZE, String.valueOf(this._tcpsize));
            }
            subcfg.addCmdValues(subCmd);
        }
        if (bBase == null && this._crypto.length() > 0 || bBase != null && !this._crypto.equals(bBase._crypto)) {
            if (bBase != null && !this._crypto.equals(bBase._crypto)) {
                int ret = dev.getFirstCmdPosition(KEY_CRYPTO, values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                CmdValues subcmd4 = new CmdValues(KEY_CRYPTO);
                subcmd4.addValue(KEY_MAP, KEY_MAP);
                subcmd4.setAction(2);
                hpsubcfg.addCmdValues(subcmd4);
            }
            if (this._crypto.length() > 0) {
                CmdValues subcmd5 = new CmdValues(KEY_CRYPTO);
                subcmd5.addValue(KEY_MAP, KEY_MAP);
                subcmd5.addValue(KEY_NAME, this._crypto);
                subcfg.addCmdValues(subcmd5);
            }
        }
        if (bBase == null) {
            if (this._ipEzVPNOut.length() > 0) {
                this.createOutsideEzVPNRemoteCmd(null, subcfg);
            }
            if (!this._ipEzVPNIn.isEmpty()) {
                this.createInsideEzVPNRemoteCmd(this._ipEzVPNIn, 1, subcfg);
            }
        } else {
            Vector addedList;
            Vector deletedList;
            if (this._ipEzVPNOut.length() > 0) {
                if (!this._ipEzVPNOut.equals(bBase._ipEzVPNOut)) {
                    this.createOutsideEzVPNRemoteCmd(null, subcfg);
                }
            } else if (bBase._ipEzVPNOut.length() > 0) {
                this.createOutsideEzVPNRemoteCmd(bBase._ipEzVPNOut, zeroIndexSubcfg);
            }
            if (!(deletedList = MiscUtils.getDiffElements(bBase._ipEzVPNIn, this._ipEzVPNIn)).isEmpty()) {
                int ret = dev.getFirstCmdPosition("crypto ezvpnremote", values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                this.createInsideEzVPNRemoteCmd(deletedList, 2, hpsubcfg);
            }
            if (!(addedList = MiscUtils.getDiffElements(this._ipEzVPNIn, bBase._ipEzVPNIn)).isEmpty()) {
                this.createInsideEzVPNRemoteCmd(addedList, 1, subcfg);
            }
        }
        if (bBase == null && this._nat != 0 || bBase != null && this._nat != bBase._nat) {
            CmdValues subcmd6 = new CmdValues(KEY_IP);
            subcmd6.addValue(KEY_NAT, KEY_NAT);
            if (this._nat == 0) {
                if (bBase._nat == 1) {
                    subcmd6.addValue(KEY_DIR, KEY_INSIDE);
                } else {
                    subcmd6.addValue(KEY_DIR, KEY_OUTSIDE);
                }
                subcmd6.setAction(2);
                subcfg.addCmdValues(subcmd6);
            } else {
                if (this._nat == 1) {
                    subcmd6.addValue(KEY_DIR, KEY_INSIDE);
                } else {
                    subcmd6.addValue(KEY_DIR, KEY_OUTSIDE);
                }
                subcfg.addCmdValues(subcmd6);
            }
        }
        if (bBase == null && this._ipAccessGroupIn.length() > 0 || bBase != null && !this._ipAccessGroupIn.equals(bBase._ipAccessGroupIn)) {
            CmdValues subcmd7 = new CmdValues(KEY_IP);
            subcmd7.addValue(KEY_AG, KEY_AG);
            subcmd7.addValue(KEY_DIR, KEY_IN);
            if (this._ipAccessGroupIn.length() == 0) {
                int ret = dev.getFirstCmdPosition("acls", values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                subcmd7.addValue(KEY_NAME, bBase._ipAccessGroupIn);
                subcmd7.setAction(2);
                hpsubcfg.addCmdValues(subcmd7);
            } else {
                subcmd7.addValue(KEY_NAME, this._ipAccessGroupIn);
                subcfg.addCmdValues(subcmd7);
            }
        }
        if (bBase == null && this._ipAccessGroupOut.length() > 0 || bBase != null && !this._ipAccessGroupOut.equals(bBase._ipAccessGroupOut)) {
            CmdValues subcmd8 = new CmdValues(KEY_IP);
            subcmd8.addValue(KEY_AG, KEY_AG);
            subcmd8.addValue(KEY_DIR, KEY_OUT);
            if (this._ipAccessGroupOut.length() == 0) {
                int ret = dev.getFirstCmdPosition("acls", values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                subcmd8.addValue(KEY_NAME, bBase._ipAccessGroupOut);
                subcmd8.setAction(2);
                hpsubcfg.addCmdValues(subcmd8);
            } else {
                subcmd8.addValue(KEY_NAME, this._ipAccessGroupOut);
                subcfg.addCmdValues(subcmd8);
            }
        }
        if (bBase == null && this._ipInspectIn.length() > 0 || bBase != null && this._ipInspectInModified) {
            CmdValues subcmd9 = new CmdValues(KEY_IP);
            subcmd9.addValue(KEY_INSPECT, KEY_INSPECT);
            subcmd9.addValue(KEY_DIR, KEY_IN);
            if (this._ipInspectIn.length() == 0 && bBase != null && bBase._ipInspectIn.length() > 0) {
                int ret = dev.getFirstCmdPosition("cbac", values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                subcmd9.addValue(KEY_NAME, bBase._ipInspectIn);
                subcmd9.setAction(2);
                hpsubcfg.addCmdValues(subcmd9);
            } else if (this._ipInspectIn.length() > 0) {
                subcmd9.addValue(KEY_NAME, this._ipInspectIn);
                subcfg.addCmdValues(subcmd9);
            }
        }
        if (bBase == null && this._ipInspectOut.length() > 0 || bBase != null && this._ipInspectOutModified) {
            CmdValues subcmd10 = new CmdValues(KEY_IP);
            subcmd10.addValue(KEY_INSPECT, KEY_INSPECT);
            subcmd10.addValue(KEY_DIR, KEY_OUT);
            if (this._ipInspectOut.length() == 0 && bBase != null && bBase._ipInspectOut.length() > 0) {
                int ret = dev.getFirstCmdPosition("cbac", values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                subcmd10.addValue(KEY_NAME, bBase._ipInspectOut);
                subcmd10.setAction(2);
                hpsubcfg.addCmdValues(subcmd10);
            } else if (this._ipInspectOut.length() > 0) {
                subcmd10.addValue(KEY_NAME, this._ipInspectOut);
                subcfg.addCmdValues(subcmd10);
            }
        }
        if (bBase == null && this._ipIpsIn.length() > 0 || bBase != null && !this._ipIpsIn.equals(bBase._ipIpsIn)) {
            CmdValues subcmd11 = new CmdValues(KEY_IP);
            subcmd11.addValue(KEY_IPS, KEY_IPS);
            subcmd11.addValue(KEY_DIR, KEY_IN);
            if (this._ipIpsIn.length() == 0 && bBase != null && bBase._ipIpsIn.length() > 0) {
                int ret = dev.getFirstCmdPosition("dids", values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                subcmd11.addValue(KEY_NAME, bBase._ipIpsIn);
                subcmd11.setAction(2);
                hpsubcfg.addCmdValues(subcmd11);
            } else if (this._ipIpsIn.length() > 0) {
                subcmd11.addValue(KEY_NAME, this._ipIpsIn);
                subcfg.addCmdValues(subcmd11);
            }
        }
        if (bBase == null && this._ipIpsOut.length() > 0 || bBase != null && !this._ipIpsOut.equals(bBase._ipIpsOut)) {
            CmdValues subcmd12 = new CmdValues(KEY_IP);
            subcmd12.addValue(KEY_IPS, KEY_IPS);
            subcmd12.addValue(KEY_DIR, KEY_OUT);
            if (this._ipIpsOut.length() == 0 && bBase != null && bBase._ipIpsOut.length() > 0) {
                int ret = dev.getFirstCmdPosition("dids", values, true);
                if (ret >= 0 && (hpcmdPos > ret || hpcmdPos < 0)) {
                    hpcmdPos = ret;
                }
                subcmd12.addValue(KEY_NAME, bBase._ipIpsOut);
                subcmd12.setAction(2);
                hpsubcfg.addCmdValues(subcmd12);
            } else if (this._ipIpsOut.length() > 0) {
                subcmd12.addValue(KEY_NAME, this._ipIpsOut);
                subcfg.addCmdValues(subcmd12);
            }
        }
        boolean bvfr = false;
        boolean vfr = this.getVirtualReassembly();
        if (bBase != null) {
            bvfr = bBase.getVirtualReassembly();
        }
        if (bBase == null && vfr || bBase != null && vfr != bvfr) {
            CmdValues subcmd13 = new CmdValues(KEY_IP);
            subcmd13.addValue(KEY_VFR, KEY_VFR);
            if (!vfr) {
                subcmd13.setAction(2);
            }
            subcfg.addCmdValues(subcmd13);
        }
        if (bBase == null && this._ipUnicastRPF || bBase != null && (this._ipUnicastRPF != bBase._ipUnicastRPF || !this._ipUnicastRPFAcl.equals(bBase._ipUnicastRPFAcl))) {
            CmdValues subcmd14 = new CmdValues(KEY_IP);
            subcmd14.addValue(KEY_VERIFY, KEY_VERIFY);
            subcmd14.addValue(KEY_UNICAST, KEY_UNICAST);
            if (!this._ipUnicastRPF) {
                hpcmdPos = 0;
                subcmd14.setAction(2);
                hpsubcfg.addCmdValues(subcmd14);
            } else {
                subcmd14.addValue(KEY_REVERSE_PATH, KEY_REVERSE_PATH);
                if (this._ipUnicastRPFAcl.length() > 0) {
                    subcmd14.addValue(KEY_ACL, this._ipUnicastRPFAcl);
                }
                subcfg.addCmdValues(subcmd14);
            }
        }
        this._ddnsDHCPCmdReqd = false;
        String oldMethodName = bBase == null || bBase._ddnsMethod == null ? "" : bBase._ddnsMethod;
        String string = this._ddnsMethod = this._ddnsMethod == null ? "" : this._ddnsMethod;
        if (oldMethodName.length() == 0) {
            if (this._ddnsMethod.length() > 0) {
                subcmd = this.generateDDNSMethodCommand(this._ddnsMethod, 1);
                subcfg.addCmdValues(subcmd);
            }
        } else if (this._ddnsMethod.length() == 0) {
            subcmd = this.generateDDNSMethodCommand(bBase._ddnsMethod, 2);
            subcfg.addCmdValues(subcmd);
        } else if (!this._ddnsMethod.equals(oldMethodName)) {
            subcmd = this.generateDDNSMethodCommand(this._ddnsMethod, 1);
            subcfg.addCmdValues(subcmd);
            subcmd = this.generateDDNSMethodCommand(oldMethodName, 2);
            subcfg.addCmdValues(subcmd);
        }
        String oldHostname = bBase == null || bBase._ddnsHostName == null ? "" : bBase._ddnsHostName;
        String string2 = this._ddnsHostName = this._ddnsHostName == null ? "" : this._ddnsHostName;
        if (!oldHostname.equals(this._ddnsHostName)) {
            CmdValues subcmd15;
            if (this._ddnsHostName.length() > 0) {
                subcmd15 = this.generateDDNSHostnameCommand(this._ddnsHostName, 1);
                subcfg.addCmdValues(subcmd15);
            } else {
                subcmd15 = this.generateDDNSHostnameCommand(oldHostname, 2);
                subcfg.addCmdValues(subcmd15);
            }
        }
        if (!this.isDDNSReadOnly()) {
            CmdValues subcmd16;
            int ret = this.isDDNSDHCPCmdRequired();
            if (ret == 1) {
                subcmd16 = this.generateDDNSDHCPCommand(1);
                subcfg.addCmdValues(subcmd16);
            } else if (ret == 2) {
                subcmd16 = this.generateDDNSDHCPCommand(2);
                subcfg.addCmdValues(subcmd16);
            }
        }
        if (bBase == null && this._ipDHCPTrackObjNo > 0 || bBase != null && this._ipDHCPTrackObjNo != bBase._ipDHCPTrackObjNo) {
            CmdValues subcmd17 = new CmdValues(KEY_IP);
            subcmd17.addValue(KEY_DHCP, KEY_DHCP);
            subcmd17.addValue(KEY_CLIENT, KEY_CLIENT);
            subcmd17.addValue(KEY_ROUTE, KEY_ROUTE);
            subcmd17.addValue(KEY_TRACK, KEY_TRACK);
            if (this._ipDHCPTrackObjNo <= 0) {
                hpcmdPos = 0;
                subcmd17.setAction(2);
                hpsubcfg.addCmdValues(subcmd17);
            } else {
                subcmd17.addValue(KEY_DHCP_TRACKOBJ_NO, String.valueOf(this._ipDHCPTrackObjNo));
                subcfg.addCmdValues(subcmd17);
                this.generateShutNoShutCmds(subcfg);
            }
        }
        if (bBase == null) {
            this.generateHelperAddressCmd(null, subcfg);
            this.generatenhrpNHSCmd(null, subcfg);
            this.generateSplitHorizonCmd(null, subcfg);
            this.generateNHSelfCmd(null, subcfg);
            if (!this._ripSplitHorizon) {
                CmdValues subcmd18 = new CmdValues(KEY_IP);
                subcmd18.addValue("split-horizon", "split-horizon");
                subcmd18.setAction(2);
                subcfg.addCmdValues(subcmd18);
            }
        } else {
            this.generateHelperAddressCmd(bBase._helperAddress, subcfg);
            this.generatenhrpNHSCmd(bBase._nhrpNHS, subcfg);
            this.generateSplitHorizonCmd(bBase._eigrpSplitHorizon, subcfg);
            this.generateNHSelfCmd(bBase._eigrpNHSelf, subcfg);
            if (bBase._ripSplitHorizon != this._ripSplitHorizon) {
                CmdValues subcmd19 = new CmdValues(KEY_IP);
                subcmd19.addValue("split-horizon", "split-horizon");
                if (!this._ripSplitHorizon) {
                    subcmd19.setAction(2);
                } else {
                    subcmd19.setAction(1);
                }
                subcfg.addCmdValues(subcmd19);
            }
        }
        if (bBase == null && this._IDSMonitoring || bBase != null && bBase._IDSMonitoring != this._IDSMonitoring) {
            CmdValues subcmd20 = new CmdValues(KEY_IDS_MODULE);
            subcmd20.addValue(KEY_MONITORING, KEY_MONITORING);
            if (!this._IDSMonitoring) {
                subcmd20.setAction(2);
            }
            subcfg.addCmdValues(subcmd20);
        }
        if (zeroIndexSubcfg.numCmds() > 0) {
            CmdValues zeroIcmd = this.generateInterfaceCmd();
            zeroIcmd.setModeCmdsValues(zeroIndexSubcfg);
            values.insertCmdValues(zeroIcmd, 0);
        }
        if (hpsubcfg.numCmds() > 0) {
            if (hpcmdPos >= 0) {
                CmdValues hpcmd = this.generateInterfaceCmd();
                hpcmd.setModeCmdsValues(hpsubcfg);
                values.insertCmdValues(hpcmd, hpcmdPos);
            } else {
                int index = 0;
                while (index < hpsubcfg.numCmds()) {
                    subcfg.insertCmdValues(hpsubcfg.getCmdValues(index), index);
                    ++index;
                }
            }
        }
        if (bBase == null && this._fairQueue || bBase != null && this._fairQueue != bBase._fairQueue) {
            CmdValues subcmd21 = new CmdValues(KEY_FAIR_QUEUE);
            if (!this._fairQueue) {
                subcmd21.setAction(2);
                subcfg.addCmdValues(subcmd21);
            }
        }
        if (bBase == null && this._nbarEnabled || bBase != null && this._nbarEnabled != bBase._nbarEnabled) {
            CmdValues subcmd22 = new CmdValues(KEY_IP);
            subcmd22.addValue("nbar", "nbar");
            subcmd22.addValue("protocol-discovery", "protocol-discovery");
            if (this._nbarEnabled) {
                subcmd22.setAction(1);
            } else {
                subcmd22.setAction(2);
            }
            subcfg.addCmdValues(subcmd22);
        }
        if (bBase == null && this._flowIn || bBase != null && this._flowIn != bBase._flowIn) {
            CmdValues subcmd23 = new CmdValues(KEY_IP);
            subcmd23.addValue(KEY_FLOW, KEY_FLOW);
            subcmd23.addValue("ingress", "ingress");
            if (this._flowIn) {
                subcmd23.setAction(1);
            } else {
                subcmd23.setAction(2);
            }
            subcfg.addCmdValues(subcmd23);
        }
        if (bBase == null && this._flowOut || bBase != null && this._flowOut != bBase._flowOut) {
            CmdValues subcmd24 = new CmdValues(KEY_IP);
            subcmd24.addValue(KEY_FLOW, KEY_FLOW);
            subcmd24.addValue("egress", "egress");
            if (this._flowOut) {
                subcmd24.setAction(1);
            } else {
                subcmd24.setAction(2);
            }
            subcfg.addCmdValues(subcmd24);
        }
        if (bBase == null && this._servicePolicyOUT.trim().length() != 0 || bBase != null && !this._servicePolicyOUT.equals(bBase._servicePolicyOUT)) {
            CmdValues subcmd25 = new CmdValues(KEY_SERVICE_POLICY);
            subcmd25.addValue(KEY_OUTPUT, KEY_OUTPUT);
            if (this._servicePolicyOUT.trim().length() == 0) {
                subcmd25.addValue("policyName", bBase._servicePolicyOUT);
                subcmd25.setAction(2);
                subcfg.addCmdValues(subcmd25);
            } else if (bBase == null || bBase._servicePolicyOUT.length() == 0) {
                subcmd25.addValue("policyName", this._servicePolicyOUT);
                subcmd25.setAction(1);
                subcfg.addCmdValues(subcmd25);
            } else {
                subcmd25.addValue("policyName", bBase._servicePolicyOUT);
                subcmd25.setAction(2);
                subcfg.addCmdValues(subcmd25);
                subcmd25 = new CmdValues(KEY_SERVICE_POLICY);
                subcmd25.addValue(KEY_OUTPUT, KEY_OUTPUT);
                subcmd25.addValue("policyName", this._servicePolicyOUT);
                subcmd25.setAction(1);
                subcfg.addCmdValues(subcmd25);
            }
        }
        if (bBase == null && this._servicePolicyIN.trim().length() != 0 || bBase != null && !this._servicePolicyIN.equals(bBase._servicePolicyIN)) {
            if (bBase != null && bBase._servicePolicyIN.length() > 0) {
                CmdValues subcmd26 = new CmdValues(KEY_SERVICE_POLICY);
                subcmd26.addValue(KEY_INPUT, KEY_INPUT);
                subcmd26.addValue("policyName", bBase._servicePolicyIN);
                subcmd26.setAction(2);
                subcfg.addCmdValues(subcmd26);
            }
            if (this._servicePolicyIN.trim().length() > 0) {
                CmdValues subcmd27 = new CmdValues(KEY_SERVICE_POLICY);
                subcmd27.addValue(KEY_INPUT, KEY_INPUT);
                subcmd27.addValue("policyName", this._servicePolicyIN);
                subcfg.addCmdValues(subcmd27);
            }
        }
        if (bBase == null && this._bridgeGroup != 0 || bBase != null && this._bridgeGroup != bBase._bridgeGroup) {
            if (bBase != null && bBase._bridgeGroup > 0) {
                CmdValues subcmd28 = new CmdValues(KEY_BRIDGE_GROUP);
                subcmd28.addValue(KEY_NUMBER, String.valueOf(bBase._bridgeGroup));
                subcmd28.setAction(2);
                subcfg.addCmdValues(subcmd28);
            }
            if (this._bridgeGroup > 0) {
                CmdValues subcmd29 = new CmdValues(KEY_BRIDGE_GROUP);
                subcmd29.addValue(KEY_NUMBER, String.valueOf(this._bridgeGroup));
                subcfg.addCmdValues(subcmd29);
            }
        }
        if (bBase == null && this._admission.length() > 0 || bBase != null && !this._admission.equals(bBase._admission)) {
            if (bBase != null && !this._admission.equals(bBase._admission) && bBase._admission != null && bBase._admission.length() > 0) {
                CmdValues subcmd30 = new CmdValues(KEY_IP);
                subcmd30.addValue(KEY_ADMISSION, KEY_ADMISSION);
                subcmd30.addValue("AdName", bBase._admission);
                subcmd30.setAction(2);
                subcfg.addCmdValues(subcmd30);
            }
            if (this._admission.length() > 0) {
                CmdValues subcmd31 = new CmdValues(KEY_IP);
                subcmd31.addValue(KEY_ADMISSION, KEY_ADMISSION);
                subcmd31.addValue("AdName", this._admission);
                subcfg.addCmdValues(subcmd31);
            }
        }
        if (bBase != null && this.m_nHoldPeriod != bBase.getHoldPeriodTimeout()) {
            CmdValues subcmd32 = new CmdValues(KEY_EOU);
            subcmd32.addValue(KEY_TIMEOUT, KEY_TIMEOUT);
            subcmd32.addValue(KEY_HOLD_PERIOD, KEY_HOLD_PERIOD);
            subcmd32.addValue(VAL_HOLD_PERIOD, Integer.toString(this.m_nHoldPeriod));
            subcfg.addCmdValues(subcmd32);
        }
        if (bBase != null && this.m_nRevalidate != bBase.getRevalidateTimeout()) {
            CmdValues subcmd33 = new CmdValues(KEY_EOU);
            subcmd33.addValue(KEY_TIMEOUT, KEY_TIMEOUT);
            subcmd33.addValue(KEY_REVALIDATION, KEY_REVALIDATION);
            subcmd33.addValue(VAL_REVALIDATION, Integer.toString(this.m_nRevalidate));
            subcfg.addCmdValues(subcmd33);
        }
        if (bBase != null && this.m_nRetransmit != bBase.getRetransmitTimeout()) {
            CmdValues subcmd34 = new CmdValues(KEY_EOU);
            subcmd34.addValue(KEY_TIMEOUT, KEY_TIMEOUT);
            subcmd34.addValue(KEY_RETRANSMIT, KEY_RETRANSMIT);
            subcmd34.addValue(VAL_RETRANSMIT, Integer.toString(this.m_nRetransmit));
            subcfg.addCmdValues(subcmd34);
        }
        if (bBase != null && this.m_nStatusQuery != bBase.getStatusQueryTimeout()) {
            CmdValues subcmd35 = new CmdValues(KEY_EOU);
            subcmd35.addValue(KEY_TIMEOUT, KEY_TIMEOUT);
            subcmd35.addValue(KEY_STATUS_QUERY, KEY_STATUS_QUERY);
            subcmd35.addValue(VAL_STATUS_QUERY, Integer.toString(this.m_nStatusQuery));
            subcfg.addCmdValues(subcmd35);
        }
        if (subcfg.numCmds() > 0) {
            cmd.setModeCmdsValues(subcfg);
        }
        this.generateDeltaByThisIf(backup, cmd);
        subcfg = cmd.getModeCmdsValues();
        if (subcfg != null && subcfg.numCmds() > 0) {
            if (this.isPointedIf() || bBase != null && bBase.isPointedIf()) {
                dev.setLastCmd(2, cmd);
            } else {
                values.addCmdValues(cmd);
            }
        }
    }

    protected abstract void generateDeltaByThisIf(XDMObject var1, CmdValues var2) throws XDMException;

    private void generateHelperAddressCmd(Vector backupVector, ConfigValues subcfg) {
        CmdValues helperSubcmd;
        IPAddress obj;
        if (this._helperAddress != null) {
            int i = 0;
            while (i < this._helperAddress.size()) {
                obj = (IPAddress)this._helperAddress.elementAt(i);
                if (!(obj == null || backupVector != null && backupVector.contains(obj))) {
                    helperSubcmd = new CmdValues(KEY_IP);
                    helperSubcmd.addValue(KEY_HELPER_ADDR, KEY_HELPER_ADDR);
                    helperSubcmd.addValue(KEY_HELPERADDR, obj.toString());
                    helperSubcmd.setAction(1);
                    subcfg.addCmdValues(helperSubcmd);
                }
                ++i;
            }
        }
        if (backupVector != null) {
            int j = 0;
            while (j < backupVector.size()) {
                obj = (IPAddress)backupVector.elementAt(j);
                if (!(obj == null || this._helperAddress != null && this._helperAddress.contains(obj))) {
                    helperSubcmd = new CmdValues(KEY_IP);
                    helperSubcmd.addValue(KEY_HELPER_ADDR, KEY_HELPER_ADDR);
                    helperSubcmd.addValue(KEY_HELPERADDR, obj.toString());
                    helperSubcmd.setAction(2);
                    subcfg.addCmdValues(helperSubcmd);
                }
                ++j;
            }
        }
    }

    public CmdValues generateInterfaceCmd() {
        CmdValues cmd = new CmdValues("interface");
        if (this._ifID.getType() == 0) {
            cmd.addValue("strIfName", this._ifID.toString());
        } else {
            cmd.addValue("ifname", this._ifID.toString());
        }
        return cmd;
    }

    private void generateNHSelfCmd(Vector backupVector, ConfigValues subcfg) {
        CmdValues nhscmd;
        Integer obj;
        if (this._eigrpNHSelf != null) {
            int i = 0;
            while (i < this._eigrpNHSelf.size()) {
                obj = (Integer)this._eigrpNHSelf.elementAt(i);
                if (!(obj == null || backupVector != null && backupVector.contains(obj))) {
                    nhscmd = new CmdValues(KEY_IP);
                    nhscmd.addValue("next-hop-self", "next-hop-self");
                    nhscmd.addValue("eigrp", "eigrp");
                    nhscmd.addValue("ASNumber", obj.toString());
                    nhscmd.setAction(2);
                    subcfg.addCmdValues(nhscmd);
                }
                ++i;
            }
        }
        if (backupVector != null) {
            int j = 0;
            while (j < backupVector.size()) {
                obj = (Integer)backupVector.elementAt(j);
                if (!(obj == null || this._eigrpNHSelf != null && this._eigrpNHSelf.contains(obj))) {
                    nhscmd = new CmdValues(KEY_IP);
                    nhscmd.addValue("next-hop-self", "next-hop-self");
                    nhscmd.addValue("eigrp", "eigrp");
                    nhscmd.addValue("ASNumber", obj.toString());
                    nhscmd.setAction(1);
                    subcfg.addCmdValues(nhscmd);
                }
                ++j;
            }
        }
    }

    private CmdValues generateNoOSPFFastHello() {
        CmdValues cmd = new CmdValues(KEY_IP);
        cmd.addValue("ospf", "ospf");
        cmd.addValue("dead-interval", "dead-interval");
        cmd.setAction(2);
        return cmd;
    }

    private void generateShutNoShutCmds(ConfigValues cv) {
        CmdValues cmd = new CmdValues(KEY_SHUTDOWN);
        cmd.setAction(1);
        cv.addCmdValues(cmd);
        cmd = new CmdValues(KEY_SHUTDOWN);
        cmd.setAction(2);
        cv.addCmdValues(cmd);
    }

    private void generateSplitHorizonCmd(Vector backupVector, ConfigValues subcfg) {
        CmdValues nhscmd;
        Integer obj;
        if (this._eigrpSplitHorizon != null) {
            int i = 0;
            while (i < this._eigrpSplitHorizon.size()) {
                obj = (Integer)this._eigrpSplitHorizon.elementAt(i);
                if (!(obj == null || backupVector != null && backupVector.contains(obj))) {
                    nhscmd = new CmdValues(KEY_IP);
                    nhscmd.addValue("split-horizon", "split-horizon");
                    nhscmd.addValue("eigrp", "eigrp");
                    nhscmd.addValue("ASNumber", obj.toString());
                    nhscmd.setAction(2);
                    subcfg.addCmdValues(nhscmd);
                }
                ++i;
            }
        }
        if (backupVector != null) {
            int j = 0;
            while (j < backupVector.size()) {
                obj = (Integer)backupVector.elementAt(j);
                if (!(obj == null || this._eigrpSplitHorizon != null && this._eigrpSplitHorizon.contains(obj))) {
                    nhscmd = new CmdValues(KEY_IP);
                    nhscmd.addValue("split-horizon", "split-horizon");
                    nhscmd.addValue("eigrp", "eigrp");
                    nhscmd.addValue("ASNumber", obj.toString());
                    nhscmd.setAction(1);
                    subcfg.addCmdValues(nhscmd);
                }
                ++j;
            }
        }
    }

    private void generatenhrpNHSCmd(Vector backupVector, ConfigValues subcfg) {
        CmdValues nhscmd;
        IPAddress obj;
        if (this._nhrpNHS != null) {
            int i = 0;
            while (i < this._nhrpNHS.size()) {
                obj = (IPAddress)this._nhrpNHS.elementAt(i);
                if (!(obj == null || backupVector != null && backupVector.contains(obj))) {
                    nhscmd = new CmdValues(KEY_IP);
                    nhscmd.addValue("nhrp", "nhrp");
                    nhscmd.addValue("nhs", "nhs");
                    nhscmd.addValue("NHS", obj.toString());
                    nhscmd.setAction(1);
                    subcfg.addCmdValues(nhscmd);
                }
                ++i;
            }
        }
        if (backupVector != null) {
            int j = 0;
            while (j < backupVector.size()) {
                obj = (IPAddress)backupVector.elementAt(j);
                if (!(obj == null || this._nhrpNHS != null && this._nhrpNHS.contains(obj))) {
                    nhscmd = new CmdValues(KEY_IP);
                    nhscmd.addValue("nhrp", "nhrp");
                    nhscmd.addValue("nhs", "nhs");
                    nhscmd.addValue("NHS", obj.toString());
                    nhscmd.setAction(2);
                    subcfg.addCmdValues(nhscmd);
                }
                ++j;
            }
        }
    }

    public String getAdmisssionPolicy() {
        return this._admission;
    }

    public XDMInterfaceBase getBackup() {
        XDMInterfaceBase backup = null;
        if (!this.isBackup()) {
            DeviceBase dev = (DeviceBase)this.getDevice();
            backup = dev.getBackup().getIfs().getIfFromString(this.getIfID().toString());
        }
        return backup;
    }

    public int getBandwidth() {
        return this._bandwidth;
    }

    public int getBridgeGroup() {
        return this._bridgeGroup;
    }

    public String getCryptoMap() {
        return this._crypto;
    }

    public String getDDNSHostname() {
        return this._ddnsHostName;
    }

    public String getDDNSMethod() {
        return this._ddnsMethod;
    }

    public int getDHCPTrackObjNo() {
        return this._ipDHCPTrackObjNo;
    }

    public int getDelay() {
        return this._delay;
    }

    public String getDesc() {
        return this._desc;
    }

    public IPAddress getDhcpRelayAddr() {
        if (this._helperAddress != null && this._helperAddress.size() > 0) {
            return (IPAddress)this._helperAddress.elementAt(0);
        }
        return null;
    }

    public Vector getDhcpRelayAddresses() {
        return this._helperAddress;
    }

    public boolean getDropFlagments() {
        return this._dropFragments;
    }

    public int getEzVPNDir() {
        return this._ezVPNDir;
    }

    public String getEzVPNName() {
        return this._ezVPNName;
    }

    public int getFWDir() {
        int ret = 0;
        if (Description.isFlagExist(this._desc, SDM_FW_INSIDE)) {
            ret = 2;
        } else if (Description.isFlagExist(this._desc, SDM_FW_OUTSIDE)) {
            ret = 1;
        } else if (Description.isFlagExist(this._desc, SDM_FW_DMZ)) {
            ret = 3;
        }
        return ret;
    }

    protected Vector getFlags() {
        Vector<String> flags = new Vector<String>();
        flags.addElement(SDM_FW_OUTSIDE);
        flags.addElement(SDM_FW_INSIDE);
        flags.addElement(SDM_FW_DMZ);
        flags.addElement(ES_LAN);
        flags.addElement(ES_WAN);
        return flags;
    }

    public String getHWTypeLabel() {
        if (this._ifID.getType() == 0) {
            return this._ifID.getUnsupportIfStr();
        }
        HWDictionary dict = HWDictionary.GetInstance();
        IfType iftype = dict.getif(this._ifID.getType());
        return iftype.getName();
    }

    public Vector getHardwares() {
        if (this._ifID.isLogical() || this._ifID.isSubInterface()) {
            return null;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev == null) {
            return null;
        }
        return dev.getDevInfoBase().getHWConfig().getHardwares(this._ifID.getType(), this._ifID.getSlot(), this._ifID.getPort());
    }

    public int getHoldPeriodTimeout() {
        return this.m_nHoldPeriod;
    }

    public IfID getIfID() {
        return this._ifID;
    }

    public Vector getInsideEzVPNRemote() {
        return this._ipEzVPNIn;
    }

    public String getInspectIn() {
        return this._ipInspectIn;
    }

    public String getInspectOut() {
        return this._ipInspectOut;
    }

    public String getIpAccessGroupIn() {
        return this._ipAccessGroupIn;
    }

    public String getIpAccessGroupOut() {
        return this._ipAccessGroupOut;
    }

    public IfIPAddress getIpAddr() {
        return this._ipAddr;
    }

    public String getIpDirectedBCastAcl() {
        return this._ipDirectedBCastAcl;
    }

    public boolean getIpMaskReply() {
        return this._ipMaskReply;
    }

    public boolean getIpRedirects() {
        return this._ipRedirects;
    }

    public boolean getIpRouteCache() {
        return this._ipRouteCache;
    }

    public boolean getIpRouteCacheCef() {
        return this._ipRouteCacheCef;
    }

    public boolean getIpRouteCacheFlow() {
        return this._ipRouteCacheFlow;
    }

    public String getIpUnicastRPFAcl() {
        return this._ipUnicastRPFAcl;
    }

    public boolean getIpUnreachables() {
        return this._ipUnreachables;
    }

    public String getIpsIn() {
        return this._ipIpsIn;
    }

    public String getIpsOut() {
        return this._ipIpsOut;
    }

    public String getLabel() {
        Vector<XDMInterfaceBase> phs = new Vector<XDMInterfaceBase>();
        DeviceBase dev = (DeviceBase)this.getDevice();
        Enumeration e = dev.getIfs().elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMSubInterfaces subIfs;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            XDMInterfaceBase logical = item.getLogicalIf();
            if (logical != null && logical.getIfID().compare(this._ifID) == 0) {
                phs.addElement(item);
            }
            if ((subIfs = (mainIf = (XDMInterface)item).getSubInterfaces()) == null) continue;
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                XDMInterfaceBase logicalSub = sif.getLogicalIf();
                if (logicalSub == null || logicalSub.getIfID().compare(this._ifID) != 0) continue;
                phs.addElement(sif);
            }
        }
        return this.getLabel(phs);
    }

    public String getLabel(Vector phs) {
        StringBuffer sb = new StringBuffer();
        sb.append(this._ifID.toString());
        if (phs != null && phs.size() > 0) {
            sb.append(" {");
            boolean c = false;
            Enumeration e = phs.elements();
            while (e.hasMoreElements()) {
                XDMInterfaceBase pItem = (XDMInterfaceBase)e.nextElement();
                if (c) {
                    sb.append(",");
                }
                sb.append(pItem.getIfID().toString());
                c = true;
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public XDMInterfaceBase getLogicalIf() {
        return null;
    }

    public boolean getMop() {
        return this._mop;
    }

    public int getMtu() {
        return this._mtu;
    }

    public String getNHRPAuth() {
        return this._nhrpAuth;
    }

    public int getNHRPHoldTime() {
        return this._nhrpHoldTime;
    }

    public long getNHRPID() {
        return this._nhrpID;
    }

    public boolean getNHRPRegNoQ() {
        return this._nhrpRegNoQ;
    }

    public boolean getNHRPSvrOnly() {
        return this._nhrpSvrOnly;
    }

    public int getNat() {
        return this._nat;
    }

    public int getOspfDead() {
        return this._ospfDeadInt;
    }

    public int getOspfHello() {
        return this._ospfHelloInt;
    }

    public int getOspfMux() {
        return this._ospfDeadMux;
    }

    public String getOutsideEzVPNRemote() {
        return this._ipEzVPNOut;
    }

    public String getPureDesc() {
        Vector flags = this.getFlags();
        return Description.getDescWithoutFlags(this._desc, flags);
    }

    public int getRIPRcvVersion() {
        return this._ripRcvVersion;
    }

    public int getResetWaitTime() {
        return 30000;
    }

    public int getRetransmitTimeout() {
        return this.m_nRetransmit;
    }

    public int getRevalidateTimeout() {
        return this.m_nRevalidate;
    }

    public String getServicePolicyIN() {
        return this._servicePolicyIN;
    }

    public String getServicePolicyOUT() {
        return this._servicePolicyOUT;
    }

    public int getStatusQueryTimeout() {
        return this.m_nStatusQuery;
    }

    public int getTcpSize() {
        return this._tcpsize;
    }

    public boolean getVirtualReassembly() {
        return this._virtualReassembly;
    }

    public String getZone() {
        return this._zoneName;
    }

    public Vector geteigrpNHSelf() {
        return this._eigrpNHSelf;
    }

    public Vector geteigrpSplitHorizon() {
        return this._eigrpSplitHorizon;
    }

    public Vector getnhrpNHS() {
        return this._nhrpNHS;
    }

    public String getospfNetworkType() {
        return this._ospfNetworkType;
    }

    public int getospfPriority() {
        return this._ospfPriority;
    }

    public boolean getripSplitHorizon() {
        return this._ripSplitHorizon;
    }

    public boolean isBackupNeedToDelete() {
        return this._isBackupNeedToDelete;
    }

    public boolean isCDPEnable() {
        return this._cdp;
    }

    public boolean isConfigurable() {
        boolean bCRBBridge = false;
        Bridging bridge = ((DeviceBase)this.getDevice()).getBridging();
        if (this.getBridgeGroup() > 0 && bridge.getBridgingType() == 1) {
            bCRBBridge = true;
        }
        return this._isConfigurable && !bCRBBridge;
    }

    public boolean isConfigured() {
        return false;
    }

    public boolean isDDNSDHCPCmdPresent() {
        return this._ddnsDHCPCmdPresent;
    }

    public int isDDNSDHCPCmdRequired() {
        if (this instanceof SerialInterface || this instanceof SerialSubInterface) {
            return -1;
        }
        if (this._ddnsDHCPCmdReqd) {
            if (this._ipAddr == null) {
                return 2;
            }
            if (this._ipAddr.getIPAddressType() == IPAddressType.DYNAMIC) {
                if (this._ddnsMethod != null && this._ddnsMethod.length() > 0) {
                    return 1;
                }
                return 2;
            }
            if (this._ipAddr.getIPAddressType() != IPAddressType.DYNAMIC) {
                return 2;
            }
        } else {
            IfIPAddress backupIpAddr;
            if (this._ddnsMethod == null || this._ddnsMethod.length() <= 0) {
                return -1;
            }
            DeviceBase dev = (DeviceBase)this.getDevice();
            DeviceBase backupDev = dev.getBackup();
            XDMInterfaceBase backupIntf = this.getBackup();
            if (backupIntf != null && (backupIpAddr = backupIntf.getIpAddr()) != null && this._ipAddr != null) {
                if (this._ipAddr.getIPAddressType() == IPAddressType.DYNAMIC && backupIpAddr.getIPAddressType() != IPAddressType.DYNAMIC) {
                    return 1;
                }
                if (backupIpAddr.getIPAddressType() == IPAddressType.DYNAMIC && this._ipAddr.getIPAddressType() != IPAddressType.DYNAMIC) {
                    return 2;
                }
            }
        }
        return -1;
    }

    public boolean isDDNSReadOnly() {
        return this._ddnsReadOnly;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isFairQueueEnabled() {
        return this._fairQueue;
    }

    public boolean isFlowInEnabled() {
        return this._flowIn;
    }

    public boolean isFlowOutEnabled() {
        return this._flowOut;
    }

    public boolean isHelperAddressConfigurable() {
        return this._helperAddress == null || this._helperAddress.size() <= 1;
    }

    public boolean isIDSMonitorig() {
        return this._IDSMonitoring;
    }

    public boolean isIpDirectedBCastEnable() {
        return this._ipDirectedBCast;
    }

    public boolean isIpProxyArpEnable() {
        return this._ipProxyArp;
    }

    public boolean isIpUnicastRPFEnable() {
        return this._ipUnicastRPF;
    }

    public boolean isNBAREnabled() {
        return this._nbarEnabled;
    }

    public boolean isPointedIf() {
        String str;
        DeviceBase dev = (DeviceBase)this.getDevice();
        String addr = dev.getDevInfoBase().getIpAddr();
        return addr != null && this.getIpAddr() != null && this.getIpAddr().getIPAddressType() == IPAddressType.STATIC && (str = this.getIpAddr().getIPAddressAsString()) != null && str.indexOf(addr) == 0;
    }

    public boolean isReset() {
        IfIPAddress backupIpAddr;
        DeviceBase dev = (DeviceBase)this.getDevice();
        DeviceBase backupDev = dev.getBackup();
        XDMInterfaceBase backupIntf = (XDMInterfaceBase)backupDev.getIfs().get(this._ifID);
        if (backupIntf != null && (backupIpAddr = backupIntf.getIpAddr()) != null && backupIpAddr != null && this._ipAddr != null && backupIpAddr.getIPAddressType() != this._ipAddr.getIPAddressType() && (this._ipAddr.getIPAddressType() == IPAddressType.DYNAMIC || this._ipAddr.getIPAddressType() == IPAddressType.NEGOTIATED)) {
            Log.getLog().debug("XDMInterfaceBase: _ipAddr requires reset.  returning true");
            return true;
        }
        return this._reset;
    }

    public boolean isResetbyGUI() {
        return this._guiReset;
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    public boolean isSupported(int attr) {
        return this.getBridgeGroup() == 0 && this.isSupported(attr, true);
    }

    private boolean isSupported(int attr, boolean detAll) {
        if (attr < 0 || attr > 25) {
            return false;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (attr == 4 && !dev.getDevInfoBase().isCBAC()) {
            return false;
        }
        if (!(attr != 2 && attr != 3 || dev.getDevInfoBase().isCrypto())) {
            return false;
        }
        if (this._isSupported[attr] == -1) {
            if (this.getIfID().isSubInterface()) {
                this._isSupported[attr] = this.findFlagFromSameMainIf(attr);
                if (this._isSupported[attr] == -1) {
                    if (detAll) {
                        this.detectAll();
                    } else {
                        this.detect(attr);
                    }
                }
            } else if (detAll) {
                this.detectAll();
            } else {
                this.detect(attr);
            }
            if (attr == 23) {
                this.extrapolatePoEDiscovery();
            }
        }
        return this._isSupported[attr] == 1;
    }

    protected final boolean isUsing(int attr, String value) {
        if (value == null) {
            return false;
        }
        boolean result = false;
        switch (attr) {
            case 0: {
                result = this._ipAccessGroupIn.equals(value) || this._ipAccessGroupOut.equals(value);
                break;
            }
            case 1: {
                result = value.equals(KEY_INSIDE) && this._nat == 1 || value.equals(KEY_OUTSIDE) && this._nat == 2;
                break;
            }
            case 2: {
                result = this._crypto.equals(value);
                break;
            }
            case 3: {
                StringTokenizer st = new StringTokenizer(value);
                String ezvpnName = st.nextToken();
                int dir = Integer.parseInt(st.nextToken());
                result = dir == 1 && this._ipEzVPNIn.contains(ezvpnName) || dir == 2 && this._ipEzVPNOut.equals(ezvpnName);
                break;
            }
            case 4: {
                result = this._ipInspectIn.equals(value) || this._ipInspectOut.equals(value);
                break;
            }
            case 19: {
                result = this._servicePolicyOUT.equals(value) || this._servicePolicyIN.equals(value);
                break;
            }
            case 18: {
                result = this._ipIpsIn.equals(value) || this._ipIpsOut.equals(value);
                break;
            }
            case 21: {
                result = this._admission.equals(value);
                break;
            }
        }
        return result;
    }

    public boolean isWAN() {
        return false;
    }

    public void makeDDNSReadOnly(boolean flag) {
        this._ddnsReadOnly = flag;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        this._ipRedirects = true;
        this._ipUnreachables = true;
        this._ipMaskReply = false;
        this._ipRouteCacheFlow = this.DEF_IPROUTECACHEFLOW;
        this._ipRouteCacheCef = this.DEF_IPROUTECACHECEF;
        this._ipRouteCache = this.DEF_IPROUTECACHE;
        this._mop = this.DEF_MOP;
        this._ddnsDHCPCmdPresent = false;
        this._ddnsReadOnly = false;
        this._ddnsHostName = "";
        this._ddnsMethod = "";
        if (subCmds != null) {
            int i = 0;
            while (i < subCmds.numCmds()) {
                String dir;
                CmdValues cmd = subCmds.getCmdValues(i);
                String cmdName = cmd.getCmdName();
                if (cmdName.compareTo(KEY_DESCRIPTION) == 0) {
                    this._desc = cmd.getValue(KEY_DESC);
                } else if (cmdName.compareTo(KEY_ZONE_MEMBER) == 0) {
                    this._zoneName = cmd.getValue(KEY_ZONE);
                } else if (cmdName.compareTo(KEY_SHUTDOWN) == 0) {
                    this._shutdown = cmd.isNoCmd() ^ true;
                } else if (cmdName.compareTo(KEY_CDP) == 0) {
                    this._cdp = cmd.isNoCmd() ^ true;
                    this._isSupported[5] = 1;
                } else if (cmd.containsKey("bandwidth")) {
                    this._bandwidth = Integer.parseInt(cmd.getValue("bandwidth"));
                } else if (cmdName.compareTo("delay") == 0) {
                    this._delay = Integer.parseInt(cmd.getValue("iDelay"));
                } else if (cmdName.compareTo(KEY_CRYPTO) == 0) {
                    if (cmd.containsKey(KEY_MAP)) {
                        this._crypto = cmd.getValue(KEY_NAME);
                        if (this._isSupported[2] == -1) {
                            this._isSupported[2] = 1;
                        }
                    } else if (cmd.containsKey(KEY_EZVPN)) {
                        dir = cmd.getValue(KEY_DIR);
                        if (dir == null || dir.compareTo(KEY_OUTSIDE) == 0) {
                            this._ipEzVPNOut = cmd.getValue(KEY_NAME);
                        } else {
                            this._ipEzVPNIn.addElement(cmd.getValue(KEY_NAME));
                        }
                        if (this._isSupported[3] == -1) {
                            this._isSupported[3] = 1;
                        }
                    }
                } else if (cmdName.compareTo(KEY_IP) == 0) {
                    if (cmd.containsKey(KEY_ADDRESS) || cmd.containsKey(KEY_UNNUMBERED)) {
                        if (!cmd.isNoCmd()) {
                            if (this._ipAddr == null) {
                                this._ipAddr = new IfIPAddress();
                            }
                            this._ipAddr.setParent(this);
                            if (this._ifID != null) {
                                Log.getLog().debug("Calling ifipaddress populate for interface : " + this._ifID.toString());
                            }
                            this._ipAddr.populate(config, cmd);
                        }
                    } else if (cmd.containsKey(KEY_PROXY_ARP)) {
                        this._ipProxyArp = cmd.isNoCmd() ^ true;
                        this._isSupported[8] = 1;
                    } else if (cmd.containsKey(KEY_DIRECTEDBCAST)) {
                        this._ipDirectedBCast = cmd.isNoCmd() ^ true;
                        if (cmd.isNoCmd()) {
                            this.setIpDirectedBCastAcl("");
                        } else {
                            this.setIpDirectedBCastAcl(cmd.getValue(KEY_ACL));
                        }
                        this._isSupported[9] = 1;
                    } else if (cmd.containsKey(KEY_NAT)) {
                        dir = cmd.getValue(KEY_DIR);
                        this._nat = dir.equalsIgnoreCase(KEY_INSIDE) ? 1 : 2;
                        this._isSupported[1] = 1;
                    } else if (cmd.containsKey(KEY_AG)) {
                        dir = cmd.getValue(KEY_DIR);
                        if (dir.compareTo(KEY_IN) == 0) {
                            this._ipAccessGroupIn = cmd.getValue(KEY_NAME);
                        } else {
                            this._ipAccessGroupOut = cmd.getValue(KEY_NAME);
                        }
                        this.setACLCategory(cmd.getValue(KEY_NAME), null);
                        if (this._isSupported[0] == -1) {
                            this._isSupported[0] = 1;
                        }
                    } else if (cmd.containsKey(KEY_INSPECT)) {
                        dir = cmd.getValue(KEY_DIR);
                        if (dir.compareTo(KEY_IN) == 0) {
                            this._ipInspectIn = cmd.getValue(KEY_NAME);
                        } else {
                            this._ipInspectOut = cmd.getValue(KEY_NAME);
                        }
                        if (this._isSupported[4] == -1) {
                            this._isSupported[4] = 1;
                        }
                    } else if (cmd.containsKey(KEY_IPS)) {
                        dir = cmd.getValue(KEY_DIR);
                        if (dir.compareTo(KEY_IN) == 0) {
                            this._ipIpsIn = cmd.getValue(KEY_NAME);
                        } else {
                            this._ipIpsOut = cmd.getValue(KEY_NAME);
                        }
                        if (this._isSupported[18] == -1) {
                            this._isSupported[18] = 1;
                        }
                    } else if (cmd.containsKey(KEY_VFR)) {
                        this._virtualReassembly = true;
                        if (cmd.containsKey(KEY_DROP_FRAG)) {
                            this._dropFragments = true;
                        }
                    } else if (cmd.containsKey(KEY_HELPER_ADDR)) {
                        if (cmd.containsKey(KEY_HELPERADDR)) {
                            String relayIp = cmd.getValue(KEY_HELPERADDR);
                            if (this._helperAddress == null) {
                                this._helperAddress = new Vector();
                            }
                            this._helperAddress.addElement(new IPAddress(relayIp));
                        }
                    } else if (cmd.containsKey(KEY_VERIFY) && cmd.containsKey(KEY_UNICAST)) {
                        if (cmd.containsKey(KEY_REVERSE_PATH)) {
                            this._ipUnicastRPF = cmd.isNoCmd() ^ true;
                            if (cmd.containsKey(KEY_ACL)) {
                                this._ipUnicastRPFAcl = cmd.getValue(KEY_ACL);
                            }
                        }
                    } else if (cmd.containsKey(KEY_DHCP) && cmd.containsKey(KEY_CLIENT) && cmd.containsKey(KEY_ROUTE) && cmd.containsKey(KEY_TRACK)) {
                        if (cmd.containsKey(KEY_DHCP_TRACKOBJ_NO)) {
                            this._ipDHCPTrackObjNo = Integer.parseInt(cmd.getValue(KEY_DHCP_TRACKOBJ_NO));
                        }
                        Log.getLog().info("DHCP Configured with tracking option, _ipDHCPTrackObjNo: " + this._ipDHCPTrackObjNo);
                    } else if (cmd.containsKey(KEY_DHCP) && cmd.containsKey(KEY_CLIENT) && cmd.containsKey("update") && cmd.containsKey("dns")) {
                        if (cmd.containsKey("server")) {
                            if (cmd.containsKey("mode")) {
                                if (!cmd.getValue("mode").equalsIgnoreCase("none")) {
                                    this.makeDDNSReadOnly(true);
                                }
                            } else {
                                this.makeDDNSReadOnly(true);
                            }
                        } else {
                            this._ddnsDHCPCmdPresent = true;
                            this.makeDDNSReadOnly(true);
                        }
                    } else if (cmd.containsKey("ddns") && cmd.containsKey("update") && cmd.containsKey("hostname")) {
                        this._ddnsHostName = cmd.getValue("hostnm");
                    } else if (cmd.containsKey("ddns") && cmd.containsKey("update") && cmd.containsKey("methodName")) {
                        if (cmd.containsKey("host") || cmd.containsKey("host-group")) {
                            this.makeDDNSReadOnly(true);
                        } else {
                            this._ddnsMethod = cmd.getValue("methodName");
                        }
                    } else if (cmd.containsKey(KEY_MTU)) {
                        this._mtu = Integer.parseInt(cmd.getValue("SIZE"));
                        Log.getLog().debug("XDMInterfaceBase: MTU set to..." + this._mtu);
                    } else if (cmd.containsKey("rip") && cmd.containsKey("receive") && cmd.containsKey("version")) {
                        this._ripRcvVersion = Integer.parseInt(cmd.getValue("ripVer"));
                    } else if (cmd.containsKey("nhrp")) {
                        if (cmd.containsKey("authentication")) {
                            this._nhrpAuth = cmd.getValue("NHRPAuth");
                        } else if (cmd.containsKey("network-id")) {
                            this._nhrpID = Long.parseLong(cmd.getValue("networkID"));
                        } else if (cmd.containsKey("holdtime")) {
                            this._nhrpHoldTime = Integer.parseInt(cmd.getValue("holdTime"));
                        } else if (cmd.containsKey("nhs")) {
                            String ip = cmd.getValue("NHS");
                            this.addnhrpNHS(new IPAddress(ip));
                        } else if (cmd.containsKey("server-only")) {
                            this._nhrpSvrOnly = true;
                        } else if (cmd.containsKey("no-unique")) {
                            this._nhrpRegNoQ = true;
                        }
                    } else if (cmd.containsKey("ospf")) {
                        if (cmd.containsKey("networkType")) {
                            this._ospfNetworkType = cmd.getValue("networkType");
                        }
                        if (cmd.containsKey("priority")) {
                            this._ospfPriority = Integer.parseInt(cmd.getValue("TunnelKey"));
                        }
                        if (cmd.containsKey("hello-interval")) {
                            this._ospfHelloInt = Integer.parseInt(cmd.getValue("helloInt"));
                        }
                        if (cmd.containsKey("dead-interval")) {
                            if (cmd.containsKey("hello-multiplier")) {
                                this._ospfDeadMux = Integer.parseInt(cmd.getValue("helloMux"));
                            } else {
                                this._ospfDeadInt = Integer.parseInt(cmd.getValue("deadInt"));
                            }
                        }
                    } else if (cmd.containsKey("split-horizon") && cmd.isNoCmd()) {
                        if (cmd.containsKey("eigrp")) {
                            this.addEIGRPSplitHorizon(Integer.parseInt(cmd.getValue("ASNumber")));
                        } else {
                            this._ripSplitHorizon = false;
                        }
                    } else if (cmd.containsKey("next-hop-self") && cmd.isNoCmd()) {
                        if (cmd.containsKey("eigrp")) {
                            this.addEIGRPNHSelf(Integer.parseInt(cmd.getValue("ASNumber")));
                        }
                    } else if (cmd.containsKey(KEY_REDIRECTS)) {
                        this._ipRedirects = cmd.isNoCmd() ^ true;
                        this._isSupported[7] = 1;
                    } else if (cmd.containsKey(KEY_UNREACHABLES)) {
                        this._ipUnreachables = cmd.isNoCmd() ^ true;
                        this._isSupported[10] = 1;
                    } else if (cmd.containsKey(KEY_MASK_REPLY)) {
                        this._ipMaskReply = cmd.isNoCmd() ^ true;
                        this._isSupported[11] = 1;
                    } else if (cmd.containsKey(KEY_ROUTE_CACHE) && cmd.containsKey(KEY_FLOW)) {
                        this._ipRouteCacheFlow = cmd.isNoCmd() ^ true;
                        this._isSupported[12] = 1;
                    } else if (cmd.containsKey(KEY_ROUTE_CACHE) && cmd.containsKey(KEY_CEF)) {
                        this._ipRouteCacheCef = cmd.isNoCmd() ^ true;
                        this._isSupported[12] = 1;
                    } else if (cmd.containsKey(KEY_ROUTE_CACHE) && !cmd.containsKey(KEY_CEF) && !cmd.containsKey(KEY_FLOW)) {
                        this._ipRouteCache = cmd.isNoCmd() ^ true;
                        this._isSupported[12] = 1;
                    } else if (cmd.containsKey("nbar") && cmd.containsKey("protocol-discovery")) {
                        this._nbarEnabled = true;
                    } else if (cmd.containsKey(KEY_ADJ_MSS) && cmd.containsKey(KEY_TCPSIZE)) {
                        this._tcpsize = Integer.parseInt(cmd.getValue(KEY_TCPSIZE));
                    } else if (cmd.containsKey(KEY_ADMISSION)) {
                        this._admission = cmd.getValue("AdName");
                        this._isSupported[21] = 1;
                    } else if (cmd.containsKey(KEY_FLOW) && cmd.containsKey("ingress")) {
                        this._flowIn = true;
                    } else if (cmd.containsKey(KEY_FLOW) && cmd.containsKey("egress")) {
                        this._flowOut = true;
                    }
                } else if (cmdName.compareTo(KEY_MOP) == 0) {
                    this._isSupported[6] = 1;
                    this._mop = cmd.isNoCmd() ^ true;
                } else if (cmdName.compareTo(KEY_IDS_MODULE) == 0) {
                    this._IDSMonitoring = cmd.isNoCmd() ^ true;
                } else if (cmdName.compareTo(KEY_NTP) == 0) {
                    String strPeerAddress;
                    String strKeyNumber;
                    Log.getLog().debug("NTP Comamnd Hits");
                    if (cmd.containsKey(KEY_BROADCAST)) {
                        Log.getLog().debug("Inside broadcast");
                        if (cmd.containsKey(KEY_BROADCAST_KEY)) {
                            strKeyNumber = cmd.getValue(KEY_BROADCAST_KEY);
                            Log.getLog().debug("Got the broadcast is associated with a key number strKeyNumber" + strKeyNumber);
                            if (strKeyNumber != null) {
                                SDM_NTPClient.addNTPPeerAuthKeyToVector(strKeyNumber);
                            }
                        }
                        if (cmd.containsKey(KEY_BROADCAST_DESTINATION)) {
                            strPeerAddress = cmd.getValue(KEY_BROADCAST_DESTINATION);
                            Log.getLog().debug("Got the broadcast Address strPeerAddress" + strPeerAddress);
                            if (strPeerAddress != null) {
                                SDM_NTPClient.addNTPPeerServerToVector(strPeerAddress);
                            }
                        }
                    } else if (cmd.containsKey(KEY_MULTICAST)) {
                        Log.getLog().debug("Inside NTP multicast");
                        if (cmd.containsKey(KEY_MULTICAST_KEY)) {
                            strKeyNumber = cmd.getValue(KEY_MULTICAST_KEY);
                            Log.getLog().debug("Got the multicast is associated with a key number strKeyNumber" + strKeyNumber);
                            if (strKeyNumber != null) {
                                SDM_NTPClient.addNTPPeerAuthKeyToVector(strKeyNumber);
                            }
                        }
                        if (cmd.containsKey(KEY_MULTICAST_DESTINATION)) {
                            strPeerAddress = cmd.getValue(KEY_MULTICAST_DESTINATION);
                            Log.getLog().debug("Got the multicast Address strPeerAddress" + strPeerAddress);
                            if (strPeerAddress != null) {
                                SDM_NTPClient.addNTPPeerServerToVector(strPeerAddress);
                            }
                        }
                    }
                } else if (cmdName.compareTo(KEY_SERVICE_POLICY) == 0 && cmd.containsKey(KEY_OUTPUT)) {
                    this._servicePolicyOUT = cmd.getValue("policyName");
                    Log.getLog().debug("XDMInterfaceBase._servicePolicyOUT = " + this._servicePolicyOUT);
                    if (this._isSupported[19] == -1) {
                        this._isSupported[19] = 1;
                    }
                } else if (cmdName.compareTo(KEY_SERVICE_POLICY) == 0 && cmd.containsKey(KEY_INPUT)) {
                    this._servicePolicyIN = cmd.getValue("policyName");
                    Log.getLog().debug("XDMInterfaceBase._servicePolicyIN = " + this._servicePolicyIN);
                    if (this._isSupported[19] == -1) {
                        this._isSupported[19] = 1;
                    }
                } else if (cmdName.compareTo(KEY_FAIR_QUEUE) == 0) {
                    this._fairQueue = true;
                } else if (cmdName.compareTo(KEY_BRIDGE_GROUP) == 0) {
                    this._bridgeGroup = Integer.valueOf(cmd.getValue(KEY_NUMBER));
                } else if (cmdName.compareTo(KEY_EOU) == 0) {
                    if (cmd.containsKey(KEY_HOLD_PERIOD)) {
                        this.m_nHoldPeriod = Integer.parseInt(cmd.getValue(VAL_HOLD_PERIOD));
                    } else if (cmd.containsKey(KEY_RETRANSMIT)) {
                        this.m_nRetransmit = Integer.parseInt(cmd.getValue(VAL_RETRANSMIT));
                    } else if (cmd.containsKey(KEY_REVALIDATION)) {
                        this.m_nRevalidate = Integer.parseInt(cmd.getValue(VAL_REVALIDATION));
                    } else if (cmd.containsKey(KEY_STATUS_QUERY)) {
                        this.m_nStatusQuery = Integer.parseInt(cmd.getValue(VAL_STATUS_QUERY));
                    }
                }
                ++i;
            }
        }
    }

    public void removeAllInsideEzVPNRemote() {
        this._ipEzVPNIn.clear();
        this.setModified();
    }

    public boolean removeEIGRPNHSelf(int asNo) {
        if (this._eigrpNHSelf == null) {
            return false;
        }
        this.setModified();
        return this._eigrpNHSelf.removeElement(new Integer(asNo));
    }

    public boolean removeEIGRPSplitHorizon(int asNo) {
        if (this._eigrpSplitHorizon == null) {
            return false;
        }
        this.setModified();
        return this._eigrpSplitHorizon.removeElement(new Integer(asNo));
    }

    public void removeInsideEzVPNRemote(String ezvpnIn) {
        if (ezvpnIn == null || !this._ipEzVPNIn.contains(ezvpnIn)) {
            return;
        }
        this._ipEzVPNIn.removeElement(ezvpnIn);
        this.setModified();
    }

    public boolean removenhrpNHS(IPAddress ip) {
        if (this._nhrpNHS == null) {
            return false;
        }
        this.setModified();
        return this._nhrpNHS.removeElement(ip);
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        this._ipInspectInModified = false;
        this._ipInspectOutModified = false;
        if (this._ipAddr != null) {
            this._ipAddr.resetModifiedFlag();
        }
        this._reset = false;
        this._guiReset = false;
    }

    public void sendNoEzVPNOutside2Dev() throws IOException {
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        if (ifs.getIfObjStat(this) == 0) {
            return;
        }
        String ezVPN = this.getOutsideEzVPNRemote();
        if (ezVPN.length() == 0) {
            return;
        }
        this.setOutsideEzVPNRemote("");
        String[] commands = new String[]{"interface " + this._ifID.toString(), "no crypto ipsec client ezvpn " + ezVPN + " outside", "exit"};
        dev.getDevInfoBase().getComm().config(commands);
        XDMInterfaceBase backupIf = dev.getBackup().getIfs().getIfFromString(this.getIfID().toString());
        if (backupIf != null) {
            backupIf.setOutsideEzVPNRemote("");
        }
    }

    public void sendShutdown2Dev(boolean flag) throws IOException {
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        if (ifs.getIfObjStat(this) == 0) {
            return;
        }
        this.shutdown(flag);
        String[] commands = new String[]{"interface " + this._ifID.toString(), "no shutdown"};
        if (flag) {
            commands[1] = KEY_SHUTDOWN;
        }
        dev.getDevInfoBase().getComm().config(commands);
        ifs.setShutdownInBackup(this, flag);
    }

    void setACLCategory(String aclNew, String aclOld) {
        DeviceBase dev = (DeviceBase)this.getDevice();
        dev.setACLAccessCategory(aclNew, aclOld);
    }

    public boolean setAdmissionPolicy(String admission) {
        if (this.isSupported(21) && !this._admission.equals(admission)) {
            this._admission = admission == null ? "" : admission;
            this.setModified();
        }
        return this.isSupported(21);
    }

    public void setBackupDelete(boolean flag) {
        this._isBackupNeedToDelete = flag;
    }

    public void setBandwidth(int bw) {
        this._bandwidth = bw;
        this.setModified();
    }

    public void setBridgeGroup(int val) {
        this._bridgeGroup = val;
        this.setModified();
    }

    public void setCDP(boolean enable) {
        if (!this.isSupported(5) || this._cdp == enable) {
            return;
        }
        this._cdp = enable;
        this.setModified();
    }

    public void setConfigurable(boolean configurable) {
        this._isConfigurable = configurable;
    }

    public boolean setCryptoMap(String crypto) {
        if (this.isSupported(2) && !this._crypto.equals(crypto)) {
            this._crypto = crypto == null ? "" : crypto;
            this.setModified();
        }
        return this.isSupported(2);
    }

    public void setDDNSDHCPCmdPresent(boolean flag) {
        this._ddnsDHCPCmdPresent = flag;
    }

    public void setDDNSDHCPCmdRequired(boolean flag) {
        this._ddnsDHCPCmdReqd = flag;
    }

    public void setDDNSHostname(String hostname) {
        if (hostname == null) {
            this._ddnsHostName = "";
        } else if (!this._ddnsHostName.equals(hostname)) {
            this._ddnsHostName = hostname;
            this.setModified();
        }
    }

    public void setDDNSMethod(String methName) {
        if (methName == null) {
            this._ddnsMethod = "";
        } else if (!this._ddnsMethod.equals(methName)) {
            this._ddnsMethod = methName;
            this.setModified();
        }
    }

    public void setDHCPTrackObjNo(int trackObjNo) {
        this._ipDHCPTrackObjNo = trackObjNo;
        this.setModified();
    }

    public void setDelay(int delay) {
        this._delay = delay;
    }

    public void setDesc(String desc) {
        if (!this._desc.equals(desc)) {
            this._desc = desc == null ? "" : desc;
            this.setModified();
        }
    }

    public boolean setDhcpRelayAddr(IPAddress relayIp) {
        if (relayIp != null) {
            if (this._helperAddress == null) {
                this._helperAddress = new Vector();
            }
            if (!this._helperAddress.contains(relayIp)) {
                this._helperAddress.addElement(relayIp);
                this.setModified();
                return true;
            }
            return false;
        }
        this._helperAddress = null;
        return true;
    }

    public boolean setEzVPN(String ezVPN, int dir) {
        if (!this.isSupported(3) || dir != 1 && dir != 2 && dir != 0) {
            return false;
        }
        if (!this._ezVPNName.equals(ezVPN) || this._ezVPNDir != dir) {
            if (ezVPN == null || ezVPN.length() == 0) {
                this._ezVPNName = "";
                this._ezVPNDir = 0;
            } else {
                this._ezVPNName = ezVPN;
            }
            this._ezVPNDir = dir;
            this.setModified();
        }
        return true;
    }

    public void setFWDir(int dir) {
        if (dir != 0 && dir != 1 && dir != 2 && dir != 3) {
            return;
        }
        this._desc = Description.removeFlag(this._desc, SDM_FW_OUTSIDE);
        this._desc = Description.removeFlag(this._desc, SDM_FW_INSIDE);
        this._desc = Description.removeFlag(this._desc, SDM_FW_DMZ);
        if (dir == 1) {
            this._desc = Description.addFlag(this._desc, SDM_FW_OUTSIDE);
        } else if (dir == 2) {
            this._desc = Description.addFlag(this._desc, SDM_FW_INSIDE);
        } else if (dir == 3) {
            this._desc = Description.addFlag(this._desc, SDM_FW_DMZ);
        }
        this.setModified();
    }

    public void setFlowIn(boolean state) {
        this._flowIn = state;
        this.setModified();
    }

    public void setFlowOut(boolean state) {
        this._flowOut = state;
        this.setModified();
    }

    public void setHoldPeriodTimeout(int nHoldPeriod) {
        this.m_nHoldPeriod = nHoldPeriod;
        this.setModified();
    }

    public void setIDSMonitoring(boolean flag) {
        if (flag != this._IDSMonitoring) {
            this._IDSMonitoring = flag;
            this.setModified();
        }
    }

    public boolean setInspectIn(String in) {
        if (this.isSupported(4)) {
            this._ipInspectInModified = true;
            this._ipInspectIn = in == null ? "" : in;
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setInspectOut(String out) {
        if (this.isSupported(4)) {
            this._ipInspectOutModified = true;
            this._ipInspectOut = out == null ? "" : out;
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setIpAccessGroupIn(String agIn) {
        if (this.isSupported(0) && !this._ipAccessGroupIn.equals(agIn)) {
            String old = this._ipAccessGroupIn;
            this._ipAccessGroupIn = agIn == null ? "" : agIn;
            this.setACLCategory(this._ipAccessGroupIn, old);
            this.setModified();
        }
        return this.isSupported(0);
    }

    public boolean setIpAccessGroupOut(String agOut) {
        if (this.isSupported(0) && !this._ipAccessGroupOut.equals(agOut)) {
            String old = this._ipAccessGroupOut;
            this._ipAccessGroupOut = agOut == null ? "" : agOut;
            this.setACLCategory(this._ipAccessGroupOut, old);
            this.setModified();
        }
        return this.isSupported(0);
    }

    public void setIpAddr(IfIPAddress addr) {
        this._ipAddr = addr;
        if (this._ipAddr != null) {
            this._ipAddr.setParent(this);
        }
        this.setModified();
    }

    public void setIpDirectedBCast(boolean enable) {
        if (this._ipDirectedBCast != enable) {
            this._ipDirectedBCast = enable;
            this._ipDirectedBCastAcl = "";
            this.setModified();
        }
    }

    public void setIpDirectedBCastAcl(String acl) {
        if (!this._ipDirectedBCastAcl.equals(acl)) {
            this._ipDirectedBCastAcl = acl == null ? "" : acl;
            this.setModified();
        }
    }

    public void setIpMaskReply(boolean ipMaskReply) {
        if (this._ipMaskReply != ipMaskReply) {
            this._ipMaskReply = ipMaskReply;
            this.setModified();
        }
    }

    public void setIpProxyArp(boolean enable) {
        if (this._ipProxyArp != enable) {
            this._ipProxyArp = enable;
            this.setModified();
        }
    }

    public void setIpRedirects(boolean ipRedirects) {
        if (this._ipRedirects != ipRedirects) {
            this._ipRedirects = ipRedirects;
            this.setModified();
        }
    }

    public void setIpRouteCache(boolean ipRouteCache) {
        if (this._ipRouteCache != ipRouteCache) {
            this._ipRouteCache = ipRouteCache;
            this.setModified();
        }
    }

    public void setIpRouteCacheCef(boolean ipRouteCacheCef) {
        if (this._ipRouteCacheCef != ipRouteCacheCef) {
            this._ipRouteCacheCef = ipRouteCacheCef;
            this.setModified();
        }
    }

    public void setIpRouteCacheFlow(boolean ipRouteCacheFlow) {
        if (this._ipRouteCacheFlow != ipRouteCacheFlow) {
            this._ipRouteCacheFlow = ipRouteCacheFlow;
            this.setModified();
        }
    }

    public void setIpUnicastRPF(boolean enable, String acl) {
        DeviceBase dev;
        if (enable && !(dev = (DeviceBase)this.getDevice()).getSystemProp().isIpCEF()) {
            return;
        }
        if (enable != this._ipUnicastRPF || !this._ipUnicastRPFAcl.equals(acl)) {
            this._ipUnicastRPF = enable;
            this._ipUnicastRPFAcl = acl == null ? "" : acl;
            this.setModified();
        }
    }

    public void setIpUnreachables(boolean ipUnreachables) {
        if (this._ipUnreachables != ipUnreachables) {
            this._ipUnreachables = ipUnreachables;
            this.setModified();
        }
    }

    public boolean setIpsIn(String in) {
        if (this.isSupported(18) && !this._ipIpsIn.equals(in)) {
            this._ipIpsIn = in == null ? "" : in;
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setIpsOut(String out) {
        if (this.isSupported(18) && !this._ipIpsOut.equals(out)) {
            this._ipIpsOut = out == null ? "" : out;
            this.setModified();
            return true;
        }
        return false;
    }

    public void setMop(boolean mop) {
        if (this._mop != mop) {
            this._mop = mop;
            this.setModified();
        }
    }

    public void setMtu(int mtu) {
        this._mtu = mtu;
        this.setModified();
    }

    public void setNBAR(boolean state) {
        this._nbarEnabled = state;
        this.setModified();
    }

    public void setNHRPAuth(String auth) {
        this._nhrpAuth = auth;
        this.setModified();
    }

    public void setNHRPHoldTime(int time) {
        this._nhrpHoldTime = time;
        this.setModified();
    }

    public void setNHRPID(long id) {
        this._nhrpID = id;
        this.setModified();
    }

    public void setNHRPRegNoQ(boolean bRegQ) {
        this._nhrpRegNoQ = bRegQ;
    }

    public void setNHRPSvrOnly(boolean bSvrOnly) {
        this._nhrpSvrOnly = bSvrOnly;
    }

    public boolean setNat(int nat) {
        if (!this.isSupported(1) || nat != 0 && nat != 1 && nat != 2) {
            return false;
        }
        if (nat != this._nat) {
            this._nat = nat;
            this.setModified();
        }
        return true;
    }

    public boolean setNatForLoopback(int nat) {
        if (nat != 0 && nat != 1 && nat != 2) {
            return false;
        }
        if (nat != this._nat) {
            this._nat = nat;
            this.setModified();
        }
        return true;
    }

    public void setOspfDead(int dead) {
        this._ospfDeadInt = dead;
        this.setModified();
    }

    public void setOspfHello(int hello) {
        this._ospfHelloInt = hello;
        this.setModified();
    }

    public void setOutsideEzVPNRemote(String ezvpnOut) {
        if (ezvpnOut == null) {
            return;
        }
        this._ipEzVPNOut = ezvpnOut;
        this.setModified();
    }

    public void setPureDesc(String desc) {
        Vector flags = this.getFlags();
        Vector<String> existings = new Vector<String>();
        Enumeration e = flags.elements();
        while (e.hasMoreElements()) {
            String flag = (String)e.nextElement();
            String fullFlag = Description.getFlagContent(this._desc, flag);
            if (fullFlag == null || fullFlag.length() <= 0) continue;
            existings.addElement(fullFlag);
        }
        String cur = this.getPureDesc();
        if (!cur.equals(desc)) {
            this._desc = desc;
            Enumeration e2 = existings.elements();
            while (e2.hasMoreElements()) {
                String flag = (String)e2.nextElement();
                this._desc = Description.addFlag(this._desc, flag);
            }
            this.setModified();
        }
    }

    public void setRIPRcvVersion(int nRipRcv) {
        this._ripRcvVersion = nRipRcv;
    }

    public void setReset(boolean flag) {
        this._reset = flag;
    }

    public void setResetbyGUI(boolean flag) {
        this._guiReset = flag;
    }

    public void setRetransmitTimeout(int nRetransmit) {
        this.m_nRetransmit = nRetransmit;
        this.setModified();
    }

    public void setRevalidateTimeout(int nRevalidate) {
        this.m_nRevalidate = nRevalidate;
        this.setModified();
    }

    public void setServicePolicyIN(String policyName) {
        this._servicePolicyIN = policyName == null ? "" : policyName;
        this.setModified();
    }

    public void setServicePolicyOUT(String policyName) {
        this._servicePolicyOUT = policyName == null ? "" : policyName;
        this.setModified();
    }

    public void setStatusQueryTimeout(int nStatusQuery) {
        this.m_nStatusQuery = nStatusQuery;
        this.setModified();
    }

    public void setSupport(int attr, int flag) {
        if (attr < 0 || attr > 25 || flag != -1 && flag != 0 && flag != 1) {
            return;
        }
        this._isSupported[attr] = flag;
    }

    public void setTcpSize(int tcpsize) {
        this._tcpsize = tcpsize;
        this.setModified();
    }

    public void setVirtualReassembly(boolean enable) {
        if (this._virtualReassembly != enable) {
            this._virtualReassembly = enable;
            this.setModified();
        }
    }

    public void setospfNetworkType(String type) {
        this._ospfNetworkType = type;
        this.setModified();
    }

    public void setospfPriority(int priority) {
        this._ospfPriority = priority;
        this.setModified();
    }

    public void setripSplitHorizon(boolean sh) {
        this._ripSplitHorizon = sh;
        this.setModified();
    }

    public void shutdown(boolean flag) {
        if (this._shutdown != flag) {
            this._shutdown = flag;
            this.setModified();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this._ifID != null) {
            sb.append("\t_ifID: " + this._ifID.toString());
        }
        if (this._ipAddr != null) {
            sb.append("\t_ipAddr: " + this._ipAddr.toString());
        }
        sb.append("\t_shutdown: " + this._shutdown);
        sb.append("\t_desc: " + this._desc);
        sb.append("\t_zone: " + this._zoneName);
        sb.append("\t_cdp: " + this._cdp);
        sb.append("\t_ipProxyArp: " + this._ipProxyArp);
        sb.append("\t_ipDirectedBCast: " + this._ipDirectedBCast);
        sb.append("\t_ipDirectedBCastAcl: " + this._ipDirectedBCastAcl);
        sb.append("\t_ipAccessGroupIn: " + this._ipAccessGroupIn);
        sb.append("\t_ipAccessGroupOut: " + this._ipAccessGroupOut);
        sb.append("\t_crypto: " + this._crypto);
        sb.append("\t_nat: " + this._nat);
        sb.append("\t_ipEzVPNOut: " + this._ipEzVPNOut);
        int count = 0;
        while (count < this._ipEzVPNIn.size()) {
            sb.append("\t_ipEzVPNIn: " + this._ipEzVPNIn.elementAt(count));
            ++count;
        }
        sb.append("\t_ipInspectIn: " + this._ipInspectIn);
        sb.append("\t_ipInspectOut: " + this._ipInspectOut);
        sb.append("\t_ipIpsIn: " + this._ipIpsIn);
        sb.append("\t_ipIpsOut: " + this._ipIpsOut);
        sb.append("\t_ipUnicastRPF: " + this._ipUnicastRPF);
        sb.append("\t_ipUnicastRPFAcl: " + this._ipUnicastRPFAcl);
        sb.append("\t_ipRedirects: " + this._ipRedirects);
        sb.append("\t_ipUnreachables: " + this._ipUnreachables);
        sb.append("\t_ipMaskReply: " + this._ipMaskReply);
        sb.append("\t_ipRouteCacheFlow: " + this._ipRouteCacheFlow);
        sb.append("\t_ipRouteCacheCef: " + this._ipRouteCacheCef);
        sb.append("\t_mop: " + this._mop);
        sb.append("\t_mtu: " + this._mtu);
        sb.append("\t_servicePolicyIN: " + this._servicePolicyIN);
        sb.append("\t_servicePolicyOUT: " + this._servicePolicyOUT);
        sb.append("\t_admission: " + this._admission);
        if (this._helperAddress != null) {
            int i = 0;
            while (i < this._helperAddress.size()) {
                sb.append("\t_helperAddress: " + ((IPAddress)this._helperAddress.elementAt(i)).toString());
                ++i;
            }
        }
        return sb.toString();
    }

    private class FeatureCLIMap {
        int _cli;
        String _phrase;

        FeatureCLIMap(int cli, String phrase) {
            this._cli = cli;
            this._phrase = phrase;
        }
    }
}

