/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.nat;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.MiscUtils;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ACLCollection;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.common.WANHelperBase;
import com.cisco.xdm.data.interfaces.Async;
import com.cisco.xdm.data.interfaces.BRI;
import com.cisco.xdm.data.interfaces.Dialer;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.nat.NatDynamicRule;
import com.cisco.xdm.data.nat.NatException;
import com.cisco.xdm.data.nat.NatPool;
import com.cisco.xdm.data.nat.NatPoolCollection;
import com.cisco.xdm.data.nat.NatRule;
import com.cisco.xdm.data.nat.NatStaticRule;
import com.cisco.xdm.data.nat.RouteMap;
import com.cisco.xdm.data.nat.RouteMapCollection;
import com.cisco.xdm.data.nat.RouteMapEntry;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Nat
extends XDMObject {
    public static final String XDM_NAT_DNS_TIMEOUT = "dns-timeout";
    public static final String XDM_NAT_ICMP_TIMEOUT = "icmp-timeout";
    public static final String XDM_NAT_PPTP_TIMEOUT = "pptp-timeout";
    public static final String XDM_NAT_TIMEOUT = "timeout";
    public static final String XDM_NAT_UDP_TIMEOUT = "udp-timeout";
    public static final String XDM_NAT_TCP_TIMEOUT = "tcp-timeout";
    public static final String XDM_NAT_MAX_ENTRIES = "max-entries";
    public static final int ROUTE_MAP = 1;
    public static final int ACL = 2;
    private static final int NAT_ANY = -1;
    public static final int NAT_UNSUPPORTED_POOL_TYPE = 1;
    public static final int NAT_UNSUPPORTED_RULE_ESP = 16;
    public static final int NAT_UNSUPPORTED_RULE_DESTINATION = 32;
    public static final int NAT_UNSUPPORTED_RULE_STATIC_IF = 64;
    public static final int NAT_UNSUPPORTED_RULE_IF_LOOPBACK = 128;
    public static final int NAT_UNSUPPORTED_OPTION_NOALIAS = 256;
    public static final int NAT_UNSUPPORTED_OPTION_NOPAYLOAD = 512;
    public static final int NAT_UNSUPPORTED_OPTION_EXTENDABLE = 1024;
    public static final int NAT_UNSUPPORTED_OPTION_REDUNDANCY = 4096;
    public static final int NAT_UNSUPPORTED_OPTION_ADDROUTE = 8192;
    public static final int NAT_UNSUPPORTED_OPTION_VRF = 16384;
    public static final int XDM_NAT_TIMEOUT_NEVER = 0;
    public static final Integer XDM_NAT_TIMEOUT_NEVER_OBJ = new Integer(0);
    public static final int XDM_NAT_NO_MAX_ENTRIES = 0;
    public static final Integer XDM_NAT_NO_MAX_ENTRIES_OBJ = new Integer(0);
    private Log _theLog;
    private Vector _lstRules;
    private Hashtable _htParameters;
    private NatPoolCollection _collPools;
    private Hashtable _htDefaultValues;
    private Hashtable _htMaxValues;
    private Hashtable _htMinValues;

    public Nat() {
        this.init();
    }

    public Nat(XDMObject parent) {
        super(parent);
        this.init();
    }

    private void addACEsInRMapACLs(Vector aceList, RouteMap routeMap) {
        DeviceBase device = (DeviceBase)this.getDevice();
        ACLCollection aclCollection = device.getAcls();
        Enumeration e = routeMap.elements();
        while (e.hasMoreElements()) {
            RouteMapEntry rmapEntry = (RouteMapEntry)e.nextElement();
            if (!rmapEntry.getAction()) continue;
            Vector aclList = rmapEntry.getACLs();
            if (aclList == null) {
                return;
            }
            int count = 0;
            while (count < aclList.size()) {
                String aclName = (String)aclList.elementAt(count);
                ACL acl = (ACL)aclCollection.getACL(aclName);
                if (acl != null) {
                    if (acl.getACLType() == 0) {
                        rmapEntry.removeACL(aclName);
                        acl = this.convertToExtended(acl, aclCollection);
                        rmapEntry.addACL(acl.getNameOrNumber());
                        aclCollection.addACL(acl);
                        this.addNatRuleCategory(acl.getNameOrNumber());
                    }
                    ExtendedACE ace = null;
                    int counter = 0;
                    while (counter < aceList.size()) {
                        ace = (ExtendedACE)aceList.elementAt(counter);
                        if (!acl.isDuplicateACE(ace)) {
                            acl.addACE((ExtendedACE)ace.clone(), 0);
                        }
                        ++counter;
                    }
                }
                ++count;
            }
        }
    }

    public void addACEsToDynamicNATWithACL(Vector aces) {
        ACLCollection aclCollection = ((DeviceBase)this.getDevice()).getAcls();
        if (aces == null || aces.size() == 0) {
            return;
        }
        NatDynamicRule[] rules = this.getInsideMapRules(2);
        if (rules == null || rules.length == 0) {
            return;
        }
        int count = 0;
        while (count < rules.length) {
            ACL acl = null;
            ACLBase aclObj = aclCollection.getACL(rules[count].getACL());
            acl = aclObj.getACLType() == 0 ? this.convertToExtended((ACL)aclObj, aclCollection) : (ACL)aclObj;
            int i = 0;
            while (i < aces.size()) {
                acl.addACE((ACEInterface)aces.elementAt(i));
                ++i;
            }
            ++count;
        }
    }

    void addNatRuleCategory(String aclId) {
        ACLBase acl;
        if (aclId == null) {
            return;
        }
        DeviceBase d = (DeviceBase)this.getDevice();
        if (d != null && (acl = d.getAcls().getACL(aclId)) != null) {
            acl.addToCategory(2);
        }
    }

    public void addRule(NatRule rule) {
        this.setModified();
        this._lstRules.addElement(rule);
        rule.setParent(this);
        if (rule instanceof NatDynamicRule) {
            String aclId = ((NatDynamicRule)rule).getACL();
            this.addNatRuleCategory(aclId);
        }
    }

    private void clearNatTranslations(ConfigValues values) {
        int cmdPosition = -1;
        DeviceBase dev = (DeviceBase)this.getDevice();
        cmdPosition = dev.getFirstCmdPosition("ifs", values, true);
        CmdValues cmd = new CmdValues("do");
        cmd.addValue("command", "clear ip nat translation forced");
        if (cmdPosition == -1) {
            values.addCmdValues(cmd);
        } else {
            values.insertCmdValues(cmd, cmdPosition);
        }
    }

    public Object clone() {
        Nat dup = (Nat)super.clone();
        dup._lstRules = (Vector)this._lstRules.clone();
        int i = 0;
        while (i < dup._lstRules.size()) {
            NatRule rule = (NatRule)this._lstRules.elementAt(i);
            NatRule dupRule = (NatRule)rule.clone();
            dupRule.setParent(dup);
            dup._lstRules.setElementAt(dupRule, i);
            ++i;
        }
        dup._htParameters = (Hashtable)this._htParameters.clone();
        dup._htDefaultValues = (Hashtable)this._htDefaultValues.clone();
        dup._htMaxValues = (Hashtable)this._htMaxValues.clone();
        dup._htMinValues = (Hashtable)this._htMinValues.clone();
        dup._collPools = (NatPoolCollection)this._collPools.clone();
        dup._collPools.setParent(dup);
        return dup;
    }

    public void configureNatForBackup(XDMInterfaceBase xdmPrimIntf, XDMInterfaceBase xdmBackupIntf, NatDynamicRule natRulePrim) {
        if (natRulePrim == null || xdmPrimIntf == null || xdmBackupIntf == null) {
            return;
        }
        DeviceBase device = (DeviceBase)this.getDevice();
        String strBackupIntfName = "";
        NatDynamicRule natRuleBackup = null;
        Dialer dialerIntfPrim = null;
        dialerIntfPrim = (Dialer)xdmPrimIntf.getLogicalIf();
        if (dialerIntfPrim != null) {
            xdmPrimIntf = dialerIntfPrim;
        }
        Dialer dialerIntf = null;
        switch (xdmBackupIntf.getIfID().getType()) {
            case 505: {
                dialerIntf = ((BRI)xdmBackupIntf).getBackupLogicalIf();
                if (dialerIntf == null) break;
                xdmBackupIntf = dialerIntf;
                break;
            }
            case 1009: {
                dialerIntf = ((Async)xdmBackupIntf).getBackupLogicalIf();
                if (dialerIntf == null) break;
                xdmBackupIntf = dialerIntf;
                break;
            }
        }
        strBackupIntfName = xdmBackupIntf.getIfID().toString();
        String strACL = natRulePrim.getACL();
        this._theLog.info("\n configureNatForBackup strACL: " + strACL);
        if (strACL != null && strACL.length() > 0) {
            ACLCollection aclCollection = device.getAcls();
            ACL acl = (ACL)aclCollection.getACL(strACL);
            if (acl.getACLType() == 0) {
                acl = this.convertToExtended(acl, aclCollection);
                natRulePrim.setACL(acl.getNameOrNumber());
                this._theLog.info("\n configureNatForBackup Converted ACL: " + acl.getNameOrNumber());
                aclCollection.addACL(acl);
                this.addNatRuleCategory(acl.getNameOrNumber());
            }
            natRuleBackup = (NatDynamicRule)natRulePrim.clone();
            natRuleBackup.setInterface(strBackupIntfName, device);
            NatDynamicRule[] dynamicRule = new NatDynamicRule[]{natRulePrim, natRuleBackup};
            this.convertACLtoRMapForBackup(dynamicRule);
            xdmBackupIntf.setNat(2);
            return;
        }
        String strRMap = natRulePrim.getRouteMap();
        RouteMap routeMapBackup = null;
        RouteMap routeMapPrim = null;
        RouteMapEntry rmapEntryPrim = null;
        RouteMapEntry rmapEntryBackup = null;
        this._theLog.info("\n configureNatForBackup strRMap: " + strRMap);
        if (strRMap != null && strRMap.length() > 0) {
            RouteMapCollection rmaps = device.getRouteMaps();
            routeMapPrim = (RouteMap)rmaps.get(strRMap);
            if (routeMapPrim == null) {
                return;
            }
            Enumeration enumRMapEntry = routeMapPrim.elements();
            if (enumRMapEntry.hasMoreElements()) {
                rmapEntryPrim = (RouteMapEntry)enumRMapEntry.nextElement();
            }
            if (rmapEntryPrim == null) {
                return;
            }
            routeMapBackup = new RouteMap(rmaps.generateRouteMapName());
            rmaps.addRouteMap(routeMapBackup);
            rmapEntryBackup = new RouteMapEntry(routeMapBackup.getName(), routeMapBackup.getNextSequenceNumber());
            Vector aclList = rmapEntryPrim.getACLs();
            if (aclList == null) {
                return;
            }
            int count = 0;
            while (count < aclList.size()) {
                String aclName = (String)aclList.elementAt(count);
                rmapEntryBackup.addACL(aclName);
                ++count;
            }
            rmapEntryBackup.addInterface(strBackupIntfName);
            routeMapBackup.addRouteMapEntry(rmapEntryBackup);
            natRuleBackup = (NatDynamicRule)natRulePrim.clone();
            natRuleBackup.setInterface(strBackupIntfName, device);
            natRuleBackup.setRouteMap(routeMapBackup.getName());
            this.addRule(natRuleBackup);
            xdmBackupIntf.setNat(2);
        }
    }

    private void configureRMap(Vector aceList, RouteMap routeMap, String natACL, String ifName, String poolName) {
        if (routeMap.size() > 0) {
            this.addACEsInRMapACLs(aceList, routeMap);
        } else if (natACL != null) {
            this.createRouteMapEntry(aceList, routeMap, natACL, ifName, poolName);
        }
    }

    public void configureRouteMap(Vector aceList, String natACL, String ifName, String poolName) {
        NatDynamicRule[] routeMapRules = this.getInsideMapRules(1);
        NatDynamicRule rmapRule = null;
        DeviceBase device = (DeviceBase)this.getDevice();
        RouteMapCollection rmaps = device.getRouteMaps();
        RouteMap routeMap = null;
        if (routeMapRules == null) {
            routeMap = new RouteMap(rmaps.generateRouteMapName());
            rmaps.addRouteMap(routeMap);
            this.configureRMap(aceList, routeMap, natACL, ifName, poolName);
        } else {
            if (natACL != null) {
                routeMap = new RouteMap(rmaps.generateRouteMapName());
                rmaps.addRouteMap(routeMap);
                this.configureRMap(aceList, routeMap, natACL, ifName, poolName);
            }
            int count = 0;
            while (count < routeMapRules.length) {
                rmapRule = routeMapRules[count];
                routeMap = (RouteMap)rmaps.get(rmapRule.getRouteMap());
                if (routeMap == null) {
                    routeMap = new RouteMap(rmaps.generateRouteMapName());
                }
                this.configureRMap(aceList, routeMap, null, null, null);
                ++count;
            }
        }
    }

    public void configureRouteMapForStaticNAT(NatStaticRule rule, ACL acl) {
        if (rule == null || acl == null) {
            return;
        }
        DeviceBase device = (DeviceBase)this.getDevice();
        RouteMapCollection rmaps = device.getRouteMaps();
        RouteMap routeMap = null;
        Enumeration e = acl.getACEs();
        Vector aceList = new Vector();
        while (e.hasMoreElements()) {
            aceList.addElement(e.nextElement());
        }
        if (rule.getRouteMap() == null) {
            routeMap = this.createRouteMapWithEntry(rmaps.generateRouteMapName());
            rule.setRouteMap(routeMap.getName());
        } else {
            routeMap = (RouteMap)rmaps.get(rule.getRouteMap());
            if (routeMap == null) {
                routeMap = this.createRouteMapWithEntry(rule.getRouteMap());
            }
        }
        this.configureRMap(aceList, routeMap, null, null, null);
    }

    public void convertACLtoRMap(NatDynamicRule[] aclRules) {
        if (aclRules == null) {
            return;
        }
        NatDynamicRule aclRule = null;
        DeviceBase device = (DeviceBase)this.getDevice();
        ACLCollection aclCollection = device.getAcls();
        RouteMapCollection rmaps = device.getRouteMaps();
        int count = 0;
        while (count < aclRules.length) {
            aclRule = aclRules[count];
            RouteMap routeMap = new RouteMap(rmaps.generateRouteMapName());
            RouteMapEntry rmapEntry = new RouteMapEntry(routeMap.getName(), routeMap.getNextSequenceNumber());
            rmapEntry.registerWithACL(device);
            ACL acl = null;
            if (aclRule.getACL() != null) {
                acl = (ACL)aclCollection.getACL(aclRule.getACL());
                if (acl.getACLType() == 0) {
                    acl = this.convertToExtended(acl, aclCollection);
                    rmapEntry.addACL(acl.getNameOrNumber());
                    aclCollection.addACL(acl);
                    this.addNatRuleCategory(acl.getNameOrNumber());
                } else {
                    rmapEntry.addACL(aclRule.getACL());
                }
            }
            routeMap.addRouteMapEntry(rmapEntry);
            NatDynamicRule rmapRule = new NatDynamicRule();
            rmapRule.setApplication(1);
            rmapRule.setRouteMap(routeMap.getName());
            if (aclRule.getInterface(device) != null) {
                rmapRule.setInterface(aclRule.getInterface(device), device);
                rmapRule.setOverload(true);
            }
            if (aclRule.getPool() != null) {
                rmapRule.setPool(aclRule.getPool());
                NatPool pool = (NatPool)this.getPools().get(aclRule.getPool());
                if (pool != null) {
                    if (pool.isPAT()) {
                        rmapRule.setOverload(true);
                    } else {
                        rmapRule.setOverload(false);
                    }
                }
            }
            rmapRule.setRouteMap(routeMap.getName());
            rmaps.addRouteMap(routeMap);
            this.addRule(rmapRule);
            this.removeRule(aclRule);
            ++count;
        }
    }

    public void convertACLtoRMapForBackup(NatDynamicRule[] aclRules) {
        if (aclRules == null) {
            return;
        }
        NatDynamicRule aclRule = null;
        DeviceBase device = (DeviceBase)this.getDevice();
        ACLCollection aclCollection = device.getAcls();
        RouteMapCollection rmaps = device.getRouteMaps();
        int count = 0;
        while (count < aclRules.length) {
            String strIntf;
            aclRule = aclRules[count];
            RouteMap routeMap = new RouteMap(rmaps.generateRouteMapName());
            RouteMapEntry rmapEntry = new RouteMapEntry(routeMap.getName(), routeMap.getNextSequenceNumber());
            rmapEntry.registerWithACL(device);
            ACL acl = null;
            if (aclRule.getACL() != null) {
                acl = (ACL)aclCollection.getACL(aclRule.getACL());
                if (acl.getACLType() == 0) {
                    acl = this.convertToExtended(acl, aclCollection);
                    rmapEntry.addACL(acl.getNameOrNumber());
                    aclCollection.addACL(acl);
                    this.addNatRuleCategory(acl.getNameOrNumber());
                } else {
                    rmapEntry.addACL(aclRule.getACL());
                }
            }
            if ((strIntf = aclRule.getBaseInterface()) != null && strIntf.length() > 0) {
                rmapEntry.addInterface(strIntf);
            }
            routeMap.addRouteMapEntry(rmapEntry);
            NatDynamicRule rmapRule = new NatDynamicRule();
            rmapRule.setApplication(1);
            rmapRule.setRouteMap(routeMap.getName());
            if (aclRule.getInterface(device) != null) {
                rmapRule.setInterface(aclRule.getInterface(device), device);
                rmapRule.setOverload(true);
            }
            if (aclRule.getPool() != null) {
                rmapRule.setPool(aclRule.getPool());
                NatPool pool = (NatPool)this.getPools().get(aclRule.getPool());
                if (pool != null) {
                    if (pool.isPAT()) {
                        rmapRule.setOverload(true);
                    } else {
                        rmapRule.setOverload(false);
                    }
                }
            }
            rmapRule.setRouteMap(routeMap.getName());
            rmaps.addRouteMap(routeMap);
            this.addRule(rmapRule);
            this.removeRule(aclRule);
            ++count;
        }
    }

    public ACL convertToExtended(ACL standardAcl, ACLCollection aclCollection) {
        if (standardAcl.getACLType() == 1) {
            return standardAcl;
        }
        ACL extendedACL = new ACL(1);
        int aclNumber = aclCollection.getNextAvalableExtendedACLNumber();
        extendedACL.setNameOrNumber(Integer.toString(aclNumber));
        Enumeration aceEnum = standardAcl.getACEs();
        Object aceObject = null;
        ExtendedACE ace = null;
        while (aceEnum.hasMoreElements()) {
            aceObject = aceEnum.nextElement();
            ace = new ExtendedACE();
            ace.copy(aceObject);
            extendedACL.addACE((ExtendedACE)ace.clone(), 0);
        }
        return extendedACL;
    }

    private CmdValues createCmdValues(int actionType, String key, Integer value) {
        CmdValues cmd = new CmdValues("ip");
        cmd.addValue("nat", "nat");
        cmd.addValue("translation", "translation");
        cmd.setAction(actionType);
        if (key.equals(XDM_NAT_MAX_ENTRIES)) {
            cmd.addValue(XDM_NAT_MAX_ENTRIES, XDM_NAT_MAX_ENTRIES);
            if (value == 0) {
                cmd.setAction(2);
            } else {
                cmd.addValue("max-entries-num", value.toString());
            }
        } else {
            cmd.addValue(key, key);
            if (value.equals(XDM_NAT_TIMEOUT_NEVER_OBJ)) {
                cmd.addValue("never", "never");
            } else {
                cmd.addValue(String.valueOf(key) + "-seconds", value.toString());
            }
        }
        return cmd;
    }

    private CmdValues createCmdValues(int actionType, String key, Integer value, Integer oldValue) {
        CmdValues cmd = this.createCmdValues(actionType, key, value);
        if (key.equals(XDM_NAT_MAX_ENTRIES)) {
            cmd.addOldValue(XDM_NAT_MAX_ENTRIES, XDM_NAT_MAX_ENTRIES);
            cmd.addOldValue("max-entries-num", oldValue.toString());
        } else {
            cmd.addOldValue(key, key);
            if (oldValue.equals(XDM_NAT_TIMEOUT_NEVER_OBJ)) {
                cmd.addOldValue("never", "never");
            } else {
                cmd.addOldValue(String.valueOf(key) + "-seconds", oldValue.toString());
            }
        }
        return cmd;
    }

    private void createRouteMapEntry(Vector aceList, RouteMap routeMap, String natAclName, String ifName, String poolName) {
        if (natAclName == null) {
            return;
        }
        RouteMapEntry rmapEntry = new RouteMapEntry(routeMap.getName(), routeMap.getNextSequenceNumber());
        DeviceBase device = (DeviceBase)this.getDevice();
        ACLCollection aclCollection = device.getAcls();
        ACL natACL = (ACL)aclCollection.get(natAclName);
        if (natACL == null) {
            return;
        }
        if (aceList == null) {
            return;
        }
        if (natACL.getACLType() == 0) {
            return;
        }
        ExtendedACE ace = null;
        int count = 0;
        while (count < aceList.size()) {
            ace = (ExtendedACE)aceList.elementAt(count);
            natACL.addACE((ExtendedACE)ace.clone(), 0);
            ++count;
        }
        rmapEntry.addACL(natACL.getNameOrNumber());
        rmapEntry.registerWithACL((DeviceBase)this.getDevice());
        routeMap.addRouteMapEntry(rmapEntry);
        NatDynamicRule rule = new NatDynamicRule();
        rule.setApplication(1);
        rule.setRouteMap(routeMap.getName());
        if (ifName != null) {
            rule.setInterface(ifName, device);
            rule.setOverload(true);
        }
        if (poolName != null) {
            rule.setPool(poolName);
            NatPool pool = (NatPool)this.getPools().get(poolName);
            if (pool != null) {
                if (pool.isPAT()) {
                    rule.setOverload(true);
                } else {
                    rule.setOverload(false);
                }
            }
        }
        rule.setRouteMap(routeMap.getName());
        this.addRule(rule);
    }

    private RouteMap createRouteMapWithEntry(String name) {
        DeviceBase device = (DeviceBase)this.getDevice();
        RouteMapCollection rmaps = device.getRouteMaps();
        ACLCollection acls = device.getAcls();
        ACL rMapACL = new ACL(1);
        rMapACL.setNameOrNumber(Integer.toString(acls.getNextAvalableExtendedACLNumber()));
        acls.addACL(rMapACL);
        RouteMap routeMap = new RouteMap(name);
        RouteMapEntry rmapEntry = new RouteMapEntry(routeMap.getName(), routeMap.getNextSequenceNumber());
        rmapEntry.addACL(rMapACL.getNameOrNumber());
        rmapEntry.registerWithACL(device);
        routeMap.addRouteMapEntry(rmapEntry);
        rmaps.addRouteMap(routeMap);
        return routeMap;
    }

    private void disableNatInterfaces(ConfigValues values) {
        String[] inifs = this.getInsideInterfaces();
        XDMInterfaces xifs = ((DeviceBase)this.getDevice()).getIfs();
        int i = 0;
        while (i < inifs.length) {
            XDMInterfaceBase xif = xifs.getIfFromCompositeLabel(inifs[i]);
            CmdValues cmd = xif.generateInterfaceCmd();
            CmdValues subcmd = new CmdValues("ip");
            subcmd.setAction(2);
            subcmd.addValue("nat", "nat");
            subcmd.addValue("dir", "inside");
            ConfigValues subvals = new ConfigValues();
            subvals.addCmdValues(subcmd);
            cmd.setModeCmdsValues(subvals);
            values.addCmdValues(cmd);
            ++i;
        }
        String[] outifs = this.getOutsideInterfaces();
        int j = 0;
        while (j < outifs.length) {
            XDMInterfaceBase xif = xifs.getIfFromCompositeLabel(outifs[j]);
            CmdValues cmd = xif.generateInterfaceCmd();
            CmdValues subcmd = new CmdValues("ip");
            subcmd.setAction(2);
            subcmd.addValue("nat", "nat");
            subcmd.addValue("dir", "outside");
            ConfigValues subvals = new ConfigValues();
            subvals.addCmdValues(subcmd);
            cmd.setModeCmdsValues(subvals);
            values.addCmdValues(cmd);
            ++j;
        }
    }

    private void enableNatInterfaces(ConfigValues values) {
        String[] inifs = this.getInsideInterfaces();
        XDMInterfaces xifs = ((DeviceBase)this.getDevice()).getIfs();
        int i = 0;
        while (i < inifs.length) {
            XDMInterfaceBase xif = xifs.getIfFromCompositeLabel(inifs[i]);
            CmdValues cmd = xif.generateInterfaceCmd();
            CmdValues subcmd = new CmdValues("ip");
            subcmd.addValue("nat", "nat");
            subcmd.addValue("dir", "inside");
            ConfigValues subvals = new ConfigValues();
            subvals.addCmdValues(subcmd);
            cmd.setModeCmdsValues(subvals);
            values.addCmdValues(cmd);
            ++i;
        }
        String[] outifs = this.getOutsideInterfaces();
        int i2 = 0;
        while (i2 < outifs.length) {
            XDMInterfaceBase xif = xifs.getIfFromCompositeLabel(outifs[i2]);
            CmdValues cmd = xif.generateInterfaceCmd();
            CmdValues subcmd = new CmdValues("ip");
            subcmd.addValue("nat", "nat");
            subcmd.addValue("dir", "outside");
            ConfigValues subvals = new ConfigValues();
            subvals.addCmdValues(subcmd);
            cmd.setModeCmdsValues(subvals);
            values.addCmdValues(cmd);
            ++i2;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Nat)) {
            return false;
        }
        Nat nat = (Nat)o;
        return super.equals(nat) && MiscUtils.vectorEquals(this._lstRules, nat._lstRules) && MiscUtils.hashtableEquals(this._htParameters, nat._htParameters) && this._collPools.equals(nat._collPools);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        Nat oldNat = (Nat)backup;
        if (!MiscUtils.hashtableEquals(this._htParameters, oldNat._htParameters)) {
            CmdValues cmd;
            Integer val;
            String key;
            Enumeration items = oldNat._htParameters.keys();
            while (items.hasMoreElements()) {
                key = (String)items.nextElement();
                cmd = this.generateParmCommand(key, val = (Integer)this._htParameters.get(key), (Integer)oldNat._htParameters.get(key));
                if (cmd == null) continue;
                values.addCmdValues(cmd);
            }
            items = this._htParameters.keys();
            while (items.hasMoreElements()) {
                key = (String)items.nextElement();
                val = (Integer)this._htParameters.get(key);
                if (oldNat._htParameters.get(key) != null || (cmd = this.generateParmCommand(key, val, null)) == null) continue;
                values.addCmdValues(cmd);
            }
        }
        if (!MiscUtils.vectorEquals(this._lstRules, oldNat._lstRules)) {
            int nRules = 0;
            Hashtable<String, NatRule> newRules = new Hashtable<String, NatRule>();
            int i = 0;
            while (i < this._lstRules.size()) {
                NatRule rule = (NatRule)this._lstRules.elementAt(i);
                newRules.put(rule.toString(), rule);
                ++i;
            }
            int i2 = 0;
            while (i2 < oldNat._lstRules.size()) {
                NatRule oldRule = (NatRule)oldNat._lstRules.elementAt(i2);
                String key = oldRule.toString();
                NatRule newRule = (NatRule)newRules.get(key);
                if (newRule == null) {
                    if (nRules == 0) {
                        this.disableNatInterfaces(values);
                        this.clearNatTranslations(values);
                    }
                    ++nRules;
                    oldRule.generateDelta(null, values);
                }
                ++i2;
            }
            Hashtable<String, NatRule> oldRules = new Hashtable<String, NatRule>();
            int i3 = 0;
            while (i3 < oldNat._lstRules.size()) {
                NatRule rule = (NatRule)oldNat._lstRules.elementAt(i3);
                oldRules.put(rule.toString(), rule);
                ++i3;
            }
            int i4 = 0;
            while (i4 < this._lstRules.size()) {
                NatRule rule = (NatRule)this._lstRules.elementAt(i4);
                String key = rule.toString();
                NatRule oldRule = (NatRule)oldRules.get(key);
                if (oldRule == null) {
                    rule.generateDelta(null, values);
                }
                ++i4;
            }
            if (nRules > 0) {
                this.enableNatInterfaces(values);
            }
        }
        this._collPools.generateDelta(oldNat._collPools, values);
    }

    private CmdValues generateParmCommand(String key, Integer newValue, Integer oldValue) {
        CmdValues cmd = null;
        Integer defaultValue = (Integer)this._htDefaultValues.get(key);
        if (key.equals(XDM_NAT_MAX_ENTRIES) && newValue == 0) {
            newValue = null;
        }
        if (newValue == null && oldValue == null) {
            return null;
        }
        if (newValue == null) {
            cmd = this.createCmdValues(2, key, oldValue);
        } else if (oldValue == null) {
            if (!newValue.equals(defaultValue)) {
                cmd = this.createCmdValues(1, key, newValue);
            }
        } else if (!newValue.equals(oldValue)) {
            cmd = this.createCmdValues(3, key, newValue, oldValue);
        }
        return cmd;
    }

    public String[] getACLNames() {
        Vector<String> ipStrs = new Vector<String>();
        ACLCollection acls = ((DeviceBase)this.getDevice()).getAcls();
        Enumeration aclnames = acls.keys();
        while (aclnames.hasMoreElements()) {
            String acl = (String)aclnames.nextElement();
            ipStrs.addElement(acl);
        }
        Object[] names = new String[ipStrs.size()];
        ipStrs.copyInto(names);
        return names;
    }

    public String[] getAllInterfaces() {
        return this.getInterfaces(-1);
    }

    public int getDefaultParameter(String strParameter) throws NatException {
        if (strParameter == null) {
            throw new NullPointerException();
        }
        Integer i = (Integer)this._htDefaultValues.get(strParameter);
        if (i == null) {
            throw new NatException(1000);
        }
        return i;
    }

    public Vector getDynamicNatRulesForInterface(String iface) {
        Vector<NatRule> rules = new Vector<NatRule>();
        if (this._lstRules != null) {
            int i = 0;
            while (i < this._lstRules.size()) {
                String outIface;
                NatRule rule = (NatRule)this._lstRules.elementAt(i);
                if (rule instanceof NatDynamicRule && (outIface = ((NatDynamicRule)rule).getInterface((DeviceBase)this.getDevice())) != null && outIface.equals(iface)) {
                    rules.addElement(rule);
                }
                ++i;
            }
        }
        return rules;
    }

    public String[] getInsideInterfaces() {
        return this.getInterfaces(1);
    }

    public NatDynamicRule[] getInsideMapRules(int ruleType) {
        Vector<NatDynamicRule> rmapRules = new Vector<NatDynamicRule>();
        NatRule[] ruleArray = this.getRules();
        NatRule rule = null;
        NatDynamicRule dynamicRule = null;
        int count = 0;
        while (count < ruleArray.length) {
            rule = ruleArray[count];
            if (rule instanceof NatDynamicRule && (dynamicRule = (NatDynamicRule)rule).getApplication() == 1) {
                if (ruleType == 1 && dynamicRule.getRouteMap() != null) {
                    rmapRules.addElement(dynamicRule);
                }
                if (ruleType == 2 && dynamicRule.getACL() != null && !dynamicRule.isReadOnly()) {
                    rmapRules.addElement(dynamicRule);
                }
            }
            ++count;
        }
        if (rmapRules.size() == 0) {
            return null;
        }
        Object[] retVal = new NatDynamicRule[rmapRules.size()];
        rmapRules.copyInto(retVal);
        return retVal;
    }

    private String[] getInterfaces(int natValue) {
        boolean bAll = natValue == -1;
        XDMInterfaces xifs = ((DeviceBase)this.getDevice()).getIfs();
        Vector v_ifs = xifs.getFeatureSupportedIfStrings(1);
        Vector<String> theIfs = new Vector<String>();
        Enumeration e = v_ifs.elements();
        while (e.hasMoreElements()) {
            String ifStr = (String)e.nextElement();
            XDMInterfaceBase xif = xifs.getIfFromCompositeLabel(ifStr);
            int natSetting = xif.getNat();
            if (!bAll && natSetting != natValue) continue;
            theIfs.addElement(ifStr);
        }
        Object[] ifNames = new String[theIfs.size()];
        theIfs.copyInto(ifNames);
        return ifNames;
    }

    public NatStaticRule getMappedInside(NatStaticRule newRule) {
        if (newRule == null) {
            return null;
        }
        NatRule[] rules = this.getRules();
        int i = 0;
        while (i < rules.length) {
            String existing_ifname;
            String new_ifname;
            IPAddress existing_ipGlobal;
            IPAddress new_ipGlobal;
            int new_portGlobal;
            int existing_portGlobal;
            NatRule rule = rules[i];
            if (rule != null && rule instanceof NatStaticRule && rule.getApplication() == 1 && newRule.getPortType() == ((NatStaticRule)rule).getPortType() && (existing_portGlobal = ((NatStaticRule)rule).getPortGlobal()) == (new_portGlobal = newRule.getPortGlobal()) && ((new_ipGlobal = newRule.getIPGlobal()) != null ? (existing_ipGlobal = ((NatStaticRule)rule).getIPGlobal()) != null && existing_ipGlobal.equals(new_ipGlobal) : (new_ifname = newRule.getIfNameGlobal()) != null && (existing_ifname = ((NatStaticRule)rule).getIfNameGlobal()) != null && existing_ifname.equals(new_ifname))) {
                return (NatStaticRule)rule;
            }
            ++i;
        }
        return null;
    }

    public int getMaxParameter(String strParameter) throws NatException {
        if (strParameter == null) {
            throw new NullPointerException();
        }
        Integer i = (Integer)this._htMaxValues.get(strParameter);
        if (i == null) {
            throw new NatException(1000);
        }
        return i;
    }

    public int getMinParameter(String strParameter) throws NatException {
        if (strParameter == null) {
            throw new NullPointerException();
        }
        Integer i = (Integer)this._htMinValues.get(strParameter);
        if (i == null) {
            throw new NatException(1000);
        }
        return i;
    }

    public String[] getOutsideInterfaces() {
        return this.getInterfaces(2);
    }

    public int getParameter(String strParameter) throws NatException {
        if (strParameter == null) {
            throw new NullPointerException();
        }
        Integer i = (Integer)this._htParameters.get(strParameter);
        if (i == null && (i = (Integer)this._htDefaultValues.get(strParameter)) == null) {
            throw new NatException(1000);
        }
        return i;
    }

    public NatPoolCollection getPools() {
        return this._collPools;
    }

    public NatDynamicRule getPrimNatRule(XDMInterfaceBase xdmPrimItf) {
        NatDynamicRule natRule = null;
        if (xdmPrimItf == null) {
            return natRule;
        }
        Dialer dialerIntfPrim = null;
        dialerIntfPrim = (Dialer)xdmPrimItf.getLogicalIf();
        if (dialerIntfPrim != null) {
            xdmPrimItf = dialerIntfPrim;
        }
        if (!WANHelperBase.isPATExists((DeviceBase)this.getDevice(), xdmPrimItf)) {
            return natRule;
        }
        natRule = (NatDynamicRule)WANHelperBase.getPATRule((DeviceBase)this.getDevice(), xdmPrimItf);
        this._theLog.info("isValidPrimNatExist natRule: " + natRule);
        if (natRule == null) {
            return natRule;
        }
        this._theLog.info("\n isValidPrimNatExist Interface: " + natRule.getInterface((DeviceBase)this.getDevice()));
        this._theLog.info("\n isValidPrimNatExist Overload: " + natRule.getOverload());
        if (natRule.getInterface((DeviceBase)this.getDevice()) == null || !natRule.getOverload()) {
            return natRule;
        }
        return natRule;
    }

    public NatRule[] getRules() {
        Object[] ruleArray = new NatRule[this._lstRules.size()];
        this._lstRules.copyInto(ruleArray);
        return ruleArray;
    }

    public IPItem[] getStaticMappedIPs() {
        NatRule[] rules = this.getRules();
        Vector<IPItem> v = new Vector<IPItem>();
        int i = 0;
        while (i < rules.length) {
            NatStaticRule r;
            if (rules[i] instanceof NatStaticRule && !(r = (NatStaticRule)rules[i]).isReadOnly()) {
                String ipBegin = null;
                String ipEnd = null;
                String ipTrans = null;
                String ipTransEnd = null;
                String local = r.getLocalIPStringNP();
                String global = r.getGlobalIPStringNP();
                int separator = local.indexOf("-");
                if (separator == -1) {
                    ipBegin = local;
                } else {
                    ipBegin = local.substring(0, separator);
                    ipEnd = local.substring(separator + 1);
                }
                separator = global.indexOf("-");
                if (separator == -1) {
                    ipTrans = global;
                } else {
                    ipTrans = global.substring(0, separator);
                    ipTransEnd = global.substring(separator + 1);
                }
                class Com_cisco_xdm_data_nat_Nat$1 {
                    /* synthetic */ Com_cisco_xdm_data_nat_Nat$1() {
                    }
                }
                v.addElement(new IPItem(null, ipBegin, ipEnd, ipTrans, ipTransEnd));
            }
            ++i;
        }
        Object[] items = new IPItem[v.size()];
        v.copyInto(items);
        return items;
    }

    private void init() {
        this._htParameters = new Hashtable();
        this._htDefaultValues = new Hashtable();
        this._htMaxValues = new Hashtable();
        this._htMinValues = new Hashtable();
        this._lstRules = new Vector();
        this._collPools = new NatPoolCollection(this);
        this._theLog = Log.getLog();
    }

    static String ipAddressFromInterface(DeviceBase dev, String ifStr) {
        return Nat.ipAddressFromInterface(dev, ifStr, false);
    }

    static String ipAddressFromInterface(DeviceBase dev, String ifStr, boolean bIfName) {
        String ipStr = bIfName ? ifStr : "";
        XDMInterfaces ifs = dev.getIfs();
        Log theLog = Log.getLog();
        XDMInterfaceBase xif = ifs.getIfFromString(ifStr);
        if (xif != null) {
            IPAddress ipAddr;
            IfIPAddress ipA = xif.getIpAddr();
            if (ipA != null && ipA.getIPAddressType() == IPAddressType.STATIC && (ipAddr = ipA.getIPAddress()) != null) {
                ipStr = ipAddr.toString();
            }
        } else {
            theLog.debug("Nat: interface '" + ifStr + "' not found");
        }
        return ipStr;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isNatAssociationsPresent(DeviceBase dev, XDMInterfaceBase intf) {
        try {
            NatRule drule = WANHelperBase.getPATRule(dev, intf);
            if (drule != null) {
                return true;
            }
            NatRule[] rules = this.getRules();
            int i = 0;
            while (i < rules.length) {
                NatRule srule = rules[i];
                if (srule instanceof NatStaticRule) {
                    String intfIP;
                    NatStaticRule snat = (NatStaticRule)srule;
                    String string = intfIP = intf.getIpAddr() != null && intf.getIpAddr().getIPAddressType() == IPAddressType.STATIC ? intf.getIpAddr().getIPAddress().toString() : "";
                    if (snat.getIPGlobal() != null && snat.getIPGlobal().equals(intfIP) || intf.getIfID().toString().equals(snat.getGlobalIPString())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isNatRuleContainsACL(NatDynamicRule natRule) {
        boolean isACLRule = false;
        if (natRule == null) {
            return isACLRule;
        }
        String strACL = natRule.getACL();
        this._theLog.info("\n isNatRuleContainsACL strACL: " + strACL);
        if (strACL != null && strACL.length() > 0) {
            isACLRule = true;
        }
        return isACLRule;
    }

    public NatStaticRule isRuleConflict(NatStaticRule rule1) {
        IPAddress local1 = rule1.getIPLocal();
        IPAddress global1 = rule1.getIPGlobal();
        Netmask mask1 = null;
        if (rule1.isNetworkMapping() && (mask1 = rule1.getIPMask()) == null && rule1.getMaskLen() != -1) {
            mask1 = new Netmask(Netmask.lengthToString(rule1.getMaskLen()));
        }
        NatRule[] allRules = this.getRules();
        int i = 0;
        while (i < allRules.length) {
            NatStaticRule rule2;
            if (allRules[i] instanceof NatStaticRule && rule1 != (rule2 = (NatStaticRule)allRules[i]) && rule1.getApplication() == rule2.getApplication()) {
                IPAddress local2 = rule2.getIPLocal();
                IPAddress global2 = rule2.getIPGlobal();
                Netmask mask2 = null;
                if (rule2.isNetworkMapping() && (mask2 = rule2.getIPMask()) == null && rule2.getMaskLen() != -1) {
                    mask2 = new Netmask(Netmask.lengthToString(rule2.getMaskLen()));
                }
                if (mask1 == null) {
                    if (mask2 == null) {
                        if (global1 != null && global2 != null && global1.equals(global2) && rule1.getPortType() == rule2.getPortType() && rule1.getPortGlobal() == rule2.getPortGlobal()) {
                            return rule2;
                        }
                    } else if ((IPAddress.verifyAddress(local2, mask2, local1) || IPAddress.verifyAddress(local2, mask2, global1) || IPAddress.verifyAddress(global2, mask2, local1) || IPAddress.verifyAddress(global2, mask2, global1)) && rule1.getPortType() == rule2.getPortType() && rule1.getPortLocal() == rule2.getPortLocal()) {
                        return rule2;
                    }
                } else if (mask2 != null && (IPAddress.verifyNetwork(local1, mask1, local2, mask2) || IPAddress.verifyNetwork(local1, mask1, global2, mask2) || IPAddress.verifyNetwork(global1, mask1, local2, mask2) || IPAddress.verifyNetwork(global1, mask1, global2, mask2)) && rule1.getPortType() == rule2.getPortType() && rule1.getPortLocal() == rule2.getPortLocal()) {
                    return rule2;
                }
            }
            ++i;
        }
        return null;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) {
        ConfigValues natCmds = null;
        ConfigValues translationCmds = null;
        ConfigValues poolCmds = null;
        ConfigValues insideCmds = null;
        ConfigValues outsideCmds = null;
        try {
            String aclId;
            natCmds = config.getCmds("ip", "nat", "nat", false);
            if (natCmds != null) {
                translationCmds = natCmds.getCmds("ip", "translation", "translation", false);
                poolCmds = natCmds.getCmds("ip", "poolkey", "pool", false);
                insideCmds = natCmds.getCmds("ip", "inside", "inside", false);
                outsideCmds = natCmds.getCmds("ip", "outside", "outside", false);
            }
            int numTranslationCmds = translationCmds == null ? 0 : translationCmds.numCmds();
            int numPoolCmds = poolCmds == null ? 0 : poolCmds.numCmds();
            int numInsideCmds = insideCmds == null ? 0 : insideCmds.numCmds();
            int numOutsideCmds = outsideCmds == null ? 0 : outsideCmds.numCmds();
            this._theLog.debug("Nat: populate {translation,pool,inside,outside}: " + numTranslationCmds + "," + numPoolCmds + "," + numInsideCmds + "," + numOutsideCmds);
            int i = 0;
            while (i < numTranslationCmds) {
                String parmKey;
                CmdValues cv = translationCmds.getCmdValues(i);
                Integer ival = null;
                String valueKey = null;
                if (cv.containsKey(XDM_NAT_DNS_TIMEOUT)) {
                    valueKey = XDM_NAT_DNS_TIMEOUT;
                } else if (cv.containsKey(XDM_NAT_ICMP_TIMEOUT)) {
                    valueKey = XDM_NAT_ICMP_TIMEOUT;
                } else if (cv.containsKey(XDM_NAT_PPTP_TIMEOUT)) {
                    valueKey = XDM_NAT_PPTP_TIMEOUT;
                } else if (cv.containsKey(XDM_NAT_TIMEOUT)) {
                    valueKey = XDM_NAT_TIMEOUT;
                } else if (cv.containsKey(XDM_NAT_UDP_TIMEOUT)) {
                    valueKey = XDM_NAT_UDP_TIMEOUT;
                } else if (cv.containsKey(XDM_NAT_TCP_TIMEOUT)) {
                    valueKey = XDM_NAT_TCP_TIMEOUT;
                }
                if (valueKey != null) {
                    parmKey = String.valueOf(valueKey) + "-seconds";
                    if (cv.containsKey(parmKey)) {
                        ival = new Integer(Integer.parseInt(cv.getValue(parmKey)));
                    } else if (cv.containsKey("never")) {
                        ival = new Integer(0);
                    }
                }
                if (cv.containsKey(XDM_NAT_MAX_ENTRIES)) {
                    valueKey = XDM_NAT_MAX_ENTRIES;
                    parmKey = String.valueOf(valueKey) + "-num";
                    ival = new Integer(Integer.parseInt(cv.getValue(parmKey)));
                }
                if (valueKey != null) {
                    this._htParameters.put(valueKey, ival);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < numPoolCmds) {
                CmdValues cv = poolCmds.getCmdValues(i2);
                if (!cv.containsKey("list") && !cv.containsKey("route-map")) {
                    String name = cv.getValue("poolname");
                    String ipStart = cv.getValue("startip");
                    String ipEnd = cv.getValue("endip");
                    String ipMask = null;
                    int iUnsupported = 0;
                    int prefixLen = -1;
                    if (cv.containsKey("netmask")) {
                        ipMask = cv.getValue("mask");
                    } else {
                        String prefixLenStr = cv.getValue("prefix");
                        prefixLen = Integer.parseInt(prefixLenStr);
                    }
                    if (cv.containsKey("type")) {
                        iUnsupported |= 1;
                    }
                    NatPool pool = new NatPool(this._collPools, iUnsupported, name);
                    if (ipMask == null) {
                        pool.setIPAddressRange(new IPAddress(ipStart), new IPAddress(ipEnd), prefixLen);
                    } else {
                        pool.setIPAddressRange(new IPAddress(ipStart), new IPAddress(ipEnd), new Netmask(ipMask));
                    }
                    this._collPools.put(name, pool);
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < numInsideCmds) {
                NatDynamicRule rule;
                int iUnsupported = 0;
                CmdValues cv = insideCmds.getCmdValues(i3);
                if (cv.containsKey("destination")) {
                    iUnsupported |= 0x20;
                }
                if (cv.containsKey("static")) {
                    String ipGlobal;
                    String ipLocal;
                    if (cv.containsKey("network")) {
                        ipLocal = cv.getValue("localipnet");
                        ipGlobal = cv.getValue("globalipnet");
                        iUnsupported |= cv.containsKey("no-alias") ? 256 : 0;
                        NatStaticRule rule2 = new NatStaticRule((XDMObject)this, iUnsupported |= cv.containsKey("no-payload") ? 512 : 0);
                        rule2.setApplication(1);
                        if (cv.containsKey("netmask")) {
                            String mask = cv.getValue("netmask");
                            rule2.setNetworkMapping(new IPAddress(ipLocal), new IPAddress(ipGlobal), new Netmask(mask));
                        }
                        if (cv.containsKey("prefix")) {
                            int prefixBits = Integer.parseInt(cv.getValue("prefix").substring(1));
                            rule2.setNetworkMapping(new IPAddress(ipLocal), new IPAddress(ipGlobal), prefixBits);
                        }
                        if (cv.containsKey("rmname")) {
                            rule2.setRouteMap(cv.getValue("rmname"));
                        }
                        this._lstRules.addElement(rule2);
                    } else if (cv.containsKey("porttype")) {
                        int portType;
                        ipLocal = cv.getValue("localipport");
                        ipGlobal = null;
                        String ifNameGlobal = null;
                        int portLocal = Integer.parseInt(cv.getValue("localport"));
                        int portGlobal = Integer.parseInt(cv.getValue("globalport"));
                        int n = portType = cv.getValue("porttype").equals("tcp") ? 1 : 2;
                        if (cv.containsKey("globalipport")) {
                            ipGlobal = cv.getValue("globalipport");
                        } else {
                            ifNameGlobal = cv.getValue("ifname");
                        }
                        iUnsupported |= cv.containsKey("no-alias") ? 256 : 0;
                        NatStaticRule rule3 = new NatStaticRule((XDMObject)this, iUnsupported |= cv.containsKey("no-payload") ? 512 : 0);
                        rule3.setApplication(1);
                        if (ipGlobal != null) {
                            rule3.setAddressMapping(new IPAddress(ipLocal), portLocal, new IPAddress(ipGlobal), portGlobal, portType);
                        } else {
                            rule3.setAddressMapping(new IPAddress(ipLocal), portLocal, ifNameGlobal, portGlobal, portType);
                        }
                        if (cv.containsKey("rmname")) {
                            rule3.setRouteMap(cv.getValue("rmname"));
                        }
                        this._lstRules.addElement(rule3);
                    } else {
                        iUnsupported |= cv.containsKey("no-alias") ? 256 : 0;
                        iUnsupported |= cv.containsKey("no-payload") ? 512 : 0;
                        iUnsupported |= cv.containsKey("redundancy") ? 4096 : 0;
                        iUnsupported |= cv.containsKey("vrf") ? 16384 : 0;
                        ipLocal = cv.getValue("localip");
                        ipGlobal = null;
                        String ifStr = null;
                        if (cv.containsKey("esp")) {
                            iUnsupported |= 0x10;
                            ifStr = cv.getValue("ifname");
                            ipGlobal = Nat.ipAddressFromInterface((DeviceBase)this.getDevice(), ifStr);
                        } else if (cv.containsKey("interface")) {
                            iUnsupported |= 0x40;
                            ifStr = cv.getValue("ifname");
                        } else {
                            ipGlobal = cv.getValue("globalip");
                        }
                        NatStaticRule rule4 = new NatStaticRule((XDMObject)this, iUnsupported);
                        rule4.setApplication(1);
                        if (ipGlobal != null && !ipGlobal.equals("")) {
                            rule4.setAddressMapping(new IPAddress(ipLocal), new IPAddress(ipGlobal));
                        } else {
                            rule4.setAddressMapping(new IPAddress(ipLocal), -1, ifStr, -1, -1);
                        }
                        if (cv.containsKey("rmname")) {
                            rule4.setRouteMap(cv.getValue("rmname"));
                        }
                        this._lstRules.addElement(rule4);
                    }
                } else if (cv.containsKey("list")) {
                    rule = null;
                    aclId = cv.getValue("acl-id");
                    if (cv.containsKey("pool")) {
                        String poolName = cv.getValue("poolname");
                        rule = new NatDynamicRule((XDMObject)this, iUnsupported);
                        rule.setApplication(1);
                        rule.setACL(aclId);
                        rule.setPool(poolName);
                    }
                    if (cv.containsKey("interface")) {
                        String ifName = cv.getValue("ifname");
                        if (ifName.toLowerCase().indexOf("loopback") >= 0) {
                            iUnsupported |= 0x80;
                        }
                        rule = new NatDynamicRule((XDMObject)this, iUnsupported);
                        rule.setApplication(1);
                        rule.setACL(aclId);
                        rule.setInterface(ifName, (DeviceBase)this.getDevice());
                    }
                    if (rule != null) {
                        boolean bOverload = cv.containsKey("overload");
                        rule.setOverload(bOverload);
                        this.addNatRuleCategory(aclId);
                        this._lstRules.addElement(rule);
                    }
                } else if (cv.containsKey("route-map")) {
                    rule = null;
                    String routeMap = cv.getValue("map-name");
                    this.registerWithACL(routeMap);
                    if (cv.containsKey("pool")) {
                        String poolName = cv.getValue("poolname");
                        rule = new NatDynamicRule((XDMObject)this, iUnsupported);
                        rule.setApplication(1);
                        rule.setRouteMap(routeMap);
                        rule.setPool(poolName);
                    }
                    if (cv.containsKey("interface")) {
                        String ifName = cv.getValue("ifname");
                        rule = new NatDynamicRule((XDMObject)this, iUnsupported);
                        rule.setApplication(1);
                        rule.setRouteMap(routeMap);
                        rule.setInterface(ifName, (DeviceBase)this.getDevice());
                    }
                    if (rule != null) {
                        boolean bOverload = cv.containsKey("overload");
                        rule.setOverload(bOverload);
                        this._lstRules.addElement(rule);
                    }
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < numOutsideCmds) {
                int iUnsupported = 0;
                CmdValues cv = outsideCmds.getCmdValues(i4);
                if (cv.containsKey("static")) {
                    NatStaticRule rule;
                    if (cv.containsKey("network")) {
                        iUnsupported |= cv.containsKey("no-alias") ? 256 : 0;
                        rule = new NatStaticRule((XDMObject)this, iUnsupported |= cv.containsKey("no-payload") ? 512 : 0);
                        rule.setApplication(2);
                        String ipLocal = cv.getValue("localipnet");
                        String ipGlobal = cv.getValue("globalipnet");
                        if (cv.containsKey("netmask")) {
                            String mask = cv.getValue("netmask");
                            rule.setNetworkMapping(new IPAddress(ipLocal), new IPAddress(ipGlobal), new Netmask(mask));
                        }
                        if (cv.containsKey("prefix")) {
                            int prefixBits = Integer.parseInt(cv.getValue("prefix").substring(1));
                            rule.setNetworkMapping(new IPAddress(ipLocal), new IPAddress(ipGlobal), prefixBits);
                        }
                        this._lstRules.addElement(rule);
                    } else if (cv.containsKey("porttype")) {
                        iUnsupported |= cv.containsKey("no-alias") ? 256 : 0;
                        rule = new NatStaticRule((XDMObject)this, iUnsupported |= cv.containsKey("no-payload") ? 512 : 0);
                        rule.setApplication(2);
                        String ipLocal = cv.getValue("localipport");
                        String ipGlobal = cv.getValue("globalipport");
                        int portLocal = Integer.parseInt(cv.getValue("localport"));
                        int portGlobal = Integer.parseInt(cv.getValue("globalport"));
                        int portType = cv.getValue("porttype").equals("tcp") ? 1 : 2;
                        rule.setAddressMapping(new IPAddress(ipLocal), portLocal, new IPAddress(ipGlobal), portGlobal, portType);
                        this._lstRules.addElement(rule);
                    } else if (cv.containsKey("localip")) {
                        iUnsupported |= cv.containsKey("no-alias") ? 256 : 0;
                        iUnsupported |= cv.containsKey("no-payload") ? 512 : 0;
                        rule = new NatStaticRule((XDMObject)this, iUnsupported |= cv.containsKey("add-route") ? 8192 : 0);
                        rule.setApplication(2);
                        String ipLocal = cv.getValue("localip");
                        String ipGlobal = cv.getValue("globalip");
                        rule.setAddressMapping(new IPAddress(ipLocal), new IPAddress(ipGlobal));
                        this._lstRules.addElement(rule);
                    }
                } else if (cv.containsKey("list")) {
                    aclId = cv.getValue("acl-id");
                    String poolName = cv.getValue("poolname");
                    NatDynamicRule rule = new NatDynamicRule((XDMObject)this, 0);
                    rule.setApplication(2);
                    rule.setACL(aclId);
                    rule.setPool(poolName);
                    this.addNatRuleCategory(aclId);
                    this._lstRules.addElement(rule);
                } else if (cv.containsKey("route-map")) {
                    String poolName = cv.getValue("poolname");
                    String routeMap = cv.getValue("map-name");
                    this.registerWithACL(routeMap);
                    NatDynamicRule rule = new NatDynamicRule((XDMObject)this, 1);
                    rule.setApplication(2);
                    rule.setRouteMap(routeMap);
                    rule.setPool(poolName);
                    this._lstRules.addElement(rule);
                }
                ++i4;
            }
        }
        catch (CliGPBException e) {
            this._theLog.error("Nat populate exception: " + e);
        }
        CmdSet cmdset = ((DeviceBase)this.getDevice()).getDevInfoBase().getCmdSet();
        String[] parmArray = new String[]{XDM_NAT_DNS_TIMEOUT, XDM_NAT_ICMP_TIMEOUT, XDM_NAT_PPTP_TIMEOUT, XDM_NAT_TIMEOUT, XDM_NAT_TCP_TIMEOUT, XDM_NAT_UDP_TIMEOUT};
        String[] cmds = new String[]{"ip nat translation dns-timeout ?", "ip nat translation icmp-timeout ?", "ip nat translation pptp-timeout ?", "ip nat translation timeout ?", "ip nat translation tcp-timeout ?", "ip nat translation udp-timeout ?"};
        IOSCmdService cmdsvc = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
        IOSCmdResponse[] replies = null;
        try {
            replies = cmdsvc.config(cmds);
        }
        catch (IOSCmdServiceException ex) {
            Log.getLog().debug("exception:" + ex);
        }
        int i = 0;
        while (i < parmArray.length) {
            String parmKey = String.valueOf(parmArray[i]) + "-seconds";
            KeywordParamNode node = cmdset.getParamNode("ip", parmKey, true);
            if (node != null) {
                String defaultStr = node.getDefaultValue();
                if (defaultStr != null) {
                    this._htDefaultValues.put(parmArray[i], new Integer(Integer.parseInt(defaultStr)));
                } else {
                    this._theLog.info("no default for " + parmArray[i]);
                }
                this._htMaxValues.put(parmArray[i], new Integer((int)node.getMaxRange()));
                this._htMinValues.put(parmArray[i], new Integer((int)node.getMinRange()));
                if (replies != null) {
                    IOSCmdResponse r = replies[i];
                    String discoveryStr = r.getOutput();
                    int iStart = discoveryStr.indexOf("<");
                    int iEnd = discoveryStr.indexOf(">");
                    if (iStart != -1 && iEnd != -1) {
                        String rangeStr = discoveryStr.substring(iStart + 1, iEnd);
                        int separator = rangeStr.indexOf("-");
                        this._htMinValues.put(parmArray[i], new Integer(Integer.parseInt(rangeStr.substring(0, separator))));
                        this._htMaxValues.put(parmArray[i], new Integer(Integer.parseInt(rangeStr.substring(separator + 1))));
                    }
                }
            } else {
                this._theLog.error("no grammar node for " + parmArray[i]);
            }
            ++i;
        }
        String parmKey = "max-entries-num";
        KeywordParamNode node = cmdset.getParamNode("ip", parmKey, true);
        if (node != null) {
            String defaultStr = node.getDefaultValue();
            if (defaultStr != null) {
                this._htDefaultValues.put(XDM_NAT_MAX_ENTRIES, new Integer(Integer.parseInt(defaultStr)));
            } else {
                this._htDefaultValues.put(XDM_NAT_MAX_ENTRIES, XDM_NAT_NO_MAX_ENTRIES_OBJ);
                this._theLog.info("no default for max-entries, set to 0");
            }
            this._htMaxValues.put(XDM_NAT_MAX_ENTRIES, new Integer((int)node.getMaxRange()));
            this._htMinValues.put(XDM_NAT_MAX_ENTRIES, new Integer((int)node.getMinRange()));
        } else {
            this._theLog.error("no grammar node for max-entries");
        }
    }

    private void registerWithACL(String rMap) {
        RouteMapCollection rmaps = ((DeviceBase)this.getDevice()).getRouteMaps();
        RouteMap routeMap = (RouteMap)rmaps.get(rMap);
        if (routeMap == null) {
            return;
        }
        Enumeration e = routeMap.elements();
        while (e.hasMoreElements()) {
            RouteMapEntry rmapEntry = (RouteMapEntry)e.nextElement();
            rmapEntry.registerWithACL((DeviceBase)this.getDevice());
        }
    }

    void removeNatRuleCategory(String aclId) {
        ACLBase acl;
        if (aclId == null) {
            return;
        }
        DeviceBase d = (DeviceBase)this.getDevice();
        if (d != null && (acl = d.getAcls().getACL(aclId)) != null) {
            acl.deleteFromCategory(2);
        }
    }

    public void removeRule(NatRule rule) {
        this.setModified();
        this._lstRules.removeElement(rule);
        if (rule instanceof NatDynamicRule) {
            String aclId = ((NatDynamicRule)rule).getACL();
            this.removeNatRuleCategory(aclId);
        }
    }

    public void setParameter(String strParameter, int iValue) {
        this.setModified();
        Integer v = new Integer(iValue);
        this._htParameters.put(strParameter, v);
    }

    public void setPools(NatPoolCollection pools) {
        this._collPools = pools;
        pools.setParent(this);
        this.setModified();
    }

    public boolean showWarnUnnumbered(NatDynamicRule rule) {
        if (rule == null || rule.getInterface((DeviceBase)this.getDevice()) == null) {
            return false;
        }
        String ifName = rule.getInterface((DeviceBase)this.getDevice());
        XDMInterfaces xifs = ((DeviceBase)this.getDevice()).getIfs();
        XDMInterfaceBase xif = xifs.getIfFromCompositeLabel(ifName);
        if (xif == null) {
            return false;
        }
        return xif.getIpAddr() != null && xif.getIpAddr().getIPAddressType() == IPAddressType.UNNUMBERED;
    }

    public String toString() {
        String key;
        String s = new String();
        s = "Nat:{rules}";
        int i = 0;
        while (i < this._lstRules.size()) {
            s = s.concat(this._lstRules.elementAt(i).toString());
            if (this._lstRules.size() - 1 > i) {
                s = s.concat(",");
            }
            ++i;
        }
        s = s.concat("{parameters}");
        Enumeration keys = this._htParameters.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            s = s.concat("<" + key + "$" + this._htParameters.get(key) + ">");
            if (!keys.hasMoreElements()) continue;
            s = s.concat(",");
        }
        s = s.concat("{pools}");
        keys = this._collPools.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            s = s.concat("<" + key + "$" + this._collPools.get(key) + ">");
            if (!keys.hasMoreElements()) continue;
            s = s.concat(",");
        }
        return s;
    }

    public class IPItem {
        public String _ipBegin;
        public String _ipEnd;
        public String _ipTrans;
        public String _ipTransEnd;

        /* synthetic */ IPItem(1 $0, String $1, String $2, String $3, String $4) {
            this($1, $2, $3, $4);
        }

        private IPItem(String ipBegin, String ipEnd, String ipTrans, String ipTransEnd) {
            this._ipBegin = ipBegin;
            this._ipEnd = ipEnd;
            this._ipTrans = ipTrans;
            this._ipTransEnd = ipTransEnd;
        }
    }
}

