/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.nat;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ACLCollection;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.nat.Nat;
import com.cisco.xdm.data.nat.NatPool;
import com.cisco.xdm.data.nat.NatPoolCollection;
import com.cisco.xdm.data.nat.NatRule;
import com.cisco.xdm.data.nat.RouteMap;
import com.cisco.xdm.data.nat.RouteMapCollection;
import com.cisco.xdm.data.nat.RouteMapEntry;
import java.util.Enumeration;
import java.util.Vector;

public class NatDynamicRule
extends NatRule {
    private Log _theLog;
    private String _strACL;
    private String _strRouteMap;
    private String _strInterface;
    private String _strPool;
    private boolean _bOverload;

    public NatDynamicRule() {
        this.init();
    }

    public NatDynamicRule(XDMObject parent) {
        super(parent);
        this.init();
    }

    public NatDynamicRule(XDMObject parent, int iUnsupported) {
        super(parent, iUnsupported);
        this.init();
    }

    public Object clone() {
        NatDynamicRule rule = (NatDynamicRule)super.clone();
        rule._strACL = this._strACL == null ? null : this._strACL;
        rule._strRouteMap = this._strRouteMap == null ? null : this._strRouteMap;
        rule._strInterface = this._strInterface == null ? null : this._strInterface;
        rule._strPool = this._strPool == null ? null : this._strPool;
        rule._bOverload = this._bOverload;
        return rule;
    }

    private CmdValues createDynamicRule() {
        Nat nat;
        NatPool pool;
        CmdValues cmd = new CmdValues("ip");
        cmd.addValue("nat", "nat");
        if (this.getApplication() == 1) {
            cmd.addValue("inside", "inside");
        }
        if (this.getApplication() == 2) {
            cmd.addValue("outside", "outside");
        }
        cmd.addValue("source", "source");
        if (this.getACL() != null) {
            cmd.addValue("list", "list");
            cmd.addValue("acl-id", this.getACL());
        }
        if (this.getRouteMap() != null) {
            cmd.addValue("route-map", "route-map");
            cmd.addValue("map-name", this.getRouteMap());
        }
        if (this.getACL() == null && this.getRouteMap() == null) {
            return null;
        }
        if (this.getPool() != null) {
            cmd.addValue("pool", "pool");
            cmd.addValue("poolname", this.getPool());
        }
        if (this._strInterface != null) {
            cmd.addValue("interface", "interface");
            cmd.addValue("ifname", this._strInterface);
        }
        if (this.getPool() == null && (this.getInterface((DeviceBase)this.getDevice()) == null || this.getApplication() == 2)) {
            return null;
        }
        boolean bOverload = this.getOverload();
        if (!bOverload && this.getPool() != null && (pool = (NatPool)(nat = ((DeviceBase)this.getDevice()).getNAT()).getPools().get(this.getPool())) != null) {
            bOverload = pool.isPAT();
        }
        if (bOverload) {
            cmd.addValue("overload", "overload");
        }
        return cmd;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NatDynamicRule) || !super.equals(o)) {
            return false;
        }
        NatDynamicRule rule = (NatDynamicRule)o;
        return super.equals(rule) && this._bOverload == rule._bOverload && (this._strACL != null && this._strACL.equals(rule._strACL) || this._strACL == null && rule._strACL == null) && (this._strRouteMap != null && this._strRouteMap.equals(rule._strRouteMap) || this._strRouteMap == null && rule._strRouteMap == null) && (this._strInterface != null && this._strInterface.equals(rule._strInterface) || this._strInterface == null && rule._strInterface == null) && (this._strPool != null && this._strPool.equals(rule._strPool) || this._strPool == null && rule._strPool == null);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        int cmdPosition = -1;
        DeviceBase dev = (DeviceBase)this.getDevice();
        CmdValues cmd = this.createDynamicRule();
        if (cmd == null) {
            return;
        }
        if (this.isBackup()) {
            cmdPosition = dev.getFirstCmdPosition("ifs", values, true);
            cmd.setAction(2);
        } else {
            cmd.setAction(1);
        }
        if (cmdPosition == -1) {
            values.addCmdValues(cmd);
        } else {
            values.insertCmdValues(cmd, cmdPosition);
        }
    }

    public String getACL() {
        return this._strACL;
    }

    private String getAclOrRouteMapIP() {
        ACLCollection acls;
        ACLBase acl;
        String ipStr = null;
        if (this._strRouteMap != null) {
            RouteMapCollection rmaps = ((DeviceBase)this.getDevice()).getRouteMaps();
            RouteMap routeMap = (RouteMap)rmaps.get(this._strRouteMap);
            if (routeMap != null && (ipStr = this.getIPAddressInfo(routeMap)) != null && (ipStr = ipStr.trim()).length() > 1 && ipStr.charAt(ipStr.length() - 1) == ',') {
                ipStr = ipStr.substring(0, ipStr.length() - 1);
            }
        } else if (this._strACL != null && (acl = (ACLBase)(acls = ((DeviceBase)this.getDevice()).getAcls()).get(this._strACL)) != null) {
            ipStr = this.getIPAddressInfo(acl);
        }
        return ipStr;
    }

    public String getBaseInterface() {
        return this._strInterface;
    }

    public String getGlobalIPString() {
        if (this.getApplication() == 2) {
            return this.getAclOrRouteMapIP();
        }
        return this.getPoolOrInterfaceIP();
    }

    private String getIPAddressInfo(ACLBase acl) {
        String ipStr = "";
        if (acl != null) {
            Enumeration aces = acl.getACEs();
            while (aces.hasMoreElements()) {
                StandardACE ace = (StandardACE)aces.nextElement();
                if (!ace.getGrant()) continue;
                String ipAddr = ace.getSource();
                String inverseMask = ace.getSourceWildcardMask();
                IPAddress startIpAddr = new IPAddress(ipAddr);
                IPAddress maskIP = new IPAddress(inverseMask);
                Netmask m = new Netmask(~maskIP.getIntValue());
                String endIpAddr = startIpAddr.getFinalAddress(m).toString();
                ipStr = String.valueOf(ipStr) + ipAddr;
                if (!ipAddr.equals(endIpAddr)) {
                    ipStr = String.valueOf(ipStr) + "-" + endIpAddr;
                }
                ipStr = String.valueOf(ipStr) + ", ";
            }
        } else {
            this._theLog.info("ACL " + this._strACL + " not found!");
        }
        return ipStr.equals("") ? null : ipStr.substring(0, ipStr.length() - 2);
    }

    private String getIPAddressInfo(RouteMap routeMap) {
        StringBuffer csString = new StringBuffer();
        String ipStr = null;
        ACLCollection aclCollection = ((DeviceBase)this.getDevice()).getAcls();
        Enumeration e = routeMap.elements();
        while (e.hasMoreElements()) {
            Vector aclList;
            RouteMapEntry rmapEntry = (RouteMapEntry)e.nextElement();
            if (!rmapEntry.getAction() || (aclList = rmapEntry.getACLs()) == null) continue;
            int count = 0;
            while (count < aclList.size()) {
                String aclName = (String)aclList.elementAt(count);
                ACL acl = (ACL)aclCollection.getACL(aclName);
                if (acl != null) {
                    ipStr = this.getIPAddressInfo(acl);
                    if (ipStr != null) {
                        csString.append(ipStr);
                        csString.append(", ");
                    }
                } else {
                    csString.append("(ACL - " + aclName + ")");
                }
                ++count;
            }
        }
        return csString.toString();
    }

    public String getInterface(DeviceBase dev) {
        XDMInterfaces xifs;
        XDMInterfaceBase iface;
        String ifStr = this._strInterface;
        if (this._strInterface != null && (iface = (xifs = dev.getIfs()).getIfFromString(this._strInterface)) != null) {
            ifStr = iface.getLabel();
        }
        return ifStr;
    }

    public String getLocalIPString() {
        if (this.getApplication() == 2) {
            return this.getPoolOrInterfaceIP();
        }
        return this.getAclOrRouteMapIP();
    }

    public boolean getOverload() {
        return this._bOverload;
    }

    public String getPool() {
        return this._strPool;
    }

    private String getPoolOrInterfaceIP() {
        String ipStr = null;
        if (this._strInterface != null) {
            ipStr = Nat.ipAddressFromInterface((DeviceBase)this.getDevice(), this._strInterface);
            if (ipStr.equals("")) {
                ipStr = this.getInterface((DeviceBase)this.getDevice());
            }
        } else if (this._strPool != null) {
            NatPoolCollection pools = ((Nat)this.getParent()).getPools();
            NatPool pool = (NatPool)pools.get(this._strPool);
            if (pool != null) {
                String endIpStr;
                IPAddress startIP = pool.getStartIP();
                IPAddress endIP = pool.getEndIP();
                ipStr = startIP.toString();
                if (endIP != null && !ipStr.equals(endIpStr = endIP.toString())) {
                    ipStr = String.valueOf(ipStr) + "-" + endIpStr;
                }
            } else {
                this._theLog.error("Nat pool '" + this._strPool + "' doesn't exist");
            }
        }
        return ipStr;
    }

    public String getRouteMap() {
        return this._strRouteMap;
    }

    private void init() {
        this._strACL = null;
        this._strRouteMap = null;
        this._strPool = null;
        this._strInterface = null;
        this._bOverload = false;
        this._theLog = Log.getLog();
    }

    public boolean isReadOnly() {
        XDMInterfaceBase xif;
        XDMInterfaces xifs;
        DeviceBase dev;
        boolean bRO = super.isReadOnly();
        if (this.getBaseInterface() != null && (dev = (DeviceBase)this.getDevice()) != null && (xifs = dev.getIfs()) != null && (xif = xifs.getIfFromString(this.getBaseInterface())) != null) {
            bRO = bRO || xif.getIpAddr() == null;
        }
        return bRO;
    }

    public void populate(ConfigValues config, CmdValues cmdVals) {
    }

    public void setACL(String strACLName) {
        this.setModified();
        Nat nat = (Nat)this.getParent();
        this._strACL = strACLName;
    }

    public void setInterface(String strInterface, DeviceBase dev) {
        XDMInterfaces xifs;
        XDMInterfaceBase iface;
        this.setModified();
        if (strInterface != null && (iface = (xifs = dev.getIfs()).getIfFromCompositeLabel(strInterface)) != null) {
            strInterface = iface.getIfID().toString();
        }
        this._strInterface = strInterface;
        this._strPool = null;
    }

    public void setOverload(boolean bOverload) {
        this.setModified();
        this._bOverload = bOverload;
    }

    public void setPool(String strPoolName) {
        this.setModified();
        this._strPool = strPoolName;
        this._strInterface = null;
    }

    public void setRouteMap(String routeMap) {
        this.setModified();
        this._strRouteMap = routeMap;
    }

    public String toString() {
        String s = null;
        if (this._strACL != null) {
            s = "NatDynamicRule(" + super.toString() + "):{ACL}" + this._strACL + ",{Interface}" + this._strInterface + ",{Pool}" + this._strPool;
        }
        if (this._strRouteMap != null) {
            s = "NatDynamicRule(" + super.toString() + "):{ROUTEMAP}" + this._strRouteMap + ",{Interface}" + this._strInterface + ",{Pool}" + this._strPool;
        }
        return s;
    }
}

