/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.nat;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.nat.Nat;
import com.cisco.xdm.data.nat.NatRule;

public class NatStaticRule
extends NatRule {
    public static final int XDM_NAT_TCP_PORT = 1;
    public static final int XDM_NAT_UDP_PORT = 2;
    public static final int XDM_NAT_INVALID = -1;
    private int _iPortLocal;
    private int _iPortGlobal;
    private int _iPortType;
    private IPAddress _ipLocal;
    private IPAddress _ipGlobal;
    private String _ifNameGlobal;
    private Netmask _ipMask;
    private int _iMaskLen;
    private Log _theLog;
    private String _rMap;

    public NatStaticRule() {
        this.init();
    }

    public NatStaticRule(XDMObject parent) {
        super(parent);
        this.init();
    }

    public NatStaticRule(XDMObject parent, int iUnsupported) {
        super(parent, iUnsupported);
        this.init();
    }

    public Object clone() {
        NatStaticRule rule = (NatStaticRule)super.clone();
        rule._iPortLocal = this._iPortLocal;
        rule._iPortGlobal = this._iPortGlobal;
        rule._iPortType = this._iPortType;
        rule._ipLocal = this._ipLocal == null ? null : (IPAddress)this._ipLocal.clone();
        rule._ipGlobal = this._ipGlobal == null ? null : (IPAddress)this._ipGlobal.clone();
        rule._ifNameGlobal = this._ifNameGlobal == null ? null : this._ifNameGlobal;
        rule._ipMask = this._ipMask == null ? null : (Netmask)this._ipMask.clone();
        rule._iMaskLen = this._iMaskLen;
        return rule;
    }

    public Netmask createMask() {
        Netmask mask = null;
        if (this._ipMask != null) {
            mask = this._ipMask;
        } else if (this._iMaskLen != -1) {
            mask = new Netmask(Netmask.lengthToString(this._iMaskLen));
        }
        return mask;
    }

    private CmdValues createStaticRule() {
        CmdValues cmd = new CmdValues("ip");
        cmd.addValue("nat", "nat");
        if (this.getApplication() == 1) {
            cmd.addValue("inside", "inside");
        }
        if (this.getApplication() == 2) {
            cmd.addValue("outside", "outside");
        }
        cmd.addValue("source", "source");
        cmd.addValue("static", "static");
        String localIPKey = "localip";
        String globalIPKey = "globalip";
        switch (this._iPortType) {
            case 1: {
                globalIPKey = "globalipport";
                localIPKey = "localipport";
                cmd.addValue("localport", Integer.toString(this._iPortLocal));
                cmd.addValue("globalport", Integer.toString(this._iPortGlobal));
                cmd.addValue("porttype", "tcp");
                break;
            }
            case 2: {
                globalIPKey = "globalipport";
                localIPKey = "localipport";
                cmd.addValue("localport", Integer.toString(this._iPortLocal));
                cmd.addValue("globalport", Integer.toString(this._iPortGlobal));
                cmd.addValue("porttype", "udp");
                break;
            }
        }
        if (this._ipMask != null) {
            cmd.addValue("network", "network");
            cmd.addValue("netmask", this._ipMask.toString());
            globalIPKey = "globalipnet";
            localIPKey = "localipnet";
        }
        if (this._iMaskLen != -1) {
            cmd.addValue("network", "network");
            cmd.addValue("prefix", "/" + Integer.toString(this._iMaskLen));
            globalIPKey = "globalipnet";
            localIPKey = "localipnet";
        }
        cmd.addValue(localIPKey, this._ipLocal.toString());
        if (this._ipGlobal != null) {
            cmd.addValue(globalIPKey, this._ipGlobal.toString());
        }
        if (this._ifNameGlobal != null) {
            cmd.addValue("interface", "interface");
            cmd.addValue("ifname", this._ifNameGlobal);
        }
        if (this._rMap != null) {
            cmd.addValue("rmname", this._rMap);
        }
        return cmd;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NatStaticRule) || !super.equals(o)) {
            return false;
        }
        NatStaticRule rule = (NatStaticRule)o;
        return super.equals(rule) && this._iPortLocal == rule._iPortLocal && this._iPortGlobal == rule._iPortGlobal && this._iPortType == rule._iPortType && (this._ipLocal != null && this._ipLocal.equals(rule._ipLocal) || this._ipLocal == null && rule._ipLocal == null) && (this._ipGlobal != null && this._ipGlobal.equals(rule._ipGlobal) || this._ipGlobal == null && rule._ipGlobal == null) && (this._ifNameGlobal != null && this._ifNameGlobal.equals(rule._ifNameGlobal) || this._ifNameGlobal == null && rule._ifNameGlobal == null) && (this._ipMask != null && this._ipMask.equals(rule._ipMask) || this._ipMask == null && rule._ipMask == null) && (this._rMap != null && this._rMap.equals(rule._rMap) || this._rMap == null && rule._rMap == null) && this._iMaskLen == rule._iMaskLen;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        CmdValues cmd = this.createStaticRule();
        if (this.isBackup()) {
            cmd.setAction(2);
        } else {
            cmd.setAction(1);
        }
        values.addCmdValues(cmd);
    }

    private String getGlobalIPStr(boolean bPorts) {
        String portStr = "";
        if (bPorts && this._iPortGlobal != -1) {
            portStr = " (" + this._iPortGlobal + ")";
        }
        if (this._ipGlobal != null) {
            String ipStart = this._ipGlobal.toString();
            Netmask mask = this.createMask();
            if (mask == null) {
                return String.valueOf(ipStart) + portStr;
            }
            return String.valueOf(ipStart) + "-" + this._ipGlobal.getFinalAddress(mask).toString() + portStr;
        }
        if (this._ifNameGlobal != null) {
            String ipStr = Nat.ipAddressFromInterface((DeviceBase)this.getDevice(), this._ifNameGlobal);
            if (ipStr.equals("")) {
                ipStr = this.getInterface();
            }
            return String.valueOf(ipStr) + portStr;
        }
        return "";
    }

    public String getGlobalIPString() {
        return this.getGlobalIPStr(true);
    }

    public String getGlobalIPStringNP() {
        return this.getGlobalIPStr(false);
    }

    public IPAddress getIPGlobal() {
        return this._ipGlobal;
    }

    public IPAddress getIPLocal() {
        return this._ipLocal;
    }

    public Netmask getIPMask() {
        return this._ipMask;
    }

    public String getIfNameGlobal() {
        return this._ifNameGlobal;
    }

    public String getInterface() {
        XDMInterfaces xifs;
        XDMInterfaceBase iface;
        String ifStr = this._ifNameGlobal;
        if (this._ifNameGlobal != null && (iface = (xifs = ((DeviceBase)this.getDevice()).getIfs()).getIfFromString(this._ifNameGlobal)) != null) {
            ifStr = iface.getLabel();
        }
        return ifStr;
    }

    private String getLocalIPStr(boolean bPorts) {
        if (this._ipLocal == null) {
            return "";
        }
        String portStr = "";
        if (bPorts && this._iPortLocal != -1) {
            portStr = " (" + this._iPortLocal + ")";
        }
        String ipStart = this._ipLocal.toString();
        Netmask mask = this.createMask();
        if (mask == null) {
            return String.valueOf(ipStart) + portStr;
        }
        return String.valueOf(ipStart) + "-" + this._ipLocal.getFinalAddress(mask).toString() + portStr;
    }

    public String getLocalIPString() {
        return this.getLocalIPStr(true);
    }

    public String getLocalIPStringNP() {
        return this.getLocalIPStr(false);
    }

    public int getMaskLen() {
        return this._iMaskLen;
    }

    public int getPortGlobal() {
        return this._iPortGlobal;
    }

    public int getPortLocal() {
        return this._iPortLocal;
    }

    public int getPortType() {
        return this._iPortType;
    }

    public String getRouteMap() {
        return this._rMap;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        if (this._ipLocal != null) {
            sb.append("Translate ").append(this._ipLocal.toString());
            if (this._iPortLocal != -1) {
                sb.append(this._iPortType == 2 ? " UDP port " : " TCP port ");
                sb.append(Integer.toString(this._iPortLocal));
            }
        }
        if (this._ipGlobal != null) {
            sb.append(" to ").append(this._ipGlobal.toString());
            if (this._iPortGlobal != -1) {
                sb.append(this._iPortType == 2 ? " UDP port " : " TCP port ");
                sb.append(Integer.toString(this._iPortGlobal));
            }
        } else if (this._ifNameGlobal != null && this._ifNameGlobal.length() != 0) {
            sb.append(" to IP address of interface ").append(this._ifNameGlobal);
            if (this._iPortGlobal != -1) {
                sb.append(this._iPortType == 2 ? " UDP port " : " TCP port ");
                sb.append(Integer.toString(this._iPortGlobal));
            }
        }
        return sb.toString();
    }

    public void init() {
        this._ipLocal = null;
        this._ipGlobal = null;
        this._ifNameGlobal = null;
        this._ipMask = null;
        this._iPortLocal = -1;
        this._iPortGlobal = -1;
        this._iPortType = -1;
        this._iMaskLen = -1;
        this._theLog = Log.getLog();
    }

    public boolean isNetworkMapping() {
        return this._ipMask != null || this._iMaskLen != -1;
    }

    public boolean isReadOnly() {
        XDMInterfaceBase xif;
        XDMInterfaces xifs;
        DeviceBase dev;
        boolean bRO = super.isReadOnly();
        if (this._ifNameGlobal != null && (dev = (DeviceBase)this.getDevice()) != null && (xifs = dev.getIfs()) != null && (xif = xifs.getIfFromString(this._ifNameGlobal)) != null) {
            bRO = bRO || xif.getIpAddr() == null;
        }
        return bRO;
    }

    public void populate(ConfigValues config, CmdValues cmdVals) {
    }

    public void setAddressMapping(IPAddress ipLocal, int portLocal, IPAddress ipGlobal, int portGlobal, int portType) {
        this.setModified();
        this._ipLocal = ipLocal;
        this._ipGlobal = ipGlobal;
        this._ifNameGlobal = null;
        this._ipMask = null;
        this._iPortLocal = portLocal;
        this._iPortGlobal = portGlobal;
        this._iPortType = portType;
        this._iMaskLen = -1;
    }

    public void setAddressMapping(IPAddress ipLocal, int portLocal, String ifName, int portGlobal, int portType) {
        this.setModified();
        this._ipLocal = ipLocal;
        this._ipGlobal = null;
        this._ifNameGlobal = ifName;
        this._ipMask = null;
        this._iPortLocal = portLocal;
        this._iPortGlobal = portGlobal;
        this._iPortType = portType;
        this._iMaskLen = -1;
    }

    public void setAddressMapping(IPAddress ipLocal, IPAddress ipGlobal) {
        this.setModified();
        this._ipLocal = ipLocal;
        this._ipGlobal = ipGlobal;
        this._ifNameGlobal = null;
        this._ipMask = null;
        this._iPortLocal = -1;
        this._iPortGlobal = -1;
        this._iPortType = -1;
        this._iMaskLen = -1;
    }

    public void setNetworkMapping(IPAddress ipLocal, IPAddress ipGlobal, int maskLen) {
        this.setModified();
        this._ipLocal = ipLocal;
        this._ipGlobal = ipGlobal;
        this._ifNameGlobal = null;
        this._ipMask = null;
        this._iPortLocal = -1;
        this._iPortGlobal = -1;
        this._iPortType = -1;
        this._iMaskLen = maskLen;
    }

    public void setNetworkMapping(IPAddress ipLocal, IPAddress ipGlobal, Netmask ipMask) {
        this.setModified();
        this._ipLocal = ipLocal;
        this._ipGlobal = ipGlobal;
        this._ifNameGlobal = null;
        this._ipMask = ipMask;
        this._iPortLocal = -1;
        this._iPortGlobal = -1;
        this._iPortType = -1;
        this._iMaskLen = -1;
    }

    public void setRouteMap(String rmap) {
        this._rMap = rmap;
        this.setModified();
    }

    public String toString() {
        String s = this._ipGlobal != null ? "NatStaticRule(" + super.toString() + "):{IP}" + this._ipLocal + "," + this._ipGlobal + "{port}" + this._iPortLocal + "," + this._iPortGlobal + "{mask}" + this._ipMask + "," + this._iMaskLen + "{route-map}" + this._rMap : "NatStaticRule(" + super.toString() + "):{IP}" + this._ipLocal + "," + this._ifNameGlobal + "{port}" + this._iPortLocal + "," + this._iPortGlobal + "{mask}" + this._ipMask + "," + this._iMaskLen + "{route-map}" + this._rMap;
        if (this._iPortType == 1) {
            s = s.concat("{type}tcp");
        } else if (this._iPortType == 2) {
            s = s.concat("{type}udp");
        }
        return s;
    }
}

