/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.nat;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.FilterIf;
import com.cisco.xdm.commonutils.FilterFactory;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.base.XDMSortedCollection;
import com.cisco.xdm.data.nat.RouteMapEntry;
import java.util.Enumeration;
import java.util.Vector;

public class RouteMap
extends XDMSortedCollection {
    private String _name;
    private static final int SEQ_NUMBER_START = 1;

    public RouteMap(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
    }

    public RouteMap(String name) {
        this._name = name;
    }

    public boolean addRouteMapEntry(RouteMapEntry rmapEntry) {
        this.put(new Integer(rmapEntry.getSequenceNumber()), rmapEntry);
        return true;
    }

    public ACL getConsolidatedACL() {
        ACL acl = new ACL(1);
        Enumeration elmts = this.elements();
        while (elmts.hasMoreElements()) {
            RouteMapEntry entry = (RouteMapEntry)elmts.nextElement();
            Vector acls = entry.getACLs();
            if (acls == null || acls.size() == 0) continue;
            int i = 0;
            while (i < acls.size()) {
                ACL rmAcl;
                String strRMAcl = (String)acls.elementAt(i);
                if (strRMAcl != null && (rmAcl = (ACL)((DeviceBase)this.getDevice()).getAcls().get(strRMAcl)) != null) {
                    Enumeration enumACEs = rmAcl.getACEs();
                    while (enumACEs.hasMoreElements()) {
                        ACEInterface ace = (ACEInterface)enumACEs.nextElement();
                        ExtendedACE tmp = (ExtendedACE)((ExtendedACE)ace).clone();
                        if (acl.isDuplicateACE(tmp)) continue;
                        acl.addACE(tmp);
                    }
                }
                ++i;
            }
        }
        return acl;
    }

    public String getName() {
        return this._name;
    }

    public int getNextSequenceNumber() {
        Enumeration entries = this.keys();
        if (!entries.hasMoreElements()) {
            return 1;
        }
        int seqNumber = 0;
        while (entries.hasMoreElements()) {
            seqNumber = (Integer)entries.nextElement();
        }
        return seqNumber + 1;
    }

    public boolean isBackupRouteMap() {
        return this._name.indexOf("SDM_BACKUP_RMAP_") != -1;
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException {
        FilterIf routeMapFilter = FilterFactory.getKeywordValueFilter("route-map", null, "MapTag", this.getName());
        ConfigValues routeMap = configValues.getCmds(routeMapFilter);
        if (routeMap == null) {
            return;
        }
        CmdValues rMapEntry = null;
        int count = 0;
        while (count < routeMap.numCmds()) {
            rMapEntry = routeMap.getCmdValues(count);
            RouteMapEntry routeMapEntry = new RouteMapEntry(this, false);
            routeMapEntry.setName(this.getName());
            routeMapEntry.populate(configValues, rMapEntry);
            this.put(new Integer(routeMapEntry.getSequenceNumber()), routeMapEntry);
            ++count;
        }
    }

    public void setName(String name) {
        this._name = name;
    }
}

