/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.nat;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.FilterIf;
import com.cisco.xdm.commonutils.FilterFactory;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.nat.RouteMap;

public class RouteMapCollection
extends XDMHashCollection {
    private static final String CMAP_NAME = "SDM_RMAP_";
    public static final String BACKUP_CMAP_NAME = "SDM_BACKUP_RMAP_";

    public RouteMapCollection() {
    }

    public RouteMapCollection(XDMObject parent) {
        super(parent, false);
    }

    public RouteMapCollection(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
    }

    public boolean addRouteMap(RouteMap mapSet) {
        this.put(mapSet.getName(), mapSet);
        mapSet.setParent(this);
        this.setModified();
        return true;
    }

    public boolean contains(RouteMap mapSet) {
        return super.containsKey(mapSet.getName());
    }

    public boolean containsSet(String name) {
        return super.containsKey(name);
    }

    public String generateRouteMapName() {
        int count = 1;
        while (true) {
            StringBuffer retVal = new StringBuffer(CMAP_NAME);
            retVal.append(Integer.toString(count));
            if (!this.containsSet(retVal.toString())) {
                return retVal.toString();
            }
            ++count;
        }
    }

    public String generateRouteMapNameForBackup() {
        int count = 1;
        while (true) {
            StringBuffer retVal = new StringBuffer(BACKUP_CMAP_NAME);
            retVal.append(Integer.toString(count));
            if (!this.containsSet(retVal.toString())) {
                return retVal.toString();
            }
            ++count;
        }
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException {
        FilterIf routeMapFilter = FilterFactory.getKeywordFilter("route-map", null);
        ConfigValues routeMaps = configValues.getCmds(routeMapFilter);
        if (routeMaps == null) {
            return;
        }
        CmdValues routeMap = null;
        int count = 0;
        while (count < routeMaps.numCmds()) {
            routeMap = routeMaps.getCmdValues(count);
            String mapName = routeMap.getValue("MapTag");
            if (!this.containsKey(mapName)) {
                RouteMap routeMapInfo = new RouteMap(this, false);
                routeMapInfo.setName(mapName);
                routeMapInfo.populate(configValues, cmdVal);
                this.put(routeMapInfo.getName(), routeMapInfo);
            }
            ++count;
        }
    }

    public void removeRouteMap(RouteMap mapSet) {
        this.remove(mapSet.getName());
        this.setModified();
    }
}

