/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.routing;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.MiscUtils;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMEditableVector;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.routing.Network;
import java.util.Enumeration;
import java.util.Vector;

public class DynamicRoute
extends XDMObject
implements Cloneable {
    public static final int RIP = 1;
    public static final int OSPF = 2;
    public static final int EIGRP = 3;
    private int _routingType;
    private XDMEditableVector _networks = new XDMEditableVector();
    private Vector _passiveIntfs;
    private boolean _autoSummaryFlag = false;
    private int _protocolId;
    private boolean _networksReadOnly = false;
    private String _networksReadOnlyReason = "";

    public DynamicRoute() {
        this._networks.setParent(this);
        this._passiveIntfs = new Vector();
    }

    public DynamicRoute(int routingType, int protocolId, XDMObject parent) {
        super(parent);
        this._networks.setParent(this);
        this._passiveIntfs = new Vector();
        this._routingType = routingType;
        this._protocolId = protocolId;
    }

    public DynamicRoute(XDMObject parent) {
        super(parent);
        this._networks.setParent(this);
        this._passiveIntfs = new Vector();
    }

    private void addAllIntfsAsPassiveIntf() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        Vector supportedIfs = ifs.getSupportedPassiveIntfsforDynRting();
        int i = 0;
        while (i < supportedIfs.size()) {
            XDMInterfaceBase item = (XDMInterfaceBase)supportedIfs.elementAt(i);
            this._passiveIntfs.addElement(item.getIfID().toString());
            ++i;
        }
    }

    public boolean addNetworkEntry(Network network) {
        if (network != null && network instanceof Network && !this._networks.contains(network)) {
            this._networks.addElement(network);
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean addPassiveInterface(String intfName) {
        if (intfName != null) {
            this.setModified();
            this._passiveIntfs.addElement(intfName);
            return true;
        }
        return false;
    }

    public Object clone() {
        DynamicRoute newObj = (DynamicRoute)super.clone();
        newObj._networks = (XDMEditableVector)this._networks.clone();
        newObj._networks.setParent(newObj);
        newObj._passiveIntfs = (Vector)this._passiveIntfs.clone();
        return newObj;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DynamicRoute)) {
            return false;
        }
        DynamicRoute tmp = (DynamicRoute)obj;
        if (this._routingType != tmp._routingType) {
            return false;
        }
        if (this._protocolId != tmp._protocolId) {
            return false;
        }
        if (this._networks == null) {
            if (tmp._networks != null) {
                return false;
            }
        } else {
            if (tmp._networks == null) {
                return false;
            }
            if (!this._networks.equals(tmp._networks)) {
                return false;
            }
        }
        if (this._passiveIntfs == null) {
            if (tmp._passiveIntfs != null) {
                return false;
            }
        } else {
            if (tmp._passiveIntfs == null) {
                return false;
            }
            if (!MiscUtils.vectorEquals(this._passiveIntfs, tmp._passiveIntfs)) {
                return false;
            }
        }
        return this._autoSummaryFlag == tmp._autoSummaryFlag;
    }

    public void generateDelta(XDMObject backup, ConfigValues cfgval) throws XDMException {
        if (this.isBackup()) {
            CmdValues cmdval = this.generateRtrCmd(2);
            cfgval.addCmdValues(cmdval);
        } else if (backup == null) {
            CmdValues cmdval = this.generateRtrNewCmd();
            cfgval.addCmdValues(cmdval);
        } else {
            this.generateModifyCommands((DynamicRoute)backup, cfgval);
        }
    }

    private void generateModifyCommands(DynamicRoute backup, ConfigValues cfgval) throws XDMException {
        CmdValues cmdval = this.generateRtrCmd(1);
        ConfigValues subcfgval = new ConfigValues();
        switch (this._routingType) {
            case 1: {
                if (this._protocolId != backup._protocolId) {
                    CmdValues verCmdval = new CmdValues("version");
                    if (this._protocolId == 1 || this._protocolId == 2) {
                        verCmdval.addValue("ripversion", String.valueOf(this._protocolId));
                        verCmdval.setAction(1);
                    } else {
                        verCmdval.setAction(2);
                    }
                    subcfgval.addCmdValues(verCmdval);
                }
            }
            case 3: {
                if (this._autoSummaryFlag != backup._autoSummaryFlag) {
                    CmdValues autosmryCmdVal = new CmdValues("auto-summary");
                    if (!this._autoSummaryFlag) {
                        autosmryCmdVal.setAction(2);
                    } else {
                        autosmryCmdVal.setAction(1);
                    }
                    subcfgval.addCmdValues(autosmryCmdVal);
                }
            }
            case 2: {
                if (this._networks.isModified()) {
                    this._networks.generateDelta(backup._networks, subcfgval);
                }
                this.generatePassiveIntfCmds(backup._passiveIntfs, subcfgval);
                break;
            }
            default: {
                Log.getLog().debug("GenerateDelta(): Unknown Routing type");
                return;
            }
        }
        if (subcfgval.numCmds() > 0) {
            cmdval.setModeCmdsValues(subcfgval);
            cfgval.addCmdValues(cmdval);
        }
    }

    private void generatePassiveIntfCmds(ConfigValues values) {
        int len = this._passiveIntfs.size();
        int i = 0;
        while (i < len) {
            CmdValues cmdval = new CmdValues("passive-interface");
            cmdval.addValue("passiveIntf", (String)this._passiveIntfs.elementAt(i));
            cmdval.setAction(1);
            values.addCmdValues(cmdval);
            ++i;
        }
    }

    private void generatePassiveIntfCmds(Vector backup, ConfigValues values) {
        int i = 0;
        while (i < this._passiveIntfs.size()) {
            String str = (String)this._passiveIntfs.elementAt(i);
            if (!backup.contains(str)) {
                CmdValues cmdval = new CmdValues("passive-interface");
                cmdval.addValue("passiveIntf", str);
                cmdval.setAction(1);
                values.addCmdValues(cmdval);
            }
            ++i;
        }
        int j = 0;
        while (j < backup.size()) {
            String str = (String)backup.elementAt(j);
            if (!this._passiveIntfs.contains(str)) {
                CmdValues cmdval = new CmdValues("passive-interface");
                cmdval.addValue("passiveIntf", str);
                cmdval.setAction(2);
                values.addCmdValues(cmdval);
            }
            ++j;
        }
    }

    private CmdValues generateRtrCmd(int action) {
        CmdValues cmdval = new CmdValues("router");
        switch (this._routingType) {
            case 1: {
                cmdval.addValue("rip", "rip");
                break;
            }
            case 2: {
                cmdval.addValue("ospf", "ospf");
                cmdval.addValue("processId", String.valueOf(this._protocolId));
                break;
            }
            case 3: {
                cmdval.addValue("eigrp", "eigrp");
                cmdval.addValue("as", String.valueOf(this._protocolId));
                break;
            }
            default: {
                Log.getLog().debug("GenerateDelta(): Unknown Routing type");
                return null;
            }
        }
        cmdval.setAction(action);
        return cmdval;
    }

    private CmdValues generateRtrNewCmd() throws XDMException {
        CmdValues cmdval = this.generateRtrCmd(1);
        ConfigValues subcfgval = new ConfigValues();
        switch (this._routingType) {
            case 1: {
                if (this._protocolId == 1 || this._protocolId == 2) {
                    CmdValues verCmdval = new CmdValues("version");
                    verCmdval.addValue("ripversion", String.valueOf(this._protocolId));
                    verCmdval.setAction(1);
                    subcfgval.addCmdValues(verCmdval);
                }
            }
            case 3: {
                CmdValues autosmryCmdVal = new CmdValues("auto-summary");
                if (!this._autoSummaryFlag) {
                    autosmryCmdVal.setAction(2);
                } else {
                    autosmryCmdVal.setAction(1);
                }
                subcfgval.addCmdValues(autosmryCmdVal);
            }
            case 2: {
                if (this._networks.isModified()) {
                    this._networks.generateDelta(null, subcfgval);
                }
                this.generatePassiveIntfCmds(subcfgval);
                break;
            }
            default: {
                Log.getLog().debug("GenerateDelta(): Unknown Routing type");
                return null;
            }
        }
        if (subcfgval.numCmds() > 0) {
            cmdval.setModeCmdsValues(subcfgval);
        }
        return cmdval;
    }

    public boolean getAutoSummaryFlag() {
        return this._autoSummaryFlag;
    }

    public String getHashKey() {
        return DynamicRoute.getHashKey(this._routingType, this._protocolId);
    }

    public static String getHashKey(int routingType) {
        switch (routingType) {
            case 1: {
                return "rip";
            }
            case 2: {
                return "ospf";
            }
            case 3: {
                return "eigrp";
            }
        }
        return null;
    }

    public static String getHashKey(int routingType, int protocolId) {
        switch (routingType) {
            case 1: {
                return "rip";
            }
            case 2: {
                return "ospf-" + protocolId;
            }
            case 3: {
                return "eigrp-" + protocolId;
            }
        }
        return null;
    }

    public XDMEditableVector getNetworks() {
        return this._networks;
    }

    public String getNetworksReadOnlyReason() {
        return this._networksReadOnlyReason;
    }

    public Vector getPassiveIntfs() {
        return this._passiveIntfs;
    }

    public int getProtocolId() {
        return this._protocolId;
    }

    public int getRoutingType() {
        return this._routingType;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isNetworksReadOnly() {
        return this._networksReadOnly;
    }

    public boolean isRoutingEnabled(Network ntwk) {
        if (ntwk == null) {
            return false;
        }
        IPAddress givenNtwk = ntwk.getNetwork();
        if (givenNtwk == null) {
            return false;
        }
        Netmask givenClassBasedMask = Netmask.getClassBasedMaskFromIP(givenNtwk);
        Netmask givenWildcardmask = ntwk.getMask();
        if (givenWildcardmask == null) {
            givenWildcardmask = givenClassBasedMask.reverseMask();
        }
        String givenArea = ntwk.getArea();
        switch (this._routingType) {
            case 1: {
                IPAddress classBasedNtwk = new IPAddress(givenNtwk, Netmask.getClassBasedMaskFromIP(givenNtwk));
                return this.verifyNetwork(classBasedNtwk);
            }
            case 3: {
                return this.verifyNetwork(givenNtwk, givenWildcardmask);
            }
            case 2: {
                if (givenArea == null) {
                    return this.verifyNetwork(givenNtwk, givenWildcardmask);
                }
                return this.verifyNetwork(givenNtwk, givenWildcardmask, givenArea);
            }
        }
        return false;
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log log = Log.getLog();
        log.info("DynamicRoute: populate");
        if (cmdVal != null && cmdVal.getCmdName().equals("router")) {
            if (cmdVal.containsKey("rip")) {
                this._routingType = 1;
            } else if (cmdVal.containsKey("ospf")) {
                this._routingType = 2;
                if (cmdVal.containsKey("processId")) {
                    this._protocolId = Integer.parseInt(cmdVal.getValue("processId"));
                }
            } else if (cmdVal.containsKey("eigrp")) {
                this._routingType = 3;
                if (cmdVal.containsKey("as")) {
                    this._protocolId = Integer.parseInt(cmdVal.getValue("as"));
                }
            } else {
                log.info("DynamicRoute: Unsupported routing type");
                return;
            }
            ConfigValues subCmdCfgVal = cmdVal.getModeCmdsValues();
            int numberOfCmds = subCmdCfgVal.numCmds();
            int i = 0;
            while (i < numberOfCmds) {
                CmdValues eachCmdValue = subCmdCfgVal.getCmdValues(i);
                String cmdName = eachCmdValue.getCmdName();
                if (cmdName.equals("network") && eachCmdValue.containsKey("networkIp")) {
                    String networkaddr = eachCmdValue.getValue("networkIp");
                    IPAddress ntwkIp = new IPAddress(networkaddr);
                    Network ntwk = new Network(ntwkIp, this._networks);
                    if (eachCmdValue.containsKey("mask")) {
                        String maskaddr = eachCmdValue.getValue("mask");
                        Netmask mask = new Netmask(maskaddr);
                        ntwk.setMask(mask);
                    }
                    if (this._routingType == 2 && eachCmdValue.containsKey("areaId")) {
                        String areaStr = eachCmdValue.getValue("areaId");
                        ntwk.setArea(areaStr);
                    }
                    this._networks.addElement(ntwk);
                }
                if (cmdName.equals("passive-interface") && eachCmdValue.containsKey("passiveIntf")) {
                    String intf = eachCmdValue.getValue("passiveIntf");
                    if (intf.equals("default")) {
                        Log.getLog().debug("DynamicRoute: 'default' passive intf  found. So adding all intfs aspassive intfs.");
                        this.addAllIntfsAsPassiveIntf();
                    } else if (eachCmdValue.isNoCmd()) {
                        this._passiveIntfs.removeElement(intf);
                    } else {
                        this._passiveIntfs.addElement(intf);
                    }
                }
                if (cmdName.equals("auto-summary")) {
                    this._autoSummaryFlag = !eachCmdValue.isNoCmd();
                }
                if (cmdName.equals("version") && eachCmdValue.containsKey("ripversion")) {
                    this._protocolId = Integer.parseInt(eachCmdValue.getValue("ripversion"));
                }
                if (cmdName.equals("area")) {
                    Log.getLog().debug("Found area command. So making networks vector as readonly....");
                    this._networksReadOnly = true;
                    this._networksReadOnlyReason = "Found unsupported 'area' commands. So Networks can not be edited.";
                }
                ++i;
            }
        }
    }

    public void print() {
        Object elem;
        Enumeration e;
        Log.getLog().debug("DynamicRoute: print()");
        if (this._routingType == 1) {
            Log.getLog().debug("     Routing Protocol is RIP");
        } else if (this._routingType == 2) {
            Log.getLog().debug("     Routing Protocol is OSPF");
        } else if (this._routingType == 3) {
            Log.getLog().debug("     Routing Protocol is EIGRP");
        }
        Log.getLog().debug("      RIP Version/OSPF Process id/EIGRP Autonomous System Number = " + this._protocolId);
        if (this._networks != null) {
            e = this._networks.elements();
            while (e.hasMoreElements()) {
                elem = (Network)e.nextElement();
                ((Network)elem).print();
            }
        }
        if (this._networksReadOnly) {
            Log.getLog().debug("      Found unsupported area commands, so Network vector is read only ");
        } else {
            Log.getLog().debug("      Network vector is read write. ");
        }
        if (this._passiveIntfs != null) {
            e = this._passiveIntfs.elements();
            while (e.hasMoreElements()) {
                elem = (String)e.nextElement();
                Log.getLog().debug("     Passive Interface is " + (String)elem);
            }
        }
        Log.getLog().debug("      Auto Summary flag is " + this._autoSummaryFlag);
    }

    public boolean removeNetworkEntry(Network network) {
        if (network != null && network instanceof Network) {
            this.setModified();
            return this._networks.removeElement(network);
        }
        return false;
    }

    public boolean removePassiveInterface(String intfName) {
        if (intfName != null) {
            this.setModified();
            return this._passiveIntfs.removeElement(intfName);
        }
        return false;
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        this._networks.resetModifiedFlag();
    }

    public void setAutoSummaryFlag(boolean flag) {
        this._autoSummaryFlag = flag;
        this.setModified();
    }

    public boolean setRIPVersion(int id) {
        Log.getLog().debug("DynamicRoute:SetRIPVersion: " + id);
        if (this._routingType == 1 && (id == 0 || id == 1 || id == 2)) {
            this._protocolId = id;
            this.setModified();
            return true;
        }
        return false;
    }

    private boolean verifyNetwork(IPAddress ntwk) {
        if (this._networks == null || this._networks.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this._networks.size()) {
            Network eachNetwork = (Network)this._networks.elementAt(i);
            IPAddress addr = eachNetwork.getNetwork();
            if (ntwk.equals(addr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean verifyNetwork(IPAddress ntwk, Netmask wildcardmask) {
        if (this._networks == null || this._networks.size() == 0) {
            return false;
        }
        Netmask mask = wildcardmask.reverseMask();
        int i = 0;
        while (i < this._networks.size()) {
            Netmask eachWildcardMask;
            Netmask eachMask;
            Network eachNetwork = (Network)this._networks.elementAt(i);
            IPAddress eachNtwk = eachNetwork.getNetwork();
            if (IPAddress.verifyNetwork(ntwk, mask, eachNtwk, eachMask = (eachWildcardMask = eachNetwork.getMask()) == null ? Netmask.getClassBasedMaskFromIP(eachNtwk) : eachWildcardMask.reverseMask())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean verifyNetwork(IPAddress ntwk, Netmask wildcardmask, String area) {
        if (this._networks == null || this._networks.size() == 0) {
            return false;
        }
        Netmask mask = wildcardmask.reverseMask();
        int i = 0;
        while (i < this._networks.size()) {
            Network eachNetwork = (Network)this._networks.elementAt(i);
            IPAddress eachNtwk = eachNetwork.getNetwork();
            Netmask eachWildcardMask = eachNetwork.getMask();
            Netmask eachMask = eachWildcardMask == null ? Netmask.getClassBasedMaskFromIP(eachNtwk) : eachWildcardMask.reverseMask();
            String eachArea = eachNetwork.getArea();
            if (IPAddress.verifyNetwork(ntwk, mask, eachNtwk, eachMask) && area.equals(eachArea)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

