/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.routing;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.routing.DynamicRoute;
import com.cisco.xdm.data.routing.Network;
import java.util.Enumeration;
import java.util.Vector;

public class DynamicRouteColl
extends XDMHashCollection {
    public DynamicRouteColl() {
    }

    public DynamicRouteColl(XDMObject parent) {
        super(parent);
    }

    public void addDynamicRoute(DynamicRoute dynRt) {
        String key = dynRt.getHashKey();
        super.put(key, dynRt);
        this.setModified();
    }

    public Object clone() {
        DynamicRouteColl newObj = (DynamicRouteColl)super.clone();
        return newObj;
    }

    public DynamicRoute getDynamicRoute(int routingType, int protocolId) {
        String key;
        switch (routingType) {
            case 1: {
                key = "rip";
                break;
            }
            case 2: {
                key = "ospf-" + protocolId;
                break;
            }
            case 3: {
                key = "eigrp-" + protocolId;
                break;
            }
            default: {
                key = "unknown";
            }
        }
        return (DynamicRoute)super.get(key);
    }

    public boolean isPassiveIntf(String intfName, int routingType) {
        if (intfName == null) {
            return false;
        }
        intfName.trim();
        Log.getLog().debug("DynamicRouteColl: isPassiveIntf: intf name is " + intfName);
        String rtingType = DynamicRoute.getHashKey(routingType);
        if (rtingType == null) {
            return false;
        }
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(rtingType) < 0) continue;
            Vector passiveIntfs = ((DynamicRoute)super.get(key)).getPassiveIntfs();
            int i = 0;
            while (i < passiveIntfs.size()) {
                String eachPassiveIntf = (String)passiveIntfs.elementAt(i);
                if (intfName.equalsIgnoreCase(eachPassiveIntf)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Vector isRoutingEnabled(Network ntwk) {
        Vector<DynamicRoute> retVal = new Vector<DynamicRoute>();
        if (ntwk == null || ntwk.getNetwork() == null || ntwk.getMask() == null) {
            return retVal;
        }
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            DynamicRoute dynRt = (DynamicRoute)super.get(key);
            if (!dynRt.isRoutingEnabled(ntwk)) continue;
            retVal.addElement(dynRt);
        }
        return retVal;
    }

    public boolean isRoutingEnabled(String intfName, int routingType) {
        Netmask mask;
        IPAddress ipAddr;
        XDMInterfaces intfs = ((DeviceBase)this.getDevice()).getIfs();
        XDMInterfaceBase intf = intfs.getIfFromString(intfName);
        if (intf == null) {
            return false;
        }
        IfIPAddress addr = intf.getIpAddr();
        if (addr == null) {
            return false;
        }
        IPAddressType type = addr.getIPAddressType();
        if (type == null) {
            return false;
        }
        if (type == IPAddressType.STATIC) {
            ipAddr = addr.getIPAddress();
            mask = addr.getNetmask();
        } else if (type == IPAddressType.UNNUMBERED) {
            ipAddr = addr.getIPUnnumIntfIPAddress();
            mask = addr.getIPUnnumIntfNetmask();
        } else {
            return false;
        }
        if (ipAddr == null || mask == null) {
            return false;
        }
        Network ntwk = new Network(ipAddr, mask.reverseMask());
        Vector routingsFound = this.isRoutingEnabled(ntwk);
        if (routingsFound == null || routingsFound.size() == 0) {
            return false;
        }
        String rtingType = DynamicRoute.getHashKey(routingType);
        if (rtingType == null) {
            return false;
        }
        int i = 0;
        while (i < routingsFound.size()) {
            DynamicRoute dynRt = (DynamicRoute)routingsFound.elementAt(i);
            if (dynRt.getHashKey().indexOf(rtingType) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRoutingEnabled(String intfName, String routingType) {
        Netmask mask;
        IPAddress ipAddr;
        if (intfName == null || routingType == null) {
            return false;
        }
        XDMInterfaces intfs = ((DeviceBase)this.getDevice()).getIfs();
        XDMInterfaceBase intf = intfs.getIfFromString(intfName);
        if (intf == null) {
            return false;
        }
        IfIPAddress addr = intf.getIpAddr();
        if (addr == null) {
            return false;
        }
        IPAddressType type = addr.getIPAddressType();
        if (type == null) {
            return false;
        }
        if (type == IPAddressType.STATIC) {
            ipAddr = addr.getIPAddress();
            mask = addr.getNetmask();
        } else if (type == IPAddressType.UNNUMBERED) {
            ipAddr = addr.getIPUnnumIntfIPAddress();
            mask = addr.getIPUnnumIntfNetmask();
        } else {
            return false;
        }
        if (ipAddr == null || mask == null) {
            return false;
        }
        Network ntwk = new Network(ipAddr, mask.reverseMask());
        DynamicRoute dynRt = (DynamicRoute)super.get(routingType);
        return dynRt.isRoutingEnabled(ntwk);
    }

    public void populate(ConfigValues configValues, CmdValues cmdval) throws XDMException, CliGPBException {
        Log log = Log.getLog();
        log.info("DynamicRouteColl: populate");
        Log.getLog().debug(".............  DynamicRouteColl: populate: start");
        int numberOfCmds = configValues.numCmds();
        int i = 0;
        while (i < numberOfCmds) {
            CmdValues eachCmdValue = configValues.getCmdValues(i);
            String cmdName = eachCmdValue.getCmdName();
            if (cmdName.equals("router")) {
                DynamicRoute route = new DynamicRoute(this);
                route.populate(configValues, eachCmdValue);
                String key = route.getHashKey();
                super.put(key, route);
            }
            ++i;
        }
        Log.getLog().debug(".............  DynamicRouteColl: populate: end");
        this.print();
        Log.getLog().debug(".............  DynamicRouteColl: populate: print end");
    }

    public void print() {
        Enumeration e = this._hashTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            XDMObject obj = super.get(key);
            if (obj == null) continue;
            DynamicRoute tmp = (DynamicRoute)obj;
            tmp.print();
        }
    }

    public void removeDynamicRoute(int routingType, int protocolId) {
        String key;
        switch (routingType) {
            case 1: {
                key = "rip";
                break;
            }
            case 2: {
                key = "ospf-" + protocolId;
                break;
            }
            case 3: {
                key = "eigrp-" + protocolId;
                break;
            }
            default: {
                key = "unknown";
            }
        }
        super.remove(key);
        this.setModified();
    }
}

