/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.routing;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;

public class Network
extends XDMObject
implements Cloneable {
    protected IPAddress _network;
    protected Netmask _mask;
    protected String _area;

    public Network() {
    }

    public Network(IPAddress network) {
        this._network = network;
    }

    public Network(IPAddress network, XDMObject parent) {
        super(parent);
        this._network = network;
    }

    public Network(IPAddress network, Netmask wildcardmask) {
        this._network = network;
        this._mask = wildcardmask;
    }

    public Object clone() {
        Network newObj = (Network)super.clone();
        if (this._network != null) {
            newObj._network = (IPAddress)this._network.clone();
        }
        if (this._mask != null) {
            newObj._mask = (Netmask)this._mask.clone();
        }
        return newObj;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Network)) {
            return false;
        }
        Network tmp = (Network)obj;
        if (this._network == null) {
            if (tmp._network != null) {
                return false;
            }
        } else {
            if (tmp._network == null) {
                return false;
            }
            if (!this._network.equals(tmp._network)) {
                return false;
            }
        }
        if (this._mask == null) {
            if (tmp._mask != null) {
                return false;
            }
        } else {
            if (tmp._mask == null) {
                return false;
            }
            if (!this._mask.equals(tmp._mask)) {
                return false;
            }
        }
        if (this._area == null) {
            if (tmp._area != null) {
                return false;
            }
        } else {
            if (tmp._area == null) {
                return false;
            }
            if (!this._area.equals(tmp._area)) {
                return false;
            }
        }
        return true;
    }

    public void generateDelta(XDMObject backup, ConfigValues cfgVals) {
        if (this._network == null) {
            return;
        }
        CmdValues cmdval = new CmdValues("network");
        cmdval.addValue("networkIp", this._network.toString());
        if (this._mask != null) {
            cmdval.addValue("mask", this._mask.toString());
        }
        if (this._area != null) {
            cmdval.addValue("area", "area");
            cmdval.addValue("areaId", this._area);
        }
        if (this.isBackup()) {
            cmdval.setAction(2);
        } else {
            cmdval.setAction(1);
        }
        cfgVals.addCmdValues(cmdval);
    }

    public String getArea() {
        return this._area;
    }

    public Netmask getMask() {
        return this._mask;
    }

    public IPAddress getNetwork() {
        return this._network;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException, CliGPBException {
    }

    public void print() {
        if (this._network != null) {
            Log.getLog().debug("Network is " + this._network);
        }
        if (this._mask != null) {
            Log.getLog().debug("wildcard Mask is " + this._mask);
        }
        if (this._area != null) {
            Log.getLog().debug("Area is " + this._area);
        }
    }

    public boolean setArea(String area) {
        block3: {
            try {
                Long areaInt = new Long(area);
                Long maxValue = new Long("4294967295");
                if (areaInt < 0L || areaInt > maxValue) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (IPAddress.isLegalIPAddress(area)) break block3;
                return false;
            }
        }
        this._area = area;
        this.setModified();
        return true;
    }

    public void setMask(Netmask mask) {
        this._mask = mask;
        this.setModified();
    }

    public void setNetwork(IPAddress ntwk) {
        this._network = ntwk;
        this.setModified();
    }

    public static boolean validateArea(String area) {
        block3: {
            try {
                Long areaInt = new Long(area);
                Long maxValue = new Long("4294967295");
                if (areaInt < 0L || areaInt > maxValue) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (IPAddress.isLegalIPAddress(area)) break block3;
                return false;
            }
        }
        return true;
    }
}

