/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.routing;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;

public class StaticRoute
extends XDMObject
implements Cloneable {
    public static final int VALID_NTWK_MASK = 1;
    public static final int INVALID_DEST_NTWK = 2;
    public static final int INVALID_NTWK_MASK = 3;
    private IPAddress _prefix;
    private Netmask _mask;
    private IPAddress _nextHopIp;
    private IfID _nextHopIntf;
    private int _adminDist;
    private boolean _permanentFlag;
    private boolean _trackFlag;
    private int _trackObjectNo;

    public StaticRoute() {
    }

    public StaticRoute(XDMObject parent) {
        super(parent);
    }

    public Object clone() {
        StaticRoute newObj = (StaticRoute)super.clone();
        if (this._prefix != null) {
            newObj._prefix = (IPAddress)this._prefix.clone();
        }
        if (this._mask != null) {
            newObj._mask = (Netmask)this._mask.clone();
        }
        if (this._nextHopIp != null) {
            newObj._nextHopIp = (IPAddress)this._nextHopIp.clone();
        }
        return newObj;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StaticRoute)) {
            return false;
        }
        StaticRoute tmp = (StaticRoute)obj;
        if (this._prefix == null) {
            if (tmp._prefix != null) {
                return false;
            }
        } else {
            if (tmp._prefix == null) {
                return false;
            }
            if (!this._prefix.equals(tmp._prefix)) {
                return false;
            }
        }
        if (this._mask == null) {
            if (tmp._mask != null) {
                return false;
            }
        } else {
            if (tmp._mask == null) {
                return false;
            }
            if (!this._mask.equals(tmp._mask)) {
                return false;
            }
        }
        if (this._nextHopIp == null) {
            if (tmp._nextHopIp != null) {
                return false;
            }
        } else {
            if (tmp._nextHopIp == null) {
                return false;
            }
            if (!this._nextHopIp.equals(tmp._nextHopIp)) {
                return false;
            }
        }
        if (this._nextHopIntf == null) {
            if (tmp._nextHopIntf != null) {
                return false;
            }
        } else {
            if (tmp._nextHopIntf == null) {
                return false;
            }
            if (!this._nextHopIntf.equals(tmp._nextHopIntf)) {
                return false;
            }
        }
        if (this._adminDist != tmp._adminDist) {
            return false;
        }
        if (this._permanentFlag != tmp._permanentFlag) {
            return false;
        }
        if (this._trackFlag != tmp._trackFlag) {
            return false;
        }
        return this._trackObjectNo == tmp._trackObjectNo;
    }

    public CmdValues generateCmdValues() {
        if (this.isReadOnly()) {
            return null;
        }
        CmdValues cmdval = new CmdValues("ip");
        cmdval.addValue("route", "route");
        if (this._prefix != null) {
            cmdval.addValue("prefix", this._prefix.toString());
        }
        if (this._mask != null) {
            cmdval.addValue("mask", this._mask.toString());
        }
        if (this._nextHopIntf != null) {
            cmdval.addValue("nextHopIntf", this._nextHopIntf.toString());
        } else if (this._nextHopIp != null) {
            cmdval.addValue("nextHopIntfIp", this._nextHopIp.toString());
        }
        if (this._adminDist != 0) {
            cmdval.addValue("distance", String.valueOf(this._adminDist));
        }
        if (this._permanentFlag) {
            cmdval.addValue("permanentFlag", "permanent");
        }
        if (this._trackFlag) {
            cmdval.addValue("track", "track");
            cmdval.addValue("trackObjectNo", String.valueOf(this._trackObjectNo));
        }
        return cmdval;
    }

    public void generateDelta(XDMObject backup, ConfigValues cfgVals) {
        DeviceBase dev;
        DeviceBase currentDev;
        XDMInterfaceBase iface;
        if (this.isBackup() && this._nextHopIntf != null && (iface = (currentDev = (dev = (DeviceBase)this.getDevice()).getCurrentDevice()).getIfs().getIfFromString(this._nextHopIntf.toString())) == null && (!this._trackFlag || this._trackObjectNo <= 0)) {
            return;
        }
        CmdValues cmdval = this.generateCmdValues();
        if (cmdval == null) {
            return;
        }
        if (this.isBackup()) {
            cmdval.setAction(2);
        } else {
            cmdval.setAction(1);
        }
        int index = ((DeviceBase)this.getDevice()).getFirstCmdPosition("ifs", cfgVals, true);
        if (index != -1) {
            cfgVals.insertCmdValues(cmdval, index);
        } else {
            cfgVals.addCmdValues(cmdval);
        }
    }

    public int getAdminDist() {
        return this._adminDist;
    }

    public static int getDefaultAdminDist(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "distance", true);
        int retVal = Integer.parseInt(param.getDefaultValue());
        return retVal;
    }

    public Netmask getMask() {
        return this._mask;
    }

    public static int getMaxAdminDist(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "distance", true);
        return (int)param.getMaxRange();
    }

    public static int getMinAdminDist(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("ip", "distance", true);
        return (int)param.getMinRange();
    }

    public IfID getNextHopIntf() {
        return this._nextHopIntf;
    }

    public IPAddress getNextHopIp() {
        return this._nextHopIp;
    }

    public IPAddress getPrefix() {
        return this._prefix;
    }

    public int getTrackObjectNo() {
        return this._trackObjectNo;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isPermanent() {
        return this._permanentFlag;
    }

    public boolean isTrackPresent() {
        return this._trackFlag;
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException, CliGPBException {
        DeviceBase dev;
        Log log = Log.getLog();
        log.info("StaticRoute: populate");
        if (cmdVal.containsKey("prefix")) {
            this._prefix = new IPAddress(cmdVal.getValue("prefix"));
            log.info("StaticRoute: populate: prefix" + this._prefix);
        }
        if (cmdVal.containsKey("mask")) {
            this._mask = new Netmask(cmdVal.getValue("mask"));
            log.info("StaticRoute: populate: mask" + this._mask);
        }
        if (cmdVal.containsKey("nextHopIntf")) {
            dev = (DeviceBase)this.getDevice();
            this._nextHopIntf = IfID.fromString(cmdVal.getValue("nextHopIntf"), dev.getDevInfoBase().getHWConfig());
            log.info("StaticRoute: populate: next hop interface " + this._nextHopIntf);
            if (this._nextHopIntf.getType() == 1006) {
                log.info("StaticRoute: populate: Found next hop intf as NULL intf. So marking this entry as readonly");
                this.setReadOnly(true);
            }
            if (this._nextHopIntf.getType() == 0) {
                log.info("StaticRoute: populate: Found next hop intf as Un supported  intf. So marking this entry as readonly");
                this.setReadOnly(true);
            }
        }
        if (cmdVal.containsKey("nextHopIntfIp")) {
            try {
                this._nextHopIp = new IPAddress(cmdVal.getValue("nextHopIntfIp"));
                log.info("StaticRoute: populate: next hop interface ip addr " + this._nextHopIp);
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Number format exception with nextHopIntfIp. So treating it as next hop intf");
                dev = (DeviceBase)this.getDevice();
                this._nextHopIntf = IfID.fromString(cmdVal.getValue("nextHopIntfIp"), dev.getDevInfoBase().getHWConfig());
                log.info("StaticRoute: populate: next hop interface " + this._nextHopIntf);
            }
        }
        if (cmdVal.containsKey("distance")) {
            this._adminDist = Integer.parseInt(cmdVal.getValue("distance"));
            log.info("StaticRoute: populate: admin dist " + this._adminDist);
        } else {
            this._adminDist = StaticRoute.getDefaultAdminDist((DeviceBase)this.getDevice());
            log.info("StaticRoute: populate: didn't find admin dist. so setting default value " + this._adminDist);
        }
        if (cmdVal.containsKey("permanentFlag")) {
            this._permanentFlag = true;
            log.info("StaticRoute: populate: permanentflag is " + this._permanentFlag);
        }
        if (cmdVal.containsKey("track")) {
            this._trackFlag = true;
            log.info("StaticRoute: populate: _trackFlag is " + this._trackFlag);
            if (cmdVal.containsKey("trackObjectNo")) {
                this._trackObjectNo = Integer.parseInt(cmdVal.getValue("trackObjectNo"));
                log.info("StaticRoute: populate: _trackObjectNo is " + this._trackObjectNo);
            }
        }
        if (cmdVal.containsKey("tagVal")) {
            log.info("StaticRoute: populate: Found Tag field. So marking this entry as readOnly.");
            this.setReadOnly(true);
        }
        if (cmdVal.containsKey("nameVal")) {
            log.info("StaticRoute: populate: Found 'name' field. So marking this entry as readOnly.");
            this.setReadOnly(true);
        }
    }

    public void print() {
        Log.getLog().debug("StaticRoute: print()");
        if (this._prefix != null) {
            Log.getLog().debug("     Prefix" + this._prefix);
        }
        if (this._mask != null) {
            Log.getLog().debug("     Mask " + this._mask);
        }
        if (this._nextHopIp != null) {
            Log.getLog().debug("     Next Hop IP Address " + this._nextHopIp);
        }
        if (this._nextHopIntf != null) {
            Log.getLog().debug("   Next Hop Interface " + this._nextHopIntf);
        }
        if (this._adminDist > 0) {
            Log.getLog().debug("     Admin distance " + this._adminDist);
        }
        if (this._permanentFlag) {
            Log.getLog().debug("    It is permamnet route");
        }
        if (this._trackFlag) {
            Log.getLog().debug("    Tracking is supported, track object number is: " + this._trackObjectNo);
        }
    }

    public void setAdminDist(int dist) {
        this._adminDist = dist;
        this.setModified();
    }

    public void setMask(Netmask mask) {
        this._mask = mask;
        this.setModified();
    }

    public void setNextHopIntf(IfID nextHopIntf) {
        this._nextHopIntf = nextHopIntf;
        this.setModified();
    }

    public void setNextHopIp(IPAddress nextHopIp) {
        this._nextHopIp = nextHopIp;
        this.setModified();
    }

    public void setPermanent(boolean flag) {
        this._permanentFlag = flag;
        this.setModified();
    }

    public void setPrefix(IPAddress prefix) {
        this._prefix = prefix;
        this.setModified();
    }

    public void setTrack(boolean flag) {
        this._trackFlag = flag;
        this.setModified();
    }

    public void setTrackObjectNo(int trackObjNo) {
        this._trackObjectNo = trackObjNo;
        this.setModified();
    }

    public static int validateNtwkMask(IPAddress ntwk, Netmask mask) {
        IPAddress ntwkAddr = new IPAddress(ntwk, mask);
        if (!ntwkAddr.equals(ntwk)) {
            return 3;
        }
        if (!mask.equals(Netmask.WILD_MASK) && !Netmask.isLegalNetmask(mask)) {
            return 3;
        }
        IPAddress classD = new IPAddress("224.0.0.0");
        if (ntwk.greaterThanOrEqual(classD)) {
            return 2;
        }
        return 1;
    }
}

