/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.serial;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.XDMSubInterface;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import com.cisco.xdm.data.serial.EncapsulationData;
import com.cisco.xdm.data.serial.EncapsulationType;
import com.cisco.xdm.data.serial.FRData;
import com.cisco.xdm.data.serial.SerialInterface;
import com.cisco.xdm.data.serial.SerialSubInterface;
import java.util.Enumeration;

public class EncapsulationFR
extends EncapsulationType {
    public static final int ANSI = 1;
    public static final int CISCO = 2;
    public static final int Q933A = 3;
    public static final int VALUE_NOT_SET = 0;
    static final int LMI_BEGIN = 0;
    static final int LMI_END = 3;
    static final int DLCI_MIN = 16;
    static final int DLCI_MAX = 1007;
    private static final String[] lmiStrs = new String[]{"VALUE_NOT_SET", "ANSI", "CISCO", "Q933A"};
    private int _iDlci;
    private boolean _bIetf;
    private int _iLmiType;
    private Log _theLog;

    public EncapsulationFR(XDMObject parent) {
        super("frame-relay", parent);
        this.init(false);
    }

    public EncapsulationFR(XDMObject parent, boolean bIetf) {
        super("frame-relay", parent);
        this.init(bIetf);
    }

    public Object clone() {
        EncapsulationFR encap = (EncapsulationFR)super.clone();
        encap._iDlci = this._iDlci;
        encap._iLmiType = this._iLmiType;
        encap._bIetf = this._bIetf;
        return encap;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EncapsulationFR) || !super.equals(o)) {
            return false;
        }
        EncapsulationFR encap = (EncapsulationFR)o;
        return encap._iDlci == this._iDlci && encap._iLmiType == this._iLmiType && encap._bIetf == this._bIetf;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        EncapsulationType backupEncap = (EncapsulationType)backup;
        if (this.equals(backupEncap)) {
            return;
        }
        super.generateDelta(backup, values);
        CmdValues cmd = new CmdValues("encapsulation");
        cmd.addValue("encapType", "frame-relay");
        if (this._bIetf) {
            cmd.addValue("IETF", "IETF");
        }
        values.addCmdValues(cmd);
        EncapsulationFR backupFR = null;
        if (backupEncap instanceof EncapsulationFR) {
            backupFR = (EncapsulationFR)backupEncap;
        }
        if (this._iDlci != 0 && (backupFR == null || this._iDlci != backupFR._iDlci)) {
            cmd = new CmdValues("frame-relay");
            cmd.addValue("interface-dlci", "interface-dlci");
            cmd.addValue("dlci", Integer.toString(this._iDlci));
            values.addCmdValues(cmd);
        }
        if (backupFR == null || this._iLmiType != backupFR._iLmiType) {
            cmd = new CmdValues("frame-relay");
            cmd.addValue("lmi-type", "lmi-type");
            String lmitype = "";
            if (this._iLmiType == 0) {
                if (backupFR != null) {
                    cmd.setAction(2);
                    lmitype = this.strLmiType(backupFR._iLmiType);
                }
            } else {
                lmitype = this.strLmiType(this._iLmiType);
            }
            if (!lmitype.equals("")) {
                cmd.addValue("lmiType", lmitype);
                values.addCmdValues(cmd);
            }
        }
    }

    public int getDLCI() {
        return this._iDlci;
    }

    public boolean getIETF() {
        return this._bIetf;
    }

    public int getLMIType() {
        return this._iLmiType;
    }

    private void init(boolean bIetf) {
        this._iDlci = 0;
        this._iLmiType = 0;
        this._bIetf = bIetf;
        this._theLog = Log.getLog();
    }

    public boolean isDlciInUse(int dlci) {
        XDMObject o = this.getParent();
        if (o == null || !(o instanceof SerialInterface)) {
            return false;
        }
        SerialInterface serif = (SerialInterface)o;
        XDMSubInterfaces subifs = serif.getSubInterfaces();
        if (subifs == null) {
            return false;
        }
        Enumeration e = subifs.keys();
        while (e.hasMoreElements()) {
            FRData frd;
            SerialSubInterface sersubif;
            EncapsulationData data;
            XDMSubInterface subif = (XDMSubInterface)subifs.get(e.nextElement());
            if (!(subif instanceof SerialSubInterface) || (data = (sersubif = (SerialSubInterface)subif).getEncapsulationData()) == null || !(data instanceof FRData) || (frd = (FRData)data).getDLCI() != dlci) continue;
            return true;
        }
        return this.getDLCI() == dlci;
    }

    public void populate(ConfigValues config, CmdValues cmdVals) throws CliGPBException {
        CmdValues cv;
        ConfigValues cmds = cmdVals.getModeCmdsValues();
        ConfigValues frDLCICmd = cmds.getCmds("frame-relay", "interface-dlci", ".*", false);
        ConfigValues frLMICmd = cmds.getCmds("frame-relay", "lmi-type", ".*", false);
        ConfigValues frMapCmds = cmds.getCmds("frame-relay", "map", ".*", false);
        if (frDLCICmd != null) {
            cv = frDLCICmd.getCmdValues(0);
            String dlci = cv.getValue("dlci");
            this._iDlci = Integer.parseInt(dlci);
            SerialInterface serif = (SerialInterface)this.getParent();
            serif.setConfigurable(false);
        }
        if (frLMICmd != null) {
            cv = frLMICmd.getCmdValues(0);
            String lmitype = cv.getValue("lmiType");
            if (lmitype.equals("cisco")) {
                this._iLmiType = 2;
            } else if (lmitype.equals("ansi")) {
                this._iLmiType = 1;
            } else if (lmitype.equals("q933a")) {
                this._iLmiType = 3;
            }
        }
        if (frMapCmds != null) {
            SerialInterface serif = (SerialInterface)this.getParent();
            serif.setConfigurable(false);
        }
    }

    public void setDLCI(int dlci) throws XDMException {
    }

    public void setIETF(boolean bIetf) {
        this.setModified();
        this._bIetf = bIetf;
    }

    public void setLMIType(int lmiType) throws XDMException {
        if (lmiType < 0 || lmiType > 3) {
            throw new XDMException(202, this);
        }
        this.setModified();
        this._iLmiType = lmiType;
    }

    private String strLmiType(int iLmi) {
        if (iLmi == 2) {
            return "cisco";
        }
        if (iLmi == 1) {
            return "ansi";
        }
        if (iLmi == 3) {
            return "q933a";
        }
        return "";
    }

    public String toString() {
        return "Encapsulation:{dlci:" + Integer.toString(this._iDlci) + "#lmi:" + lmiStrs[this._iLmiType] + (this._bIetf ? "#ietf" : "") + "}";
    }
}

