/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.MiscUtils;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.util.Enumeration;
import java.util.Vector;

public class Line
extends XDMObject
implements Cloneable {
    public static final int LINE = 0;
    public static final int AUX = 1;
    public static final int CONSOLE = 2;
    public static final int TTY = 3;
    public static final int VTY = 4;
    static final String KEY_LINE = "line";
    static final String KEY_VTY = "vty";
    static final String KEY_CONSOLE = "con";
    static final String KEY_TTY = "tty";
    static final String KEY_AUX = "aux";
    private static final String[] TYPES = new String[]{"line", "aux", "con", "tty", "vty"};
    private int _start = -1;
    private int _end = -1;
    private String _loc;
    private int _type = 4;
    public static final int LOGIN = 0;
    public static final int LOGIN_LOCAL = 1;
    public static final int LOGIN_TACACS = 2;
    private boolean _login = false;
    private int _loginOption = 0;
    private String _authen = "";
    private String _author = "";
    private int _privilege = -1;
    private Vector _cmdAuthors = null;
    private int _execTimeoutMin = 10;
    private int _execTimeoutSec = 0;
    private String _acIn = "";
    private String _acOut = "";
    private Vector _transInProtocols;
    private Vector _transOutProtocols;
    private static Vector _protocols = null;
    private boolean _modemEnable = false;
    private boolean _modemAutoDiscovery = false;
    public static final String KEY_MODEM = "modem";
    public static final String KEY_INOUT = "InOut";
    public static final String KEY_AUTO_SELECT = "autoselect";
    public static final String KEY_PPP = "ppp";
    public static final String KEY_EXEC = "exec";
    public static final String KEY_ENABLE = "enable";
    public static final String KEY_AUTO_CONF = "autoconfigure";
    public static final String KEY_DISC = "discovery";
    private String _lineProtocol = "";
    private String _inOut = "";
    private String _exec = "";
    static final String KEY_START = "start";
    static final String KEY_END = "end";
    static final String KEY_LOGIN = "login";
    static final String KEY_METHOD = "method";
    static final String KEY_LOCAL = "local";
    static final String KEY_TACACS = "tacacs";
    static final String KEY_EXEC_TIMEOUT = "exec-timeout";
    static final String KEY_MIN = "min";
    static final String KEY_SEC = "sec";
    static final String KEY_ACCESS_CLASS = "access-class";
    static final String KEY_AC = "ac";
    static final String KEY_DIR = "dir";
    static final String KEY_IN = "in";
    static final String KEY_OUT = "out";
    static final String KEY_VRF_ALSO = "vrf-also";
    static final String KEY_TRANSPORT = "transport";
    static final String KEY_INPUT = "input";
    static final String KEY_SSH = "ssh";
    static final String KEY_OUTPUT = "output";
    static final String KEY_ALL = "all";
    static final String KEY_NONE = "none";
    static final String KEY_PAD = "pad";
    static final String KEY_TELNET = "telnet";
    static final String KEY_UDPTN = "udptn";
    static final String KEY_RLOGIN = "rlogin";
    static final String KEY_LAPB_TA = "lapb-ta";
    static final String KEY_LAT = "lat";
    static final String KEY_MOP = "mop";
    static final String KEY_V120 = "v120";
    static final String KEY_NAME = "NAME";
    static final String KEY_AUTHENTICATION = "authentication";
    static final String KEY_AUTHORIZATION = "authorization";
    static final String KEY_EXE = "exec";
    static final String KEY_PRIVILEGE = "privilege";
    static final String KEY_LEVEL = "level";
    static final String KEY_LVL = "LVL";
    static final String KEY_LIST_NAME = "LIST_NAME";
    static final String KEY_COMMANDS = "commands";

    public Line() {
        this.initialize();
    }

    public Line(int start, int end) {
        this._start = start;
        this._end = end;
        this._loc = "";
        this.initialize();
    }

    public Line(int start, int end, int type) {
        this._loc = "";
        this._type = type;
        this._start = start;
        this._end = end;
        this.initialize();
    }

    public Line(String location, int start, int end, int type) {
        this._loc = location;
        this._type = type;
        this._start = start;
        this._end = end;
        this.initialize();
    }

    public Object clone() {
        Line newObj = (Line)super.clone();
        newObj._transInProtocols = new Vector();
        int i = 0;
        while (i < this._transInProtocols.size()) {
            newObj._transInProtocols.addElement(this._transInProtocols.elementAt(i));
            ++i;
        }
        if (this._cmdAuthors != null) {
            newObj._cmdAuthors = new Vector();
            MiscUtils.copyVector(this._cmdAuthors, newObj._cmdAuthors);
        }
        newObj._transOutProtocols = new Vector();
        int i2 = 0;
        while (i2 < this._transOutProtocols.size()) {
            newObj._transOutProtocols.addElement(this._transOutProtocols.elementAt(i2));
            ++i2;
        }
        return newObj;
    }

    private boolean compareTransProtocols(Vector trans1, Vector trans2) {
        if (trans1.size() != trans2.size()) {
            return false;
        }
        int i = 0;
        while (i < trans1.size()) {
            if (!trans2.contains(trans1.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private CmdValues createLineCmd() {
        CmdValues cmd = new CmdValues(KEY_LINE);
        cmd.addValue(TYPES[this._type], TYPES[this._type]);
        StringBuffer sb = new StringBuffer(this._loc);
        if (sb.length() > 0) {
            sb.append("/");
        }
        cmd.addValue(KEY_START, String.valueOf(sb.toString()) + String.valueOf(this._start));
        if (this._end != this._start) {
            cmd.addValue(KEY_END, String.valueOf(sb.toString()) + String.valueOf(this._end));
        }
        return cmd;
    }

    private void discoverProtocolsSupported(IOSCmdService cmd) {
        _protocols = new Vector();
        String[] configCLIs = new String[]{"line 0", "transport output ?"};
        IOSCmdResponse[] resp = null;
        try {
            resp = cmd.config(configCLIs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resp == null || resp.length < 1) {
            return;
        }
        String buf = null;
        buf = resp[1].getOutput();
        if (resp[0].getStatus() != 2 && buf != null && buf.indexOf("% Unrecognized command") < 0) {
            if (buf.indexOf(KEY_ALL) >= 0) {
                _protocols.addElement(KEY_ALL);
            }
            if (buf.indexOf(KEY_NONE) >= 0) {
                _protocols.addElement(KEY_NONE);
            }
            if (buf.indexOf(KEY_SSH) >= 0) {
                _protocols.addElement(KEY_SSH);
            }
            if (buf.indexOf(KEY_TELNET) >= 0) {
                _protocols.addElement(KEY_TELNET);
            }
            if (buf.indexOf(KEY_UDPTN) >= 0) {
                _protocols.addElement(KEY_UDPTN);
            }
            if (buf.indexOf(KEY_PAD) >= 0) {
                _protocols.addElement(KEY_PAD);
            }
            if (buf.indexOf(KEY_RLOGIN) >= 0) {
                _protocols.addElement(KEY_RLOGIN);
            }
            if (buf.indexOf(KEY_LAPB_TA) >= 0) {
                _protocols.addElement(KEY_LAPB_TA);
            }
            if (buf.indexOf(KEY_LAT) >= 0) {
                _protocols.addElement(KEY_LAT);
            }
            if (buf.indexOf(KEY_MOP) >= 0) {
                _protocols.addElement(KEY_MOP);
            }
            if (buf.indexOf(KEY_V120) >= 0) {
                _protocols.addElement(KEY_V120);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Line)) {
            return false;
        }
        Line lObj = (Line)obj;
        return this._type == lObj._type && this._start == lObj._start && this._end == lObj._end && this._login == lObj._login && this._loginOption == lObj._loginOption && this._execTimeoutMin == lObj._execTimeoutMin && this._execTimeoutSec == lObj._execTimeoutSec && this._acIn.equals(lObj._acIn) && this._acOut.equals(lObj._acOut);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        int i;
        CmdValues subcmd;
        if (this._type == 4 && this.isBackup()) {
            return;
        }
        Line bObj = (Line)backup;
        CmdValues cmd = this.createLineCmd();
        if (this.isBackup()) {
            cmd.setAction(2);
            values.addCmdValues(cmd);
            return;
        }
        ConfigValues subcfg = new ConfigValues();
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMObject aaa = dev.getObject("aaa");
        boolean aaaEnable = false;
        if (aaa != null) {
            aaaEnable = (Boolean)aaa.getAttr(KEY_ENABLE);
        }
        if (aaaEnable) {
            if (bObj == null || !this._authen.equals(bObj._authen)) {
                subcmd = new CmdValues(KEY_LOGIN);
                subcmd.addValue(KEY_AUTHENTICATION, KEY_AUTHENTICATION);
                if (this._authen.length() == 0) {
                    subcmd.setAction(2);
                } else {
                    subcmd.addValue(KEY_NAME, this._authen);
                }
                subcfg.addCmdValues(subcmd);
            }
            if (bObj == null || !this._author.equals(bObj._author)) {
                subcmd = new CmdValues(KEY_AUTHORIZATION);
                subcmd.addValue("exec", "exec");
                if (this._author.length() == 0) {
                    subcmd.setAction(2);
                } else {
                    subcmd.addValue(KEY_NAME, this._author);
                }
                subcfg.addCmdValues(subcmd);
            }
        } else {
            subcmd = new CmdValues(KEY_LOGIN);
            if (bObj == null || bObj != null && (this._login != bObj._login || this._loginOption != bObj._loginOption)) {
                if (!this._login) {
                    subcmd.setAction(2);
                } else if (this._loginOption == 1) {
                    subcmd.addValue(KEY_METHOD, KEY_LOCAL);
                } else if (this._loginOption == 2) {
                    subcmd.addValue(KEY_METHOD, KEY_TACACS);
                }
                subcfg.addCmdValues(subcmd);
            }
        }
        if (bObj == null || this._privilege != bObj._privilege) {
            subcmd = new CmdValues(KEY_PRIVILEGE);
            subcmd.addValue(KEY_LEVEL, KEY_LEVEL);
            if (this._privilege < 0) {
                subcmd.setAction(2);
            } else {
                subcmd.addValue(KEY_LVL, String.valueOf(this._privilege));
            }
            subcfg.addCmdValues(subcmd);
        }
        if (bObj == null || bObj != null && (this._execTimeoutMin != bObj._execTimeoutMin || this._execTimeoutSec != bObj._execTimeoutSec)) {
            subcmd = new CmdValues(KEY_EXEC_TIMEOUT);
            subcmd.addValue(KEY_MIN, String.valueOf(this._execTimeoutMin));
            subcmd.addValue(KEY_SEC, String.valueOf(this._execTimeoutSec));
            subcfg.addCmdValues(subcmd);
        }
        if (bObj == null && this._acIn.length() > 0 || bObj != null && !this._acIn.equals(bObj._acIn)) {
            subcmd = new CmdValues(KEY_ACCESS_CLASS);
            subcmd.addValue(KEY_DIR, KEY_IN);
            if (this._acIn.length() == 0) {
                subcmd.addValue(KEY_AC, bObj._acIn);
                subcmd.setAction(2);
            } else {
                subcmd.addValue(KEY_AC, this._acIn);
            }
            subcfg.addCmdValues(subcmd);
        }
        if (bObj == null && this._acOut.length() > 0 || bObj != null && !this._acOut.equals(bObj._acOut)) {
            subcmd = new CmdValues(KEY_ACCESS_CLASS);
            subcmd.addValue(KEY_DIR, KEY_OUT);
            if (this._acOut.length() == 0) {
                subcmd.addValue(KEY_AC, bObj._acOut);
                subcmd.setAction(2);
            } else {
                subcmd.addValue(KEY_AC, this._acOut);
            }
            subcfg.addCmdValues(subcmd);
        }
        if ((bObj == null || bObj != null && !this.compareTransProtocols(this._transInProtocols, bObj._transInProtocols)) && this._transInProtocols.size() > 0) {
            subcmd = new CmdValues(KEY_TRANSPORT);
            subcmd.addValue(KEY_INPUT, KEY_INPUT);
            i = 0;
            while (i < this._transInProtocols.size()) {
                subcmd.addValue((String)this._transInProtocols.elementAt(i), (String)this._transInProtocols.elementAt(i));
                ++i;
            }
            subcfg.addCmdValues(subcmd);
        }
        if ((bObj == null || bObj != null && !this.compareTransProtocols(this._transOutProtocols, bObj._transOutProtocols)) && this._transOutProtocols.size() > 0) {
            subcmd = new CmdValues(KEY_TRANSPORT);
            subcmd.addValue(KEY_OUTPUT, KEY_OUTPUT);
            i = 0;
            while (i < this._transOutProtocols.size()) {
                subcmd.addValue((String)this._transOutProtocols.elementAt(i), (String)this._transOutProtocols.elementAt(i));
                ++i;
            }
            subcfg.addCmdValues(subcmd);
        }
        if (bObj == null || !this._lineProtocol.equals(bObj._lineProtocol)) {
            if (this._lineProtocol.length() > 0) {
                Log.getLog().debug(" *** Generate Delta of line protocol *** ");
                subcmd = new CmdValues(KEY_AUTO_SELECT);
                subcmd.addValue(KEY_PPP, KEY_PPP);
                subcfg.addCmdValues(subcmd);
            } else {
                Log.getLog().debug(" *** Generate DELETE of line protocol *** ");
                subcmd = new CmdValues(KEY_AUTO_SELECT);
                subcmd.addValue(KEY_PPP, KEY_PPP);
                subcmd.setAction(2);
                subcfg.addCmdValues(subcmd);
            }
        }
        if (bObj == null || !this._inOut.equals(bObj._inOut)) {
            if (this._inOut.length() > 0) {
                Log.getLog().debug(" *** Generate Delta of Modem inout *** ");
                subcmd = new CmdValues(KEY_MODEM);
                subcmd.addValue(KEY_INOUT, KEY_INOUT);
                subcfg.addCmdValues(subcmd);
            } else {
                Log.getLog().debug(" *** Generate Delete of Modem inout *** ");
                subcmd = new CmdValues(KEY_MODEM);
                subcmd.addValue(KEY_INOUT, KEY_INOUT);
                subcmd.setAction(2);
                subcfg.addCmdValues(subcmd);
            }
        }
        if (bObj == null && !this._modemEnable || bObj != null && this._modemEnable != bObj._modemEnable) {
            CmdValues subCmd = new CmdValues(KEY_MODEM);
            subCmd.addValue(KEY_ENABLE, KEY_ENABLE);
            if (!this._modemEnable) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (bObj == null && !this._modemAutoDiscovery || bObj != null && this._modemAutoDiscovery != bObj._modemAutoDiscovery) {
            CmdValues subCmd = new CmdValues(KEY_MODEM);
            subCmd.addValue(KEY_AUTO_CONF, KEY_AUTO_CONF);
            subCmd.addValue(KEY_DISC, KEY_DISC);
            if (!this._modemAutoDiscovery) {
                subCmd.setAction(2);
            }
            subcfg.addCmdValues(subCmd);
        }
        if (subcfg.numCmds() > 0) {
            cmd.setModeCmdsValues(subcfg);
        }
        if (backup == null || subcfg.numCmds() > 0) {
            values.addCmdValues(cmd);
        }
    }

    public String getAccessClassIn() {
        return this._acIn;
    }

    public String getAccessClassOut() {
        return this._acOut;
    }

    public String getAuthen() {
        XDMObject aaa;
        String val = this._authen;
        if ((val == null || val.length() == 0) && (aaa = ((DeviceBase)this.getDevice()).getObject("aaa")) != null && ((Boolean)aaa.getAttr(KEY_ENABLE)).booleanValue() && aaa.getObject("ml").getObject("authen login default") != null) {
            val = "default";
        }
        return val;
    }

    public String getAuthor() {
        XDMObject aaa;
        String val = this._author;
        if ((val == null || val.length() == 0) && (aaa = ((DeviceBase)this.getDevice()).getObject("aaa")) != null && ((Boolean)aaa.getAttr(KEY_ENABLE)).booleanValue() && aaa.getObject("ml").getObject("author exec default") != null) {
            val = "default";
        }
        return val;
    }

    public String getCmdAuthor(int level) {
        if (this._cmdAuthors != null) {
            return (String)this._cmdAuthors.elementAt(level);
        }
        return null;
    }

    public int getEnd() {
        return this._end;
    }

    public int getExecTimeoutMin() {
        return this._execTimeoutMin;
    }

    public int getExecTimeoutSec() {
        return this._execTimeoutSec;
    }

    public Enumeration getInputTransProtocols() {
        return this._transInProtocols.elements();
    }

    public String getKey() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._type);
        sb.append(" ");
        if (this._loc != null && this._loc.length() > 0) {
            sb.append(String.valueOf(this._loc) + "/");
        }
        sb.append(this._start);
        if (this._end != this._start) {
            sb.append(" ");
            if (this._loc != null && this._loc.length() > 0) {
                sb.append(String.valueOf(this._loc) + "/");
            }
            sb.append(this._end);
        }
        return sb.toString();
    }

    public String getLineCmdString() {
        StringBuffer sb = new StringBuffer(TYPES[this._type]);
        sb.append(" ");
        if (this._loc != null && this._loc.length() > 0) {
            sb.append(String.valueOf(this._loc) + "/");
        }
        sb.append(this._start);
        if (this._end != this._start) {
            sb.append("/" + this._end);
        }
        return sb.toString();
    }

    public String getLineProtocol() {
        return this._lineProtocol;
    }

    public String getLocation() {
        return this._loc;
    }

    public int getLoginOption() {
        return this._loginOption;
    }

    public boolean getModemAutodiscovery() {
        return this._modemAutoDiscovery;
    }

    public boolean getModemEnable() {
        return this._modemEnable;
    }

    public String getModemInout() {
        return this._inOut;
    }

    public Enumeration getOutputTransProtocols() {
        return this._transOutProtocols.elements();
    }

    private Vector getPossibleProtocols() {
        if (_protocols == null) {
            IOSCmdService cmd = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
            this.discoverProtocolsSupported(cmd);
        }
        return _protocols;
    }

    public int getPrivilege() {
        return this._privilege;
    }

    public int getStart() {
        return this._start;
    }

    public int getType() {
        return this._type;
    }

    private void initialize() {
        this._transInProtocols = new Vector();
        this._transOutProtocols = new Vector();
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isLogin() {
        return this._login;
    }

    public boolean isProtocolSupported(String protocol) {
        Vector prots = this.getPossibleProtocols();
        return prots.contains(protocol);
    }

    public boolean isReadOnly() {
        if (this._transInProtocols.contains(KEY_SSH) && this._transInProtocols.contains(KEY_TELNET)) {
            return this._transOutProtocols.contains(KEY_SSH) && this._transOutProtocols.contains(KEY_TELNET);
        }
        return !this._transOutProtocols.contains(KEY_SSH) || !this._transOutProtocols.contains(KEY_TELNET);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (cmdVal == null || !KEY_LINE.equals(cmdVal.getCmdName())) {
            throw new XDMException(4);
        }
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        if (subCmds != null) {
            int i = 0;
            while (i < subCmds.numCmds()) {
                CmdValues cmd = subCmds.getCmdValues(i);
                String cmdName = cmd.getCmdName();
                if (cmdName.equalsIgnoreCase(KEY_LOGIN)) {
                    if (cmd.containsKey(KEY_AUTHENTICATION)) {
                        this._authen = cmd.getValue(KEY_NAME);
                    } else {
                        String method;
                        this._login = true;
                        this._loginOption = cmd.containsKey(KEY_METHOD) ? ((method = cmd.getValue(KEY_METHOD)).equalsIgnoreCase(KEY_LOCAL) ? 1 : 2) : 0;
                    }
                } else if (cmdName.equalsIgnoreCase(KEY_PRIVILEGE)) {
                    if (cmd.containsKey(KEY_LEVEL)) {
                        this._privilege = Integer.valueOf(cmd.getValue(KEY_LVL));
                    }
                } else if (cmdName.equalsIgnoreCase(KEY_AUTHORIZATION)) {
                    if (cmd.containsKey("exec")) {
                        this._author = cmd.getValue(KEY_NAME);
                    } else if (cmd.containsKey(KEY_COMMANDS)) {
                        int level = new Integer(cmd.getValue(KEY_LVL));
                        if (this._cmdAuthors == null) {
                            this._cmdAuthors = new Vector();
                            int index = 0;
                            while (index <= 15) {
                                this._cmdAuthors.addElement("");
                                ++index;
                            }
                        }
                        this._cmdAuthors.setElementAt(cmd.getValue(KEY_LIST_NAME), level);
                    }
                } else if (cmdName.equalsIgnoreCase(KEY_EXEC_TIMEOUT)) {
                    if (!cmd.isNoCmd()) {
                        this._execTimeoutMin = Integer.valueOf(cmd.getValue(KEY_MIN));
                        if (cmd.containsKey(KEY_SEC)) {
                            this._execTimeoutSec = Integer.valueOf(cmd.getValue(KEY_SEC));
                        }
                    }
                } else if (cmdName.equalsIgnoreCase(KEY_ACCESS_CLASS)) {
                    if (KEY_IN.equalsIgnoreCase(cmd.getValue(KEY_DIR))) {
                        this._acIn = cmd.getValue(KEY_AC);
                    } else {
                        this._acOut = cmd.getValue(KEY_AC);
                    }
                    this.setACLCategory(cmd.getValue(KEY_AC), null);
                } else if (cmdName.equalsIgnoreCase(KEY_TRANSPORT)) {
                    if (cmd.containsKey(KEY_INPUT)) {
                        if (cmd.containsKey(KEY_ALL)) {
                            this.setInputTransProtocols(KEY_ALL);
                        }
                        if (cmd.containsKey(KEY_NONE)) {
                            this.setInputTransProtocols(KEY_NONE);
                        }
                        if (cmd.containsKey(KEY_PAD)) {
                            this.setInputTransProtocols(KEY_PAD);
                        }
                        if (cmd.containsKey(KEY_UDPTN)) {
                            this.setInputTransProtocols(KEY_UDPTN);
                        }
                        if (cmd.containsKey(KEY_TELNET)) {
                            this.setInputTransProtocols(KEY_TELNET);
                        }
                        if (cmd.containsKey(KEY_RLOGIN)) {
                            this.setInputTransProtocols(KEY_RLOGIN);
                        }
                        if (cmd.containsKey(KEY_SSH)) {
                            this.setInputTransProtocols(KEY_SSH);
                        }
                        if (cmd.containsKey(KEY_LAPB_TA)) {
                            this.setInputTransProtocols(KEY_LAPB_TA);
                        }
                        if (cmd.containsKey(KEY_LAT)) {
                            this.setInputTransProtocols(KEY_LAT);
                        }
                        if (cmd.containsKey(KEY_MOP)) {
                            this.setInputTransProtocols(KEY_MOP);
                        }
                        if (cmd.containsKey(KEY_V120)) {
                            this.setInputTransProtocols(KEY_V120);
                        }
                    } else if (cmd.containsKey(KEY_OUTPUT)) {
                        if (cmd.containsKey(KEY_ALL)) {
                            this.setOutputTransProtocols(KEY_ALL);
                        }
                        if (cmd.containsKey(KEY_NONE)) {
                            this.setOutputTransProtocols(KEY_NONE);
                        }
                        if (cmd.containsKey(KEY_PAD)) {
                            this.setOutputTransProtocols(KEY_PAD);
                        }
                        if (cmd.containsKey(KEY_UDPTN)) {
                            this.setOutputTransProtocols(KEY_UDPTN);
                        }
                        if (cmd.containsKey(KEY_TELNET)) {
                            this.setOutputTransProtocols(KEY_TELNET);
                        }
                        if (cmd.containsKey(KEY_RLOGIN)) {
                            this.setOutputTransProtocols(KEY_RLOGIN);
                        }
                        if (cmd.containsKey(KEY_SSH)) {
                            this.setOutputTransProtocols(KEY_SSH);
                        }
                        if (cmd.containsKey(KEY_LAPB_TA)) {
                            this.setOutputTransProtocols(KEY_LAPB_TA);
                        }
                        if (cmd.containsKey(KEY_LAT)) {
                            this.setOutputTransProtocols(KEY_LAT);
                        }
                        if (cmd.containsKey(KEY_MOP)) {
                            this.setOutputTransProtocols(KEY_MOP);
                        }
                        if (cmd.containsKey(KEY_V120)) {
                            this.setOutputTransProtocols(KEY_V120);
                        }
                    }
                } else if (cmdName.equalsIgnoreCase(KEY_MODEM)) {
                    Log.getLog().debug("MODEM Value is : " + cmd.containsKey(KEY_INOUT));
                    Log.getLog().debug("MODEM Value is : " + cmd.containsKey(KEY_AUTO_CONF));
                    Log.getLog().debug("MODEM Value is : " + cmd.containsKey("type"));
                    if (cmd.containsKey(KEY_INOUT)) {
                        this._inOut = KEY_INOUT;
                    }
                    if (cmd.containsKey(KEY_ENABLE) && !cmd.isNoCmd()) {
                        this._modemEnable = true;
                    }
                    if (cmd.containsKey(KEY_AUTO_CONF) && cmd.containsKey(KEY_DISC)) {
                        this._modemAutoDiscovery = true;
                    }
                    if (cmd.containsKey(KEY_AUTO_CONF) && cmd.containsKey("type")) {
                        String scriptName = cmd.getValue("scriptname");
                        Log.getLog().debug("MODEM Value is : " + scriptName);
                    }
                } else if (cmdName.equalsIgnoreCase(KEY_AUTO_SELECT)) {
                    Log.getLog().debug("autoselect contains ppp : " + cmd.containsKey(KEY_PPP));
                    if (cmd.containsKey(KEY_PPP)) {
                        this._lineProtocol = KEY_PPP;
                    }
                } else if (cmdName.equalsIgnoreCase("")) {
                    Log.getLog().debug("autoselect contains ppp : " + cmd.containsKey(KEY_PPP));
                    if (cmd.containsKey(KEY_PPP)) {
                        this._lineProtocol = KEY_PPP;
                    }
                }
                ++i;
            }
        }
    }

    public void removeInputTransProtocols(String protocol) {
        if (this._transInProtocols.contains(protocol)) {
            this._transInProtocols.removeElement(protocol);
            if (this._transInProtocols.isEmpty()) {
                this._transInProtocols.addElement(KEY_NONE);
            }
            this.setModified();
        }
    }

    public void removeOutputTransProtocols(String protocol) {
        if (this._transOutProtocols.contains(protocol)) {
            this._transOutProtocols.removeElement(protocol);
            if (this._transOutProtocols.isEmpty()) {
                this._transOutProtocols.addElement(KEY_NONE);
            }
            this.setModified();
        }
    }

    void setACLCategory(String newAcl, String oldAcl) {
        DeviceBase dev = (DeviceBase)this.getDevice();
        dev.setACLAccessCategory(newAcl, oldAcl);
    }

    public void setAccessClassIn(String in) {
        if (!this._acIn.equals(in)) {
            String old = this._acIn;
            this._acIn = in == null ? "" : in;
            this.setACLCategory(this._acIn, old);
            this.setModified();
        }
    }

    public void setAccessClassOut(String out) {
        if (!this._acOut.equals(out)) {
            String old = this._acOut;
            this._acOut = out == null ? "" : out;
            this.setACLCategory(this._acOut, old);
            this.setModified();
        }
    }

    public void setAuthen(String val) {
        this._authen = val == null ? "" : val;
        this.setModified();
    }

    public void setAuthor(String val) {
        this._author = val == null ? "" : val;
        this.setModified();
    }

    public void setExecTimeout(int min, int sec) {
        this._execTimeoutMin = min;
        this._execTimeoutSec = sec;
        this.setModified();
    }

    public boolean setInputTransProtocols(String protocol) {
        Vector prots = this.getPossibleProtocols();
        if (!prots.contains(protocol)) {
            return false;
        }
        if (protocol.equalsIgnoreCase(KEY_ALL) || protocol.equalsIgnoreCase(KEY_NONE)) {
            this._transInProtocols.removeAllElements();
            this._transInProtocols.addElement(protocol);
            this.setModified();
            return true;
        }
        if (!this._transInProtocols.contains(protocol)) {
            if (this._transInProtocols.contains(KEY_ALL)) {
                this._transInProtocols.removeElement(KEY_ALL);
            }
            if (this._transInProtocols.contains(KEY_NONE)) {
                this._transInProtocols.removeElement(KEY_NONE);
            }
            this._transInProtocols.addElement(protocol);
            this.setModified();
            return true;
        }
        return false;
    }

    public void setLineProtocol(String protocol) {
        this._lineProtocol = protocol;
        this.setModified();
    }

    public void setLogin(boolean enable, int option) {
        if (enable != this._login || option != this._loginOption) {
            this._login = enable;
            this._loginOption = option;
            this.setModified();
        }
    }

    public void setModemAutodiscovery(boolean bDiscovery) {
        this.setModified();
        this._modemAutoDiscovery = bDiscovery;
    }

    public void setModemEnable(boolean bEnable) {
        this.setModified();
        this._modemEnable = bEnable;
    }

    public void setModemInOut(String inOut) {
        this._inOut = inOut;
        this.setModified();
    }

    public boolean setOutputTransProtocols(String protocol) {
        Vector prots = this.getPossibleProtocols();
        if (!prots.contains(protocol)) {
            return false;
        }
        if (protocol.equalsIgnoreCase(KEY_ALL) || protocol.equalsIgnoreCase(KEY_NONE)) {
            this._transOutProtocols.removeAllElements();
            this._transOutProtocols.addElement(protocol);
            this.setModified();
            return true;
        }
        if (!this._transOutProtocols.contains(protocol)) {
            if (this._transOutProtocols.contains(KEY_ALL)) {
                this._transOutProtocols.removeElement(KEY_ALL);
            }
            if (this._transOutProtocols.contains(KEY_NONE)) {
                this._transOutProtocols.removeElement(KEY_NONE);
            }
            this._transOutProtocols.addElement(protocol);
            this.setModified();
            return true;
        }
        return false;
    }

    public void setPrivilege(int val) {
        this._privilege = val;
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ line type = " + this._type);
        sb.append("\t_start = " + this._start);
        sb.append("\t_end = " + this._end);
        sb.append("\t_login = " + this._login);
        sb.append("\t_loginOption = " + this._loginOption);
        sb.append("\t_execTimeoutMin = " + this._execTimeoutMin);
        sb.append("\t_execTimeoutSec = " + this._execTimeoutSec);
        sb.append("\t_acIn = " + this._acIn);
        sb.append("\t_acOut = " + this._acOut + "}");
        sb.append("\n_protocols: " + _protocols);
        sb.append("\n_transInProtocols: " + this._transInProtocols);
        sb.append("\n_transOutProtocols: " + this._transOutProtocols);
        return sb.toString();
    }
}

